/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.cox_reg;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegSaveTableModel;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegSaveVariable;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegressionDlg;
import com.spss.shared.core_tools.utils.SerializableObject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class CSCoxRegSaveTab
extends BaseProcedureTab
implements ActionListener,
ItemListener,
TableModelListener {
    public static final String CSCOX_SAV_TABLE = "CSCOX_SAV_TABLE";
    public static final String CSCOX_SAV_TDP = "CSCOX_SAV_TDP";
    public static final String CSCOX_SAV_ID = "CSCOX_SAV_ID";
    private static final int VAR_TABLE_WIDTH = 300;
    private static final int VAR_TABLE_HEIGHT = 300;
    private static final int NOTES_WIDTH = 600;
    private final int ROW_HEIGHT_PAD = 5;
    private PlainTable mVarsTable;
    private CSCoxRegSaveTableModel mVarsTableModel;
    private boolean mEnableByTDP = false;
    private boolean mEnableBySubjectId = false;
    private JPanel mNamesPanel;
    private JRadioButton mAutoNamesRadio;
    private JRadioButton mCustomNamesRadio;
    private SpssButtonGroup mNamesGroup;
    private JTextArea mAutoNamesTextArea;
    private JTextArea mCustomNamesTextArea;
    private final int mMargin = DialogUtil.getGroupBoxInnerMargin();
    private final Insets mInsets = DialogUtil.getStandardControlInsets();
    private Map<String, Boolean> mRootnames = new HashMap<String, Boolean>();

    public CSCoxRegSaveTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initializePanel();
    }

    @Override
    public void reset() {
        this.setDefaults();
        this.mVarsTableModel.resetNames();
        this.mVarsTableModel.resetSaveState();
        this.updateTable(false);
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mVarsTable;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.mAutoNamesRadio == itemEvent.getSource()) {
            this.updateTable(true);
            if (this.mAutoNamesRadio.isSelected()) {
                this.mVarsTableModel.resetNames();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cscoxreg_save";
    }

    @Override
    public boolean validateTab() {
        this.mRootnames.clear();
        TableCellEditor tableCellEditor = this.mVarsTable.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        if (this.mCustomNamesRadio.isSelected() && this.mEnableByTDP) {
            int n;
            for (n = 0; n < 13; ++n) {
                if (this.validateName(n)) continue;
                return false;
            }
            if (this.mEnableBySubjectId) {
                for (n = 13; n < 18; ++n) {
                    if (this.validateName(n)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean validateName(int n) {
        boolean bl = (Boolean)this.mVarsTableModel.getValueAt(n, this.mVarsTableModel.SAVE_COL);
        if (bl) {
            String string = ((String)this.mVarsTableModel.getValueAt(n, this.mVarsTableModel.NAME_COL)).trim();
            if (string.length() < 1) {
                return this.errorMessageForValue(n);
            }
            if (string.length() > 64) {
                return this.errorMessageForLength(n);
            }
            if (VarNameValidator.ValidNameCode.SPSSNAME_STANDARD != VarNameValidator.validateSPSSName((String)string, (boolean)true)) {
                return this.errorMessageForValue(n);
            }
            String string2 = string.toUpperCase();
            if (this.mRootnames.containsKey(string2)) {
                return this.errorMessageForUnique(n);
            }
            this.mRootnames.put(string2, true);
        }
        return true;
    }

    private boolean errorMessageForValue(int n) {
        SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_CSCOX_TDP_MESG1"), VersionInfo.getAppVersionString());
        this.mVarsTable.setRowSelectionInterval(n, n);
        this.mVarsTable.editCellAt(n, this.mVarsTableModel.NAME_COL);
        return false;
    }

    private boolean errorMessageForLength(int n) {
        String string = String.format(this.getResString("IDS_CSCOX_SAV_LNG_ERR"), 64);
        SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, string, VersionInfo.getAppVersionString());
        this.mVarsTable.setRowSelectionInterval(n, n);
        this.mVarsTable.editCellAt(n, this.mVarsTableModel.NAME_COL);
        return false;
    }

    private boolean errorMessageForUnique(int n) {
        SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_CSCOX_TDP_MESG2"), VersionInfo.getAppVersionString());
        this.mVarsTable.setRowSelectionInterval(n, n);
        this.mVarsTable.editCellAt(n, this.mVarsTableModel.NAME_COL);
        return false;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getSource() == this.mVarsTableModel) {
            // empty if block
        }
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        this.setupColumnWidths();
        this.updateTable(true);
    }

    private void updateTable(boolean bl) {
        if (this.mVarsTable.getRowCount() < 18) {
            return;
        }
        this.mEnableByTDP = ((CSCoxRegressionDlg)this.mParent).getEnableByTDP();
        this.mEnableBySubjectId = ((CSCoxRegressionDlg)this.mParent).getEnableBySubjectId();
        this.mVarsTableModel.setEnableFlags(this.mEnableByTDP, this.mEnableBySubjectId, !this.mAutoNamesRadio.isSelected());
        if (bl) {
            this.mVarsTable.setRowSelectionInterval(0, 0);
            this.mVarsTable.editCellAt(0, 0);
        }
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        List<CSCoxRegSaveVariable> list = this.mVarsTableModel.getVariables();
        dialogDataModel.putSerializableArray(CSCOX_SAV_TABLE, list.toArray(new SerializableObject[list.size()]));
        dialogDataModel.putBoolean(CSCOX_SAV_TDP, this.mEnableByTDP);
        dialogDataModel.putBoolean(CSCOX_SAV_ID, this.mEnableBySubjectId);
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        Object[] objectArray = dialogDataModel.getSerializableArray(CSCOX_SAV_TABLE);
        if (objectArray != null && this.mVarsTable != null) {
            ((CSCoxRegSaveTableModel)this.mVarsTable.getModel()).copyData(objectArray);
        }
    }

    private void initializePanel() {
        this.initVars();
        this.setDefaults();
        this.populateSaveVarData();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        Insets insets = new Insets(n, n, 0, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_COMPLEX_SAMPLES_COMMON_SAVE_SAVE_VARIABLES_LABEL")));
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_COMPSAMP_VARIABLES_LABEL");
        JScrollPane jScrollPane = new JScrollPane(this.mVarsTable);
        jScrollPane.setMinimumSize(new Dimension(jScrollPane.getPreferredSize().width, 210));
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width, 210));
        jLabel.setLabelFor(this.mVarsTable);
        insets.set(this.mInsets.top, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weighty = 0.0;
        this.mNamesPanel = this.setupNamesPanel();
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mNamesPanel, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        insets.set(this.mMargin, n, 0, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        this.setFocusTraversalPolicy();
    }

    private JPanel setupNamesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_CSCOX_SAV_NAMES_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = new Insets(0, this.mMargin, this.mMargin / 2, this.mMargin);
        DialogUtil.addUsingGBL(jPanel, this.mAutoNamesRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mAutoNamesTextArea, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCustomNamesRadio, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCustomNamesTextArea, gridBagConstraints, 0, 4, 1, 1, n, insets);
        this.mNamesGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mVarsTable);
        vector.add(this.mNamesGroup);
        JPanel jPanel = ((CSCoxRegressionDlg)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void initVars() {
        this.mVarsTableModel = new CSCoxRegSaveTableModel();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("<HTML><B>" + this.getResString("IDS_PFA_SPSS_DATAFILE_SAVE") + "</B></HTML>");
        arrayList.add("<HTML><B>" + this.getResString("IDS_CSCOX_SAV_ITEM_HEADER") + "</B></HTML>");
        arrayList.add("<HTML><B>" + this.getResString("IDS_CSCOX_SAV_ROOT_HEADER") + "</B></HTML>");
        this.mVarsTableModel.setColumnNames(arrayList);
        this.mVarsTable = new PlainTable(this.mVarsTableModel);
        this.mVarsTable.setPreferredScrollableViewportSize(new Dimension(300, 300));
        this.mVarsTableModel.addTableModelListener(this);
        CheckCellRenderer checkCellRenderer = new CheckCellRenderer();
        this.mVarsTable.getColumnModel().getColumn(this.mVarsTableModel.SAVE_COL).setCellRenderer(checkCellRenderer);
        SaveCellRenderer saveCellRenderer = new SaveCellRenderer();
        this.mVarsTable.getColumnModel().getColumn(this.mVarsTableModel.DESC_COL).setCellRenderer(saveCellRenderer);
        this.mVarsTable.getColumnModel().getColumn(this.mVarsTableModel.NAME_COL).setCellRenderer(saveCellRenderer);
        this.mVarsTable.setFocusable(true);
        this.mVarsTable.setFocusTraversalKeys(0, null);
        this.mVarsTable.setRowHeight(this.mVarsTable.getRowHeight() + 5);
        this.mVarsTable.getTableHeader().setReorderingAllowed(false);
        this.mAutoNamesRadio = DialogUtil.createRadioButton(this.mParent, "IDS_CSCOX_SAV_AUTO_RADIO", null);
        this.mAutoNamesRadio.addItemListener(this);
        this.mCustomNamesRadio = DialogUtil.createRadioButton(this.mParent, "IDS_CSCOX_SAV_CUSTOM_RADIO", null);
        this.mAutoNamesTextArea = new JTextArea(this.getResString("IDS_CSCOX_SAV_AUTO_NOTE"));
        this.mCustomNamesTextArea = new JTextArea(this.getResString("IDS_CSCOX_SAV_CUSTOM_NOTE"));
    }

    private void setupColumnWidths() {
        TableColumnModel tableColumnModel = this.mVarsTable.getColumnModel();
        int n = this.mVarsTable.getWidth();
        tableColumnModel.getColumn(this.mVarsTableModel.SAVE_COL).setPreferredWidth((int)((double)n * 0.1));
        tableColumnModel.getColumn(this.mVarsTableModel.DESC_COL).setPreferredWidth((int)((double)n * 0.6));
        tableColumnModel.getColumn(this.mVarsTableModel.NAME_COL).setPreferredWidth((int)((double)n * 0.3));
    }

    private void setDefaults() {
        this.mAutoNamesRadio.setSelected(true);
        this.mAutoNamesTextArea.setOpaque(false);
        this.mAutoNamesTextArea.setLineWrap(true);
        this.mAutoNamesTextArea.setWrapStyleWord(true);
        this.mAutoNamesTextArea.setBorder(BorderFactory.createEmptyBorder());
        this.mAutoNamesTextArea.setBackground(this.getBackground());
        this.mAutoNamesTextArea.setEditable(false);
        this.mAutoNamesTextArea.setRows(2);
        this.mAutoNamesTextArea.setFocusable(false);
        this.mAutoNamesTextArea.setPreferredSize(new Dimension(600, this.mAutoNamesTextArea.getHeight()));
        this.mCustomNamesTextArea.setOpaque(false);
        this.mCustomNamesTextArea.setLineWrap(true);
        this.mCustomNamesTextArea.setWrapStyleWord(true);
        this.mCustomNamesTextArea.setBorder(BorderFactory.createEmptyBorder());
        this.mCustomNamesTextArea.setBackground(this.getBackground());
        this.mCustomNamesTextArea.setEditable(false);
        this.mCustomNamesTextArea.setRows(2);
        this.mCustomNamesTextArea.setFocusable(false);
        this.mCustomNamesTextArea.setPreferredSize(new Dimension(600, this.mCustomNamesTextArea.getHeight()));
    }

    public void populateSaveVarData() {
        this.mVarsTableModel.clear();
        this.mVarsTableModel.addVariable(new CSCoxRegSaveVariable(false, this.getResString("IDS_CSCOX_SAV_SURV_DES"), this.getResString("IDS_CSCOX_SAV_SURV_ROOT"), "SURVIVAL"));
        this.mVarsTableModel.addVariable(new CSCoxRegSaveVariable(false, this.getResString("IDS_CSCOX_SAV_LSURV_DES"), this.getResString("IDS_CSCOX_SAV_LSURV_ROOT"), "LCL_SURVIVAL"));
        this.mVarsTableModel.addVariable(new CSCoxRegSaveVariable(false, this.getResString("IDS_CSCOX_SAV_USURV_DES"), this.getResString("IDS_CSCOX_SAV_USURV_ROOT"), "UCL_SURVIVAL"));
        this.mVarsTableModel.addVariable(new CSCoxRegSaveVariable(false, this.getResString("IDS_CSCOX_SAV_HAZARD_DES"), this.getResString("IDS_CSCOX_SAV_HAZARD_ROOT"), "CUMHAZARD"));
        this.mVarsTableModel.addVariable(new CSCoxRegSaveVariable(false, this.getResString("IDS_CSCOX_SAV_LHAZARD_DES"), this.getResString("IDS_CSCOX_SAV_LHAZARD_ROOT"), "LCL_CUMHAZARD"));
        this.mVarsTableModel.addVariable(new CSCoxRegSaveVariable(false, this.getResString("IDS_CSCOX_SAV_UHAZARD_DES"), this.getResString("IDS_CSCOX_SAV_UHAZARD_ROOT"), "UCL_CUMHAZARD"));
        this.mVarsTableModel.addVariable(new CSCoxRegSaveVariable(false, this.getResString("IDS_CSCOX_SAV_XB_DES"), this.getResString("IDS_CSCOX_SAV_XB_ROOT"), "XBETA"));
        this.mVarsTableModel.addVariable(new CSCoxRegSaveVariable(false, this.getResString("IDS_CSCOX_SAV_RESSC_DES"), this.getResString("IDS_CSCOX_SAV_RESSC_ROOT"), "SCHOENFELD"));
        this.mVarsTableModel.addVariable(new CSCoxRegSaveVariable(false, this.getResString("IDS_CSCOX_SAV_RESMR_DES"), this.getResString("IDS_CSCOX_SAV_RESMR_ROOT"), "MARTINGALE"));
        this.mVarsTableModel.addVariable(new CSCoxRegSaveVariable(false, this.getResString("IDS_CSCOX_SAV_RESD_DES"), this.getResString("IDS_CSCOX_SAV_RESD_ROOT"), "DEVIANCE"));
        this.mVarsTableModel.addVariable(new CSCoxRegSaveVariable(false, this.getResString("IDS_CSCOX_SAV_RESCOX_DES"), this.getResString("IDS_CSCOX_SAV_RESCOX_ROOT"), "COXSNELL"));
        this.mVarsTableModel.addVariable(new CSCoxRegSaveVariable(false, this.getResString("IDS_CSCOX_SAV_RESSCO_DES"), this.getResString("IDS_CSCOX_SAV_RESSCO_ROOT"), "SCORE"));
        this.mVarsTableModel.addVariable(new CSCoxRegSaveVariable(false, this.getResString("IDS_CSCOX_SAV_RESDF_DES"), this.getResString("IDS_CSCOX_SAV_RESDF_ROOT"), "DFBETA"));
        this.mVarsTableModel.addVariable(new CSCoxRegSaveVariable(false, this.getResString("IDS_CSCOX_SAV_ARM_DES"), this.getResString("IDS_CSCOX_SAV_ARM_ROOT"), "AGGMARTINGALE"));
        this.mVarsTableModel.addVariable(new CSCoxRegSaveVariable(false, this.getResString("IDS_CSCOX_SAV_ARD_DES"), this.getResString("IDS_CSCOX_SAV_ARD_ROOT"), "AGGDEVIANCE"));
        this.mVarsTableModel.addVariable(new CSCoxRegSaveVariable(false, this.getResString("IDS_CSCOX_SAV_ARCS_DES"), this.getResString("IDS_CSCOX_SAV_ARCS_ROOT"), "AGGCOXSNELL"));
        this.mVarsTableModel.addVariable(new CSCoxRegSaveVariable(false, this.getResString("IDS_CSCOX_SAV_ARSCO_DES"), this.getResString("IDS_CSCOX_SAV_ARSCO_ROOT"), "AGGSCORE"));
        this.mVarsTableModel.addVariable(new CSCoxRegSaveVariable(false, this.getResString("IDS_CSCOX_SAV_ARDF_DES"), this.getResString("IDS_CSCOX_SAV_ARDF_ROOT"), "AGGDFBETA"));
        this.mVarsTableModel.setDefaultNames();
    }

    public class CheckCellRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public CheckCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setEnabled(((CSCoxRegSaveTableModel)jTable.getModel()).isCellEnabled(n, n2));
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setSelected(object != null && (Boolean)object != false);
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(this.noFocusBorder);
            }
            return this;
        }
    }

    public class SaveCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setEnabled(((CSCoxRegSaveTableModel)jTable.getModel()).isCellEnabled(n, n2));
            if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2);
            } else {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            return this;
        }
    }
}

