/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.cox_reg;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariableComparator;
import com.spss.java_client.core.documents.data.dictionary.SpssVariableSortType;
import com.spss.java_client.core.documents.data.dictionary.TimeDependentPredictors;
import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.VarListDropListener;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IPlainListVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegressionDlg;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSPlanCoxRegDlg;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.DefineTimeDepPredictorsDlg;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CSCoxRegPredictorsTab
extends BaseProcedureTab
implements FocusListener,
ListDataListener,
ListSelectionListener,
ActionListener {
    public static final String SRC_LIST_KEY = "IDS_COX_REG_PRED_SOURCE_VAR_LIST";
    public static final String TIME_DEP_LIST_KEY = "IDS_COX_REG_PRED_TIME_VAR_LIST";
    public static final String COVARIATES_TARGET_LIST_KEY = "IDS_COX_REG_PRED_COVARIATES_TARGET_LIST";
    static final String FACTORS_TARGET_LIST_KEY = "IDS_COX_REG_PRED__FACTORS_TARGET_LIST";
    static final String FACTOR_MODEL_KEY = "IDS_COX_REG_PRED_FACTORS_TARGET_MODEL";
    static final String COVARIATE_MODEL_KEY = "IDS_COX_REG_PRED_COVARIATE_TARGET_MODEL";
    static final String TDP_MODEL_KEY = "IDS_COX_REG_PRED_TDP_SOURCE_MODEL";
    private SrcVariableList mSrcVarList;
    private JScrollPane mSrcScrollPane;
    private TargetVariableList mFactorTargetVarList;
    private TargetVariableList mCovariatesTargetVarList;
    private TargetVariableList mTimeDepVarList;
    private JScrollPane mTimeDepVarListScrollPane;
    private JScrollPane mFactorTargetVarListScrollPane;
    private JScrollPane mCovariatesTargetVarListScrollPane;
    private ComponentsArrowButton mFactorArrowButton;
    private ComponentsArrowButton mCovariatesArrowButton;
    protected IPlainListVarMoveHandler mPlainListVarMoveHandler;
    private IVarMoveHandler mMoveHandler;
    private JButton mNewButton;
    private JButton mEditButton;
    private JButton mDeleteButton;

    public CSCoxRegPredictorsTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initializePanel();
    }

    @Override
    public void reset() {
        this.setDefaults();
        if (((CSCoxRegressionDlg)this.mParent).getDialogDataModel() != null) {
            ((CSCoxRegressionDlg)this.mParent).getDialogDataModel().putArray("IDS_COX_REG_TDP_VARIABLE", null);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cscoxreg_predictors";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mFactorTargetVarList) {
            this.stateOfArrowButton(this.mFactorTargetVarList);
        } else if (focusEvent.getSource() == this.mCovariatesTargetVarList) {
            this.stateOfArrowButton(this.mCovariatesTargetVarList);
        } else if (focusEvent.getSource() == this.mSrcVarList) {
            if (this.mSrcVarList.getSelectedIndex() != -1) {
                this.mTimeDepVarList.clearSelection();
                this.stateOfArrowButtons(true);
            } else if (this.mSrcVarList.getSelectedIndex() == -1 && this.mTimeDepVarList.getSelectedIndex() == -1) {
                this.stateOfArrowButtons(false);
            } else if (this.mSrcVarList.getSelectedIndex() == -1 && this.mTimeDepVarList.getSelectedIndex() != -1) {
                this.stateOfArrowButtons(true);
            }
        } else if (focusEvent.getSource() == this.mTimeDepVarList) {
            if (this.mTimeDepVarList.getSelectedIndex() != -1) {
                this.mSrcVarList.clearSelection();
                this.stateOfArrowButtons(true);
                this.mDeleteButton.setEnabled(true);
                this.mEditButton.setEnabled(false);
                if (this.mTimeDepVarList.getSelectedIndices().length == 1) {
                    this.mEditButton.setEnabled(true);
                }
            } else if (this.mTimeDepVarList.getSelectedIndex() == -1 && this.mSrcVarList.getSelectedIndex() == -1) {
                this.stateOfArrowButtons(false);
            } else if (this.mTimeDepVarList.getSelectedIndex() == -1 && this.mSrcVarList.getSelectedIndex() != -1) {
                this.stateOfArrowButtons(true);
            }
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mSrcVarList.getModel() && listDataEvent.getType() == 1) {
            ISpssVariable iSpssVariable = this.mSrcVarList.getModel().getElementAt(listDataEvent.getIndex0());
            ((CSCoxRegressionDlg)this.mParent).getModelTab().removeVarFromModel(iSpssVariable.getName());
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.mFactorTargetVarList) {
            if (this.mFactorTargetVarList.getSelectedIndex() != -1) {
                this.mSrcVarList.clearSelection();
                this.mTimeDepVarList.clearSelection();
                this.mCovariatesTargetVarList.clearSelection();
            }
            this.stateOfArrowButton(this.mFactorTargetVarList);
        } else if (listSelectionEvent.getSource() == this.mCovariatesTargetVarList) {
            if (this.mCovariatesTargetVarList.getSelectedIndex() != -1) {
                this.mSrcVarList.clearSelection();
                this.mTimeDepVarList.clearSelection();
                this.mFactorTargetVarList.clearSelection();
            }
            this.stateOfArrowButton(this.mCovariatesTargetVarList);
        } else if (listSelectionEvent.getSource() == this.mTimeDepVarList) {
            if (this.mTimeDepVarList.getSelectedIndex() != -1) {
                this.mSrcVarList.clearSelection();
                this.mFactorTargetVarList.clearSelection();
                this.mCovariatesTargetVarList.clearSelection();
                this.stateOfArrowButtons(true);
                this.mDeleteButton.setEnabled(true);
                this.mEditButton.setEnabled(false);
                if (this.mTimeDepVarList.getSelectedIndices().length == 1) {
                    this.mEditButton.setEnabled(true);
                }
            } else if (this.mTimeDepVarList.getSelectedIndex() == -1) {
                this.stateOfArrowButtons(false);
                this.mEditButton.setEnabled(false);
                this.mDeleteButton.setEnabled(false);
            }
        } else if (listSelectionEvent.getSource() == this.mSrcVarList) {
            if (this.mSrcVarList.getSelectedIndex() != -1) {
                this.mTimeDepVarList.clearSelection();
                this.mFactorTargetVarList.clearSelection();
                this.mCovariatesTargetVarList.clearSelection();
                this.stateOfArrowButtons(true);
            } else if (this.mSrcVarList.getSelectedIndex() == -1) {
                this.stateOfArrowButtons(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mFactorArrowButton) {
            if (SpssArrowButton.ButtonOrientation.right == ((ComponentsArrowButton)actionEvent.getSource()).getArrowOrientation()) {
                if (this.mSrcVarList.getSelectedIndex() != -1) {
                    if (this.checkSrcVariable(this.mFactorTargetVarList, this.mSrcVarList.getSelectedValues())) {
                        this.ordinaryListToTarget(this.mFactorTargetVarList);
                    }
                } else if (this.mTimeDepVarList.getSelectedIndex() != -1) {
                    this.TDPListToTargetList(this.mFactorTargetVarList);
                }
            } else {
                this.targetToSrc(this.mFactorTargetVarList);
            }
        }
        if (actionEvent.getSource() == this.mCovariatesArrowButton) {
            if (SpssArrowButton.ButtonOrientation.right == ((ComponentsArrowButton)actionEvent.getSource()).getArrowOrientation()) {
                if (this.mSrcVarList.getSelectedIndex() != -1) {
                    if (this.checkSrcVariable(this.mCovariatesTargetVarList, this.mSrcVarList.getSelectedValues())) {
                        this.ordinaryListToTarget(this.mCovariatesTargetVarList);
                    }
                } else if (this.mTimeDepVarList.getSelectedIndex() != -1) {
                    this.TDPListToTargetList(this.mCovariatesTargetVarList);
                }
            } else {
                this.targetToSrc(this.mCovariatesTargetVarList);
            }
        }
    }

    public ListModel getFactorsListModel() {
        return this.mFactorTargetVarList.getModel();
    }

    public ListModel getCovariatesListModel() {
        return this.mCovariatesTargetVarList.getModel();
    }

    public boolean isTdpInPredictors() {
        boolean bl = this.isTdpInFactorList();
        if (!bl) {
            bl = this.isTdpInCovariateList();
        }
        return bl;
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        Component component = ((CSCoxRegressionDlg)((Object)this.getTopLevelAncestor())).getGlassPane();
        if (component instanceof DragPane) {
            DragPane dragPane = (DragPane)component;
            dragPane.getDropListeners().removeAllElements();
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mSrcVarList, this.mMoveHandler));
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mFactorTargetVarList, this.mMoveHandler));
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mCovariatesTargetVarList, this.mMoveHandler));
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mTimeDepVarList, this.mMoveHandler));
        }
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        TDPListModel tDPListModel;
        ListModel listModel = (ListModel)dialogDataModel.getObject(FACTOR_MODEL_KEY);
        if (listModel != null) {
            this.mFactorTargetVarList.setModel(listModel);
        }
        if ((listModel = (ListModel)dialogDataModel.getObject(COVARIATE_MODEL_KEY)) != null) {
            this.mCovariatesTargetVarList.setModel(listModel);
        }
        if ((tDPListModel = (TDPListModel)dialogDataModel.getObject(TDP_MODEL_KEY)) != null) {
            this.mTimeDepVarList.setModel(tDPListModel);
        }
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        TDPListModel tDPListModel;
        VarListModel varListModel;
        boolean bl = this.isTdpInFactorList();
        if (bl) {
            varListModel = this.mFactorTargetVarList.getModel();
            dialogDataModel.putObject(FACTOR_MODEL_KEY, varListModel);
        }
        if (bl = this.isTdpInCovariateList()) {
            varListModel = this.mCovariatesTargetVarList.getModel();
            dialogDataModel.putObject(COVARIATE_MODEL_KEY, varListModel);
        }
        if ((tDPListModel = (TDPListModel)this.mTimeDepVarList.getModel()).getSize() > 0) {
            dialogDataModel.putObject(TDP_MODEL_KEY, tDPListModel);
        }
    }

    private void stateOfArrowButton(TargetVariableList targetVariableList) {
        if (targetVariableList == this.mFactorTargetVarList) {
            this.mFactorArrowButton.setEnabled(this.mFactorTargetVarList.getModel().getSize() > 0 && this.mFactorTargetVarList.getSelectedIndex() != -1);
            this.mFactorArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            if (this.mFactorTargetVarList.getSelectedIndex() != -1) {
                this.mCovariatesArrowButton.setEnabled(false);
            }
        } else if (targetVariableList == this.mCovariatesTargetVarList) {
            this.mCovariatesArrowButton.setEnabled(this.mCovariatesTargetVarList.getModel().getSize() > 0 && this.mCovariatesTargetVarList.getSelectedIndex() != -1);
            this.mCovariatesArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            if (this.mCovariatesTargetVarList.getSelectedIndex() != -1) {
                this.mFactorArrowButton.setEnabled(false);
            }
        }
    }

    private void stateOfArrowButtons(boolean bl) {
        this.mFactorArrowButton.setEnabled(bl);
        this.mCovariatesArrowButton.setEnabled(bl);
        this.mFactorArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mCovariatesArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mEditButton.setEnabled(false);
        this.mDeleteButton.setEnabled(false);
    }

    private void TDPListToTargetList(TargetVariableList targetVariableList) {
        VarListModel varListModel = targetVariableList.getModel();
        ISpssVariable[] iSpssVariableArray = this.mTimeDepVarList.getSelectedValues();
        int n = targetVariableList.getModel().getSize();
        int n2 = n + iSpssVariableArray.length - 1;
        targetVariableList.clearSelection();
        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
            varListModel.addElement((ISpssVariable)((TimeDependentPredictors)iSpssVariable));
            ((CSCoxRegressionDlg)this.mParent).getModelTab().updateTdpNamesSet(((TimeDependentPredictors)iSpssVariable).getName(), true);
            this.mTimeDepVarList.getModel().removeElement(iSpssVariable);
        }
        targetVariableList.setSelectionInterval(n, n2);
        targetVariableList.requestFocus();
    }

    private void ordinaryListToTarget(TargetVariableList targetVariableList) {
        VarListModel varListModel = targetVariableList.getModel();
        ISpssVariable[] iSpssVariableArray = this.mSrcVarList.getSelectedValues();
        this.mSrcVarList.clearSelection();
        int n = targetVariableList.getModel().getSize();
        int n2 = n + iSpssVariableArray.length - 1;
        targetVariableList.clearSelection();
        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
            varListModel.addElement(iSpssVariable);
            this.mSrcVarList.getModel().removeElement(iSpssVariable);
        }
        targetVariableList.requestFocus();
        targetVariableList.setSelectionInterval(n, n2);
    }

    private void targetToSrc(TargetVariableList targetVariableList) {
        TDPListModel tDPListModel = (TDPListModel)this.mTimeDepVarList.getModel();
        VarListModel varListModel = targetVariableList.getModel();
        ISpssVariable[] iSpssVariableArray = targetVariableList.getSelectedValues();
        int n = this.mTimeDepVarList.getModel().getSize();
        int[] nArray = new int[iSpssVariableArray.length];
        int n2 = 0;
        int n3 = 0;
        for (ISpssVariable i : iSpssVariableArray) {
            String string;
            if (i instanceof TimeDependentPredictors) {
                tDPListModel.addElement((ISpssVariable)((TimeDependentPredictors)i));
                string = ((TimeDependentPredictors)i).getName();
                ((CSCoxRegressionDlg)this.mParent).getModelTab().updateTdpNamesSet(string, false);
            } else {
                this.mSrcVarList.getModel().addElement(i, true);
                ++n2;
                string = i.getName();
            }
            varListModel.removeElement(i);
            ((CSCoxRegressionDlg)this.mParent).getModelTab().removeVarFromModel(string);
        }
        if (n3 > 0) {
            this.mSrcVarList.requestFocus();
            if (n2 != iSpssVariableArray.length) {
                int[] n4 = new int[n2];
                System.arraycopy(nArray, 0, n4, 0, n4.length);
                this.mSrcVarList.setSelectedIndices(n4);
            } else {
                this.mSrcVarList.setSelectedIndices(nArray);
            }
        } else {
            int n4 = this.mTimeDepVarList.getModel().getSize();
            int n5 = n4 - n;
            int[] nArray2 = new int[n5];
            this.mTimeDepVarList.requestFocus();
            for (int i = 0; i < n5; ++i) {
                nArray2[i] = n++;
            }
            if (iSpssVariableArray.length > 0) {
                this.mTimeDepVarList.setSelectedIndices(nArray2);
            }
        }
        targetVariableList.clearSelection();
    }

    private void initializePanel() {
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getArrowButtonInsets();
        Insets insets2 = new Insets(n, 0, 0, insets.right * 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = 23;
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        JPanel jPanel = this.setupListPanel();
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 4, n2, insets2);
        Insets insets3 = new Insets(0, insets.left * 2, 0, insets.right * 2);
        n2 = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, this.mFactorArrowButton, gridBagConstraints, 1, 1, 1, 1, n2, insets3);
        DialogUtil.addUsingGBL(this, this.mCovariatesArrowButton, gridBagConstraints, 1, 3, 1, 1, n2, insets3);
        n2 = 23;
        gridBagConstraints.fill = 0;
        ImageIcon imageIcon = new ImageIcon(ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_FACTOR_IMAGE")));
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_FACTORS_LABEL");
        jLabel.setIcon(imageIcon);
        jLabel.setLabelFor(this.mFactorTargetVarList);
        Insets insets4 = new Insets(n3, insets.right * 2, 0, insets.right);
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 2, 0, 1, 1, n2, insets4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        n2 = 23;
        gridBagConstraints.fill = 1;
        insets4.set(0, insets.right * 2, 10, insets.right);
        DialogUtil.addUsingGBL(this, this.mFactorTargetVarListScrollPane, gridBagConstraints, 2, 1, 1, 1, n2, insets4);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n2 = 23;
        gridBagConstraints.fill = 0;
        imageIcon = new ImageIcon(ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_COVARIATE_IMAGE")));
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_COVARIATES_LABEL");
        jLabel2.setIcon(imageIcon);
        jLabel2.setLabelFor(this.mCovariatesTargetVarList);
        insets4.set(n3, insets.right * 2, 0, insets.right);
        DialogUtil.addUsingGBL(this, jLabel2, gridBagConstraints, 2, 2, 1, 1, n2, insets4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets4.set(0, insets.right * 2, 10, insets.right);
        DialogUtil.addUsingGBL(this, this.mCovariatesTargetVarListScrollPane, gridBagConstraints, 2, 3, 1, 1, n2, insets4);
        this.setFocusTraversalPolicy();
        this.mSrcVarList.setSelectedIndex(0);
    }

    private boolean checkSrcVariable(JList jList, ISpssVariable[] iSpssVariableArray) {
        if (jList == this.mCovariatesTargetVarList || jList == this.mFactorTargetVarList) {
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                if (iSpssVariable == null) continue;
                if (CSPlanCoxRegDlg.isPlanVariable(iSpssVariable.getName())) {
                    SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_CSCOX_PREDICTOR_MESG3"), VersionInfo.getAppVersionString());
                    return false;
                }
                if (jList != this.mCovariatesTargetVarList || iSpssVariable.getType() <= 0) continue;
                SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_CSCOX_PREDICTOR_MESG2"), VersionInfo.getAppVersionString());
                return false;
            }
        }
        return true;
    }

    private JPanel setupListPanel() {
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(new GridBagLayout());
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, n, 0, n);
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_COMPSAMP_VARIABLES_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        insets.set(0, n, n, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n, n, 0, n);
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_CSCOX_PREDICTOR_TIME_VAR");
        jLabel2.setLabelFor(this.mTimeDepVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets.set(0, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mTimeDepVarListScrollPane, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        gridBagConstraints.weighty = 0.0;
        insets.set(0, n, n, n);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.setupButtonPanel(), gridBagConstraints, 0, 4, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel setupButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        int n = insets.left + insets.right;
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets2 = new Insets(0, n, 0, 0);
            int n2 = 23;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, this.mDeleteButton, gridBagConstraints, 0, 0, 1, 1, n2, null);
            n2 = 24;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, this.mEditButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mNewButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
        } else {
            FlowLayout flowLayout = new FlowLayout(1, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(this.mNewButton);
            jPanel.add(this.mEditButton);
            jPanel.add(this.mDeleteButton);
        }
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mTimeDepVarList);
        vector.add(this.mNewButton);
        vector.add(this.mEditButton);
        vector.add(this.mDeleteButton);
        vector.add(this.mFactorArrowButton);
        vector.add(this.mCovariatesArrowButton);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void initVars() {
        ActionListener[] actionListenerArray;
        this.mMoveHandler = new CSCoxPredictorMoveHandler();
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.addListSelectionListener(this);
        Dimension dimension = this.mSrcVarList.getMinimumSize();
        this.mSrcVarList.setMinimumSize(dimension);
        this.mSrcVarList.setIdentifier(SRC_LIST_KEY);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcScrollPane.setHorizontalScrollBarPolicy(30);
        this.mSrcScrollPane.setVerticalScrollBarPolicy(20);
        this.mTimeDepVarList = new TargetVariableList();
        this.mTimeDepVarList.setModel(new TDPListModel(this.mTimeDepVarList));
        this.mTimeDepVarList.setIdentifier(TIME_DEP_LIST_KEY);
        this.mTimeDepVarList.getModel().addListDataListener(this);
        this.mTimeDepVarList.addFocusListener(this);
        this.mTimeDepVarList.addListSelectionListener(this);
        dimension = this.mTimeDepVarList.getMinimumSize();
        dimension.height = 60;
        this.mTimeDepVarList.setMinimumSize(dimension);
        this.mTimeDepVarListScrollPane = new JScrollPane(this.mTimeDepVarList);
        this.mTimeDepVarListScrollPane.setPreferredSize(this.mTimeDepVarList.getMinimumSize());
        this.mTimeDepVarListScrollPane.setHorizontalScrollBarPolicy(30);
        this.mTimeDepVarListScrollPane.setVerticalScrollBarPolicy(20);
        this.mFactorTargetVarList = new TargetVariableList();
        this.mFactorTargetVarList.setIdentifier(FACTORS_TARGET_LIST_KEY);
        this.mFactorTargetVarList.getModel().addListDataListener(this);
        this.mFactorTargetVarList.addListSelectionListener(this);
        this.mFactorTargetVarList.addFocusListener(this);
        this.mFactorTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mFactorTargetVarList.getFixedCellHeight() * 3 + 2));
        this.mFactorTargetVarListScrollPane = new JScrollPane(this.mFactorTargetVarList);
        this.mFactorTargetVarListScrollPane.setPreferredSize(this.mFactorTargetVarList.getMinimumSize());
        this.mFactorTargetVarList.setName("CoxRegFactorVarList");
        this.mCovariatesTargetVarList = new TargetVariableList();
        this.mCovariatesTargetVarList.setIdentifier(COVARIATES_TARGET_LIST_KEY);
        this.mCovariatesTargetVarList.getModel().addListDataListener(this);
        this.mCovariatesTargetVarList.addListSelectionListener(this);
        this.mCovariatesTargetVarList.addFocusListener(this);
        this.mCovariatesTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mCovariatesTargetVarList.getFixedCellHeight() * 3 + 2));
        this.mCovariatesTargetVarListScrollPane = new JScrollPane(this.mCovariatesTargetVarList);
        this.mCovariatesTargetVarListScrollPane.setPreferredSize(this.mCovariatesTargetVarList.getMinimumSize());
        this.mCovariatesTargetVarList.setName("CoxRegConvariatesVarList");
        this.mFactorArrowButton = new ComponentsArrowButton(SpssArrowButton.ButtonOrientation.left);
        this.mFactorArrowButton.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mFactorArrowButton.registerComponents(this.mFactorTargetVarList, SpssArrowButton.ButtonOrientation.left);
        for (ActionListener actionListener : actionListenerArray = this.mFactorArrowButton.getActionListeners()) {
            this.mFactorArrowButton.removeActionListener(actionListener);
        }
        this.mFactorArrowButton.addActionListener(this);
        this.mCovariatesArrowButton = new ComponentsArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCovariatesArrowButton.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mCovariatesArrowButton.registerComponents(this.mCovariatesTargetVarList, SpssArrowButton.ButtonOrientation.left);
        for (ActionListener actionListener : actionListenerArray = this.mCovariatesArrowButton.getActionListeners()) {
            this.mCovariatesArrowButton.removeActionListener(actionListener);
        }
        this.mCovariatesArrowButton.addActionListener(this);
        this.mNewButton = new JButton(new NewAction());
        this.mEditButton = new JButton(new EditAction());
        this.mDeleteButton = new JButton(new DeleteAction());
    }

    private void setDefaults() {
        this.mSrcVarList.setModel(((CSCoxRegressionDlg)this.mParent).getSrcListModel());
        this.mSrcVarList.getModel().addListDataListener(this);
        if (this.mSrcVarList.getModel().getSize() > 0) {
            this.mSrcVarList.setSelectedIndex(0);
        }
        this.mSrcVarList.requestFocus();
        this.mTimeDepVarList.ensureIndexIsVisible(0);
        this.mFactorTargetVarList.getModel().removeAll();
        this.mCovariatesTargetVarList.getModel().removeAll();
        this.mFactorArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mCovariatesArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mEditButton.setEnabled(false);
        this.mDeleteButton.setEnabled(false);
    }

    private boolean isTdpInFactorList() {
        ListModel listModel = this.getFactorsListModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            ISpssVariable iSpssVariable = (ISpssVariable)listModel.getElementAt(i);
            if (!(iSpssVariable instanceof TimeDependentPredictors)) continue;
            return true;
        }
        return false;
    }

    private boolean isTdpInCovariateList() {
        ListModel listModel = this.getCovariatesListModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            ISpssVariable iSpssVariable = (ISpssVariable)listModel.getElementAt(i);
            if (!(iSpssVariable instanceof TimeDependentPredictors)) continue;
            return true;
        }
        return false;
    }

    class TDPListModel
    extends VarListModel {
        protected TDPListModel(VariableList variableList) {
            super(variableList);
        }

        @Override
        public boolean addElement(ISpssVariable iSpssVariable, boolean bl) {
            super.addElement(iSpssVariable, bl);
            this.sort();
            return true;
        }

        @Override
        public void sort() {
            try {
                ISpssVariable[] iSpssVariableArray = this.mVarList.getSelectedValues();
                Collections.sort(this.mVariables, new SpssVariableComparator(SpssVariableSortType.alpha, false));
                this.mVarList.clearSelection();
                this.mVarList.setSelection(iSpssVariableArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class CSCoxPredictorMoveHandler
    implements IVarMoveHandler {
        CSCoxPredictorMoveHandler() {
        }

        @Override
        public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
            boolean bl = CSCoxRegPredictorsTab.this.checkSrcVariable(variableList, iSpssVariableArray);
            if (bl) {
                for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                    if (iSpssVariable == null) continue;
                    if (variableList == CSCoxRegPredictorsTab.this.mTimeDepVarList && !(iSpssVariable instanceof TimeDependentPredictors)) {
                        return false;
                    }
                    if (variableList != CSCoxRegPredictorsTab.this.mSrcVarList || !(iSpssVariable instanceof TimeDependentPredictors)) continue;
                    return false;
                }
            }
            return bl;
        }
    }

    class DeleteAction
    extends AbstractAction {
        DeleteAction() {
            this.putValue("Name", CSCoxRegPredictorsTab.this.getResString("IDS_CSCOX_PREDICTOR_BUTTON_DELETE"));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            void var6_8;
            ISpssVariable[] iSpssVariableArray = CSCoxRegPredictorsTab.this.mTimeDepVarList.getSelectedValues();
            Vector<String> vector = new Vector<String>(iSpssVariableArray.length);
            ISpssVariable[] object = iSpssVariableArray;
            int n = object.length;
            boolean objectArray = false;
            while (var6_8 < n) {
                ISpssVariable iSpssVariable = object[var6_8];
                String string = iSpssVariable.getName();
                vector.addElement(string);
                ++var6_8;
            }
            String string = String.format(CSCoxRegPredictorsTab.this.getResString("ERR_CSCOX_PREDICTOR_MESG1"), iSpssVariableArray.length);
            n = SpssAlertOptionPane.showConfirmDialog((Window)CSCoxRegPredictorsTab.this.mParent, string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
            if (n == 1) {
                void var8_16;
                ISpssVariable[] iSpssVariableArray2 = iSpssVariableArray;
                int n2 = iSpssVariableArray2.length;
                boolean bl = false;
                while (var8_16 < n2) {
                    ISpssVariable iSpssVariable = iSpssVariableArray2[var8_16];
                    CSCoxRegPredictorsTab.this.mTimeDepVarList.getModel().removeElement(iSpssVariable);
                    ++var8_16;
                }
                Object[] objectArray2 = ((CSCoxRegressionDlg)CSCoxRegPredictorsTab.this.mParent).getDialogDataModel().getArray("IDS_COX_REG_TDP_VARIABLE");
                Vector<TimeDependentPredictors> vector2 = new Vector<TimeDependentPredictors>();
                for (Object object2 : objectArray2) {
                    TimeDependentPredictors timeDependentPredictors;
                    if (!(object2 instanceof TimeDependentPredictors) || vector.contains((timeDependentPredictors = (TimeDependentPredictors)object2).getName())) continue;
                    vector2.add(timeDependentPredictors);
                }
                ((CSCoxRegressionDlg)CSCoxRegPredictorsTab.this.mParent).getDialogDataModel().putArray("IDS_COX_REG_TDP_VARIABLE", null);
                ((CSCoxRegressionDlg)CSCoxRegPredictorsTab.this.mParent).getDialogDataModel().putArray("IDS_COX_REG_TDP_VARIABLE", vector2.toArray());
            }
        }
    }

    class EditAction
    extends AbstractAction {
        EditAction() {
            this.putValue("Name", CSCoxRegPredictorsTab.this.getResString("IDS_CSCOX_PREDICTOR_BUTTON_EDIT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ISpssVariable iSpssVariable = (ISpssVariable)CSCoxRegPredictorsTab.this.mTimeDepVarList.getSelectedValue();
            DefineTimeDepPredictorsDlg defineTimeDepPredictorsDlg = new DefineTimeDepPredictorsDlg((CSCoxRegressionDlg)CSCoxRegPredictorsTab.this.mParent, ((ISpssVariable)CSCoxRegPredictorsTab.this.mTimeDepVarList.getSelectedValue()).getName());
            defineTimeDepPredictorsDlg.setVisible(true);
            if (defineTimeDepPredictorsDlg.wasContinuePressed()) {
                TDPListModel tDPListModel = (TDPListModel)CSCoxRegPredictorsTab.this.mTimeDepVarList.getModel();
                tDPListModel.removeElement(iSpssVariable);
                tDPListModel.addElement(defineTimeDepPredictorsDlg.getNewTimeVar());
                CSCoxRegPredictorsTab.this.mTimeDepVarList.setSelectedValue(defineTimeDepPredictorsDlg.getNewTimeVar(), false);
                defineTimeDepPredictorsDlg.dispose();
            }
        }
    }

    class NewAction
    extends AbstractAction {
        NewAction() {
            this.putValue("Name", CSCoxRegPredictorsTab.this.getResString("IDS_CSCOX_PREDICTOR_BUTTON_NEW"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefineTimeDepPredictorsDlg defineTimeDepPredictorsDlg = new DefineTimeDepPredictorsDlg((BaseProcedureDialog)CSCoxRegPredictorsTab.this.mParent, null);
            defineTimeDepPredictorsDlg.setVisible(true);
            if (defineTimeDepPredictorsDlg.wasContinuePressed()) {
                TDPListModel tDPListModel = (TDPListModel)CSCoxRegPredictorsTab.this.mTimeDepVarList.getModel();
                tDPListModel.addElement(defineTimeDepPredictorsDlg.getNewTimeVar());
                defineTimeDepPredictorsDlg.dispose();
            }
        }
    }
}

