/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.cox_reg;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.TimeDependentPredictors;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SpssFocusCellRenderer;
import com.spss.java_client.ui.dialogs.common.SpssFocusGenericRenderer;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesGLMComboBoxModel;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegressionDlg;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.BackgroundColoredCellRenderer;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class CSCoxRegPlotsTab
extends BaseProcedureTab
implements ActionListener,
ItemListener,
FocusListener,
TableModelListener {
    public final int HEAD_COL = 0;
    public final int LVL_VAL_COL = 1;
    public final int LINES_COL = 2;
    private final int NOTES_WIDTH = 600;
    private final int TABLE_HEIGHT = 120;
    private final int TABLE_HEIGHT_MIN = 100;
    private final int ROW_HEIGHT_PAD = 5;
    private JCheckBox mSurvivalCheckBox;
    private JCheckBox mHazardCheckBox;
    private JCheckBox mLogMinusCheckBox;
    private JCheckBox mOneMinusCheckBox;
    private JCheckBox mDisplayCheckBox;
    private JTextArea mNoteTextArea;
    private PlainTable mFactorsTable;
    private DefaultTableModel mFactorsModel;
    private HashMap<String, Object> mFactorsMap = new HashMap();
    private HashMap<String, Object> mOldFactorsMap;
    private JComboBox mFactorsCombo;
    private HashMap<String, Object> mFactorModelsMap;
    private String mCheckedFactor = "";
    private int mCheckedFactorRow = -1;
    private PlainTable mCovariatesTable;
    private DefaultTableModel mCovariatesModel;
    private HashMap<String, Object> mCovariatesMap = new HashMap();
    private HashMap<String, Object> mOldCovariatesMap;
    private JComboBox mCovariatesCombo;
    private HashMap<String, Object> mCovariateModelsMap;
    private final int mMargin = DialogUtil.getGroupBoxInnerMargin();
    private final Insets mInsets = DialogUtil.getStandardControlInsets();
    private int mEditRow;
    private HashMap<Integer, HashMap<String, String>> mFactorCategoryMap = new HashMap();

    public CSCoxRegPlotsTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initializePanel();
    }

    @Override
    public void reset() {
        this.setDefaults();
        this.resetTables();
    }

    public boolean isMisValuePresent() {
        String string;
        String string2;
        int n;
        int n2 = this.mFactorsTable.getRowCount();
        String string3 = this.getResString("IDS_CSCOX_PLOT_HLVL");
        String string4 = this.getResString("IDS_CSCOX_PLOT_MEAN");
        for (n = 0; n < n2; ++n) {
            string2 = this.mFactorsTable.getModel().getValueAt(n, 0).toString();
            string = this.mFactorsTable.getModel().getValueAt(n, 1).toString();
            if (string.equals(string3) || !((CSCoxRegressionDlg)this.mParent).isUserMissingValue(this.getVariable(string2, true), string)) continue;
            return true;
        }
        n2 = this.mCovariatesTable.getRowCount();
        for (n = 0; n < n2; ++n) {
            string2 = this.mCovariatesTable.getModel().getValueAt(n, 0).toString();
            string = this.mCovariatesTable.getModel().getValueAt(n, 1).toString();
            if (string.equals(string4) || !((CSCoxRegressionDlg)this.mParent).isUserMissingValue(this.getVariable(string2, false), string)) continue;
            return true;
        }
        return false;
    }

    public void resetMisValue() {
        String string;
        String string2;
        int n;
        int n2 = this.mFactorsTable.getRowCount();
        String string3 = this.getResString("IDS_CSCOX_PLOT_HLVL");
        String string4 = this.getResString("IDS_CSCOX_PLOT_MEAN");
        for (n = 0; n < n2; ++n) {
            string2 = this.mFactorsTable.getModel().getValueAt(n, 0).toString();
            string = this.mFactorsTable.getModel().getValueAt(n, 1).toString();
            if (!((CSCoxRegressionDlg)this.mParent).isUserMissingValue(this.getVariable(string2, true), string)) continue;
            this.mFactorsTable.getModel().setValueAt(string3, n, 1);
            this.mFactorsMap.put(string2, string3);
        }
        this.mFactorsTable.revalidate();
        n2 = this.mCovariatesTable.getRowCount();
        for (n = 0; n < n2; ++n) {
            string2 = this.mCovariatesTable.getModel().getValueAt(n, 0).toString();
            string = this.mCovariatesTable.getModel().getValueAt(n, 1).toString();
            if (!((CSCoxRegressionDlg)this.mParent).isUserMissingValue(this.getVariable(string2, false), string)) continue;
            this.mCovariatesTable.getModel().setValueAt(string4, n, 1);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        String string;
        Object object = itemEvent.getSource();
        if (this.mCovariatesCombo == object) {
            string = (String)this.mCovariatesCombo.getSelectedItem();
            ((JTextField)this.mCovariatesCombo.getEditor().getEditorComponent()).setText(string);
        }
        if (this.mFactorsCombo == object) {
            string = ((String)this.mFactorsCombo.getSelectedItem()).trim();
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                string = ComponentState.removeBidiDirectionMarks((String)string);
            }
            if (string != null && string.length() > 0) {
                String string2;
                HashMap<String, String> hashMap;
                if (!string.equals(this.getResString("IDS_CSCOX_PLOT_HLVL")) && (hashMap = this.mFactorCategoryMap.get(this.mEditRow)) != null && (string2 = hashMap.get(string)) != null) {
                    string = string2;
                }
                if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                    ((JTextField)this.mFactorsCombo.getEditor().getEditorComponent()).setText(string);
                } else {
                    ((JTextField)this.mFactorsCombo.getEditor().getEditorComponent()).setText(string);
                }
            }
        }
        if (this.mSurvivalCheckBox == object || this.mHazardCheckBox == object || this.mLogMinusCheckBox == object || this.mOneMinusCheckBox == object) {
            this.mDisplayCheckBox.setEnabled(this.mSurvivalCheckBox.isSelected() || this.mHazardCheckBox.isSelected() || this.mLogMinusCheckBox.isSelected() || this.mOneMinusCheckBox.isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cscoxreg_plots";
    }

    @Override
    public boolean validateTab() {
        String string;
        String string2;
        int n;
        int n2 = this.mFactorsTable.getRowCount();
        int n3 = this.mFactorsTable.getEditingRow();
        if (n2 > 0 && n3 > -1) {
            this.mFactorsTable.getCellEditor(n3, 1).stopCellEditing();
        }
        this.mFactorsMap.clear();
        for (n = 0; n < n2; ++n) {
            string2 = this.mFactorsTable.getModel().getValueAt(n, 0).toString();
            string = this.mFactorsTable.getModel().getValueAt(n, 1).toString();
            boolean bl = (Boolean)this.mFactorsTable.getModel().getValueAt(n, 2);
            if (!bl && !this.validateCellValue(n, string2, string, this.mFactorsTable, true)) {
                return false;
            }
            this.mFactorsMap.put(string2, string);
            if (!bl) continue;
            this.mCheckedFactor = string2;
        }
        n2 = this.mCovariatesTable.getRowCount();
        n3 = this.mCovariatesTable.getEditingRow();
        if (n2 > 0 && n3 > -1) {
            this.mCovariatesTable.getCellEditor(n3, 1).stopCellEditing();
        }
        this.mCovariatesMap.clear();
        for (n = 0; n < n2; ++n) {
            string2 = this.mCovariatesTable.getModel().getValueAt(n, 0).toString();
            if (!this.validateCellValue(n, string2, string = this.mCovariatesTable.getModel().getValueAt(n, 1).toString(), this.mCovariatesTable, false)) {
                return false;
            }
            this.mCovariatesMap.put(string2, string);
        }
        return true;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getSource() == this.mFactorsTable) {
            // empty if block
        }
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        this.setupColumnWidths();
        this.mFactorCategoryMap.clear();
        this.updateTables();
        this.enableTables();
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        String string;
        String string2;
        String string3;
        String string4 = "";
        ListModel listModel = ((CSCoxRegressionDlg)this.mParent).getFactorsListModel();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < listModel.getSize(); ++i) {
            ISpssVariable iSpssVariable = (ISpssVariable)listModel.getElementAt(i);
            if (iSpssVariable instanceof TimeDependentPredictors) {
                string2 = string3 = iSpssVariable.getName();
            } else {
                string3 = iSpssVariable.getName();
                string2 = iSpssVariable.getLabel();
                if (string2.length() < 1) {
                    string2 = string3;
                }
            }
            string = (String)this.mFactorsMap.get(string2);
            if (string != null) {
                hashMap.put(string3, string);
            }
            if (!this.mCheckedFactor.equals(string2)) continue;
            string4 = string3;
        }
        listModel = ((CSCoxRegressionDlg)this.mParent).getCovariatesListModel();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        for (int i = 0; i < listModel.getSize(); ++i) {
            ISpssVariable iSpssVariable = (ISpssVariable)listModel.getElementAt(i);
            if (iSpssVariable instanceof TimeDependentPredictors) {
                string2 = string3 = iSpssVariable.getName();
            } else {
                string3 = iSpssVariable.getName();
                string2 = iSpssVariable.getLabel();
                if (string2.length() < 1) {
                    string2 = string3;
                }
            }
            string = (String)this.mCovariatesMap.get(string2);
            if (string == null) continue;
            hashMap2.put(string3, string);
        }
        dialogDataModel.putObject("DM_CSCOX_PLOT_FACTORS", hashMap);
        dialogDataModel.putObject("DM_CSCOX_PLOT_COVARS", hashMap2);
        dialogDataModel.putString("DM_CSCOX_PLOT_CH_FACTOR", string4);
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        String string;
        String string2;
        String string3;
        ISpssVariable iSpssVariable;
        int n;
        String string4 = dialogDataModel.getString("DM_CSCOX_PLOT_CH_FACTOR");
        HashMap hashMap = (HashMap)dialogDataModel.getObject("DM_CSCOX_PLOT_FACTORS");
        HashMap hashMap2 = (HashMap)dialogDataModel.getObject("DM_CSCOX_PLOT_COVARS");
        this.mFactorsMap.clear();
        this.mFactorModelsMap.clear();
        this.mCovariatesMap.clear();
        this.mCovariateModelsMap.clear();
        this.mCheckedFactor = "";
        ListModel listModel = ((CSCoxRegressionDlg)this.mParent).getFactorsListModel();
        for (n = 0; n < listModel.getSize(); ++n) {
            iSpssVariable = (ISpssVariable)listModel.getElementAt(n);
            if (!(iSpssVariable instanceof TimeDependentPredictors)) {
                string3 = iSpssVariable.getName();
                string2 = iSpssVariable.getLabel();
                if (string2.length() < 1) {
                    string2 = string3;
                }
            } else {
                string2 = string3 = iSpssVariable.getName();
            }
            if (hashMap != null && (string = (String)hashMap.get(string3)) != null) {
                this.mFactorsMap.put(string2, string);
            }
            if (string4 == null || !string4.equals(string3)) continue;
            this.mCheckedFactor = string2;
        }
        listModel = ((CSCoxRegressionDlg)this.mParent).getCovariatesListModel();
        for (n = 0; n < listModel.getSize(); ++n) {
            iSpssVariable = (ISpssVariable)listModel.getElementAt(n);
            if (!(iSpssVariable instanceof TimeDependentPredictors)) {
                string3 = iSpssVariable.getName();
                string2 = iSpssVariable.getLabel();
                if (string2.length() < 1) {
                    string2 = string3;
                }
            } else {
                string2 = string3 = iSpssVariable.getName();
            }
            if (hashMap2 == null || (string = (String)hashMap2.get(string3)) == null) continue;
            this.mCovariatesMap.put(string2, string);
        }
    }

    private void updateTables() {
        String string;
        ISpssVariable iSpssVariable;
        int n;
        ListModel listModel = ((CSCoxRegressionDlg)this.mParent).getFactorsListModel();
        this.mOldFactorsMap = new HashMap<String, Object>(this.mFactorsMap);
        int n2 = this.mFactorsModel.getRowCount();
        for (n = n2 - 1; n > -1; --n) {
            this.mFactorsModel.removeRow(n);
        }
        this.mFactorsMap.clear();
        for (n = 0; n < listModel.getSize(); ++n) {
            iSpssVariable = (ISpssVariable)listModel.getElementAt(n);
            if (!(iSpssVariable instanceof TimeDependentPredictors)) {
                string = iSpssVariable.getLabel();
                if (string.length() < 1) {
                    string = iSpssVariable.getName();
                }
                this.addOneFactorVariable(string, n);
                continue;
            }
            this.addOneFactorVariable(iSpssVariable.getName(), n);
        }
        this.mOldFactorsMap.clear();
        listModel = ((CSCoxRegressionDlg)this.mParent).getCovariatesListModel();
        this.mOldCovariatesMap = new HashMap<String, Object>(this.mCovariatesMap);
        n2 = this.mCovariatesModel.getRowCount();
        for (n = n2 - 1; n > -1; --n) {
            this.mCovariatesModel.removeRow(n);
        }
        this.mCovariatesMap.clear();
        for (n = 0; n < listModel.getSize(); ++n) {
            iSpssVariable = (ISpssVariable)listModel.getElementAt(n);
            if (!(iSpssVariable instanceof TimeDependentPredictors)) {
                string = iSpssVariable.getLabel();
                if (string.length() < 1) {
                    string = iSpssVariable.getName();
                }
                this.addOneCovariateVariable(string);
                continue;
            }
            this.addOneCovariateVariable(iSpssVariable.getName());
        }
        this.mOldCovariatesMap.clear();
    }

    private void enableTables() {
        boolean bl = ((CSCoxRegressionDlg)this.mParent).isTdpInPredictors();
        boolean bl2 = !bl && this.mFactorsTable.getRowCount() > 0;
        boolean bl3 = !bl && this.mCovariatesTable.getRowCount() > 0;
        this.mFactorsTable.setVisible(bl2);
        this.mCovariatesTable.setVisible(bl3);
        this.mFactorsTable.getTableHeader().setForeground(bl2 ? this.getForeground() : Color.gray);
        this.mCovariatesTable.getTableHeader().setForeground(bl3 ? this.getForeground() : Color.gray);
    }

    private void addOneCovariateVariable(String string) {
        Object[] objectArray = new String[]{string, this.mOldCovariatesMap.containsKey(string) ? (String)this.mOldCovariatesMap.get(string) : this.getResString("IDS_CSCOX_PLOT_MEAN")};
        this.mCovariatesMap.put(string, objectArray[1]);
        this.mCovariatesModel.addRow(objectArray);
    }

    private void addOneFactorVariable(String string, int n) {
        Object[] objectArray = new Object[3];
        objectArray[0] = string;
        objectArray[1] = this.mOldFactorsMap.containsKey(string) ? this.mOldFactorsMap.get(string) : this.getResString("IDS_CSCOX_PLOT_HLVL");
        if (this.mCheckedFactor.equals(string)) {
            objectArray[2] = true;
            this.mCheckedFactorRow = n;
        } else {
            objectArray[2] = false;
        }
        this.mFactorsMap.put(string, objectArray[1]);
        this.mFactorsModel.addRow(objectArray);
    }

    private void resetTables() {
        int n;
        int n2 = this.mFactorsModel.getRowCount();
        for (n = n2 - 1; n > -1; --n) {
            this.mFactorsModel.removeRow(n);
        }
        n2 = this.mCovariatesModel.getRowCount();
        for (n = n2 - 1; n > -1; --n) {
            this.mCovariatesModel.removeRow(n);
        }
        this.mFactorsMap.clear();
        this.mFactorModelsMap.clear();
        this.mCheckedFactor = "";
        this.mCovariatesMap.clear();
        this.mCovariateModelsMap.clear();
    }

    private void initializePanel() {
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        Insets insets = new Insets(this.mInsets.top, this.mMargin, 0, this.mMargin);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_CSCOX_PLOTS_TAB")));
        JSeparator jSeparator = new JSeparator(0);
        jSeparator.setEnabled(true);
        JSeparator jSeparator2 = new JSeparator(0);
        jSeparator2.setEnabled(true);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mSurvivalCheckBox, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mHazardCheckBox, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mLogMinusCheckBox, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mOneMinusCheckBox, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(n, n, n, n);
        DialogUtil.addUsingGBL(jPanel, jSeparator, gridBagConstraints, 0, 2, 2, 1, n2, insets);
        insets.set(0, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mDisplayCheckBox, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        insets.set(n, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, jSeparator2, gridBagConstraints, 0, 4, 2, 1, n2, insets);
        JPanel jPanel2 = this.setupFactorsPanel();
        JPanel jPanel3 = this.setupCovariatesPanel();
        insets.set(0, n, 0, n);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 5, 2, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 6, 2, 1, n2, insets);
        gridBagConstraints.weighty = 0.0;
        insets.set(n, n * 2, 0, n);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mNoteTextArea, gridBagConstraints, 0, 7, 2, 1, n2, insets);
        gridBagConstraints = new GridBagConstraints();
        insets.set(this.mMargin, n, 0, n);
        n2 = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        this.setFocusTraversalPolicy();
    }

    private JPanel setupFactorsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_CSCOX_PLOT_FACTORS");
        JScrollPane jScrollPane = new JScrollPane(this.mFactorsTable);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setMinimumSize(new Dimension(600, 100));
        jScrollPane.setPreferredSize(new Dimension(600, 120));
        jLabel.setLabelFor(this.mFactorsTable);
        Insets insets = new Insets(this.mMargin, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        insets.set(this.mMargin, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupCovariatesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_CSCOX_PLOT_COVARS");
        JScrollPane jScrollPane = new JScrollPane(this.mCovariatesTable);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setMinimumSize(new Dimension(600, 100));
        jScrollPane.setPreferredSize(new Dimension(600, 120));
        jLabel.setLabelFor(this.mCovariatesTable);
        Insets insets = new Insets(this.mMargin, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        insets.set(this.mMargin, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSurvivalCheckBox);
        vector.add(this.mHazardCheckBox);
        vector.add(this.mLogMinusCheckBox);
        vector.add(this.mOneMinusCheckBox);
        vector.add(this.mDisplayCheckBox);
        vector.add(this.mFactorsTable);
        vector.add(this.mCovariatesTable);
        JPanel jPanel = ((CSCoxRegressionDlg)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void setupTableForFocusRepainting(final JTable jTable) {
        SpssFocusCellRenderer spssFocusCellRenderer = new SpssFocusCellRenderer();
        jTable.setDefaultRenderer(Object.class, spssFocusCellRenderer);
        jTable.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                jTable.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                jTable.repaint();
            }
        });
    }

    private void initVars() {
        this.mSurvivalCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_CSCOX_PLOT_SURV_CHECK", null);
        this.mHazardCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_CSCOX_PLOT_HAZ_CHECK", null);
        this.mLogMinusCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_CSCOX_PLOT_LGM_CHECK", null);
        this.mOneMinusCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_CSCOX_PLOT_ONE_CHECK", null);
        this.mDisplayCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_CSCOX_PLOT_DISP_CHECK", null);
        this.mSurvivalCheckBox.addItemListener(this);
        this.mHazardCheckBox.addItemListener(this);
        this.mLogMinusCheckBox.addItemListener(this);
        this.mOneMinusCheckBox.addItemListener(this);
        this.mNoteTextArea = new JTextArea(this.getResString("IDS_CSCOX_PLOT_NOTE"));
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        vector2.add(this.getResString("IDS_LOGISTIC_REGRESSION_ODDS_RATIOS_FACTOR_COLUMN_LABEL"));
        vector2.add(this.getResString("IDS_CSCOX_PLOT_LEVEL"));
        vector2.add(this.getResString("IDS_CSCOX_PLOT_LINES"));
        this.mFactorsModel = new DefaultTableModel(vector, vector2){

            @Override
            public boolean isCellEditable(int n, int n2) {
                if (n2 == 1) {
                    return (Boolean)this.getValueAt(n, 2) == false;
                }
                return n2 > 0;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (n2 == 2) {
                    return CSCoxRegPlotsTab.this.mCheckedFactorRow == n;
                }
                return super.getValueAt(n, n2);
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (n2 == 2) {
                    if (((Boolean)object).booleanValue()) {
                        CSCoxRegPlotsTab.this.mCheckedFactorRow = n;
                        CSCoxRegPlotsTab.this.mCheckedFactor = (String)this.getValueAt(n, 0);
                    } else {
                        CSCoxRegPlotsTab.this.mCheckedFactorRow = -1;
                        CSCoxRegPlotsTab.this.mCheckedFactor = "";
                    }
                    this.fireTableRowsUpdated(0, this.getRowCount() - 1);
                } else {
                    super.setValueAt(object, n, n2);
                }
            }

            @Override
            public Class<?> getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }
        };
        this.mFactorsTable = new PlainTable();
        this.mFactorsTable.setModel(this.mFactorsModel);
        this.mFactorsTable.addFocusListener(this);
        this.mFactorsTable.setRowSelectionAllowed(true);
        this.mFactorsTable.setSelectionMode(0);
        this.mFactorsTable.setColumnSelectionAllowed(false);
        this.setupTableForFocusRepainting(this.mFactorsTable);
        this.mFactorsCombo = new JComboBox();
        this.mFactorsCombo.addItemListener(this);
        BackgroundColoredCellRenderer backgroundColoredCellRenderer = new BackgroundColoredCellRenderer(this);
        this.mFactorsTable.getColumnModel().getColumn(0).setCellRenderer(backgroundColoredCellRenderer);
        this.mFactorsTable.getColumnModel().getColumn(1).setCellRenderer(new LevelCellRenderer());
        LevelValCellEditor levelValCellEditor = new LevelValCellEditor(this.mFactorsCombo, true, this.mFactorsTable);
        this.mFactorsTable.getColumnModel().getColumn(1).setCellEditor(levelValCellEditor);
        this.mFactorsTable.getColumnModel().getColumn(2).setCellRenderer(new SpssFocusGenericRenderer(new CheckCellRenderer()));
        levelValCellEditor.addCellEditorListener(this.createTableCellEditorListener());
        this.mFactorsTable.setFocusable(true);
        this.mFactorsTable.setSurrendersFocusOnKeystroke(true);
        this.mFactorsTable.setFocusTraversalKeys(0, null);
        this.mFactorsTable.setRowHeight(this.mFactorsTable.getRowHeight() + 5);
        this.mFactorModelsMap = new HashMap();
        JTableHeader jTableHeader = this.mFactorsTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        Font font = jTableHeader.getFont().deriveFont(1);
        TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
        jTableHeader.setDefaultRenderer(new BoldFontRenderer(tableCellRenderer, font));
        vector = new Vector();
        vector2 = new Vector();
        vector2.add(this.getResString("IDS_LOGISTIC_REGRESSION_ODDS_RATIOS_COVARIATE_COLUMN_LABEL"));
        vector2.add(this.getResString("IDS_CSCOX_PLOT_VALUE"));
        this.mCovariatesModel = new DefaultTableModel(vector, vector2){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 > 0;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return super.getValueAt(n, n2);
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                super.setValueAt(object, n, n2);
            }
        };
        this.mCovariatesTable = new PlainTable();
        this.mCovariatesTable.setModel(this.mCovariatesModel);
        this.mCovariatesTable.addFocusListener(this);
        this.mCovariatesTable.setRowSelectionAllowed(true);
        this.mCovariatesTable.setSelectionMode(0);
        this.mCovariatesTable.setColumnSelectionAllowed(false);
        this.mCovariatesCombo = new JComboBox<String>(new String[]{this.getResString("IDS_CSCOX_PLOT_MEAN")});
        this.mCovariatesCombo.addItemListener(this);
        BackgroundColoredCellRenderer backgroundColoredCellRenderer2 = new BackgroundColoredCellRenderer(this);
        this.mCovariatesTable.getColumnModel().getColumn(0).setCellRenderer(backgroundColoredCellRenderer2);
        this.mCovariatesTable.getColumnModel().getColumn(1).setCellRenderer(new LevelCellRenderer());
        this.mCovariatesTable.getColumnModel().getColumn(1).setCellEditor(new LevelValCellEditor(this.mCovariatesCombo, false, this.mCovariatesTable));
        this.mCovariatesTable.setFocusable(true);
        this.mCovariatesTable.setFocusTraversalKeys(0, null);
        this.mCovariatesTable.setRowHeight(this.mFactorsTable.getRowHeight() + 5);
        this.setupTableForFocusRepainting(this.mCovariatesTable);
        this.mCovariateModelsMap = new HashMap();
        jTableHeader = this.mCovariatesTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        font = jTableHeader.getFont().deriveFont(1);
        tableCellRenderer = jTableHeader.getDefaultRenderer();
        jTableHeader.setDefaultRenderer(new BoldFontRenderer(tableCellRenderer, font));
    }

    private CellEditorListener createTableCellEditorListener() {
        return new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
            }

            @Override
            public void editingCanceled(ChangeEvent changeEvent) {
            }
        };
    }

    private void setupColumnWidths() {
        TableColumnModel tableColumnModel = this.mFactorsTable.getColumnModel();
        int n = this.mFactorsTable.getWidth();
        tableColumnModel.getColumn(0).setPreferredWidth((int)((double)n * 0.35));
        tableColumnModel.getColumn(1).setPreferredWidth((int)((double)n * 0.35));
        tableColumnModel.getColumn(2).setPreferredWidth((int)((double)n * 0.15));
        tableColumnModel = this.mCovariatesTable.getColumnModel();
        n = this.mCovariatesTable.getWidth();
        tableColumnModel.getColumn(0).setPreferredWidth((int)((double)n * 0.4));
        tableColumnModel.getColumn(1).setPreferredWidth((int)((double)n * 0.4));
    }

    private void setDefaults() {
        this.mSurvivalCheckBox.setSelected(false);
        this.mHazardCheckBox.setSelected(false);
        this.mLogMinusCheckBox.setSelected(false);
        this.mOneMinusCheckBox.setSelected(false);
        this.mDisplayCheckBox.setSelected(false);
        this.mDisplayCheckBox.setEnabled(false);
        this.mNoteTextArea.setOpaque(false);
        this.mNoteTextArea.setLineWrap(true);
        this.mNoteTextArea.setWrapStyleWord(true);
        this.mNoteTextArea.setBorder(BorderFactory.createEmptyBorder());
        this.mNoteTextArea.setBackground(this.getBackground());
        this.mNoteTextArea.setEditable(false);
        this.mNoteTextArea.setRows(3);
        this.mNoteTextArea.setFocusable(false);
        this.mNoteTextArea.setPreferredSize(new Dimension(600, this.mDisplayCheckBox.getHeight()));
    }

    private ComplexSamplesGLMComboBoxModel fillCategoryCombo(String string, JTable jTable) {
        Set set;
        IValueLabelMap iValueLabelMap;
        ISpssVariable iSpssVariable = this.getVariable(string, true);
        Object[] objectArray = new String[]{this.getResString("IDS_CSCOX_PLOT_HLVL")};
        if (iSpssVariable != null && (iValueLabelMap = iSpssVariable.getValueLabels()) != null && (set = iValueLabelMap.getValueLabelEntries()).size() > 0) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n = set.size();
            objectArray = new String[n + 1];
            objectArray[0] = this.getResString("IDS_CSCOX_PLOT_HLVL");
            int n2 = 0;
            boolean bl = !((CSCoxRegressionDlg)this.mParent).isUserMissingIncluded();
            for (Map.Entry entry : set) {
                OBS oBS = (OBS)entry.getKey();
                if (bl && iSpssVariable.isMissing(oBS)) continue;
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = oBS.isString() ? oBS.getString().trim() : UIToolResUtil.addLocale((String)Double.toString(oBS.getNum()));
                stringBuffer.append(string2);
                stringBuffer.append(" ");
                stringBuffer.append(((String)entry.getValue()).trim());
                objectArray[++n2] = stringBuffer.toString();
                hashMap.put(stringBuffer.toString(), string2);
            }
            this.mFactorCategoryMap.put(this.mEditRow, hashMap);
        }
        return new ComplexSamplesGLMComboBoxModel(objectArray, jTable);
    }

    private ISpssVariable getVariable(String string, boolean bl) {
        ISpssVariable iSpssVariable = null;
        ListModel listModel = bl ? ((CSCoxRegressionDlg)this.mParent).getFactorsListModel() : ((CSCoxRegressionDlg)this.mParent).getCovariatesListModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            ISpssVariable iSpssVariable2 = (ISpssVariable)listModel.getElementAt(i);
            if (iSpssVariable2 instanceof TimeDependentPredictors) continue;
            String string2 = iSpssVariable2.getLabel();
            if (string2.length() < 1) {
                string2 = iSpssVariable2.getName();
            }
            if (!string2.equals(string)) continue;
            iSpssVariable = iSpssVariable2;
            break;
        }
        return iSpssVariable;
    }

    private boolean validateCellByRow(int n, boolean bl) {
        PlainTable plainTable = bl ? this.mFactorsTable : this.mCovariatesTable;
        if (n < 0 || n > plainTable.getModel().getRowCount() - 1) {
            return true;
        }
        String string = plainTable.getModel().getValueAt(n, 0).toString();
        String string2 = plainTable.getCellEditor(n, 1).getCellEditorValue().toString().trim();
        return this.validateCellValue(n, string, string2, plainTable, bl);
    }

    private boolean validateCellValue(final int n, String string, String string2, final JTable jTable, boolean bl) {
        boolean bl2 = true;
        if (string2.length() < 1) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_CS_ORDINAL_OPTIONS_EMPTY_FIELD_ERROR1"), VersionInfo.getAppVersionString());
            bl2 = false;
        }
        if (bl2 && (bl && !string2.equals(this.getResString("IDS_CSCOX_PLOT_HLVL")) || !bl && !string2.equals(this.getResString("IDS_CSCOX_PLOT_MEAN")))) {
            OBS oBS = new OBS();
            ISpssVariable iSpssVariable = this.getVariable(string, bl);
            if (iSpssVariable != null && !CellValueFormatter.stringToObs((String)string2, (SPSS_Format)iSpssVariable.getFormat(), (OBS)oBS)) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("IDS_CSCOX_PLOT_VAL_ERR"), VersionInfo.getAppVersionString());
                bl2 = false;
            }
        }
        if (!bl2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Rectangle rectangle = jTable.getCellRect(n, 1, true);
                    if (rectangle != null) {
                        jTable.scrollRectToVisible(rectangle);
                    }
                    jTable.requestFocus();
                    jTable.setRowSelectionInterval(n, n);
                    jTable.setColumnSelectionInterval(1, 1);
                    jTable.editCellAt(n, 1);
                }
            });
        }
        return bl2;
    }

    private class BoldFontRenderer
    implements TableCellRenderer {
        private TableCellRenderer mHeaderRenderer;
        private Font mBoldFont;

        BoldFontRenderer(TableCellRenderer tableCellRenderer, Font font) {
            this.mHeaderRenderer = tableCellRenderer;
            this.mBoldFont = font;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = null;
            component = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? this.mHeaderRenderer.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : this.mHeaderRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            component.setFont(this.mBoldFont);
            CSCoxRegPlotsTab.this.setEnabled(jTable.isEnabled());
            return component;
        }
    }

    public class CheckCellRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public CheckCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setEnabled(jTable.isEnabled());
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setSelected(object != null && (Boolean)object != false);
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(this.noFocusBorder);
            }
            return this;
        }
    }

    private class LevelValCellEditor
    extends DefaultCellEditor {
        private JComboBox mComboBox;
        boolean mFactors;
        private JTable mTable;

        public LevelValCellEditor(JComboBox jComboBox, boolean bl, JTable jTable) {
            super(jComboBox);
            this.mComboBox = jComboBox;
            this.mFactors = bl;
            this.mTable = jTable;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Object object2;
            this.mComboBox.setEditable(true);
            CSCoxRegPlotsTab.this.mEditRow = n;
            if (this.mFactors) {
                String string = CSCoxRegPlotsTab.this.mFactorsModel.getValueAt(n, 0).toString();
                if (CSCoxRegPlotsTab.this.mFactorModelsMap.containsKey(string)) {
                    CSCoxRegPlotsTab.this.mFactorModelsMap.remove(string);
                }
                object2 = CSCoxRegPlotsTab.this.fillCategoryCombo(string, CSCoxRegPlotsTab.this.mFactorsTable);
                this.mComboBox.setModel(object2);
                CSCoxRegPlotsTab.this.mFactorModelsMap.put(string, object2);
            } else {
                String string = CSCoxRegPlotsTab.this.mCovariatesModel.getValueAt(n, 0).toString();
                if (CSCoxRegPlotsTab.this.mCovariateModelsMap.containsKey(string)) {
                    this.mComboBox.setModel((ComboBoxModel)CSCoxRegPlotsTab.this.mCovariateModelsMap.get(string));
                } else {
                    object2 = new ComplexSamplesGLMComboBoxModel(new String[]{CSCoxRegPlotsTab.this.getResString("IDS_CSCOX_PLOT_MEAN")}, CSCoxRegPlotsTab.this.mCovariatesTable);
                    this.mComboBox.setModel(object2);
                    CSCoxRegPlotsTab.this.mCovariateModelsMap.put(string, object2);
                }
            }
            ((ComplexSamplesGLMComboBoxModel)this.mComboBox.getModel()).setSelectedItem(object.toString(), n, n2);
            CSCoxRegPlotsTab.this.setEnabled(jTable.isEnabled());
            if (this.mFactors && n2 == 1) {
                object2 = (Boolean)this.mTable.getModel().getValueAt(n, 2);
                if (((Boolean)object2).booleanValue()) {
                    this.mComboBox.setEditable(false);
                    this.mComboBox.setEnabled(false);
                } else {
                    this.mComboBox.setEditable(true);
                    this.mComboBox.setEnabled(true);
                }
            }
            return this.mComboBox;
        }

        @Override
        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }
    }

    private class LevelCellRenderer
    extends SpssFocusCellRenderer {
        private LevelCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                this.setText(object.toString());
            }
            if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2);
            } else {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            this.setEnabled(jTable.isEnabled());
            if (jTable == CSCoxRegPlotsTab.this.mFactorsTable && n2 == 1) {
                Boolean bl3 = (Boolean)jTable.getModel().getValueAt(n, 2);
                if (bl3.booleanValue()) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(jTable.isEnabled());
                }
            }
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }

        @Override
        public void setToolTipText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setToolTipText(string);
            }
        }
    }
}

