/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.cox_reg;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineRadioButton;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegressionDlg;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class CSCoxRegOptionsTab
extends BaseProcedureTab
implements ItemListener,
FocusListener {
    public static final String MIN_PARAMETER_KEY = "MIN_CHANGE_PARAMETER_KEY";
    public static final String TYPE_PARAMETER_KEY = "TYPE_PARAMETER_KEY";
    public static final String MIN_LOG_KEY = "MIN_CHANGE_LOG_KEY";
    public static final String TYPE_LOG_KEY = "TYPE_LOG_KEY";
    public static final String CONFIDENCE_KEY = "CONFIDENCE_TEXT_KEY";
    public static final String TRANSFORMATION_KEY = "CONF_TRANSFORMATION";
    private IntTextField mMaxIterationTextfield;
    private IntTextField mMaxStepTextfield;
    private JCheckBox mLimitParameterEstimatesCheckBox;
    private JLabel mMinChangeParameterLabel;
    private FloatTextField mMinChangeParameterTextfield;
    private JLabel mTypeParameterLabel;
    private JComboBox mTypeParameterComboBox;
    private JCheckBox mLimitLogLikelihoodCheckBox;
    private JLabel mMinChangeLogLabel;
    private FloatTextField mMinChangeLogTextfield;
    private JLabel mTypeLogLabel;
    private JComboBox mTypeLogComboBox;
    private JCheckBox mDisplayHistoryCheckBox;
    private JLabel mIncrementLabel;
    private IntTextField mIncrementTextField;
    private JRadioButton mTieEfronRadio;
    private JRadioButton mTieBreslowRadio;
    private SpssButtonGroup mTieBreakingGroup;
    private JRadioButton mMetEfronRadio;
    private JRadioButton mMetBreslowRadio;
    private JRadioButton mProductLimitRadio;
    private SpssButtonGroup mMethodBaselineGroup;
    private JRadioButton mConfTransformedRadio;
    private JLabel mConfTransformationLabel;
    private JComboBox mConfTransformationComboBox;
    private JRadioButton mConfOriginalRadio;
    private SpssButtonGroup mConfIntervalsGroup;
    private JRadioButton mInValidRadioButton;
    private JRadioButton mValidRadioButton;
    private JTextArea mUserMisTextArea;
    private SpssButtonGroup mUserMisGroup;
    private JLabel mConfidenceLabel;
    private FloatTextField mConfidenceTextField;
    private final int mIndent = DialogUtil.getGroupingIndent();
    private final int mMargin = DialogUtil.getGroupBoxInnerMargin();
    private final Insets mInsets = DialogUtil.getStandardControlInsets();

    public CSCoxRegOptionsTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initializePanel();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void reset() {
        this.setDefaults();
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mMaxIterationTextfield;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.mLimitParameterEstimatesCheckBox == itemEvent.getSource()) {
            this.enableControls(GroupType.GR_LIMIT_PAR, this.mLimitParameterEstimatesCheckBox.isSelected());
        } else if (this.mLimitLogLikelihoodCheckBox == itemEvent.getSource()) {
            this.enableControls(GroupType.GR_LIMIT_LOG, this.mLimitLogLikelihoodCheckBox.isSelected());
        } else if (this.mDisplayHistoryCheckBox == itemEvent.getSource()) {
            this.enableControls(GroupType.GR_DISPLAY, this.mDisplayHistoryCheckBox.isSelected());
        } else if (this.mConfTransformedRadio == itemEvent.getSource()) {
            this.enableControls(GroupType.GR_TRANSFORM, this.mConfTransformedRadio.isSelected());
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cscoxreg_options";
    }

    @Override
    public boolean validateTab() {
        if (this.mMaxIterationTextfield.getText().trim().length() < 1) {
            return this.errorMessageForValue((JComponent)this.mMaxIterationTextfield);
        }
        String string = this.mMaxStepTextfield.getText().trim();
        if (string.length() < 1) {
            return this.errorMessageForValue((JComponent)this.mMaxStepTextfield);
        }
        if (Integer.parseInt(string) < 1) {
            return this.errorMessageForPosValue((JComponent)this.mMaxStepTextfield);
        }
        if (this.mLimitParameterEstimatesCheckBox.isSelected() && this.mMinChangeParameterTextfield.getText().trim().length() < 1) {
            return this.errorMessageForValue((JComponent)this.mMinChangeParameterTextfield);
        }
        if (this.mLimitLogLikelihoodCheckBox.isSelected() && this.mMinChangeLogTextfield.getText().trim().length() < 1) {
            return this.errorMessageForValue((JComponent)this.mMinChangeLogTextfield);
        }
        if (this.mDisplayHistoryCheckBox.isSelected()) {
            string = this.mIncrementTextField.getText().trim();
            if (string.length() < 1) {
                return this.errorMessageForValue((JComponent)this.mIncrementTextField);
            }
            if (Integer.parseInt(string) < 1) {
                return this.errorMessageForPosValue((JComponent)this.mIncrementTextField);
            }
        }
        if ((string = this.mConfidenceTextField.getText().trim()).length() < 1) {
            return this.errorMessageForValue((JComponent)this.mConfidenceTextField);
        }
        double d = Double.parseDouble(string);
        if (d < 50.0 || !(d < 100.0)) {
            this.mConfidenceTextField.grabFocus();
            return false;
        }
        return this.validateUserMissing();
    }

    public boolean validateUserMissing() {
        if (!this.mInValidRadioButton.isSelected()) {
            return true;
        }
        boolean bl = ((CSCoxRegressionDlg)this.mParent).isEventMisValPresent();
        boolean bl2 = ((CSCoxRegressionDlg)this.mParent).isSubgroupsMisValPresent();
        boolean bl3 = ((CSCoxRegressionDlg)this.mParent).isPlotsMisValPresent();
        if (bl || bl2 || bl3) {
            int n = SpssAlertOptionPane.showConfirmDialog((Window)this.mParent, this.getResString("ERR_CSCOX_OPT_MIS_VAL"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            if (n == 0) {
                ((CSCoxRegressionDlg)this.mParent).resetMisValue(bl, bl2, bl3);
                if (bl) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean isUserMissingIncluded() {
        return this.mValidRadioButton.isSelected();
    }

    private boolean errorMessageForValue(JComponent jComponent) {
        SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_CS_ORDINAL_OPTIONS_EMPTY_FIELD_ERROR1"), VersionInfo.getAppVersionString());
        jComponent.grabFocus();
        return false;
    }

    private boolean errorMessageForPosValue(JComponent jComponent) {
        jComponent.grabFocus();
        return false;
    }

    private void initializePanel() {
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        Insets insets = new Insets(n, n, 0, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, this.setupEstimationPanel(), gridBagConstraints, 0, 0, 1, 2, n2, insets);
        DialogUtil.addUsingGBL(this, this.setupSurvivalPanel(), gridBagConstraints, 1, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(this, this.setupUserMissingPanel(), gridBagConstraints, 1, 1, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(this, this.setupConfidencePanel(), gridBagConstraints, 0, 2, 1, 1, n2, insets);
        this.setFocusTraversalPolicy();
    }

    private JPanel setupEstimationPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_LOGISTIC_REGRESSION_OPTIONS_ESTIMATION_LABEL")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_LOGISTIC_REGRESSION_OPTIONS_MAX_ITERATION_LABEL");
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_LOGISTIC_REGRESSION_OPTIONS_MAX_STEP_LABEL");
        int n2 = jLabel.getPreferredSize().width;
        int n3 = jLabel2.getPreferredSize().width;
        int n4 = jLabel2.getPreferredSize().height;
        if (n2 < n3) {
            n2 = n3;
        }
        jLabel.setPreferredSize(new Dimension(n2, n4));
        jLabel2.setPreferredSize(new Dimension(n2, n4));
        jLabel.setLabelFor((Component)this.mMaxIterationTextfield);
        JPanel jPanel2 = new JPanel(new FlowLayout(3));
        jPanel2.add(jLabel);
        jPanel2.add(Box.createHorizontalStrut(this.mMargin));
        jPanel2.add((Component)this.mMaxIterationTextfield);
        insets.set(this.mMargin, this.mMargin, 0, 0);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        jLabel2.setLabelFor((Component)this.mMaxStepTextfield);
        JPanel jPanel3 = new JPanel(new FlowLayout(3));
        jPanel3.add(jLabel2);
        jPanel3.add(Box.createHorizontalStrut(this.mMargin));
        jPanel3.add((Component)this.mMaxStepTextfield);
        insets.set(this.mMargin * 2, this.mMargin, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(this.mMargin * 3, this.mMargin, 0, this.mMargin);
        DialogUtil.addUsingGBL(jPanel, this.mLimitParameterEstimatesCheckBox, gridBagConstraints, 0, 2, 3, 1, n, insets);
        JPanel jPanel4 = this.setupMinChangeParameterEstimatesPanel();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 3, 3, 1, n, insets);
        gridBagConstraints.fill = 0;
        insets.set(this.mMargin * 2, this.mMargin, 0, this.mMargin);
        DialogUtil.addUsingGBL(jPanel, this.mLimitLogLikelihoodCheckBox, gridBagConstraints, 0, 4, 3, 1, n, insets);
        JPanel jPanel5 = this.setupMinChangeLogLikelihoodPanel();
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 5, 3, 1, n, insets);
        gridBagConstraints.fill = 0;
        insets.set(this.mMargin * 2, this.mMargin, 0, this.mMargin);
        DialogUtil.addUsingGBL(jPanel, this.mDisplayHistoryCheckBox, gridBagConstraints, 0, 6, 3, 1, n, insets);
        JPanel jPanel6 = new JPanel(new FlowLayout(3));
        jPanel6.add(this.mIncrementLabel);
        jPanel6.add(Box.createHorizontalStrut(this.mMargin));
        jPanel6.add((Component)this.mIncrementTextField);
        gridBagConstraints.weightx = 0.0;
        insets.set(this.mMargin, this.mMargin + this.mIndent, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel6, gridBagConstraints, 0, 7, 1, 1, n, insets);
        JLabel jLabel3 = DialogUtil.createLabel(this.mParent, "IDS_CSCOX_OPT_TIE_BREAK_LABEL");
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        insets.set(this.mMargin, this.mMargin, 0, 0);
        DialogUtil.addUsingGBL(jPanel7, jLabel3, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(this.mInsets.top, this.mMargin + this.mIndent, 0, 0);
        DialogUtil.addUsingGBL(jPanel7, this.mTieEfronRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel7, this.mTieBreslowRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.mTieBreakingGroup = DialogUtil.createButtonGroup(jPanel7);
        gridBagConstraints.weighty = 1.0;
        insets.set(this.mMargin, this.mInsets.left, 0, this.mMargin);
        DialogUtil.addUsingGBL(jPanel, jPanel7, gridBagConstraints, 0, 8, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupSurvivalPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_CSCOX_OPT_SURVIVAL_TITLE")));
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_CSCOX_OPT_METHOD_LABEL");
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_CSCOX_OPT_CONF_INT_LABEL");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(this.mMetEfronRadio);
        jPanel2.add(this.mMetBreslowRadio);
        jPanel2.add(this.mProductLimitRadio);
        this.mMethodBaselineGroup = DialogUtil.createButtonGroup(jPanel2);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = new Insets(0, 0, 0, 0);
        insets.set(this.mMargin, this.mInsets.left, 0, this.mMargin);
        DialogUtil.addUsingGBL(jPanel3, this.mConfTransformedRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        insets.set(this.mMargin, this.mMargin + this.mIndent, 0, this.mMargin);
        DialogUtil.addUsingGBL(jPanel3, this.mConfTransformationLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(this.mMargin, this.mMargin, 0, this.mMargin);
        DialogUtil.addUsingGBL(jPanel3, this.mConfTransformationComboBox, gridBagConstraints, 1, 1, 1, 1, n, insets);
        insets.set(this.mMargin, this.mInsets.left, 0, this.mMargin);
        DialogUtil.addUsingGBL(jPanel3, this.mConfOriginalRadio, gridBagConstraints, 0, 2, 2, 1, n, insets);
        this.mConfIntervalsGroup = DialogUtil.createButtonGroup(jPanel3);
        gridBagConstraints.weightx = 1.0;
        insets.set(this.mInsets.top, this.mMargin, 0, this.mMargin);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(this.mInsets.top, this.mMargin + this.mIndent, 0, this.mMargin);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(this.mMargin * 2, this.mMargin, 0, this.mMargin);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        insets.set(this.mInsets.top, this.mMargin + this.mIndent, 0, this.mMargin);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 3, 2, 1, n, insets);
        return jPanel;
    }

    private JPanel setupUserMissingPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_COMPLEX_SAMPLES_COMMON_OPTIONS_USER_MISSING_VALUES_LABEL")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = new Insets(0, 0, 0, 0);
        insets.set(this.mInsets.top, this.mMargin, 0, this.mMargin);
        DialogUtil.addUsingGBL(jPanel, this.mInValidRadioButton, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mValidRadioButton, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        insets.set(this.mMargin * 2, this.mMargin, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mUserMisTextArea, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.mUserMisGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupConfidencePanel() {
        JPanel jPanel = new JPanel(new FlowLayout(3));
        jPanel.add(this.mConfidenceLabel);
        jPanel.add(Box.createHorizontalStrut(this.mMargin));
        jPanel.add((Component)this.mConfidenceTextField);
        return jPanel;
    }

    private JPanel setupMinChangeParameterEstimatesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = new Insets(0, 0, 0, 0);
        insets.set(this.mMargin, this.mMargin + this.mIndent, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMinChangeParameterLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(this.mMargin, this.mMargin, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinChangeParameterTextfield, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(this.mMargin, this.mMargin + this.mIndent, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTypeParameterLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(this.mMargin, this.mMargin, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTypeParameterComboBox, gridBagConstraints, 3, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupMinChangeLogLikelihoodPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = new Insets(0, 0, 0, 0);
        insets.set(this.mMargin, this.mMargin + this.mIndent, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMinChangeLogLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(this.mMargin, this.mMargin, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinChangeLogTextfield, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(this.mMargin, this.mMargin + this.mIndent, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTypeLogLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(this.mMargin, this.mMargin, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTypeLogComboBox, gridBagConstraints, 3, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMaxIterationTextfield);
        vector.add(this.mMaxStepTextfield);
        vector.add(this.mLimitParameterEstimatesCheckBox);
        vector.add(this.mMinChangeParameterTextfield);
        vector.add(this.mTypeParameterComboBox);
        vector.add(this.mLimitLogLikelihoodCheckBox);
        vector.add(this.mMinChangeLogTextfield);
        vector.add(this.mTypeLogComboBox);
        vector.add(this.mDisplayHistoryCheckBox);
        vector.add(this.mIncrementTextField);
        vector.add(this.mTieBreakingGroup);
        vector.add(this.mConfidenceTextField);
        vector.add(this.mMethodBaselineGroup);
        vector.add(this.mConfIntervalsGroup);
        vector.add(this.mConfTransformationComboBox);
        vector.add(this.mUserMisGroup);
        JPanel jPanel = ((CSCoxRegressionDlg)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void initVars() {
        this.mMaxIterationTextfield = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mMaxIterationTextfield.setAction((Action)new TextFieldAction(this.mParent, "IDS_LOGISTIC_REGRESSION_OPTIONS_MAX_ITERATION_LABEL"));
        this.mMaxIterationTextfield.setColumns(5);
        this.mMaxIterationTextfield.addFocusListener((FocusListener)new textFieldFocusAdapter());
        this.mMaxStepTextfield = new IntTextField(1, Integer.MAX_VALUE, true);
        this.mMaxStepTextfield.setAction((Action)new TextFieldAction(this.mParent, "IDS_LOGISTIC_REGRESSION_OPTIONS_MAX_STEP_LABEL"));
        this.mMaxStepTextfield.setColumns(5);
        this.mMaxStepTextfield.addFocusListener((FocusListener)new textFieldFocusAdapter());
        this.mLimitParameterEstimatesCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_LOGISTIC_REGRESSION_OPTIONS_LIMIT_ITERATIONS_PARA_ESTIMATES_CHECKBOX", null);
        this.mLimitParameterEstimatesCheckBox.addItemListener(this);
        this.mMinChangeParameterLabel = DialogUtil.createLabel(this.mParent, "IDS_LOGISTIC_REGRESSION_OPTIONS_MIN_CHANGE_PARA_LABEL");
        this.mMinChangeParameterTextfield = new FloatTextField(0.0, Double.MAX_VALUE, Integer.MAX_VALUE, true);
        this.mMinChangeParameterTextfield.setAction((Action)new TextFieldAction(this.mParent, MIN_PARAMETER_KEY));
        this.mMinChangeParameterTextfield.setColumns(6);
        this.mMinChangeParameterTextfield.addFocusListener((FocusListener)new textFieldFocusAdapter());
        this.mMinChangeParameterLabel.setLabelFor((Component)this.mMinChangeParameterTextfield);
        this.mTypeParameterLabel = DialogUtil.createLabel(this.mParent, "IDS_LOGISTIC_REGRESSION_OPTIONS_TYPE1_LABEL");
        this.mTypeParameterComboBox = new JComboBox<String>(this.getResStringArray("IDS_LOGISTIC_REGRESSION_OPTIONS_TYPE_COMBO"));
        this.mTypeParameterComboBox.setAction(new ComboboxAction(this.mParent, TYPE_PARAMETER_KEY));
        this.mTypeParameterLabel.setLabelFor(this.mTypeParameterComboBox);
        this.mLimitLogLikelihoodCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_LOGISTIC_REGRESSION_OPTIONS_LIMIT_ITERATIONS_LOG_CHECKBOX", null);
        this.mLimitLogLikelihoodCheckBox.addItemListener(this);
        this.mMinChangeLogLabel = DialogUtil.createLabel(this.mParent, "IDS_LOGISTIC_REGRESSION_OPTIONS_MIN_CHANGE_LOG_LABEL");
        this.mMinChangeLogTextfield = new FloatTextField(0.0, Double.MAX_VALUE, Integer.MAX_VALUE, true);
        this.mMinChangeLogTextfield.setAction((Action)new TextFieldAction(this.mParent, MIN_LOG_KEY));
        this.mMinChangeLogTextfield.setColumns(6);
        this.mMinChangeLogTextfield.addFocusListener((FocusListener)new textFieldFocusAdapter());
        this.mMinChangeLogLabel.setLabelFor((Component)this.mMinChangeLogTextfield);
        this.mTypeLogLabel = DialogUtil.createLabel(this.mParent, "IDS_LOGISTIC_REGRESSION_OPTIONS_TYPE2_LABEL");
        this.mTypeLogComboBox = new JComboBox<String>(this.getResStringArray("IDS_LOGISTIC_REGRESSION_OPTIONS_TYPE_COMBO"));
        this.mTypeLogComboBox.setAction(new ComboboxAction(this.mParent, TYPE_LOG_KEY));
        this.mTypeLogLabel.setLabelFor(this.mTypeLogComboBox);
        this.mDisplayHistoryCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_LOGISTIC_REGRESSION_OPTIONS_DISPLAY_ITERATION_CHECKBOX", null);
        this.mDisplayHistoryCheckBox.addItemListener(this);
        this.mIncrementLabel = DialogUtil.createLabel(this.mParent, "IDS_LOGISTIC_REGRESSION_OPTIONS_INCREMENT_LABEL");
        this.mIncrementTextField = new IntTextField(1, Integer.MAX_VALUE, true);
        this.mIncrementTextField.setAction((Action)new TextFieldAction(this.mParent, "IDS_LOGISTIC_REGRESSION_OPTIONS_INCREMENT_LABEL"));
        this.mIncrementTextField.setColumns(5);
        this.mIncrementTextField.addFocusListener((FocusListener)new textFieldFocusAdapter());
        this.mIncrementLabel.setLabelFor((Component)this.mIncrementTextField);
        this.mTieEfronRadio = DialogUtil.createRadioButton(this.mParent, "IDS_CSCOX_OPT_TIE_EFRON_RADIO", null);
        this.mTieBreslowRadio = DialogUtil.createRadioButton(this.mParent, "IDS_CSCOX_OPT_TIE_BRESLOW_RADIO", null);
        this.mMetEfronRadio = DialogUtil.createRadioButton(this.mParent, "IDS_CSCOX_OPT_MET_EFRON_RADIO", null);
        this.mMetBreslowRadio = DialogUtil.createRadioButton(this.mParent, "IDS_CSCOX_OPT_MET_BRESLOW_RADIO", null);
        this.mProductLimitRadio = DialogUtil.createRadioButton(this.mParent, "IDS_CSCOX_OPT_PROD_LIMIT_RADIO", null);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_CSCOX_OPT_CONF_TRANS_RADIO");
        this.mConfTransformedRadio = new SpssMultiLineRadioButton(toggleButtonAction, 220);
        this.mConfTransformedRadio.addItemListener(this);
        this.mConfTransformationLabel = DialogUtil.createLabel(this.mParent, "IDS_CSCOX_OPT_TRANSFORM_LABEL");
        this.mConfTransformationComboBox = new JComboBox<String>(this.getResStringArray("IDS_CSCOX_OPT_TRANSFORM_COMBO"));
        this.mConfTransformationComboBox.setAction(new ComboboxAction(this.mParent, TRANSFORMATION_KEY));
        this.mConfTransformationLabel.setLabelFor(this.mConfTransformationComboBox);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_CSCOX_OPT_CONF_ORIG_RADIO");
        this.mConfOriginalRadio = new SpssMultiLineRadioButton(toggleButtonAction, 170);
        this.mInValidRadioButton = DialogUtil.createRadioButton(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_OPTIONS_INVALID_RADIOBUTTON", null);
        this.mValidRadioButton = DialogUtil.createRadioButton(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_OPTIONS_VALID_RADIOBUTTON", null);
        this.mUserMisTextArea = new JTextArea(this.getResString("IDS_CSCOX_OPT_USER_MIS_NOTE"));
        this.mConfidenceLabel = DialogUtil.createLabel(this.mParent, "IDS_CSCOX_OPT_CONF_LABEL");
        this.mConfidenceTextField = new FloatTextField(50.0, 100.0, -1, true);
        this.mConfidenceTextField.setAction((Action)new TextFieldAction(this.mParent, CONFIDENCE_KEY));
        this.mConfidenceLabel.setLabelFor((Component)this.mConfidenceTextField);
    }

    private void setDefaults() {
        this.mMaxIterationTextfield.setText("100");
        this.mMaxStepTextfield.setText("5");
        this.mLimitParameterEstimatesCheckBox.setSelected(true);
        this.mMinChangeParameterTextfield.setText(String.format(ComponentState.getSPSSLocale(), "%f", 1.0E-6));
        this.mTypeParameterComboBox.setSelectedIndex(0);
        this.mLimitLogLikelihoodCheckBox.setSelected(false);
        this.mMinChangeLogTextfield.setText("");
        this.mTypeLogComboBox.setSelectedIndex(0);
        this.mDisplayHistoryCheckBox.setSelected(false);
        this.mIncrementTextField.setText("1");
        this.mTieEfronRadio.setSelected(true);
        this.enableControls(GroupType.GR_LIMIT_PAR, true);
        this.enableControls(GroupType.GR_LIMIT_LOG, false);
        this.enableControls(GroupType.GR_DISPLAY, false);
        this.mMetEfronRadio.setSelected(true);
        this.mConfTransformedRadio.setSelected(true);
        this.mConfTransformationComboBox.setSelectedIndex(0);
        this.enableControls(GroupType.GR_TRANSFORM, true);
        this.mInValidRadioButton.setSelected(true);
        this.mUserMisTextArea.setOpaque(false);
        this.mUserMisTextArea.setLineWrap(true);
        this.mUserMisTextArea.setWrapStyleWord(true);
        this.mUserMisTextArea.setBorder(BorderFactory.createEmptyBorder());
        this.mUserMisTextArea.setBackground(this.getBackground());
        this.mUserMisTextArea.setEditable(false);
        this.mUserMisTextArea.setRows(2);
        this.mUserMisTextArea.setFocusable(false);
        this.mUserMisTextArea.setPreferredSize(new Dimension(this.mLimitLogLikelihoodCheckBox.getPreferredSize().width, this.mUserMisTextArea.getHeight()));
        this.mConfidenceTextField.setText("95");
        this.mConfidenceTextField.setIncludeMaxRange(false);
    }

    private void enableControls(GroupType groupType, boolean bl) {
        if (groupType == GroupType.GR_LIMIT_PAR) {
            DialogUtil.enableHTMLComponent(this.mMinChangeParameterLabel, bl);
            this.mMinChangeParameterTextfield.setEnabled(bl);
            this.mTypeParameterLabel.setEnabled(bl);
            this.mTypeParameterComboBox.setEnabled(bl);
        } else if (groupType == GroupType.GR_LIMIT_LOG) {
            DialogUtil.enableHTMLComponent(this.mMinChangeLogLabel, bl);
            this.mMinChangeLogTextfield.setEnabled(bl);
            this.mTypeLogLabel.setEnabled(bl);
            this.mTypeLogComboBox.setEnabled(bl);
        } else if (groupType == GroupType.GR_DISPLAY) {
            this.mIncrementLabel.setEnabled(bl);
            this.mIncrementTextField.setEnabled(bl);
        } else if (groupType == GroupType.GR_TRANSFORM) {
            this.mConfTransformationLabel.setEnabled(bl);
            this.mConfTransformationComboBox.setEnabled(bl);
        }
    }

    private static enum GroupType {
        GR_LIMIT_PAR,
        GR_LIMIT_LOG,
        GR_DISPLAY,
        GR_TRANSFORM;

    }

    private class textFieldFocusAdapter
    extends FocusAdapter {
        private textFieldFocusAdapter() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            if (object instanceof JTextField) {
                ((JTextField)object).selectAll();
            }
        }
    }
}

