/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.cox_reg;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegressionDlg;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class CSCoxRegHTestsTab
extends BaseProcedureTab
implements ActionListener,
ItemListener,
FocusListener {
    private JRadioButton mFRadioButton;
    private JRadioButton mAdjustedFRadioButton;
    private JRadioButton mChiSquareRadioButton;
    private JRadioButton mAdjustedChiSquareRadioButton;
    private JRadioButton mLeastRadioButton;
    private JRadioButton mSeqSidakRadioButton;
    private JRadioButton mSeqBonRadioButton;
    private JRadioButton mSidakRadioButton;
    private JRadioButton mBonRadioButton;
    private JRadioButton mSampleDesignRadioButton;
    private JRadioButton mFixedRadioButton;
    private JLabel mValueLabel;
    private IntTextField mValueTextField;
    private Vector<Object> mFocus;

    public CSCoxRegHTestsTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initializePanel();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void reset() {
        this.setDefaults();
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mFRadioButton;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        JRadioButton jRadioButton = (JRadioButton)itemEvent.getSource();
        if (jRadioButton == this.mFixedRadioButton) {
            this.mValueLabel.setEnabled(true);
            this.mValueTextField.setEnabled(true);
            this.mValueTextField.setOpaque(true);
        } else {
            this.mValueLabel.setEnabled(false);
            this.mValueTextField.setEnabled(false);
            this.mValueTextField.setOpaque(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cscoxreg_hyptests";
    }

    @Override
    public boolean validateTab() {
        boolean bl = true;
        if (this.mFixedRadioButton.isSelected()) {
            if (this.mValueTextField.getText().equals("")) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_TEXTFIELD_ERROR_MESSAGE"), VersionInfo.getAppVersionString());
                this.mValueTextField.grabFocus();
                bl = false;
            } else if (Long.parseLong(this.mValueTextField.getText()) < 1L) {
                bl = false;
            }
        }
        return bl;
    }

    private void initializePanel() {
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        Insets insets = new Insets(n, 0, 0, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, this.setupStatisticPanel(), gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(this, this.setupSamplingPanel(), gridBagConstraints, 1, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(this, this.setupAdjustmentPanel(), gridBagConstraints, 0, 1, 2, 1, n2, insets);
        this.setFocusTraversalPolicy();
    }

    private JPanel setupStatisticPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mFRadioButton, this.mAdjustedFRadioButton, this.mChiSquareRadioButton, this.mAdjustedChiSquareRadioButton};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_TEST_STATISTICS_LABEL"));
        SpssButtonGroup spssButtonGroup = DialogUtil.createButtonGroup(jPanel);
        this.mFocus.add(spssButtonGroup);
        return jPanel;
    }

    private JPanel setupSamplingPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_SAMPLING_DEGREES_LABEL")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        int n3 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        insets2.set(insets.top, insets.left, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mSampleDesignRadioButton, gridBagConstraints, 0, 0, 3, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets2.set(insets.top, insets.left, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mFixedRadioButton, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        insets2.set(n2, n3, n3, 0);
        DialogUtil.addUsingGBL(jPanel, this.mValueLabel, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        insets2.set(n2, n2, n3, 7 * n3);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mValueTextField, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        SpssButtonGroup spssButtonGroup = DialogUtil.createButtonGroup(jPanel);
        this.mFocus.add(spssButtonGroup);
        this.mFocus.add(this.mValueTextField);
        return jPanel;
    }

    private JPanel setupAdjustmentPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mLeastRadioButton, this.mSeqSidakRadioButton, this.mSeqBonRadioButton, this.mSidakRadioButton, this.mBonRadioButton};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_ADJUSTMENT_LABEL"));
        SpssButtonGroup spssButtonGroup = DialogUtil.createButtonGroup(jPanel);
        this.mFocus.add(spssButtonGroup);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        JPanel jPanel = ((CSCoxRegressionDlg)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            this.mFocus.add(component);
        }
        this.setComponentOrder(this.mFocus);
    }

    private void initVars() {
        this.mFocus = new Vector();
        this.mFRadioButton = DialogUtil.createRadioButton(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_F_RADIOBUTTON", null);
        this.mAdjustedFRadioButton = DialogUtil.createRadioButton(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_ADJUSTED_F_RADIOBUTTON", null);
        this.mChiSquareRadioButton = DialogUtil.createRadioButton(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_CHISQUARE_RADIOBUTTON", null);
        this.mAdjustedChiSquareRadioButton = DialogUtil.createRadioButton(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_ADJUSTED_CHISQUARE_RADIOBUTTON", null);
        this.mLeastRadioButton = DialogUtil.createRadioButton(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_LEAST_RADIOBUTTON", null);
        this.mSeqSidakRadioButton = DialogUtil.createRadioButton(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_SEQUENTIAL_SIDAK_RADIOBUTTON", null);
        this.mSeqBonRadioButton = DialogUtil.createRadioButton(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_SEQUENTIAL_BONFERRONI_RADIOBUTTON", null);
        this.mSidakRadioButton = DialogUtil.createRadioButton(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_SIDAK_RADIOBUTTON", null);
        this.mBonRadioButton = DialogUtil.createRadioButton(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_BONFERRONI_RADIOBUTTON", null);
        this.mSampleDesignRadioButton = DialogUtil.createRadioButton(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_BASED_RADIOBUTTON", null);
        this.mSampleDesignRadioButton.addItemListener(this);
        this.mFixedRadioButton = DialogUtil.createRadioButton(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_FIXED_RADIOBUTTON", null);
        this.mFixedRadioButton.addItemListener(this);
        this.mValueLabel = DialogUtil.createLabel(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_VALUE_LABEL");
        this.mValueTextField = new IntTextField(1, Integer.MAX_VALUE, true);
        this.mValueTextField.setColumns(6);
        this.mValueTextField.setAction((Action)new TextFieldAction(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_VALUE_LABEL"));
        this.mValueLabel.setLabelFor((Component)this.mValueTextField);
    }

    private void setDefaults() {
        this.mFRadioButton.setSelected(true);
        this.mLeastRadioButton.setSelected(true);
        this.mSampleDesignRadioButton.setSelected(true);
        this.mValueLabel.setEnabled(false);
        this.mValueTextField.setEnabled(false);
        this.mValueTextField.setOpaque(false);
    }
}

