/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.cox_reg;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;

public class CSCoxRegExportTab
extends BaseProcedureTab
implements ActionListener,
ItemListener,
FocusListener {
    public static final String FILE_MODEL_BUTTON = "IDS_CS_ORDINAL_SAVE_DATASET_FILE_BUTTON";
    public static final String DATASET_MODEL_FIELD = "IDS_DATASET_MODEL";
    public static final String FILE_PATH_MODEL = "FILE_PATH_MODEL";
    public static final String FILE_FUNCTION_BUTTON = "IDS_CSCOX_EXPORT_FILE_FUNC_BUT";
    public static final String DATASET_FUNCTION_FIELD = "IDS_DATASET_FUNC";
    public static final String FILE_PATH_FUNCTION = "FILE_PATH_FUNC";
    public static final String FILE_XML_BUTTON = "IDS_CSCOX_EXPORT_FILE_XML_BUT";
    public static final String FILE_PATH_XML = "FILE_PATH_XML";
    private JCheckBox mExportModelDataCheck;
    private JPanel mDestModelPanel;
    private JRadioButton mNewDatasetModRadio;
    private JRadioButton mExterFileModRadio;
    private JButton mFileModButton;
    private FileTextField mFilePathMod;
    private JLabel mNameModLabel;
    private StringTextField mDatasetModField;
    private JCheckBox mExportFuncDataCheck;
    private JRadioButton mNewDatasetFuncRadio;
    private JRadioButton mExterFileFuncRadio;
    private JButton mFileFuncButton;
    private FileTextField mFilePathFunc;
    private JLabel mNameFuncLabel;
    private StringTextField mDatasetFuncField;
    private JTextArea mNoteTextArea;
    private JRadioButton mCovarianceRadio;
    private JRadioButton mCorrelationRadio;
    private JCheckBox mExportXmlCheck;
    private JButton mFileXmlButton;
    private FileTextField mFilePathXml;
    private SpssButtonGroup mModelGroup;
    private SpssButtonGroup mContentsGroup;
    private SpssButtonGroup mFunctionGroup;
    private Vector<Object> mFocus;

    public CSCoxRegExportTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initializePanel();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void reset() {
        this.setDefaults();
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mExportModelDataCheck;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.mExportModelDataCheck == itemEvent.getSource()) {
            boolean bl = this.mExportModelDataCheck.isSelected();
            this.mCovarianceRadio.setEnabled(bl);
            this.mCorrelationRadio.setEnabled(bl);
            this.enableDestinationControls(bl, true);
        } else if (this.mExportFuncDataCheck == itemEvent.getSource()) {
            boolean bl = this.mExportFuncDataCheck.isSelected();
            this.enableDestinationControls(bl, false);
        } else if (this.mExportXmlCheck == itemEvent.getSource()) {
            boolean bl = this.mExportXmlCheck.isSelected();
            this.mFileXmlButton.setEnabled(bl);
            this.mFilePathXml.setEnabled(bl);
        } else if (this.mNewDatasetModRadio == itemEvent.getSource()) {
            this.enableDestinationControls(true, true);
        } else if (this.mNewDatasetFuncRadio == itemEvent.getSource()) {
            this.enableDestinationControls(true, false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cscoxreg_export";
    }

    @Override
    public boolean validateTab() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.mExportModelDataCheck.isSelected()) {
            if (this.mNewDatasetModRadio.isSelected()) {
                string = this.mDatasetModField.getText();
                if (string.length() < 1) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_CSCOX_EXPORT_DATASET_ERR"), VersionInfo.getAppVersionString());
                    this.mDatasetModField.grabFocus();
                    return false;
                }
                if (DatasetNameValidator.validateDatasetName((String)string, (Component)this) != 1) {
                    this.mDatasetModField.grabFocus();
                    return false;
                }
                bl = true;
            } else {
                string3 = this.mFilePathMod.getText();
                if (string3.length() < 1) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_CS_ORDINAL_SAVE_FILE_FILED_EMPTY_ERROR"), VersionInfo.getAppVersionString());
                    this.mFileModButton.grabFocus();
                    return false;
                }
                bl3 = true;
            }
        }
        if (this.mExportFuncDataCheck.isSelected()) {
            if (this.mNewDatasetFuncRadio.isSelected()) {
                string2 = this.mDatasetFuncField.getText();
                if (string2.length() < 1) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_CSCOX_EXPORT_DATASET_ERR"), VersionInfo.getAppVersionString());
                    this.mDatasetFuncField.grabFocus();
                    return false;
                }
                if (DatasetNameValidator.validateDatasetName((String)string2, (Component)this) != 1) {
                    this.mDatasetFuncField.grabFocus();
                    return false;
                }
                bl2 = true;
            } else {
                string4 = this.mFilePathFunc.getText();
                if (string4.length() < 1) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_CS_ORDINAL_SAVE_FILE_FILED_EMPTY_ERROR"), VersionInfo.getAppVersionString());
                    this.mFileFuncButton.grabFocus();
                    return false;
                }
                bl4 = true;
            }
        }
        if (this.mExportXmlCheck.isSelected() && this.mFilePathXml.getText().length() < 1) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_CS_ORDINAL_SAVE_FILE_FILED_EMPTY_ERROR"), VersionInfo.getAppVersionString());
            this.mFileXmlButton.grabFocus();
            return false;
        }
        if (bl && bl2 && string.equals(string2)) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_CSCOX_EXPORT_UNIQD_ERR"), VersionInfo.getAppVersionString());
            this.mDatasetFuncField.grabFocus();
            return false;
        }
        if (bl3 && bl4 && string3.equals(string4)) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_CSCOX_EXPORT_UNIQF_ERR"), VersionInfo.getAppVersionString());
            this.mFileFuncButton.grabFocus();
            return false;
        }
        return true;
    }

    private void initializePanel() {
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        Insets insets = new Insets(n, n, 0, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mDestModelPanel = this.setupDestModelPanel();
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, this.mExportModelDataCheck, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, this.mDestModelPanel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(this, this.setupContentsPanel(), gridBagConstraints, 0, 2, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(this, this.setupExportXmlPanel(), gridBagConstraints, 0, 3, 2, 1, n2, insets);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, this.mExportFuncDataCheck, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, this.setupDestFuncPanel(), gridBagConstraints, 1, 1, 1, 2, n2, insets);
        this.setFocusTraversalPolicy();
    }

    private JPanel setupDestModelPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_CSCOX_EXPORT_DEST_LABEL")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        int n3 = DialogUtil.getGroupingIndent();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, n2 + n3, insets.bottom, insets.right);
        Insets insets3 = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        insets3.set(insets.top, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mNewDatasetModRadio, gridBagConstraints, 0, 0, 2, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets3.set(insets.top, insets.left, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mNameModLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        this.mNameModLabel.setLabelFor((Component)((Object)this.mDatasetModField));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mDatasetModField), gridBagConstraints, 1, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets3.set(insets.top, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mExterFileModRadio, gridBagConstraints, 0, 2, 1, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mFileModButton, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        this.mModelGroup = DialogUtil.createButtonGroup(jPanel);
        insets3.set(insets.top + 5, insets.left + 3, insets.bottom + 1, insets.right + 3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFilePathMod), gridBagConstraints, 1, 3, 2, 1, n, insets3);
        return jPanel;
    }

    private JPanel setupContentsPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mCovarianceRadio, this.mCorrelationRadio};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_CSCOX_EXPORT_CONTENTS_LABEL"));
        this.mContentsGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupExportXmlPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        int n3 = DialogUtil.getGroupingIndent();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, n2 + n3, insets.bottom, insets.right);
        Insets insets3 = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        insets3.set(insets.top, insets.left, insets.bottom, n2);
        DialogUtil.addUsingGBL(jPanel, this.mExportXmlCheck, gridBagConstraints, 0, 0, 3, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets3.set(insets.top * 2, insets.left, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mFileXmlButton, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        insets3.set(insets.top + 5, insets.left + 3, insets.bottom + 1, insets.right + 3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFilePathXml), gridBagConstraints, 1, 1, 2, 1, n, insets3);
        return jPanel;
    }

    private JPanel setupDestFuncPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_CSCOX_EXPORT_DEST_LABEL")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        int n3 = DialogUtil.getGroupingIndent();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, n2 + n3, insets.bottom, insets.right);
        Insets insets3 = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        insets3.set(insets.top, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mNewDatasetFuncRadio, gridBagConstraints, 0, 0, 2, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets3.set(insets.top, insets.left, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mNameFuncLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        this.mNameFuncLabel.setLabelFor((Component)((Object)this.mDatasetFuncField));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mDatasetFuncField), gridBagConstraints, 1, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets3.set(insets.top, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mExterFileFuncRadio, gridBagConstraints, 0, 2, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mFileFuncButton, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        this.mFunctionGroup = DialogUtil.createButtonGroup(jPanel);
        insets3.set(insets.top + 5, insets.left + 3, insets.bottom + 1, insets.right + 3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFilePathFunc), gridBagConstraints, 1, 3, 2, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        insets3.set(insets.top + n2 * 2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mNoteTextArea, gridBagConstraints, 0, 4, 2, 1, n, insets3);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        this.mFocus.add(this.mExportModelDataCheck);
        this.mFocus.add(this.mModelGroup);
        this.mFocus.add(this.mDatasetModField);
        this.mFocus.add(this.mFileModButton);
        this.mFocus.add(this.mContentsGroup);
        this.mFocus.add(this.mExportFuncDataCheck);
        this.mFocus.add(this.mFunctionGroup);
        this.mFocus.add(this.mDatasetFuncField);
        this.mFocus.add(this.mFileFuncButton);
        this.mFocus.add(this.mExportXmlCheck);
        this.mFocus.add(this.mFileXmlButton);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            this.mFocus.add(component);
        }
        this.setComponentOrder(this.mFocus);
    }

    private void initVars() {
        this.mFocus = new Vector();
        this.mExportModelDataCheck = DialogUtil.createCheckBox(this.mParent, "IDS_CSCOX_EXPORT_MODEL_CHECK", null);
        this.mExportModelDataCheck.addItemListener(this);
        this.mNewDatasetModRadio = DialogUtil.createRadioButton(this.mParent, "IDS_CSCOX_EXPORT_NEWDS_MOD_RADIO", null);
        this.mNewDatasetModRadio.addItemListener(this);
        this.mExterFileModRadio = DialogUtil.createRadioButton(this.mParent, "IDS_CSCOX_EXPORT_EXFILE_MOD_RADIO", null);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, FILE_MODEL_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CSCoxRegExportTab.this.openFileDialog(FileType.FILE_MODEL);
            }
        };
        this.mFileModButton = new JButton(toggleButtonAction);
        this.mNameModLabel = DialogUtil.createLabel(this.mParent, "IDS_CSCOX_EXPORT_NAME_MOD_LABEL");
        this.mDatasetModField = new StringTextField();
        this.mDatasetModField.setAction(new TextFieldAction(this.mParent, DATASET_MODEL_FIELD));
        this.mFilePathMod = new FileTextField();
        this.mFilePathMod.setAction(new TextFieldAction(this.mParent, FILE_PATH_MODEL));
        this.mFilePathMod.setBorder(BorderFactory.createEmptyBorder());
        this.mFilePathMod.setText("");
        this.mExportFuncDataCheck = DialogUtil.createCheckBox(this.mParent, "IDS_CSCOX_EXPORT_FUNC_CHECK", null);
        this.mExportFuncDataCheck.addItemListener(this);
        this.mNewDatasetFuncRadio = DialogUtil.createRadioButton(this.mParent, "IDS_CSCOX_EXPORT_NEWDS_FUNC_RADIO", null);
        this.mNewDatasetFuncRadio.addItemListener(this);
        this.mExterFileFuncRadio = DialogUtil.createRadioButton(this.mParent, "IDS_CSCOX_EXPORT_EXFILE_FUNC_RADIO", null);
        toggleButtonAction = new ToggleButtonAction(this.mParent, FILE_FUNCTION_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CSCoxRegExportTab.this.openFileDialog(FileType.FILE_FUNCTION);
            }
        };
        this.mFileFuncButton = new JButton(toggleButtonAction);
        this.mNameFuncLabel = DialogUtil.createLabel(this.mParent, "IDS_CSCOX_EXPORT_NAME_FUNC_LABEL");
        this.mDatasetFuncField = new StringTextField();
        this.mDatasetFuncField.setAction(new TextFieldAction(this.mParent, DATASET_FUNCTION_FIELD));
        this.mFilePathFunc = new FileTextField();
        this.mFilePathFunc.setAction(new TextFieldAction(this.mParent, FILE_PATH_FUNCTION));
        this.mFilePathFunc.setBorder(BorderFactory.createEmptyBorder());
        this.mFilePathFunc.setText("");
        this.mNoteTextArea = new JTextArea(this.getResString("IDS_CSCOX_EXPORT_NOTE_LABEL"));
        this.mCovarianceRadio = DialogUtil.createRadioButton(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_SAVE_PARAMETER_COVARIANCE_SPSS_RADIOBUTTON", null);
        this.mCorrelationRadio = DialogUtil.createRadioButton(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_SAVE_PARAMETER_CORRELATION_RADIOBUTTON", null);
        this.mExportXmlCheck = DialogUtil.createCheckBox(this.mParent, "IDS_CSCOX_EXPORT_XML_CHECK", null);
        this.mExportXmlCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, FILE_XML_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CSCoxRegExportTab.this.openFileDialog(FileType.FILE_XML);
            }
        };
        this.mFileXmlButton = new JButton(toggleButtonAction);
        this.mFilePathXml = new FileTextField();
        this.mFilePathXml.setAction(new TextFieldAction(this.mParent, FILE_PATH_XML));
        this.mFilePathXml.setBorder(BorderFactory.createEmptyBorder());
        this.mFilePathXml.setText("");
    }

    private void setDefaults() {
        this.mExportModelDataCheck.setSelected(false);
        this.mNewDatasetModRadio.setSelected(true);
        this.mFilePathMod.setEditable(false);
        this.mFilePathMod.setOpaque(false);
        this.mFilePathMod.setFocusable(false);
        this.mFilePathMod.setText("");
        this.mDatasetModField.setText("");
        this.mExportFuncDataCheck.setSelected(false);
        this.mNewDatasetFuncRadio.setSelected(true);
        this.mFilePathFunc.setEditable(false);
        this.mFilePathFunc.setOpaque(false);
        this.mFilePathFunc.setFocusable(false);
        this.mFilePathFunc.setText("");
        this.mDatasetFuncField.setText("");
        this.mNoteTextArea.setOpaque(false);
        this.mNoteTextArea.setLineWrap(true);
        this.mNoteTextArea.setWrapStyleWord(true);
        this.mNoteTextArea.setBorder(BorderFactory.createEmptyBorder());
        this.mNoteTextArea.setBackground(this.getBackground());
        this.mNoteTextArea.setEditable(false);
        this.mNoteTextArea.setRows(2);
        this.mNoteTextArea.setFocusable(false);
        this.mNoteTextArea.setPreferredSize(new Dimension(this.mCovarianceRadio.getPreferredSize().width, this.mNoteTextArea.getHeight()));
        this.mCovarianceRadio.setSelected(true);
        this.mExportXmlCheck.setSelected(false);
        this.mFilePathXml.setEditable(false);
        this.mFilePathXml.setOpaque(false);
        this.mFilePathXml.setFocusable(false);
        this.mFilePathXml.setText("");
        this.mCovarianceRadio.setEnabled(false);
        this.mCorrelationRadio.setEnabled(false);
        this.enableDestinationControls(false, true);
        this.enableDestinationControls(false, false);
        this.mFileXmlButton.setEnabled(false);
        this.mFilePathXml.setEnabled(false);
    }

    private void enableDestinationControls(boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                if (this.mDestModelPanel != null) {
                    this.mDestModelPanel.setEnabled(bl);
                }
                this.mCovarianceRadio.setEnabled(bl);
                this.mCorrelationRadio.setEnabled(bl);
                this.mNewDatasetModRadio.setEnabled(bl);
                this.mExterFileModRadio.setEnabled(bl);
                if (this.mNewDatasetModRadio.isSelected()) {
                    this.mNameModLabel.setEnabled(bl);
                    this.mDatasetModField.setEnabled(bl);
                    this.mFileModButton.setEnabled(!bl);
                    this.mFilePathMod.setEnabled(!bl);
                } else {
                    this.mNameModLabel.setEnabled(!bl);
                    this.mDatasetModField.setEnabled(!bl);
                    this.mFileModButton.setEnabled(bl);
                    this.mFilePathMod.setEnabled(bl);
                }
            } else {
                this.mNewDatasetFuncRadio.setEnabled(bl);
                this.mExterFileFuncRadio.setEnabled(bl);
                this.mNoteTextArea.setEnabled(bl);
                if (this.mNewDatasetFuncRadio.isSelected()) {
                    this.mNameFuncLabel.setEnabled(bl);
                    this.mDatasetFuncField.setEnabled(bl);
                    this.mFileFuncButton.setEnabled(!bl);
                    this.mFilePathFunc.setEnabled(!bl);
                } else {
                    this.mNameFuncLabel.setEnabled(!bl);
                    this.mDatasetFuncField.setEnabled(!bl);
                    this.mFileFuncButton.setEnabled(bl);
                    this.mFilePathFunc.setEnabled(bl);
                }
            }
        } else if (bl2) {
            if (this.mDestModelPanel != null) {
                this.mDestModelPanel.setEnabled(bl);
            }
            this.mNewDatasetModRadio.setEnabled(bl);
            this.mNameModLabel.setEnabled(bl);
            this.mDatasetModField.setEnabled(bl);
            this.mExterFileModRadio.setEnabled(bl);
            this.mFileModButton.setEnabled(bl);
            this.mFilePathMod.setEnabled(bl);
        } else {
            this.mNewDatasetFuncRadio.setEnabled(bl);
            this.mNameFuncLabel.setEnabled(bl);
            this.mDatasetFuncField.setEnabled(bl);
            this.mExterFileFuncRadio.setEnabled(bl);
            this.mFileFuncButton.setEnabled(bl);
            this.mFilePathFunc.setEnabled(bl);
            this.mNoteTextArea.setEnabled(bl);
        }
    }

    private void openFileDialog(FileType fileType) {
        String string;
        String string2;
        String string3;
        String string4 = this.getResString("IDS_CSCOX_EXPORT_SAVE_TITLE");
        if (fileType == FileType.FILE_XML) {
            string3 = this.getResString("IDS_CS_ORDINAL_XML_FILTER_NAME_TYPE");
            string2 = this.getResString("IDS_CS_ORDINAL_XML_FILE_EXTENSION");
            string = FileLocationsUtil.getOtherFilesDirectoryPath();
        } else {
            string3 = this.getResString("IDS_CS_ORDINAL_FILTER_NAME_TYPE");
            string2 = this.getResString("IDS_CS_ORDINAL_FILE_EXTENSION");
            string = FileLocationsUtil.getDataFilesDirectoryPath();
        }
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, string, true);
        remoteFileChooser.setDialogTitle(string4);
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(string3, string2));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        int n = remoteFileChooser.showSaveDialog(this);
        if (n == 0) {
            if (fileType == FileType.FILE_XML) {
                FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            } else {
                FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            }
            String string5 = remoteFileChooser.getSelectedFilePath();
            if (!string2.regionMatches(true, 0, string5, string5.length() - string2.length(), string2.length())) {
                string5 = string5 + string2;
            }
            if (fileType == FileType.FILE_MODEL) {
                this.mFilePathMod.setText(string5);
            } else if (fileType == FileType.FILE_FUNCTION) {
                this.mFilePathFunc.setText(string5);
            } else if (fileType == FileType.FILE_XML) {
                this.mFilePathXml.setText(string5);
            }
        }
    }

    private static enum FileType {
        FILE_MODEL,
        FILE_FUNCTION,
        FILE_XML;

    }
}

