/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.common;

import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.dialogs.complex_samples.common.VariableName;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public final class VariableCategoryList {
    private final Vector<VariableName> mVariableList = new Vector(10);
    private final Hashtable<Vector<String>, Double> mVariableCategoryMap = new Hashtable();
    final double mMinimumValue = 0.0;
    final double mMaximumValue = 0.0;
    final boolean mAllValuesInteger = true;

    public final boolean addVariable(String string) {
        return this.mVariableCategoryMap.size() <= 0 && this.mVariableList.add(new VariableName(string));
    }

    public final long getVariableListSize() {
        return this.mVariableList.size();
    }

    public final boolean isInVariableList(String string) {
        return this.mVariableList.contains(new VariableName(string));
    }

    public final String getVariable(long l) {
        try {
            VariableName variableName = this.mVariableList.get(new Long(l).intValue());
            return variableName.toString();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "";
        }
    }

    public final long getVariable(String string) {
        return this.mVariableList.indexOf(new VariableName(string));
    }

    public boolean addToCategoryList(Vector<String> vector, String string) {
        if (vector.size() >= this.mVariableList.size()) {
            return false;
        }
        vector.add(string);
        return true;
    }

    public boolean isCategoryListOK(Vector<String> vector) {
        return vector.size() == this.mVariableList.size();
    }

    public boolean addCategoryList(Vector<String> vector, double d) {
        if (!this.isCategoryListOK(vector)) {
            return false;
        }
        this.mVariableCategoryMap.put(vector, d);
        return true;
    }

    public boolean display(OutputStreamWriter outputStreamWriter) throws IOException {
        boolean bl = true;
        for (VariableName object2 : this.mVariableList) {
            outputStreamWriter.write(object2 + " ");
        }
        outputStreamWriter.write("\n");
        Enumeration<Double> enumeration = this.mVariableCategoryMap.elements();
        Enumeration<Vector<String>> enumeration2 = this.mVariableCategoryMap.keys();
        while (enumeration.hasMoreElements()) {
            Vector<String> vector = enumeration2.nextElement();
            double d = (Double)enumeration.nextElement();
            outputStreamWriter.write("     ");
            for (String string : vector) {
                outputStreamWriter.write(string + " ");
            }
            outputStreamWriter.write(Double.toString(d) + "\n");
        }
        return bl;
    }

    public boolean copyCategoryKeysValues(Vector<Vector<String>> vector, Vector<Double> vector2, ISpssDataSrc iSpssDataSrc) {
        int n;
        boolean bl = this.copyCategoryKeysValues(vector, vector2);
        Vector<Integer> vector3 = new Vector<Integer>();
        bl &= VariableCategoryList.validateVariableList(this.mVariableList, vector3, iSpssDataSrc);
        Object[] objectArray = new RowData[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            Double d = vector2.size() > n ? vector2.get(n) : null;
            objectArray[n] = new RowData(vector.get(n), d);
        }
        Arrays.sort(objectArray);
        vector.clear();
        vector2.clear();
        for (n = 0; n < objectArray.length; ++n) {
            vector.add(n, ((RowData)objectArray[n]).getVarValues());
            vector2.add(n, ((RowData)objectArray[n]).getValue());
        }
        return bl;
    }

    private boolean copyCategoryKeysValues(Vector<Vector<String>> vector, Vector<Double> vector2) {
        boolean bl = this.mVariableCategoryMap.size() > 0;
        for (Vector<String> object2 : vector) {
            object2.clear();
        }
        vector.clear();
        vector2.clear();
        Set<Map.Entry<Vector<String>, Double>> set = this.mVariableCategoryMap.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Vector vector3 = (Vector)entry.getKey();
            vector.add((Vector)vector3.clone());
            double d = (Double)entry.getValue();
            vector2.add(d);
        }
        return bl;
    }

    private static boolean validateVariableList(Vector<VariableName> vector, Vector<Integer> vector2, ISpssDataSrc iSpssDataSrc) {
        assert (iSpssDataSrc != null);
        boolean bl = true;
        vector2.clear();
        for (VariableName variableName : vector) {
            int n = iSpssDataSrc.findVarIndex(variableName.toString());
            bl &= n >= 0;
            vector2.add(n);
        }
        return bl;
    }

    class RowData
    implements Comparable {
        private Vector<String> varValues;
        private Double value;

        RowData(Vector<String> vector, Double d) {
            this.varValues = vector;
            this.value = d;
        }

        public Vector<String> getVarValues() {
            return this.varValues;
        }

        public Double getValue() {
            return this.value;
        }

        public int compareTo(Object object) {
            RowData rowData = (RowData)object;
            if (this.value != null && rowData.value != null) {
                return this.value.compareTo(rowData.value);
            }
            return this.value != null ? 1 : (rowData.value != null ? -1 : 0);
        }
    }
}

