/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.common;

import com.spss.java_client.ui.dialogs.complex_samples.common.VariableCategoryList;
import com.spss.java_client.ui.dialogs.complex_samples.common.VariableName;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Vector;

public final class StageInformation {
    private int mSerial = 0;
    private String mLabel = "";
    private final Vector<VariableName> mStrataList = new Vector(10);
    private final Vector<VariableName> mClusterList = new Vector(10);
    private KeyType mKey = KeyType.NO_VALUE;
    private KeySubcommandType mKeySubcommand = KeySubcommandType.NONE;
    private ParameterGivenType mParameterGiven = ParameterGivenType.NONE;
    private double mMinimumSize = 0.0;
    private double mMaximumSize = 0.0;
    private double mParameterValue = 0.0;
    private String mParameterVariable = "";
    private VariableCategoryList mVariableCategoryList = new VariableCategoryList();
    private String mInclusionProbability = "";
    private String mCumulativeWeight = "";
    private String mIndex = "";
    private String mPopulationSize = "";
    private String mSampleSize = "";
    private String mRate = "";
    private String mWeight = "";
    private final HashSet<VariableName> mVariableList = new HashSet();

    public VariableCategoryList getVariableCategoryList() {
        return this.mVariableCategoryList;
    }

    public void setVariableCategoryList(VariableCategoryList variableCategoryList) {
        this.mVariableCategoryList = variableCategoryList;
    }

    public double getMinimumSize() {
        return this.mMinimumSize;
    }

    public void setMinimumSize(double d) {
        this.mMinimumSize = d;
    }

    public double getMaximumSize() {
        return this.mMaximumSize;
    }

    public void setMaximumSize(double d) {
        this.mMaximumSize = d;
    }

    public String getInclusionProbability() {
        return this.mInclusionProbability;
    }

    public void setInclusionProbability(String string) {
        this.mInclusionProbability = string;
    }

    public String getCumulativeWeight() {
        return this.mCumulativeWeight;
    }

    public void setCumulativeWeight(String string) {
        this.mCumulativeWeight = string;
    }

    public String getIndex() {
        return this.mIndex;
    }

    public void setIndex(String string) {
        this.mIndex = string;
    }

    public String getPopulationSize() {
        return this.mPopulationSize;
    }

    public void setPopulationSize(String string) {
        this.mPopulationSize = string;
    }

    public String getSampleSize() {
        return this.mSampleSize;
    }

    public void setSampleSize(String string) {
        this.mSampleSize = string;
    }

    public String getRate() {
        return this.mRate;
    }

    public void setRate(String string) {
        this.mRate = string;
    }

    public String getWeight() {
        return this.mWeight;
    }

    public void setWeight(String string) {
        this.mWeight = string;
    }

    public final int getSerial() {
        return this.mSerial;
    }

    public final void setSerial(int n) {
        this.mSerial = n;
    }

    public final boolean addToVariableList(String string) {
        return this.mVariableList.add(new VariableName(string));
    }

    public final long getVariableListSize() {
        return this.mVariableList.size();
    }

    public final boolean isInVariableList(String string) {
        return this.mVariableList.contains(new VariableName(string));
    }

    void addToStrataList(String string) {
        this.mStrataList.add(new VariableName(string));
    }

    public final long getStrataListSize() {
        return this.mStrataList.size();
    }

    public final boolean isInStrataList(String string) {
        return this.mStrataList.contains(new VariableName(string));
    }

    public final String getStrataVariable(long l) {
        try {
            VariableName variableName = this.mStrataList.get(new Long(l).intValue());
            return variableName.toString();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "";
        }
    }

    void addToClusterList(String string) {
        this.mClusterList.add(new VariableName(string));
    }

    public final long getClusterListSize() {
        return this.mClusterList.size();
    }

    public final boolean isInClusterList(String string) {
        return this.mClusterList.contains(new VariableName(string));
    }

    public final String getClusterVariable(long l) {
        try {
            VariableName variableName = this.mClusterList.get(new Long(l).intValue());
            return variableName.toString();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "";
        }
    }

    public final boolean display(OutputStreamWriter outputStreamWriter) throws IOException {
        outputStreamWriter.write("STAGELABEL = " + this.mLabel + "\n");
        outputStreamWriter.write("NUMBER OF STRATA VARIABLES = " + Integer.toString(this.mStrataList.size()) + "\n");
        outputStreamWriter.write("STRATA VARIABLES = ");
        for (VariableName variableName : this.mStrataList) {
            outputStreamWriter.write(variableName + " ");
        }
        outputStreamWriter.write("\n");
        outputStreamWriter.write("NUMBER OF CLUSTER VARIABLES = " + Integer.toString(this.mClusterList.size()) + "\n");
        outputStreamWriter.write("CLUSTER VARIABLES = ");
        for (VariableName variableName : this.mClusterList) {
            outputStreamWriter.write(variableName + " ");
        }
        outputStreamWriter.write("\n");
        outputStreamWriter.write("TYPE = ");
        switch (this.mKey) {
            case NO_VALUE: {
                outputStreamWriter.write("NO_VALUE\n");
                break;
            }
            case SIMPLE_WOR: {
                outputStreamWriter.write("SIMPLE_WOR\n");
                break;
            }
            case SIMPLE_WR: {
                outputStreamWriter.write("SIMPLE_WR\n");
                break;
            }
            case SIMPLE_SYSTEMATIC: {
                outputStreamWriter.write("SIMPLE_SYSTEMATIC\n");
                break;
            }
            case SIMPLE_CHROMY: {
                outputStreamWriter.write("SIMPLE_CHROMY\n");
                break;
            }
            case PPS_WOR: {
                outputStreamWriter.write("PPS_WOR\n");
                break;
            }
            case PPS_WR: {
                outputStreamWriter.write("PPS_WR\n");
                break;
            }
            case PPS_SYSTEMATIC: {
                outputStreamWriter.write("PPS_SYSTEMATIC\n");
                break;
            }
            case PPS_BREWER: {
                outputStreamWriter.write("PPS_BREWER\n");
                break;
            }
            case PPS_MURTHY: {
                outputStreamWriter.write("PPS_MURTHY\n");
                break;
            }
            case PPS_SAMPFORD: {
                outputStreamWriter.write("PPS_SAMPFORD\n");
                break;
            }
            case PPS_CHROMY: {
                outputStreamWriter.write("PPS_CHROMY\n");
                break;
            }
            case EQUAL_WOR: {
                outputStreamWriter.write("EQUAL_WOR\n");
                break;
            }
            case UNEQUAL_WOR: {
                outputStreamWriter.write("UNEQUAL_WOR\n");
                break;
            }
            case WR: {
                outputStreamWriter.write("WR\n");
                break;
            }
            default: {
                outputStreamWriter.write("Wrong value\n");
            }
        }
        outputStreamWriter.write("How parameter given: ");
        switch (this.mParameterGiven) {
            case NONE: {
                outputStreamWriter.write("NOT_GIVEN\n");
                break;
            }
            case BY_VALUE: {
                outputStreamWriter.write("BY_VALUE\n");
                break;
            }
            case BY_VARNAME: {
                outputStreamWriter.write("BY_VARNAME\n");
                break;
            }
            case BY_VARCATLIST: {
                outputStreamWriter.write("BY_VARCATLIST\n");
                break;
            }
            default: {
                outputStreamWriter.write("Wrong way\n");
            }
        }
        outputStreamWriter.write("Which subcommand of SIZE, RATE, POPSIZE, INCLPROB is given: ");
        switch (this.mKeySubcommand) {
            case NONE: {
                outputStreamWriter.write("NO SUBCOMMAND\n");
                break;
            }
            case SIZE: {
                outputStreamWriter.write("SIZE\n");
                break;
            }
            case RATE: {
                outputStreamWriter.write("RATE\n");
                break;
            }
            case POPSIZE: {
                outputStreamWriter.write("POPSIZE\n");
                break;
            }
            case INCLPROB: {
                outputStreamWriter.write("INCLPROB\n");
                break;
            }
            default: {
                outputStreamWriter.write("Wrong subcommand\n");
            }
        }
        outputStreamWriter.write("Parameter Value = " + Double.toString(this.mParameterValue) + "\n");
        outputStreamWriter.write("Parameter Variable Name = " + this.mParameterVariable + "\n");
        outputStreamWriter.write("Parameter Matrix = ");
        boolean bl = this.mVariableCategoryList.display(outputStreamWriter);
        outputStreamWriter.write("\n");
        outputStreamWriter.write("MINSIZE = " + this.mMinimumSize + "\n");
        outputStreamWriter.write("MAXSIZE = " + this.mMaximumSize + "\n");
        outputStreamWriter.write("INCLPROB = " + this.mInclusionProbability + "\n");
        outputStreamWriter.write("CUMWEIGHT = " + this.mCumulativeWeight + "\n");
        outputStreamWriter.write("INDEX = " + this.mIndex + "\n");
        outputStreamWriter.write("POPSIZE = " + this.mPopulationSize + "\n");
        outputStreamWriter.write("SAMPSIZE = " + this.mSampleSize + "\n");
        outputStreamWriter.write("RATE = " + this.mRate + "\n");
        outputStreamWriter.write("WEIGHT = " + this.mWeight + "\n");
        outputStreamWriter.write("\n");
        return bl;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public void setLabel(String string) {
        this.mLabel = string;
    }

    public KeyType getKey() {
        return this.mKey;
    }

    public void setKey(KeyType keyType) {
        this.mKey = keyType;
    }

    public KeySubcommandType getKeySubcommand() {
        return this.mKeySubcommand;
    }

    public void setKeySubcommand(KeySubcommandType keySubcommandType) {
        this.mKeySubcommand = keySubcommandType;
    }

    public ParameterGivenType getParameterGiven() {
        return this.mParameterGiven;
    }

    public void setParameterGiven(ParameterGivenType parameterGivenType) {
        this.mParameterGiven = parameterGivenType;
    }

    public double getParameterValue() {
        return this.mParameterValue;
    }

    public void setParameterValue(double d) {
        this.mParameterValue = d;
    }

    public String getParameterVariable() {
        return this.mParameterVariable;
    }

    public void setParameterVariable(String string) {
        this.mParameterVariable = string;
    }

    public static enum ParameterGivenType {
        NONE(0),
        BY_VALUE(1),
        BY_VARNAME(2),
        BY_VARCATLIST(3);

        private final int mValue;

        private ParameterGivenType(int n2) {
            this.mValue = n2;
        }

        public int getValue() {
            return this.mValue;
        }
    }

    public static enum KeySubcommandType {
        NONE(0),
        SIZE(1),
        RATE(2),
        POPSIZE(3),
        INCLPROB(4);

        private final int mValue;

        private KeySubcommandType(int n2) {
            this.mValue = n2;
        }

        public int getValue() {
            return this.mValue;
        }
    }

    public static enum KeyType {
        NO_VALUE(0),
        SIMPLE_WOR(1),
        SIMPLE_WR(2),
        SIMPLE_SYSTEMATIC(3),
        SIMPLE_CHROMY(4),
        PPS_WOR(5),
        PPS_WR(6),
        PPS_SYSTEMATIC(7),
        PPS_BREWER(8),
        PPS_MURTHY(9),
        PPS_SAMPFORD(10),
        PPS_CHROMY(11),
        EQUAL_WOR(12),
        UNEQUAL_WOR(13),
        WR(15);

        private final int mValue;

        private KeyType(int n2) {
            this.mValue = n2;
        }

        public int getValue() {
            return this.mValue;
        }
    }
}

