/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.common;

import com.spss.java_client.ui.dialogs.complex_samples.common.StageInformation;
import com.spss.java_client.ui.dialogs.complex_samples.common.VariableName;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Vector;

public final class Specification {
    public static final int MAX_STAGE_NUMBER = 3;
    private Mode mMode = Mode.NO_MODE;
    private PrintOption mPrintOption = PrintOption.PRINT_PLAN;
    private String mFilename = "";
    private String mWeight = "";
    private String mPreviousWeight = "";
    private SRSEstimatorType mEstimator = SRSEstimatorType.WOR;
    private boolean mMOSFromData = false;
    private double mMOSMinimum = 0.0;
    private double mMOSMaximum = 0.0;
    private MethodEstimation mEstimation = MethodEstimation.DEFAULT;
    private String mMOSVariable = "";
    private final HashSet<VariableName> mCommonVariableList = new HashSet();
    private final HashSet<VariableName> mSelectVariableList = new HashSet();
    private final Vector<StageInformation> mStageList = new Vector(3);

    public final boolean isInitialized() {
        return this.mMode != Mode.NO_MODE;
    }

    public final void setSampleMode() {
        this.mMode = Mode.SAMPLE_MODE;
    }

    public final boolean isSampleMode() {
        return this.mMode == Mode.SAMPLE_MODE;
    }

    public final void setAnalysisMode() {
        this.mMode = Mode.ANALYSIS_MODE;
    }

    public final boolean isAnalysisMode() {
        return this.mMode == Mode.ANALYSIS_MODE;
    }

    public final void setViewMode() {
        this.mMode = Mode.VIEW_MODE;
    }

    public final boolean isViewMode() {
        return this.mMode == Mode.VIEW_MODE;
    }

    public final void setPrintPlan() {
        this.mPrintOption = PrintOption.PRINT_PLAN;
    }

    public final boolean isPrintPlan() {
        return this.mPrintOption == PrintOption.PRINT_PLAN;
    }

    public final void setPrintMatrix() {
        this.mPrintOption = PrintOption.PRINT_MATRIX;
    }

    public final boolean isPrintMatrix() {
        return this.mPrintOption == PrintOption.PRINT_MATRIX;
    }

    public final void setPrintBoth() {
        this.mPrintOption = PrintOption.PRINT_BOTH;
    }

    public final boolean isPrintBoth() {
        return this.mPrintOption == PrintOption.PRINT_BOTH;
    }

    public final void setXMLFilename(String string) {
        this.mFilename = string;
    }

    public final String getXMLFilename() {
        return this.mFilename;
    }

    public final void setWeight(String string) {
        this.mWeight = string;
    }

    public final String getWeight() {
        return this.mWeight;
    }

    public final void setPreviousWeight(String string) {
        this.mPreviousWeight = string;
    }

    public final String getPreviousWeight() {
        return this.mPreviousWeight;
    }

    public final void setSRSEstimator(SRSEstimatorType sRSEstimatorType) {
        this.mEstimator = sRSEstimatorType;
    }

    public final SRSEstimatorType getSRSEstimator() {
        return this.mEstimator;
    }

    public final void setMOSVariableName(String string) {
        this.mMOSVariable = string;
    }

    public final String getMOS() {
        return this.mMOSVariable;
    }

    public final void setMOSFromData() {
        this.mMOSFromData = true;
    }

    public final void UnSetMOSFromData() {
        this.mMOSFromData = false;
    }

    public final boolean isMOSFromData() {
        return this.mMOSFromData;
    }

    public final void setMinimumMOS(double d) {
        this.mMOSMinimum = d;
    }

    public final double getMinimumMOS() {
        return this.mMOSMinimum;
    }

    public final void setMaximumMOS(double d) {
        this.mMOSMaximum = d;
    }

    public final double getMaximumMOS() {
        return this.mMOSMaximum;
    }

    public final void setEstimation(MethodEstimation methodEstimation) {
        this.mEstimation = methodEstimation;
    }

    public final MethodEstimation getEstimation() {
        return this.mEstimation;
    }

    public final boolean addToCommonList(String string) {
        return this.mCommonVariableList.add(new VariableName(string));
    }

    public final long getCommonListSize() {
        return this.mCommonVariableList.size();
    }

    public final boolean isInCommonList(String string) {
        return this.mCommonVariableList.contains(new VariableName(string));
    }

    public final boolean addToSelectList(String string) {
        return this.mSelectVariableList.add(new VariableName(string));
    }

    public final long getSelectListSize() {
        return this.mSelectVariableList.size();
    }

    public final boolean isInSelectList(String string) {
        return this.mSelectVariableList.contains(new VariableName(string));
    }

    public final void addToStageList(StageInformation stageInformation) {
        this.mStageList.add(stageInformation);
    }

    public final long getStageListSize() {
        return this.mStageList.size();
    }

    public final StageInformation getStage(long l) {
        try {
            return this.mStageList.get(new Long(l - 1L).intValue());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public final boolean isStageNumSeqNatural(Vector<Integer> vector) {
        boolean bl = true;
        vector.clear();
        for (int i = 0; i < this.mStageList.size(); ++i) {
            int n = this.mStageList.get(i).getSerial();
            vector.add(n);
            bl &= n - 1 == i;
        }
        return bl;
    }

    public final StageInformation getLastStage() {
        try {
            return this.mStageList.lastElement();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public final boolean display(String string) {
        boolean bl = false;
        OutputStreamWriter outputStreamWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-16");
            bl = this.display(outputStreamWriter);
            outputStreamWriter.close();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IOException iOException) {
            try {
                outputStreamWriter.close();
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
            }
        }
        return bl;
    }

    public final boolean display(OutputStreamWriter outputStreamWriter) throws IOException {
        boolean bl = true;
        outputStreamWriter.write("CSPLAN mode: ");
        switch (this.mMode) {
            case NO_MODE: {
                outputStreamWriter.write("NO_MODE\n");
                break;
            }
            case SAMPLE_MODE: {
                outputStreamWriter.write("SAMPLE_MODE\n");
                break;
            }
            case ANALYSIS_MODE: {
                outputStreamWriter.write("ANALYSIS_MODE\n");
                break;
            }
            case VIEW_MODE: {
                outputStreamWriter.write("VIEW_MODE\n");
                break;
            }
            default: {
                outputStreamWriter.write("Wrong mode\n");
            }
        }
        outputStreamWriter.write("FILE = " + this.mFilename + "\n");
        outputStreamWriter.write("WEIGHT = " + this.mWeight + "\n");
        outputStreamWriter.write("PREVIOUSWEIGHT = " + this.mPreviousWeight + "\n");
        outputStreamWriter.write("SRSESTIMATOR TYPE: ");
        switch (this.mEstimator) {
            case WOR: {
                outputStreamWriter.write("WOR\n");
                break;
            }
            case WR: {
                outputStreamWriter.write("WR\n");
                break;
            }
            default: {
                outputStreamWriter.write("Wrong SRS estimator type\n");
            }
        }
        outputStreamWriter.write("PRINT OPTION: ");
        switch (this.mPrintOption) {
            case PRINT_PLAN: {
                outputStreamWriter.write("PRINT_PLAN\n");
                break;
            }
            case PRINT_MATRIX: {
                outputStreamWriter.write("PRINT_MATRIX\n");
                break;
            }
            case PRINT_BOTH: {
                outputStreamWriter.write("PRINT_BOTH\n");
                break;
            }
            default: {
                outputStreamWriter.write("Wrong print option\n");
            }
        }
        outputStreamWriter.write("MOS VARIABLE = " + this.mMOSVariable + "\n");
        outputStreamWriter.write("MOS SOURCE = ");
        if (this.mMOSFromData) {
            outputStreamWriter.write("FROMDATA\n");
        } else {
            outputStreamWriter.write("NOT FROMDATA\n");
        }
        outputStreamWriter.write("MOS MIN = " + Double.toString(this.mMOSMinimum) + "\n");
        outputStreamWriter.write("MOS MAX = " + Double.toString(this.mMOSMaximum) + "\n");
        outputStreamWriter.write("ESTIMATION = ");
        switch (this.mEstimation) {
            case DEFAULT: {
                outputStreamWriter.write("DEFAULT\n");
                break;
            }
            case WR: {
                outputStreamWriter.write("WR\n");
                break;
            }
            default: {
                outputStreamWriter.write("Wrong estimation\n");
            }
        }
        outputStreamWriter.write("\n");
        for (int i = 0; i < this.mStageList.size(); ++i) {
            outputStreamWriter.write("Display stage " + Integer.toString(i + 1) + "\n");
            bl &= this.mStageList.get(i).display(outputStreamWriter);
        }
        outputStreamWriter.close();
        return bl;
    }

    private static enum PrintOption {
        PRINT_PLAN(0),
        PRINT_MATRIX(1),
        PRINT_BOTH(2);

        private final int mValue;

        private PrintOption(int n2) {
            this.mValue = n2;
        }

        public int getValue() {
            return this.mValue;
        }
    }

    private static enum Mode {
        NO_MODE(0),
        SAMPLE_MODE(1),
        ANALYSIS_MODE(2),
        VIEW_MODE(3);

        private final int mValue;

        private Mode(int n2) {
            this.mValue = n2;
        }

        public int getValue() {
            return this.mValue;
        }
    }

    public static enum MethodEstimation {
        DEFAULT(14),
        WR(15);

        private final int mValue;

        private MethodEstimation(int n2) {
            this.mValue = n2;
        }

        public int getValue() {
            return this.mValue;
        }
    }

    public static enum SRSEstimatorType {
        WR(15),
        WOR(16);

        private final int mValue;

        private SRSEstimatorType(int n2) {
            this.mValue = n2;
        }

        public int getValue() {
            return this.mValue;
        }
    }
}

