/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.common;

import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.xml.DOMFactory;
import com.spss.java_client.core.xml.SchemaType;
import com.spss.java_client.ui.dialogs.complex_samples.common.ErrorCodeType;
import com.spss.java_client.ui.dialogs.complex_samples.common.Specification;
import com.spss.java_client.ui.dialogs.complex_samples.common.StageInformation;
import com.spss.java_client.ui.dialogs.complex_samples.common.VariableCategoryList;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class Importer {
    private Specification mSpec = null;

    public Importer(Specification specification) {
        assert (specification != null);
        this.mSpec = specification;
    }

    public ErrorCodeType getAnalysisPlan(String string) {
        Document document;
        DOMFactory dOMFactory = new DOMFactory();
        try {
            document = dOMFactory.createDOM(new InputSource(new FileInputStream(string)), SchemaType.DTD_COMPLEX_SAMPLES_V1);
            if (document == null) {
                return ErrorCodeType.CSXML_PARSER_ERROR;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return ErrorCodeType.CSXML_PARSER_ERROR;
        }
        Element element = document.getDocumentElement();
        Element element2 = Importer.getChildByTagName(element, "AnalysisDesign");
        if (element2 == null) {
            return ErrorCodeType.CSXML_ANALYSISDESIGN_MISSING;
        }
        this.mSpec.setAnalysisMode();
        this.mSpec.setXMLFilename(string);
        ErrorCodeType errorCodeType = this.getAnalysisStage(element2, true);
        ErrorCodeType errorCodeType2 = this.getWeight(element2);
        if (errorCodeType == ErrorCodeType.CSXML_ERROR_NONE) {
            errorCodeType = errorCodeType2;
        }
        if (errorCodeType == ErrorCodeType.CSXML_ERROR_NONE) {
            String string2 = element2.getAttribute("SRSestimator");
            if (string2.equals("wor")) {
                this.mSpec.setSRSEstimator(Specification.SRSEstimatorType.WOR);
            } else if (string2.equals("wr")) {
                this.mSpec.setSRSEstimator(Specification.SRSEstimatorType.WR);
            } else if (string2.length() != 0) {
                errorCodeType = ErrorCodeType.CSXML_WRONG_SRSESTIMATOR;
            }
        }
        return errorCodeType;
    }

    public ErrorCodeType getSamplePlan(String string) {
        Document document;
        DOMFactory dOMFactory = new DOMFactory();
        try {
            document = dOMFactory.createDOM(new InputSource(new FileInputStream(string)), SchemaType.DTD_COMPLEX_SAMPLES_V1);
            if (document == null) {
                return ErrorCodeType.CSXML_PARSER_ERROR;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return ErrorCodeType.CSXML_PARSER_ERROR;
        }
        Element element = document.getDocumentElement();
        Element element2 = Importer.getChildByTagName(element, "SampleDesign");
        if (element2 == null) {
            return ErrorCodeType.CSXML_SAMPLEDESIGN_MISSING;
        }
        this.mSpec.setSampleMode();
        this.mSpec.setXMLFilename(string);
        ErrorCodeType errorCodeType = this.getSampleStage(element2, true);
        ErrorCodeType errorCodeType2 = this.getPreviousWeight(element2);
        if (errorCodeType == ErrorCodeType.CSXML_ERROR_NONE) {
            errorCodeType = errorCodeType2;
        }
        errorCodeType2 = this.getWeight(element2);
        if (errorCodeType == ErrorCodeType.CSXML_ERROR_NONE) {
            errorCodeType = errorCodeType2;
        }
        if (errorCodeType == ErrorCodeType.CSXML_VARIABLE_REPEATED) {
            errorCodeType = ErrorCodeType.CSXML_VARIABLE_REPEATED_SAMPLE;
        }
        return errorCodeType;
    }

    private ErrorCodeType getWeight(Element element) {
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        String string = this.getFirstVariable(element, "Weight");
        if (string.length() != 0) {
            errorCodeType = Importer.validateVariable(string);
            if (!this.mSpec.addToCommonList(string)) {
                errorCodeType = ErrorCodeType.CSXML_VARIABLE_REPEATED;
            }
            this.mSpec.setWeight(string);
        }
        return errorCodeType;
    }

    private ErrorCodeType getPreviousWeight(Element element) {
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        String string = this.getFirstVariable(element, "PreviousWeight");
        if (string.length() != 0) {
            errorCodeType = Importer.validateVariable(string);
            if (!this.mSpec.addToCommonList(string)) {
                errorCodeType = ErrorCodeType.CSXML_VARIABLE_REPEATED;
            }
            this.mSpec.setPreviousWeight(string);
        }
        return errorCodeType;
    }

    private ErrorCodeType getSampleStage(Element element, boolean bl) {
        Object object;
        NodeList nodeList;
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        ErrorCodeType errorCodeType2 = ErrorCodeType.CSXML_ERROR_NONE;
        if (element.getAttribute("wrEstimation").equals("yes")) {
            this.mSpec.setEstimation(Specification.MethodEstimation.WR);
        }
        if ((nodeList = element.getElementsByTagName("SampleStage")).getLength() > 3 && bl) {
            errorCodeType2 = ErrorCodeType.CSXML_NUMBEROFSTAGES_EXCEEDS;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            object = new StageInformation();
            this.mSpec.addToStageList((StageInformation)object);
            Element element3 = (Element)nodeList.item(i);
            ((StageInformation)object).setLabel(element3.getAttribute("label"));
            try {
                ((StageInformation)object).setSerial(Integer.decode(element3.getAttribute("stageNumber")));
            }
            catch (NumberFormatException numberFormatException) {
                ((StageInformation)object).setSerial(0);
            }
            String string = element3.getAttribute("selectionMethod");
            ErrorCodeType errorCodeType3 = Importer.getEstimationType(string, (StageInformation)object, i + 1);
            if (errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE && bl) {
                errorCodeType2 = errorCodeType3;
            }
            if ((((StageInformation)object).getKey() == StageInformation.KeyType.SIMPLE_WR || ((StageInformation)object).getKey() == StageInformation.KeyType.PPS_WR) && i + 1 != nodeList.getLength()) {
                errorCodeType3 = ErrorCodeType.CSXML_METHOD_NOTALLOWED_ATSTAGE;
            }
            if (errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE && bl) {
                errorCodeType2 = errorCodeType3;
            }
            errorCodeType3 = this.getStrataList(element3, (StageInformation)object);
            if (errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE && bl) {
                errorCodeType2 = errorCodeType3;
            }
            errorCodeType3 = this.getClusterList(element3, (StageInformation)object);
            if (errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE && bl) {
                errorCodeType2 = errorCodeType3;
            }
            if ((element2 = Importer.getChildByTagName(element3, "InputSampleSize")) != null) {
                ((StageInformation)object).setKeySubcommand(StageInformation.KeySubcommandType.SIZE);
                errorCodeType3 = this.getSubcommandInformation(element2, (StageInformation)object, i + 1);
                if (errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE && bl) {
                    errorCodeType2 = errorCodeType3;
                }
            } else {
                Element element4 = Importer.getChildByTagName(element3, "InputSampleRate");
                if (element4 != null) {
                    ((StageInformation)object).setKeySubcommand(StageInformation.KeySubcommandType.RATE);
                    errorCodeType3 = this.getSubcommandInformation(element4, (StageInformation)object, i + 1);
                    if (errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE && bl) {
                        errorCodeType2 = errorCodeType3;
                    }
                    errorCodeType3 = this.getMinimumInputRate(element4, (StageInformation)object);
                    if (errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE && bl) {
                        errorCodeType2 = errorCodeType3;
                    }
                    errorCodeType3 = this.getMaximumInputRate(element4, (StageInformation)object);
                    if (errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE && bl) {
                        errorCodeType2 = errorCodeType3;
                    }
                    if (errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE && ((StageInformation)object).getMinimumSize() > ((StageInformation)object).getMaximumSize() && ((StageInformation)object).getMaximumSize() > 0.0 && bl) {
                        errorCodeType2 = ErrorCodeType.CSXML_MIN_GREATER_THAN_MAX;
                    }
                } else if (((StageInformation)object).getKey() != StageInformation.KeyType.PPS_MURTHY && ((StageInformation)object).getKey() != StageInformation.KeyType.PPS_BREWER && bl && errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE) {
                    errorCodeType2 = ErrorCodeType.CSXML_RATE_SIZE_NOT_PRESENT;
                }
            }
            switch (((StageInformation)object).getKey()) {
                case PPS_WOR: 
                case PPS_WR: 
                case PPS_SYSTEMATIC: 
                case PPS_BREWER: 
                case PPS_MURTHY: 
                case PPS_SAMPFORD: 
                case PPS_CHROMY: {
                    errorCodeType3 = this.getMOS(element3);
                    if (errorCodeType2 != ErrorCodeType.CSXML_ERROR_NONE || !bl) break;
                    errorCodeType2 = errorCodeType3;
                    break;
                }
            }
            errorCodeType3 = this.getIndex(element3, (StageInformation)object);
            if (errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE && bl) {
                errorCodeType2 = errorCodeType3;
            }
            errorCodeType3 = this.getSampleInclusionProbability(element3, (StageInformation)object);
            if (errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE && bl) {
                errorCodeType2 = errorCodeType3;
            }
            errorCodeType3 = this.getSamplePopulationSize(element3, (StageInformation)object);
            if (errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE && bl) {
                errorCodeType2 = errorCodeType3;
            }
            errorCodeType3 = this.getOutputSampleSize(element3, (StageInformation)object);
            if (errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE && bl) {
                errorCodeType2 = errorCodeType3;
            }
            errorCodeType3 = this.getOutputSampleRate(element3, (StageInformation)object);
            if (errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE && bl) {
                errorCodeType2 = errorCodeType3;
            }
            errorCodeType3 = this.getStageWeight(element3, (StageInformation)object);
            if (errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE && bl) {
                errorCodeType2 = errorCodeType3;
            }
            errorCodeType3 = this.getCumulativeWeight(element3, (StageInformation)object);
            if (errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE && bl) {
                errorCodeType2 = errorCodeType3;
            }
            if (!bl || ((StageInformation)object).getVariableListSize() > 0L || i >= nodeList.getLength() - 1) continue;
            errorCodeType = ErrorCodeType.CSXML_CLUSTER_REQUIRED;
        }
        if (bl) {
            if (nodeList.getLength() == 1) {
                StageInformation stageInformation = this.mSpec.getStage(1L);
                object = stageInformation.getKey();
                long l = stageInformation.getVariableListSize();
                if (l <= 0L && errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE && (object == StageInformation.KeyType.PPS_WOR || object == StageInformation.KeyType.PPS_SAMPFORD || object == StageInformation.KeyType.PPS_MURTHY || object == StageInformation.KeyType.PPS_BREWER)) {
                    errorCodeType2 = ErrorCodeType.CSXML_CLUSTER_MISSING_IN_PPS;
                }
            } else if (errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE) {
                errorCodeType2 = errorCodeType;
            }
        }
        return errorCodeType2;
    }

    private ErrorCodeType getCumulativeWeight(Element element, StageInformation stageInformation) {
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        String string = this.getFirstVariable(element, "CumulativeWeight");
        if (string.length() != 0) {
            errorCodeType = Importer.validateVariable(string);
            if (!this.mSpec.addToCommonList(string)) {
                errorCodeType = ErrorCodeType.CSXML_VARIABLE_REPEATED;
            }
            stageInformation.setCumulativeWeight(string);
        }
        return errorCodeType;
    }

    private ErrorCodeType getStageWeight(Element element, StageInformation stageInformation) {
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        String string = this.getFirstVariable(element, "Weight");
        if (string.length() != 0) {
            errorCodeType = Importer.validateVariable(string);
            if (!this.mSpec.addToCommonList(string)) {
                errorCodeType = ErrorCodeType.CSXML_VARIABLE_REPEATED;
            }
            stageInformation.setWeight(string);
        }
        return errorCodeType;
    }

    private ErrorCodeType getOutputSampleRate(Element element, StageInformation stageInformation) {
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        String string = this.getFirstVariable(element, "OutputSampleRate");
        if (string.length() != 0) {
            errorCodeType = Importer.validateVariable(string);
            if (!this.mSpec.addToCommonList(string)) {
                errorCodeType = ErrorCodeType.CSXML_VARIABLE_REPEATED;
            }
            stageInformation.setRate(string);
        }
        return errorCodeType;
    }

    private ErrorCodeType getOutputSampleSize(Element element, StageInformation stageInformation) {
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        String string = this.getFirstVariable(element, "OutputSampleSize");
        if (string.length() != 0) {
            errorCodeType = Importer.validateVariable(string);
            if (!this.mSpec.addToCommonList(string)) {
                errorCodeType = ErrorCodeType.CSXML_VARIABLE_REPEATED;
            }
            stageInformation.setSampleSize(string);
        }
        return errorCodeType;
    }

    private ErrorCodeType getSamplePopulationSize(Element element, StageInformation stageInformation) {
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        String string = this.getFirstVariable(element, "PopulationSize");
        if (string.length() != 0) {
            errorCodeType = Importer.validateVariable(string);
            if (!this.mSpec.addToCommonList(string)) {
                errorCodeType = ErrorCodeType.CSXML_VARIABLE_REPEATED;
            }
            stageInformation.setPopulationSize(string);
        }
        return errorCodeType;
    }

    private ErrorCodeType getSampleInclusionProbability(Element element, StageInformation stageInformation) {
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        String string = this.getFirstVariable(element, "IncProb");
        if (string.length() != 0) {
            errorCodeType = Importer.validateVariable(string);
            if (!this.mSpec.addToCommonList(string)) {
                errorCodeType = ErrorCodeType.CSXML_VARIABLE_REPEATED;
            }
            stageInformation.setInclusionProbability(string);
        }
        return errorCodeType;
    }

    private ErrorCodeType getIndex(Element element, StageInformation stageInformation) {
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        String string = this.getFirstVariable(element, "Index");
        if (string.length() != 0) {
            errorCodeType = Importer.validateVariable(string);
            if (!this.mSpec.addToCommonList(string)) {
                errorCodeType = ErrorCodeType.CSXML_VARIABLE_REPEATED;
            }
            stageInformation.setIndex(string);
        }
        return errorCodeType;
    }

    private ErrorCodeType getMOS(Element element) {
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        Element element2 = Importer.getChildByTagName(element, "MOS");
        if (element2 != null) {
            Object object;
            if (element2.getAttribute("fromData").equals("yes")) {
                this.mSpec.setMOSFromData();
            } else if (element2.getAttribute("fromData").equals("no")) {
                object = Importer.getChildByTagName(element2, "Variable");
                if (object != null) {
                    String string = object.getAttribute("name");
                    errorCodeType = Importer.validateVariable(string);
                    if (!this.mSpec.addToCommonList(string)) {
                        errorCodeType = ErrorCodeType.CSXML_VARIABLE_REPEATED;
                    }
                    this.mSpec.setMOSVariableName(string);
                } else {
                    errorCodeType = ErrorCodeType.CSXML_MOS_VARIABLE_MISSING;
                }
            }
            object = this.getMinimumMOS(element2, this.mSpec);
            if (object != ErrorCodeType.CSXML_ERROR_NONE) {
                errorCodeType = object;
            }
            if ((object = this.getMaximumMOS(element2, this.mSpec)) != ErrorCodeType.CSXML_ERROR_NONE) {
                errorCodeType = object;
            }
            if (errorCodeType == ErrorCodeType.CSXML_ERROR_NONE && this.mSpec.getMinimumMOS() > this.mSpec.getMaximumMOS() && this.mSpec.getMaximumMOS() > 0.0) {
                errorCodeType = ErrorCodeType.CSXML_MIN_GREATER_THAN_MAX;
            }
        } else {
            errorCodeType = ErrorCodeType.CSXML_MOS_MISSING;
        }
        return errorCodeType;
    }

    private ErrorCodeType getMaximumInputRate(Element element, StageInformation stageInformation) {
        Element element2;
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        Element element3 = Importer.getChildByTagName(element, "MaxSize");
        if (element3 != null && (element2 = Importer.getChildByTagName(element3, "SingleValue")) != null) {
            try {
                double d = Double.valueOf(element2.getAttribute("value"));
                if (d < 0.0 || !Importer.isValidInteger(d)) {
                    errorCodeType = ErrorCodeType.CSXML_MAX_MIN_VALUE_INCORRECT;
                } else {
                    stageInformation.setMaximumSize(d);
                }
            }
            catch (NumberFormatException numberFormatException) {
                errorCodeType = ErrorCodeType.CSXML_MAX_MIN_VALUE_INCORRECT;
            }
        }
        return errorCodeType;
    }

    private ErrorCodeType getMinimumInputRate(Element element, StageInformation stageInformation) {
        Element element2;
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        Element element3 = Importer.getChildByTagName(element, "MinSize");
        if (element3 != null && (element2 = Importer.getChildByTagName(element3, "SingleValue")) != null) {
            try {
                double d = Double.valueOf(element2.getAttribute("value"));
                if (d < 0.0 || !Importer.isValidInteger(d)) {
                    errorCodeType = ErrorCodeType.CSXML_MAX_MIN_VALUE_INCORRECT;
                } else {
                    stageInformation.setMinimumSize(d);
                }
            }
            catch (NumberFormatException numberFormatException) {
                errorCodeType = ErrorCodeType.CSXML_MAX_MIN_VALUE_INCORRECT;
            }
        }
        return errorCodeType;
    }

    private ErrorCodeType getMaximumMOS(Element element, Specification specification) {
        Element element2;
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        Element element3 = Importer.getChildByTagName(element, "MaxSize");
        if (element3 != null && (element2 = Importer.getChildByTagName(element3, "SingleValue")) != null) {
            try {
                double d = Double.valueOf(element2.getAttribute("value"));
                if (d < 0.0 || !Importer.isValidInteger(d)) {
                    errorCodeType = ErrorCodeType.CSXML_MAX_MIN_VALUE_INCORRECT;
                } else {
                    specification.setMaximumMOS(d);
                }
            }
            catch (NumberFormatException numberFormatException) {
                errorCodeType = ErrorCodeType.CSXML_MAX_MIN_VALUE_INCORRECT;
            }
        }
        return errorCodeType;
    }

    private ErrorCodeType getMinimumMOS(Element element, Specification specification) {
        Element element2;
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        Element element3 = Importer.getChildByTagName(element, "MinSize");
        if (element3 != null && (element2 = Importer.getChildByTagName(element3, "SingleValue")) != null) {
            try {
                double d = Double.valueOf(element2.getAttribute("value"));
                if (d < 0.0 || !Importer.isValidInteger(d)) {
                    errorCodeType = ErrorCodeType.CSXML_MAX_MIN_VALUE_INCORRECT;
                } else {
                    specification.setMinimumMOS(d);
                }
            }
            catch (NumberFormatException numberFormatException) {
                errorCodeType = ErrorCodeType.CSXML_MAX_MIN_VALUE_INCORRECT;
            }
        }
        return errorCodeType;
    }

    private static boolean isValidInteger(double d) {
        return d >= -2.147483648E9 && d <= 2.147483647E9 && Math.floor(d) == d;
    }

    private static ErrorCodeType getEstimationType(String string, StageInformation stageInformation, int n) {
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        if (string.equals("simple_wor")) {
            stageInformation.setKey(StageInformation.KeyType.SIMPLE_WOR);
        } else if (string.equals("simple_wr")) {
            stageInformation.setKey(StageInformation.KeyType.SIMPLE_WR);
        } else if (string.equals("simple_systematic")) {
            stageInformation.setKey(StageInformation.KeyType.SIMPLE_SYSTEMATIC);
        } else if (string.equals("simple_chromy")) {
            stageInformation.setKey(StageInformation.KeyType.SIMPLE_CHROMY);
        } else if (string.equals("pps_wor")) {
            stageInformation.setKey(StageInformation.KeyType.PPS_WOR);
            if (n > 1) {
                errorCodeType = ErrorCodeType.CSXML_INVALID_METHODTYPE;
            }
        } else if (string.equals("pps_wr")) {
            stageInformation.setKey(StageInformation.KeyType.PPS_WR);
            if (n > 1) {
                errorCodeType = ErrorCodeType.CSXML_INVALID_METHODTYPE;
            }
        } else if (string.equals("pps_systematic")) {
            stageInformation.setKey(StageInformation.KeyType.PPS_SYSTEMATIC);
            if (n > 1) {
                errorCodeType = ErrorCodeType.CSXML_INVALID_METHODTYPE;
            }
        } else if (string.equals("pps_brewer")) {
            stageInformation.setKey(StageInformation.KeyType.PPS_BREWER);
            if (n > 1) {
                errorCodeType = ErrorCodeType.CSXML_INVALID_METHODTYPE;
            }
        } else if (string.equals("pps_murthy")) {
            stageInformation.setKey(StageInformation.KeyType.PPS_MURTHY);
            if (n > 1) {
                errorCodeType = ErrorCodeType.CSXML_INVALID_METHODTYPE;
            }
        } else if (string.equals("pps_sampford")) {
            stageInformation.setKey(StageInformation.KeyType.PPS_SAMPFORD);
            if (n > 1) {
                errorCodeType = ErrorCodeType.CSXML_INVALID_METHODTYPE;
            }
        } else if (string.equals("pps_chromy")) {
            stageInformation.setKey(StageInformation.KeyType.PPS_CHROMY);
            if (n > 1) {
                errorCodeType = ErrorCodeType.CSXML_INVALID_METHODTYPE;
            }
        } else {
            errorCodeType = ErrorCodeType.CSXML_INVALID_METHODTYPE;
        }
        return errorCodeType;
    }

    private ErrorCodeType getAnalysisStage(Element element, boolean bl) {
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        ErrorCodeType errorCodeType2 = ErrorCodeType.CSXML_ERROR_NONE;
        NodeList nodeList = element.getElementsByTagName("AnalysisStage");
        if (nodeList.getLength() > 3 && bl) {
            errorCodeType2 = ErrorCodeType.CSXML_NUMBEROFSTAGES_EXCEEDS;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            StageInformation stageInformation = new StageInformation();
            this.mSpec.addToStageList(stageInformation);
            Element element2 = (Element)nodeList.item(i);
            stageInformation.setLabel(element2.getAttribute("label"));
            try {
                stageInformation.setSerial(Integer.decode(element2.getAttribute("stageNumber")));
            }
            catch (NumberFormatException numberFormatException) {
                stageInformation.setSerial(0);
            }
            String string = element2.getAttribute("estimationMethod");
            if (string.equals("equal_wor")) {
                stageInformation.setKey(StageInformation.KeyType.EQUAL_WOR);
            } else if (string.equals("unequal_wor")) {
                if (i != 0 && bl && errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE) {
                    errorCodeType2 = ErrorCodeType.CSXML_WRONG_ESTIMATOR;
                }
                stageInformation.setKey(StageInformation.KeyType.UNEQUAL_WOR);
            } else if (string.equals("wr")) {
                stageInformation.setKey(StageInformation.KeyType.WR);
            }
            ErrorCodeType errorCodeType3 = this.getStrataList(element2, stageInformation);
            if (errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE && bl) {
                errorCodeType2 = errorCodeType3;
            }
            errorCodeType3 = this.getClusterList(element2, stageInformation);
            if (errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE && bl) {
                errorCodeType2 = errorCodeType3;
            }
            if (!bl || stageInformation.getKey() == StageInformation.KeyType.EQUAL_WOR) {
                Element element3 = Importer.getChildByTagName(element2, "PopulationSize");
                if (element3 != null) {
                    stageInformation.setKeySubcommand(StageInformation.KeySubcommandType.POPSIZE);
                    errorCodeType3 = this.getSubcommandInformation(element3, stageInformation, i + 1);
                    if (errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE && bl) {
                        errorCodeType2 = errorCodeType3;
                    }
                } else {
                    Element element4 = Importer.getChildByTagName(element2, "IncProb");
                    if (element4 != null) {
                        stageInformation.setKeySubcommand(StageInformation.KeySubcommandType.INCLPROB);
                        errorCodeType3 = this.getSubcommandInformation(element4, stageInformation, i + 1);
                        if (errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE && bl) {
                            errorCodeType2 = errorCodeType3;
                        }
                    }
                }
            }
            if (!bl || stageInformation.getVariableListSize() > 0L || i >= nodeList.getLength() - 1) continue;
            errorCodeType = ErrorCodeType.CSXML_CLUSTER_REQUIRED;
        }
        if (bl && errorCodeType2 == ErrorCodeType.CSXML_ERROR_NONE) {
            errorCodeType2 = errorCodeType;
        }
        return errorCodeType2;
    }

    private ErrorCodeType getSubcommandInformation(Element element, StageInformation stageInformation, int n) {
        ErrorCodeType errorCodeType = this.getSingleValue(element, stageInformation);
        ErrorCodeType errorCodeType2 = this.getParameterVariable(element, stageInformation);
        if (errorCodeType == ErrorCodeType.CSXML_ERROR_NONE) {
            errorCodeType = errorCodeType2;
        }
        errorCodeType2 = this.getMatrix(element, stageInformation, n);
        if (errorCodeType == ErrorCodeType.CSXML_ERROR_NONE) {
            errorCodeType = errorCodeType2;
        }
        return errorCodeType;
    }

    private ErrorCodeType getSingleValue(Element element, StageInformation stageInformation) {
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        Element element2 = Importer.getChildByTagName(element, "SingleValue");
        if (element2 != null) {
            try {
                double d = Double.valueOf(element2.getAttribute("value"));
                errorCodeType = this.validateValue(d, stageInformation.getKeySubcommand());
                stageInformation.setParameterValue(d);
                stageInformation.setParameterGiven(StageInformation.ParameterGivenType.BY_VALUE);
            }
            catch (NumberFormatException numberFormatException) {
                stageInformation.setParameterValue(0.0);
            }
        }
        return errorCodeType;
    }

    private ErrorCodeType getParameterVariable(Element element, StageInformation stageInformation) {
        String string;
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        Element element2 = Importer.getChildByTagName(element, "Variable");
        if (element2 != null && (string = element2.getAttribute("name")).length() != 0) {
            stageInformation.setParameterVariable(string);
            stageInformation.setParameterGiven(StageInformation.ParameterGivenType.BY_VARNAME);
            errorCodeType = Importer.validateVariable(string);
            if (!this.mSpec.addToCommonList(string)) {
                errorCodeType = ErrorCodeType.CSXML_VARIABLE_REPEATED;
            }
        }
        return errorCodeType;
    }

    private static ErrorCodeType validateVariable(String string) {
        VarNameValidator.ValidNameCode validNameCode;
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_INVALID_SPSS_VARIABLE;
        if (string.length() != 0 && ((validNameCode = VarNameValidator.validateSPSSName((String)string, (boolean)true)) == VarNameValidator.ValidNameCode.SPSSNAME_STANDARD || validNameCode == VarNameValidator.ValidNameCode.SPSSNAME_WARN_UNDERSCORE)) {
            errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        }
        return errorCodeType;
    }

    private String getFirstVariable(Element element, String string) {
        Element element2;
        String string2 = "";
        Element element3 = Importer.getChildByTagName(element, string);
        if (element3 != null && (element2 = Importer.getChildByTagName(element3, "Variable")) != null) {
            string2 = element2.getAttribute("name");
        }
        return string2;
    }

    private ErrorCodeType validateValue(double d, StageInformation.KeySubcommandType keySubcommandType) {
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        if (keySubcommandType == StageInformation.KeySubcommandType.INCLPROB) {
            if (d <= 0.0 || d > 1.0) {
                errorCodeType = ErrorCodeType.CSXML_INCPROB_VALUE_INCORRECT;
            }
        } else if (keySubcommandType == StageInformation.KeySubcommandType.POPSIZE) {
            if (d <= 0.0 || !Importer.isValidInteger(d)) {
                errorCodeType = ErrorCodeType.CSXML_POPSIZE_VALUE_INCORRECT;
            }
        } else if (keySubcommandType == StageInformation.KeySubcommandType.RATE) {
            if (d <= 0.0) {
                errorCodeType = ErrorCodeType.CSXML_RATE_VALUE_INCORRECT;
            }
        } else if (keySubcommandType == StageInformation.KeySubcommandType.SIZE && (d <= 0.0 || !Importer.isValidInteger(d))) {
            errorCodeType = ErrorCodeType.CSXML_SIZE_VALUE_INCORRECT;
        }
        return errorCodeType;
    }

    private ErrorCodeType getMatrix(Element element, StageInformation stageInformation, int n) {
        Object object = ErrorCodeType.CSXML_ERROR_NONE;
        Element element2 = Importer.getChildByTagName(element, "Matrix");
        if (element2 != null) {
            Object object2;
            Object object3;
            int n2;
            NodeList nodeList;
            int n3;
            stageInformation.setParameterGiven(StageInformation.ParameterGivenType.BY_VARCATLIST);
            VariableCategoryList variableCategoryList = stageInformation.getVariableCategoryList();
            Element element3 = Importer.getChildByTagName(element2, "MatrixVarList");
            if (element3 != null) {
                n3 = Integer.decode(element3.getAttribute("numberOfVariables"));
                nodeList = element3.getElementsByTagName("Variable");
                assert (n3 == nodeList.getLength());
                for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                    object3 = (Element)nodeList.item(n2);
                    object2 = object3.getAttribute("name");
                    object = Importer.validateVariable((String)object2);
                    variableCategoryList.addVariable((String)object2);
                    if (this.mSpec.isInSelectList((String)object2) && !this.mSpec.getStage(n).isInVariableList((String)object2)) continue;
                    object = ErrorCodeType.CSXML_INVALID_MATRIX_VARIABLE;
                }
            }
            n3 = Integer.decode(element2.getAttribute("numberOfValues"));
            nodeList = element2.getElementsByTagName("MatrixValue");
            assert (n3 == nodeList.getLength());
            for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                Object object4;
                object3 = new Vector();
                object2 = (Element)nodeList.item(n2);
                NodeList nodeList2 = object2.getElementsByTagName("Category");
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    Element element4 = (Element)nodeList2.item(i);
                    object4 = element4.getAttribute("value");
                    variableCategoryList.addToCategoryList((Vector<String>)object3, (String)object4);
                }
                if (!variableCategoryList.isCategoryListOK((Vector<String>)object3)) {
                    object = ErrorCodeType.CSXML_WRONG_CATEGORYLIST_LENGTH;
                }
                try {
                    double d = Double.valueOf(object2.getAttribute("sizeValue"));
                    object4 = this.validateValue(d, stageInformation.getKeySubcommand());
                    if (object4 != ErrorCodeType.CSXML_ERROR_NONE) {
                        object = object4;
                    }
                    variableCategoryList.addCategoryList((Vector<String>)object3, d);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    object = this.validateValue(-1.0, stageInformation.getKeySubcommand());
                }
            }
        }
        return object;
    }

    private ErrorCodeType getStrataList(Element element, StageInformation stageInformation) {
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        Element element2 = Importer.getChildByTagName(element, "StrataVarList");
        if (element2 != null) {
            int n = Integer.decode(element2.getAttribute("numberOfVariables"));
            NodeList nodeList = element2.getElementsByTagName("Variable");
            assert (n == nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element3 = (Element)nodeList.item(i);
                String string = element3.getAttribute("name");
                errorCodeType = Importer.validateVariable(string);
                if (!this.mSpec.addToCommonList(string)) {
                    errorCodeType = ErrorCodeType.CSXML_VARIABLE_REPEATED;
                }
                this.mSpec.addToSelectList(string);
                stageInformation.addToStrataList(string);
            }
        }
        return errorCodeType;
    }

    private ErrorCodeType getClusterList(Element element, StageInformation stageInformation) {
        ErrorCodeType errorCodeType = ErrorCodeType.CSXML_ERROR_NONE;
        Element element2 = Importer.getChildByTagName(element, "ClusterVarList");
        if (element2 != null) {
            int n = Integer.decode(element2.getAttribute("numberOfVariables"));
            NodeList nodeList = element2.getElementsByTagName("Variable");
            assert (n == nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element3 = (Element)nodeList.item(i);
                String string = element3.getAttribute("name");
                errorCodeType = Importer.validateVariable(string);
                if (!this.mSpec.addToCommonList(string)) {
                    errorCodeType = ErrorCodeType.CSXML_VARIABLE_REPEATED;
                }
                this.mSpec.addToSelectList(string);
                stageInformation.addToVariableList(string);
                stageInformation.addToClusterList(string);
            }
        }
        return errorCodeType;
    }

    private static Element getChildByTagName(Element element, String string) {
        Element element2 = null;
        if (element != null) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().equals(string)) continue;
                element2 = (Element)node;
                break;
            }
        }
        return element2;
    }
}

