/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples;

import com.spss.java_client.core.common.ComponentState;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class SummaryTableCellRenderer
extends JTextArea
implements TableCellRenderer {
    JTextArea label;
    private Map<Integer, Integer> mRowHeightMap = new HashMap<Integer, Integer>();
    private JTable mSummaryTable;
    private int mDefaultRowHeight;

    public SummaryTableCellRenderer(JTable jTable, int n) {
        this.mSummaryTable = jTable;
        this.mDefaultRowHeight = n + 3;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.label = new JTextArea();
        if (ComponentState.isBtdRtlOrLtr()) {
            if (ComponentState.getBTD() == 1) {
                this.label.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
            } else {
                this.label.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            }
        }
        this.label.setText("");
        String string = "";
        if (object != null && object.getClass().equals(Vector.class)) {
            int n3;
            Vector vector = (Vector)object;
            for (n3 = 0; n3 < vector.size(); ++n3) {
                string = string + vector.get(n3).toString() + "\n";
            }
            if (ComponentState.getBTD() == 1 && !ComponentState.containsBidiLetter((String)string)) {
                this.label.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            }
            this.label.setText(string);
            if (!this.mRowHeightMap.containsKey(n) && vector.size() > 1) {
                n3 = this.mDefaultRowHeight * vector.size();
                this.mSummaryTable.setRowHeight(n, n3);
                this.mRowHeightMap.put(n, n3);
            }
            if (this.mRowHeightMap.containsKey(n) && (n3 = Integer.parseInt(this.mRowHeightMap.get(n).toString())) < vector.size()) {
                int n4 = this.mDefaultRowHeight * vector.size();
                this.mSummaryTable.setRowHeight(n, n4);
                this.mRowHeightMap.put(n, n4);
            }
        } else if (object != null) {
            TableColumn tableColumn;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n5 = fontMetrics.stringWidth(object.toString());
            if (n5 > (tableColumn = this.mSummaryTable.getColumnModel().getColumn(n2)).getWidth()) {
                this.label.setRows(2);
            }
            if (ComponentState.getBTD() == 1 && object instanceof String && !ComponentState.containsBidiLetter((String)((String)object))) {
                this.label.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            }
            this.label.setText(object.toString());
            this.label.setLineWrap(true);
            int n6 = this.mDefaultRowHeight * this.label.getRows();
            if (this.mRowHeightMap.containsKey(n)) {
                int n7 = Integer.parseInt(this.mRowHeightMap.get(n).toString());
                if (n7 < n6) {
                    this.mSummaryTable.setRowHeight(n6);
                }
            } else if (n6 > 0) {
                this.mSummaryTable.setRowHeight(n, n6);
                this.mRowHeightMap.put(n, n6);
            }
        }
        if (bl2) {
            this.label.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            this.label.setBackground(jTable.getSelectionBackground());
            this.label.setForeground(jTable.getSelectionForeground());
        } else {
            this.label.setBorder(UIManager.getBorder("Table.cellBorder"));
            this.label.setBackground(jTable.getBackground());
            this.label.setForeground(jTable.getForeground());
        }
        return this.label;
    }

    public void clearRowHeightHashMap() {
        this.mRowHeightMap.clear();
    }
}

