/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples;

import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.dialogs.complex_samples.CellInformation;
import com.spss.java_client.ui.dialogs.complex_samples.ColumnComparision;
import com.spss.java_client.ui.dialogs.complex_samples.DefineTableModel;
import com.spss.java_client.ui.dialogs.complex_samples.res.ComplexSamplesResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class DefineTableContextMenu
implements ActionListener {
    private static final String UNDO_KEY = "IDS_CS_DEFINE_UNDO";
    private static final String REDO_KEY = "IDS_CS_DEFINE_REDO";
    private static final String COPY_KEY = "IDS_CS_DEFINE_COPY";
    private static final String CUT_KEY = "IDS_CS_DEFINE_CUT";
    private static final String PASTE_KEY = "IDS_CS_DEFINE_PASTE";
    private static final String DELETE_KEY = "IDS_CS_DEFINE_DELETE";
    private static final String REDO_PASTE_DATA_KEY = "IDS_CS_DEFINE_REDO_PASTE";
    private static final String UNDO_PASTE_DATA_KEY = "IDS_CS_DEFINE_UNDO_PASTE";
    private static final String REDO_CUT_DATA_KEY = "IDS_CS_DEFINE_REDO_CUT_DATA";
    private static final String UNDO_CUT_DATA_KEY = "IDS_CS_DEFINE_UNDO_CUT_DATA";
    private static final String REDO_CLEAR_CELLS_KEY = "IDS_CS_DEFINE_REDO_CLEAR_CELLS";
    private static final String UNDO_CLEAR_CELLS_KEY = "IDS_CS_DEFINE_UNDO_CLEAR_CELLS";
    private static final String REDO_INSERT_ROWS_KEY = "IDS_CS_DEFINE_REDO_INSERT_ROWS";
    private static final String UNDO_INSERT_ROWS_KEY = "IDS_CS_DEFINE_UNDO_INSERT_ROWS";
    private static final String SORT_BY_KEY = "IDS_CS_DEFINE_SORT_BY";
    private static final String ASCENDING_KEY = "IDS_CS_DEFINE_ASCENDING";
    private static final String DESCENDING_KEY = "IDS_CS_DEFINE_DSCENDING";
    private JTable mDefineTable;
    private DefineTableModel mModel;
    private int mRowIndex;
    private int mColumnIndex;
    private Stack<String> mUndoSubMenuStack;
    private Stack<String> mRedoSubMenuStack;
    private Stack<CellInformation> mCutData;
    private Stack<CellInformation> mPasteData;
    private Stack<CellInformation> mCopyData;
    private Stack<CellInformation> mDeleteData;
    private Stack<CellInformation> mEditorData;
    private JMenuItem mUndoMenu;
    private JMenuItem mCutMenu;
    private JMenuItem mPasteMenu;
    private JMenuItem mDeleteMenu;
    private JMenuItem mRedoMenu;
    private JMenuItem mSortAscMenu;
    private JMenuItem mSortDesMenu;
    private JMenuItem mCopyMenu;
    private JPopupMenu mContextMenu;
    private int mCheck;
    private int mCutDataStackPos;
    private int mDeleteDataStackPos;
    private int mPasteDataStackPos;
    private Integer mRowCount;
    private BaseDialog mBaseDlg;
    private int mFlag;
    private boolean mIsCopyMenuPressed;
    private boolean mIsPasteMenuPressed;
    private Map<String, Vector<Object>> mCellMap;

    public DefineTableContextMenu(BaseDialog baseDialog, JTable jTable, DefineTableModel defineTableModel, Map<String, Vector<Object>> map) {
        this.mDefineTable = jTable;
        this.mModel = defineTableModel;
        this.mBaseDlg = baseDialog;
        this.mCellMap = map;
        this.initVars();
        this.createContextMenu();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.mModel != null) {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            if (object.equals(this.mCutMenu)) {
                object5 = this.mModel.getValueAt(this.mRowIndex, this.mColumnIndex);
                DefineTableContextMenu.setClipboardContents(object5 == null ? "" : object5.toString());
                this.mModel.setValueAt("", this.mRowIndex, this.mColumnIndex);
                this.mUndoMenu.setText(this.mBaseDlg.getResString(UNDO_CUT_DATA_KEY));
                this.mUndoMenu.setEnabled(true);
                object4 = this.mModel.getColumnName(this.mColumnIndex);
                object3 = this.mCellMap.get(object4);
                object2 = new CellInformation(object5, (Vector<Object>)object3, this.mColumnIndex, this.mRowIndex);
                this.mCutData.push((CellInformation)object2);
                this.mUndoSubMenuStack.push(this.mBaseDlg.getResString(UNDO_CUT_DATA_KEY));
                this.mCutDataStackPos = this.mCutData.size() - 1;
                this.mIsCopyMenuPressed = false;
            }
            if (object.equals(this.mCopyMenu)) {
                object5 = this.mModel.getValueAt(this.mRowIndex, this.mColumnIndex);
                DefineTableContextMenu.setClipboardContents(object5 == null ? "" : object5.toString());
                object4 = this.mModel.getColumnName(this.mColumnIndex);
                object3 = this.mCellMap.get(object4);
                object2 = new CellInformation(object5, (Vector<Object>)object3, this.mColumnIndex, this.mRowIndex);
                this.mCopyData.push((CellInformation)object2);
                this.mIsCopyMenuPressed = true;
            }
            if (object.equals(this.mPasteMenu)) {
                if (DefineTableContextMenu.isClipboardContainingText(this) && this.mModel.isCellEditable(this.mRowIndex, this.mColumnIndex)) {
                    CellInformation cellInformation;
                    CellInformation cellInformation2;
                    this.mIsPasteMenuPressed = true;
                    object5 = DefineTableModel.getClipboardContents(this);
                    object4 = this.mModel.getValueAt(this.mRowIndex, this.mColumnIndex);
                    this.mModel.pasteValues((String)object5, this.mRowIndex, this.mColumnIndex);
                    this.mUndoSubMenuStack.push(this.mBaseDlg.getResString(UNDO_PASTE_DATA_KEY));
                    this.mUndoMenu.setText(this.mBaseDlg.getResString(UNDO_PASTE_DATA_KEY));
                    this.mUndoMenu.setEnabled(true);
                    object3 = this.mModel.getColumnName(this.mColumnIndex);
                    object2 = this.mCellMap.get(object3);
                    CellInformation cellInformation3 = new CellInformation(object4, (Vector<Object>)object2, this.mColumnIndex, this.mRowIndex);
                    this.mPasteData.push(cellInformation3);
                    this.mPasteDataStackPos = this.mPasteData.size() - 1;
                    if (this.mIsCopyMenuPressed) {
                        if (!this.mCopyData.isEmpty()) {
                            cellInformation2 = this.mCopyData.peek();
                            cellInformation = new CellInformation(cellInformation2.getCellValue(), cellInformation2.getCellEditorValues(), this.mColumnIndex, this.mRowIndex);
                            this.mEditorData.push(cellInformation);
                        }
                    } else if (!this.mCutData.isEmpty()) {
                        cellInformation2 = this.mCutData.peek();
                        cellInformation = new CellInformation(cellInformation2.getCellValue(), cellInformation2.getCellEditorValues(), this.mColumnIndex, this.mRowIndex);
                        this.mEditorData.push(cellInformation);
                    }
                } else {
                    this.mPasteMenu.setEnabled(false);
                }
            }
            if (object.equals(this.mDeleteMenu)) {
                object5 = this.mModel.getValueAt(this.mRowIndex, this.mColumnIndex);
                this.mModel.setValueAt("", this.mRowIndex, this.mColumnIndex);
                object4 = this.mModel.getColumnName(this.mColumnIndex);
                object3 = this.mCellMap.get(object4);
                object2 = new CellInformation(object5, (Vector<Object>)object3, this.mColumnIndex, this.mRowIndex);
                this.mDeleteData.push((CellInformation)object2);
                this.mUndoSubMenuStack.push(this.mBaseDlg.getResString(UNDO_CLEAR_CELLS_KEY));
                this.mUndoMenu.setText(this.mBaseDlg.getResString(UNDO_CLEAR_CELLS_KEY));
                this.mUndoMenu.setEnabled(true);
                this.mDeleteDataStackPos = this.mDeleteData.size() - 1;
            }
            if (object.equals(this.mUndoMenu)) {
                object5 = this.mUndoSubMenuStack.pop();
                if (((String)object5).equals(this.mBaseDlg.getResString(UNDO_CUT_DATA_KEY)) && this.mCutDataStackPos >= 0) {
                    object4 = (CellInformation)this.mCutData.get(this.mCutDataStackPos);
                    this.mModel.setValueAt(((CellInformation)object4).getCellValue(), ((CellInformation)object4).getRowIndex(), ((CellInformation)object4).getColumnIndex());
                    this.mRedoSubMenuStack.push(this.mBaseDlg.getResString(REDO_CUT_DATA_KEY));
                    --this.mCutDataStackPos;
                } else if (((String)object5).equals(this.mBaseDlg.getResString(UNDO_PASTE_DATA_KEY)) && this.mPasteDataStackPos >= 0) {
                    object4 = (CellInformation)this.mPasteData.get(this.mPasteDataStackPos);
                    this.mModel.setValueAt(((CellInformation)object4).getCellValue(), ((CellInformation)object4).getRowIndex(), ((CellInformation)object4).getColumnIndex());
                    this.mRedoSubMenuStack.push(this.mBaseDlg.getResString(REDO_PASTE_DATA_KEY));
                    --this.mPasteDataStackPos;
                } else if (((String)object5).equals(this.mBaseDlg.getResString(UNDO_CLEAR_CELLS_KEY))) {
                    object4 = (CellInformation)this.mDeleteData.get(this.mDeleteDataStackPos);
                    this.mModel.setValueAt(((CellInformation)object4).getCellValue(), ((CellInformation)object4).getRowIndex(), ((CellInformation)object4).getColumnIndex());
                    this.mRedoSubMenuStack.push(this.mBaseDlg.getResString(REDO_CLEAR_CELLS_KEY));
                    --this.mDeleteDataStackPos;
                } else if (((String)object5).equals(this.mBaseDlg.getResString(UNDO_INSERT_ROWS_KEY))) {
                    if (this.mModel.getRowCount() >= this.mRowCount) {
                        int n = this.mModel.getRowCount();
                        this.mModel.deleteRow(n - 1);
                        this.mModel.deleteRow(n - 2);
                        this.mModel.deleteRow(n - 3);
                        this.mModel.deleteRow(n - 4);
                        this.mModel.fireTableDataChanged();
                        this.mDefineTable.invalidate();
                    }
                    this.mRedoSubMenuStack.push(this.mBaseDlg.getResString(REDO_INSERT_ROWS_KEY));
                }
                if (this.mRedoSubMenuStack.size() > 1 && this.mRedoSubMenuStack.peek() != null) {
                    this.mRedoMenu.setText(this.mRedoSubMenuStack.peek());
                    this.mRedoMenu.setEnabled(true);
                } else if (this.mRedoSubMenuStack.size() > 0 && this.mRedoSubMenuStack.peek() != null) {
                    this.mRedoMenu.setText(this.mRedoSubMenuStack.peek());
                    this.mRedoMenu.setEnabled(false);
                }
                if (this.mUndoSubMenuStack.size() > 1 && this.mUndoSubMenuStack.peek() != null) {
                    this.mUndoMenu.setText(this.mUndoSubMenuStack.peek());
                    this.mUndoMenu.setEnabled(true);
                } else if (this.mUndoSubMenuStack.size() > 0 && this.mUndoSubMenuStack.peek() != null) {
                    this.mUndoMenu.setText(this.mUndoSubMenuStack.peek());
                    this.mUndoMenu.setEnabled(false);
                }
            }
            if (object.equals(this.mRedoMenu)) {
                object5 = this.mRedoSubMenuStack.pop();
                if (((String)object5).equals(this.mBaseDlg.getResString(REDO_CUT_DATA_KEY)) && this.mCutDataStackPos < this.mCutData.size()) {
                    ++this.mCutDataStackPos;
                    CellInformation cellInformation = (CellInformation)this.mCutData.get(this.mCutDataStackPos);
                    this.mModel.setValueAt("", cellInformation.getRowIndex(), cellInformation.getColumnIndex());
                    this.mUndoSubMenuStack.push(this.mBaseDlg.getResString(UNDO_CUT_DATA_KEY));
                } else if (((String)object5).equals(this.mBaseDlg.getResString(REDO_PASTE_DATA_KEY))) {
                    CellInformation cellInformation;
                    ++this.mPasteDataStackPos;
                    if (this.mCopyData.size() == 0 && this.mPasteDataStackPos >= 0) {
                        ++this.mCutDataStackPos;
                        cellInformation = (CellInformation)this.mCutData.get(this.mCutDataStackPos);
                        object3 = (CellInformation)this.mPasteData.get(this.mPasteDataStackPos);
                        this.mModel.setValueAt(cellInformation.getCellValue(), ((CellInformation)object3).getRowIndex(), ((CellInformation)object3).getColumnIndex());
                    } else {
                        cellInformation = this.mCopyData.peek();
                        this.mModel.setValueAt(cellInformation.getCellValue(), cellInformation.getRowIndex(), cellInformation.getColumnIndex());
                        object3 = (CellInformation)this.mPasteData.get(this.mPasteDataStackPos);
                        this.mModel.setValueAt(cellInformation.getCellValue(), ((CellInformation)object3).getRowIndex(), ((CellInformation)object3).getColumnIndex());
                    }
                    this.mUndoSubMenuStack.push(this.mBaseDlg.getResString(UNDO_PASTE_DATA_KEY));
                } else if (((String)object5).equals(this.mBaseDlg.getResString(REDO_CLEAR_CELLS_KEY))) {
                    ++this.mDeleteDataStackPos;
                    CellInformation cellInformation = (CellInformation)this.mDeleteData.get(this.mDeleteDataStackPos);
                    this.mModel.setValueAt("", cellInformation.getRowIndex(), cellInformation.getColumnIndex());
                    this.mUndoSubMenuStack.push(this.mBaseDlg.getResString(UNDO_CLEAR_CELLS_KEY));
                } else if (((String)object5).equals(this.mBaseDlg.getResString(REDO_INSERT_ROWS_KEY))) {
                    int n = this.mModel.getRowCount();
                    this.mModel.addRow(n);
                    this.mModel.addRow(n + 1);
                    this.mModel.addRow(n + 2);
                    this.mModel.addRow(n + 3);
                    this.mModel.fireTableDataChanged();
                    this.mDefineTable.invalidate();
                }
                if (this.mRedoSubMenuStack.size() > 1 && this.mRedoSubMenuStack.peek() != null) {
                    this.mRedoMenu.setText(this.mRedoSubMenuStack.peek());
                    this.mRedoMenu.setEnabled(true);
                } else if (this.mRedoSubMenuStack.size() > 0 && this.mRedoSubMenuStack.peek() != null) {
                    this.mRedoMenu.setText(this.mRedoSubMenuStack.peek());
                    this.mRedoMenu.setEnabled(false);
                }
                if (this.mUndoSubMenuStack.size() > 1 && this.mUndoSubMenuStack.peek() != null) {
                    this.mUndoMenu.setText(this.mUndoSubMenuStack.peek());
                    this.mUndoMenu.setEnabled(true);
                } else if (this.mUndoSubMenuStack.size() > 0 && this.mUndoSubMenuStack.peek() != null) {
                    this.mUndoMenu.setText(this.mUndoSubMenuStack.peek());
                    this.mUndoMenu.setEnabled(false);
                }
            }
            if (object.equals(this.mSortAscMenu)) {
                object5 = this.mModel.getRowData();
                String string = this.mModel.getColumnName(this.mColumnIndex);
                object3 = object5.get(string);
                ((Vector)object3).setSize(this.mRowCount - 4);
                Collections.sort(object3, new ColumnComparision(true));
                for (int i = 0; i < 4; ++i) {
                    ((Vector)object3).add((Object)"");
                }
                object5.put((String)string, object3);
                this.mModel.fireTableDataChanged();
                this.mDefineTable.invalidate();
                this.mDefineTable.setRowSelectionAllowed(true);
                this.mDefineTable.setColumnSelectionAllowed(true);
                this.mDefineTable.setColumnSelectionInterval(this.mColumnIndex, this.mColumnIndex);
                if (this.mDefineTable instanceof PlainTable) {
                    ((PlainTable)this.mDefineTable).setRowSelectionInterval(this.mRowIndex, this.mRowIndex, this.mColumnIndex);
                } else {
                    this.mDefineTable.setRowSelectionInterval(this.mRowIndex, this.mRowIndex);
                }
                this.mUndoSubMenuStack.push(this.mBaseDlg.getResString(UNDO_INSERT_ROWS_KEY));
                this.mUndoMenu.setText(this.mBaseDlg.getResString(UNDO_INSERT_ROWS_KEY));
                this.mUndoMenu.setEnabled(true);
            }
            if (object.equals(this.mSortDesMenu)) {
                object5 = this.mModel.getRowData();
                String string = this.mModel.getColumnName(this.mColumnIndex);
                object3 = object5.get(string);
                ((Vector)object3).setSize(this.mRowCount - 4);
                Collections.sort(object3, new ColumnComparision(false));
                for (int i = 0; i < 4; ++i) {
                    ((Vector)object3).add("");
                }
                object5.put((String)string, (Vector<Object>)object3);
                this.mModel.fireTableDataChanged();
                this.mDefineTable.invalidate();
                this.mDefineTable.setRowSelectionAllowed(true);
                this.mDefineTable.setColumnSelectionAllowed(true);
                this.mDefineTable.setColumnSelectionInterval(this.mColumnIndex, this.mColumnIndex);
                if (this.mDefineTable instanceof PlainTable) {
                    ((PlainTable)this.mDefineTable).setRowSelectionInterval(this.mRowIndex, this.mRowIndex, this.mColumnIndex);
                } else {
                    this.mDefineTable.setRowSelectionInterval(this.mRowIndex, this.mRowIndex);
                }
                this.mUndoSubMenuStack.push(this.mBaseDlg.getResString(UNDO_INSERT_ROWS_KEY));
                this.mUndoMenu.setText(this.mBaseDlg.getResString(UNDO_INSERT_ROWS_KEY));
                this.mUndoMenu.setEnabled(true);
            }
        }
    }

    void createContextMenu() {
        this.mCutMenu.addActionListener(this);
        this.mContextMenu.add(this.mCutMenu);
        this.mCopyMenu.addActionListener(this);
        this.mContextMenu.add(this.mCopyMenu);
        this.mPasteMenu.addActionListener(this);
        this.mContextMenu.add(this.mPasteMenu);
        this.mDeleteMenu.addActionListener(this);
        this.mContextMenu.add(this.mDeleteMenu);
        this.mContextMenu.addSeparator();
        this.mUndoMenu.setEnabled(false);
        this.mUndoMenu.addActionListener(this);
        this.mContextMenu.add(this.mUndoMenu);
        this.mRedoMenu.setEnabled(false);
        this.mRedoMenu.addActionListener(this);
        this.mContextMenu.add(this.mRedoMenu);
        this.mContextMenu.addSeparator();
        this.mSortAscMenu.addActionListener(this);
        this.mContextMenu.add(this.mSortAscMenu);
        this.mSortDesMenu.addActionListener(this);
        this.mContextMenu.add(this.mSortDesMenu);
        this.mUndoSubMenuStack.push(this.mBaseDlg.getResString(UNDO_KEY));
        this.mRedoSubMenuStack.push(this.mBaseDlg.getResString(REDO_KEY));
    }

    public boolean isPasteMenuPressed() {
        return this.mIsPasteMenuPressed;
    }

    public void setFlag(int n) {
        this.mFlag = n;
    }

    public Stack<CellInformation> getPastedData() {
        return this.mEditorData;
    }

    public JPopupMenu getContextMenu(int n, int n2) {
        this.mRowIndex = n;
        this.mColumnIndex = n2;
        int n3 = this.mModel.getColumnCount();
        this.mSortAscMenu.setText(this.mBaseDlg.getResString(SORT_BY_KEY) + this.mModel.getColumnName(this.mColumnIndex) + this.mBaseDlg.getResString(ASCENDING_KEY));
        this.mSortDesMenu.setText(this.mBaseDlg.getResString(SORT_BY_KEY) + this.mModel.getColumnName(this.mColumnIndex) + this.mBaseDlg.getResString(DESCENDING_KEY));
        this.mCutMenu.setEnabled(this.mModel != null && !this.mModel.getValueAt(n, n2).toString().equals("") || n2 == n3 - 1);
        this.mCopyMenu.setEnabled(this.mModel != null && !this.mModel.getValueAt(n, n2).toString().equals("") || n2 == n3 - 1);
        this.mDeleteMenu.setEnabled(this.mModel != null && !this.mModel.getValueAt(n, n2).toString().equals("") || n2 == n3 - 1);
        if (this.mCheck == 0) {
            this.mRowCount = this.mModel.getRowCount();
            this.mCheck = 1;
        }
        this.setDefaults();
        return this.mContextMenu;
    }

    private static boolean isClipboardContainingText(Object object) {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(object);
        return transferable != null && (transferable.isDataFlavorSupported(DataFlavor.stringFlavor) || transferable.isDataFlavorSupported(DataFlavor.getTextPlainUnicodeFlavor()));
    }

    private static void setClipboardContents(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
    }

    private void initVars() {
        this.mUndoSubMenuStack = new Stack();
        this.mRedoSubMenuStack = new Stack();
        this.mCutData = new Stack();
        this.mPasteData = new Stack();
        this.mDeleteData = new Stack();
        this.mCopyData = new Stack();
        this.mEditorData = new Stack();
        this.mUndoMenu = new JMenuItem(this.mBaseDlg.getResString(UNDO_KEY));
        Integer n = this.getMenuNemonic(UNDO_KEY);
        this.mUndoMenu.setMnemonic(n);
        this.mUndoMenu.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.mCutMenu = new JMenuItem(this.mBaseDlg.getResString(CUT_KEY));
        n = this.getMenuNemonic(CUT_KEY);
        this.mCutMenu.setMnemonic(n);
        this.mCutMenu.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.mPasteMenu = new JMenuItem(this.mBaseDlg.getResString(PASTE_KEY));
        n = this.getMenuNemonic(PASTE_KEY);
        this.mPasteMenu.setMnemonic(n);
        this.mPasteMenu.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.mDeleteMenu = new JMenuItem(this.mBaseDlg.getResString(DELETE_KEY));
        n = this.getMenuNemonic(DELETE_KEY);
        this.mDeleteMenu.setMnemonic(n);
        this.mDeleteMenu.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.mRedoMenu = new JMenuItem(this.mBaseDlg.getResString(REDO_KEY));
        n = this.getMenuNemonic(REDO_KEY);
        this.mRedoMenu.setMnemonic(n);
        this.mRedoMenu.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.mSortAscMenu = new JMenuItem();
        n = this.getMenuNemonic(ASCENDING_KEY);
        this.mSortAscMenu.setMnemonic(n);
        this.mSortDesMenu = new JMenuItem();
        n = this.getMenuNemonic(DESCENDING_KEY);
        this.mSortDesMenu.setMnemonic(n);
        this.mCopyMenu = new JMenuItem(this.mBaseDlg.getResString(COPY_KEY));
        n = this.getMenuNemonic(COPY_KEY);
        this.mCopyMenu.setMnemonic(n);
        this.mCopyMenu.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.mContextMenu = new JPopupMenu();
        this.mCheck = 0;
    }

    private Integer getMenuNemonic(String string) {
        ResourceBundle resourceBundle = ResUtil.getBundle(ComplexSamplesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        return (Integer)ResUtil.getObject(string + "_KEY", resourceBundle);
    }

    private void setDefaults() {
        if (this.mFlag == 0) {
            this.setEnabledSubMenu(true);
            this.setEnabledSortByMenu(true);
        } else if (this.mFlag == 1 || this.mFlag == 2) {
            this.setEnabledSubMenu(false);
            this.setEnabledSortByMenu(true);
        }
        if (this.mFlag == 2) {
            this.setEnabledSortByMenu(false);
            this.mSortAscMenu.setText(this.mBaseDlg.getResString(SORT_BY_KEY) + this.mBaseDlg.getResString("IDS_PFA_PERCENTAGE_S") + this.mBaseDlg.getResString(ASCENDING_KEY));
            this.mSortDesMenu.setText(this.mBaseDlg.getResString(SORT_BY_KEY) + this.mBaseDlg.getResString("IDS_PFA_PERCENTAGE_S") + this.mBaseDlg.getResString(DESCENDING_KEY));
        }
    }

    private void setEnabledSubMenu(boolean bl) {
        this.mCopyMenu.setEnabled(bl);
        this.mCutMenu.setEnabled(bl);
        this.mDeleteMenu.setEnabled(bl);
        this.mPasteMenu.setEnabled(bl);
    }

    private void setEnabledSortByMenu(boolean bl) {
        this.mSortAscMenu.setEnabled(bl);
        this.mSortDesMenu.setEnabled(bl);
    }
}

