/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.uitools.util.CharacterUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ComplexSamplesUtils {
    public static ArrayList<String> getMissingValues(ISpssVariable iSpssVariable) {
        SPSS_Format sPSS_Format = iSpssVariable.getFormat();
        IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
        int n = 0;
        Object[] objectArray = new String[iValueLabelMap.size()];
        boolean bl = sPSS_Format.getFormatType().isStringFormat();
        Set set = iValueLabelMap.getValueLabelEntries();
        for (Map.Entry entry : set) {
            OBS oBS = (OBS)entry.getKey();
            String string = (String)entry.getValue();
            if (oBS.isEmpty()) continue;
            String string2 = bl ? CharacterUtil.rightTrim((String)oBS.getString()) : CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)sPSS_Format);
            objectArray[n] = string2 + " " + string;
            ++n;
        }
        Arrays.sort(objectArray);
        ArrayList arrayList = new ArrayList();
        arrayList.add("");
        arrayList.addAll(Arrays.asList(objectArray));
        if (arrayList.size() > 1) {
            arrayList.remove(0);
        }
        return arrayList;
    }

    public static Map<String, String> getMissingValuesMap(ISpssVariable iSpssVariable) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        SPSS_Format sPSS_Format = iSpssVariable.getFormat();
        IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
        int n = 0;
        boolean bl = sPSS_Format.getFormatType().isStringFormat();
        Set set = iValueLabelMap.getValueLabelEntries();
        for (Map.Entry entry : set) {
            OBS oBS = (OBS)entry.getKey();
            String string = (String)entry.getValue();
            if (oBS.isEmpty()) continue;
            String string2 = bl ? CharacterUtil.rightTrim((String)oBS.getString()) : CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)sPSS_Format);
            hashMap.put(string, string2);
            ++n;
        }
        return hashMap;
    }

    public static void validateTableContents(DialogDataModel dialogDataModel, String string, String string2, String string3) {
        HashMap<Integer, Object> hashMap = dialogDataModel.getMap(string3);
        HashMap<Integer, Object> hashMap2 = dialogDataModel.getMap(string);
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray(string2);
        if (iSpssVariableArray != null && hashMap2 != null) {
            if (iSpssVariableArray.length > 0) {
                Iterator<Integer> iterator = hashMap2.keySet().iterator();
                while (iterator.hasNext()) {
                    boolean bl = false;
                    int n = iterator.next();
                    for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                        if (!hashMap2.get(n).equals(iSpssVariable.getName())) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    iterator.remove();
                    hashMap.remove(n);
                }
                dialogDataModel.putMap(string, hashMap2);
                dialogDataModel.putMap(string3, hashMap);
            }
        } else if (hashMap2 != null) {
            dialogDataModel.putMap(string, null);
            dialogDataModel.putMap(string3, null);
        }
    }

    public static ArrayList<ISpssVariable> getValidVariables(DialogDataModel dialogDataModel, String string, String string2) {
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray(string);
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        if (iSpssVariableArray != null && iSpssVariableArray.length > 0) {
            ISpssVariable[] iSpssVariableArray2 = dialogDataModel.getVarArray(string2);
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                boolean bl = false;
                for (ISpssVariable iSpssVariable2 : iSpssVariableArray2) {
                    if (!iSpssVariable2.getId().equals((Object)iSpssVariable.getId())) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                arrayList.add(iSpssVariable);
            }
        }
        return arrayList;
    }
}

