/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.UtilityProxy;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.IVarFilter;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseGatingDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.common.ErrorCodeType;
import com.spss.java_client.ui.dialogs.complex_samples.common.Importer;
import com.spss.java_client.ui.dialogs.complex_samples.common.Specification;
import com.spss.java_client.ui.dialogs.complex_samples.common.StageInformation;
import com.spss.java_client.ui.dialogs.complex_samples.res.ComplexSamplesResBundle;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public abstract class ComplexSamplesPlan
extends BaseGatingDialog
implements ActionListener,
FocusListener,
ItemListener,
DocumentListener,
ListSelectionListener {
    private static ComplexSamplesPlan mComplexSamplePlan;
    static final String PLAN_PANEL = "IDS_CS_PLAN_PANEL";
    static final String PLAN_FILE_LABEL = "IDS_CS_PLAN_FILE_LABEL";
    static final String PLAN_FILE_TEXT = "IDS_PLAN_FILE_TEXT";
    static final String PLAN_BROWSE_BUTTON = "IDS_CS_PLAN_BROWSE_BUTTON";
    static final String PLAN_MULTILINE_TEXT = "IDS_CS_PLAN_TEXT";
    static final String JP_PANEL = "IDS_CS_JOINT_PROB_PANEL";
    static final String JP_MULTILINE_TEXT = "IDS_CS_JOINT_PROB_TEXT";
    static final String JP_USE_DEF_FILE_RADIO = "IDS_CS_USE_DEF_FILE_RADIO";
    static final String JP_USE_DEF_FILE_TEXT = "IDS_CS_USE_DEF_FILE_TEXT";
    static final String JP_USE_DEFAULT_FILE_TEXTFIELD = "IDS_JP_USE_DEFAULT_FILE_TEXTFIELD";
    static final String JP_OPEN_DATASET_RADIO = "IDS_CS_OPEN_DATASET_RADIO";
    static final String JP_OPEN_DATASET_LIST = "IDS_JP_OPEN_DATASET_LIST";
    static final String JP_CUSTOM_FILE_RADIO = "IDS_CS_CUSTOM_FILE_RADIO";
    static final String JP_FILE_LABEL = "IDS_CS_CUSTOM_FILE_LABEL";
    static final String JP_FILE_TEXT = "IDS_JP_FILE_TEXT";
    static final String JP_BROWSE_BUTTON = "IDS_CS_CUSTOM_BROWSE_BUTTON";
    static final int ZERO = 0;
    protected static Vector<String> mPlanElements;
    private static String mWeightElements;
    private static String mIncludePopulateElments;
    private static ArrayList<String> mEqualWORArrayElements;
    private static String sPlanFileName;
    private static String mUnequalSyntaxLine;
    private static final int FILE_FIELD_LENGTH = 22;
    private static final int LIST_WIDTH = 150;
    private static final int LIST_HEIGHT = 130;
    private JLabel mPlanFileLabel;
    private FileTextField mPlanFileText;
    private JButton mPlanBrowseButton;
    private JTextArea mPlanMultilineTextArea;
    private JTextArea mJPMultilineTextArea;
    private JRadioButton mUseDefFileRadio;
    private FileTextField mUseDefFileText;
    private JRadioButton mOpenDatasetRadio;
    private SerializableList mOpenDatasetList;
    private JScrollPane mOpenDatasetScroll;
    private JRadioButton mCustomFileRadio;
    private SpssButtonGroup mJointProbButtonGroup;
    private JLabel mCustomFileLabel;
    private FileTextField mCustomFileText;
    private JButton mCustomBrowseButton;
    private boolean mEstimationType = false;
    private boolean mDatasetFileOnRemoteHost = false;
    private boolean mPlanFileOnRemoteHost = false;

    public ComplexSamplesPlan(JFrame jFrame) {
        super(jFrame, ComplexSamplesResBundle.getDefaultResourceBundleName(), ComplexSamplesResBundle.getImageFolder());
        mComplexSamplePlan = this;
        this.setLocationRelativeTo(jFrame);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_csan_gating_plan";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mCustomBrowseButton) {
            this.mDatasetFileOnRemoteHost = this.isSelectedFileOnRemoteHost("IDS_CS_BROWSE_TYPE_FILE_TITLE", "IDS_CS_BROWSE_TYPE_DESC_FILTER", "IDS_CS_BROWSE_TYPE_DESC_FILE_EXTENSION", (JTextField)((Object)this.mCustomFileText));
            this.mCustomFileText.setCaretPosition(0);
        } else if (object == this.mPlanBrowseButton) {
            this.mPlanFileOnRemoteHost = this.isSelectedFileOnRemoteHost("IDS_CS_PLAN_TYPE_FILE_TITLE", "IDS_CS_PLAN_TYPE_DESC_FILTER", "csplan,csaplan", (JTextField)((Object)this.mPlanFileText));
            this.setDefFileText();
            this.mPlanFileText.setCaretPosition(0);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.mUseDefFileText.setText(this.mUseDefFileText.getText());
        super.validate();
        this.mUseDefFileText.setCaretPosition(0);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mPlanFileText) {
            this.setDefFileText();
        }
        if (focusEvent.getSource() == this.mUseDefFileText) {
            this.mUseDefFileText.setCaretPosition(0);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object == this.mPlanFileText || object == this.mCustomFileText) {
            ((FileTextField)object).setSelectionStart(0);
            ((JTextField)object).setSelectionEnd(((JTextField)object).getText().length());
        }
        if (object == this.mPlanFileText) {
            this.mUseDefFileText.setCaretPosition(0);
            this.mCustomFileText.setCaretPosition(0);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mUseDefFileRadio) {
            this.setJointProbEnabled(false, false);
            this.enableOpenDataSetScroll(false);
        } else if (object == this.mOpenDatasetRadio) {
            this.setJointProbEnabled(true, false);
            this.enableOpenDataSetScroll(true);
        }
        if (object == this.mCustomFileRadio) {
            this.setJointProbEnabled(false, true);
            this.mCustomFileText.setCaretPosition(0);
            this.enableOpenDataSetScroll(false);
        }
        this.setContinueEnabled();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setContinueEnabled();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setContinueEnabled();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setContinueEnabled();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setContinueEnabled();
    }

    @Override
    public boolean continuePressed() {
        if (!this.canClickContinue()) {
            return false;
        }
        this.saveDialogState();
        ProcedureDlgMgr.getMgr().savePersistentState(this.getIActionKey(), this.getDialogDataModel());
        ProcedureDlgMgr.getMgr().addRecallItem(this.getTitle(), this.getIActionKey());
        return true;
    }

    public static String getJointProbalityValue() {
        return mUnequalSyntaxLine == null || mUnequalSyntaxLine.length() == 0 ? null : mUnequalSyntaxLine;
    }

    public static String getSelectedPlanFileName() {
        return sPlanFileName;
    }

    public static void setSelectedPlanFileName(String string) {
        sPlanFileName = string;
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.putBoolean("IDS_DATASET_REMOTE_FLAG", this.mDatasetFileOnRemoteHost);
        dialogDataModel.putBoolean("IDS_PLANFILE_REMOTE_FLAG", this.mPlanFileOnRemoteHost);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.pack();
    }

    private void initVars() {
        mPlanElements = new Vector();
        mWeightElements = "";
        mIncludePopulateElments = "";
        mEqualWORArrayElements = new ArrayList();
        this.mPlanFileLabel = DialogUtil.createLabel(this, PLAN_FILE_LABEL);
        this.mPlanFileText = new FileTextField();
        this.mPlanFileText.setAction(new TextFieldAction(this, PLAN_FILE_TEXT));
        this.mPlanFileLabel.setLabelFor((Component)((Object)this.mPlanFileText));
        this.mPlanFileText.setColumns(22);
        this.mPlanFileText.addFocusListener(this);
        this.mPlanFileText.getDocument().addDocumentListener(this);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, PLAN_BROWSE_BUTTON);
        this.mPlanBrowseButton = new JButton(toggleButtonAction);
        this.mPlanBrowseButton.addActionListener(this);
        this.mPlanMultilineTextArea = new JTextArea();
        this.mPlanMultilineTextArea.setFocusable(false);
        this.mPlanMultilineTextArea.setText(this.getResString(PLAN_MULTILINE_TEXT));
        this.mPlanMultilineTextArea.setWrapStyleWord(true);
        this.mPlanMultilineTextArea.setLineWrap(true);
        this.mJPMultilineTextArea = new JTextArea();
        this.mJPMultilineTextArea.setFocusable(false);
        this.mJPMultilineTextArea.setText(this.getResString(JP_MULTILINE_TEXT));
        this.mJPMultilineTextArea.setWrapStyleWord(true);
        this.mJPMultilineTextArea.setLineWrap(true);
        toggleButtonAction = new ToggleButtonAction(this, JP_USE_DEF_FILE_RADIO);
        this.mUseDefFileRadio = new JRadioButton(toggleButtonAction);
        this.mUseDefFileRadio.addItemListener(this);
        this.mUseDefFileText = new FileTextField();
        this.mUseDefFileText.setAction(new TextFieldAction(this, JP_USE_DEFAULT_FILE_TEXTFIELD));
        this.mUseDefFileText.setColumns(22);
        this.mUseDefFileText.addFocusListener(this);
        toggleButtonAction = new ToggleButtonAction(this, JP_OPEN_DATASET_RADIO);
        this.mOpenDatasetRadio = new JRadioButton(toggleButtonAction);
        this.mOpenDatasetRadio.addItemListener(this);
        this.mOpenDatasetList = new SerializableList(JP_OPEN_DATASET_LIST);
        this.mOpenDatasetScroll = new JScrollPane(this.mOpenDatasetList);
        this.mOpenDatasetScroll.setPreferredSize(new Dimension(150, 130));
        this.mOpenDatasetList.addListSelectionListener(this);
        toggleButtonAction = new ToggleButtonAction(this, JP_CUSTOM_FILE_RADIO);
        this.mCustomFileRadio = new JRadioButton(toggleButtonAction);
        this.mCustomFileRadio.addItemListener(this);
        this.mCustomFileLabel = DialogUtil.createLabel(this, JP_FILE_LABEL);
        this.mCustomFileText = new FileTextField();
        this.mCustomFileText.setAction(new TextFieldAction(this, JP_FILE_TEXT));
        this.mCustomFileText.setColumns(22);
        this.mCustomFileLabel.setLabelFor((Component)((Object)this.mCustomFileText));
        this.mCustomFileText.addFocusListener(this);
        this.mCustomFileText.getDocument().addDocumentListener(this);
        toggleButtonAction = new ToggleButtonAction(this, JP_BROWSE_BUTTON);
        this.mCustomBrowseButton = new JButton(toggleButtonAction);
        this.mCustomBrowseButton.addActionListener(this);
    }

    private void setDefaults() {
        String[] stringArray;
        this.mUseDefFileRadio.setSelected(true);
        this.mUseDefFileText.setOpaque(false);
        this.mUseDefFileText.setEditable(false);
        this.mUseDefFileText.setBorder(BorderFactory.createEmptyBorder());
        this.mUseDefFileText.setText(this.getResString(JP_USE_DEF_FILE_TEXT));
        this.mUseDefFileText.setCaretPosition(0);
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (String string : stringArray = this.getDataSetList()) {
            defaultListModel.addElement(string);
        }
        this.mOpenDatasetList.setModel(defaultListModel);
        this.setJointProbEnabled(false, false);
        if (sPlanFileName != null) {
            this.mPlanFileText.setText(sPlanFileName);
        }
        if (this.mUseDefFileText.getText().trim().length() > 0) {
            this.mUseDefFileText.setCaretPosition(0);
        }
        if (this.mCustomFileText.getText() != null && this.mCustomFileText.getText().trim().length() > 0) {
            this.mCustomFileText.setCaretPosition(0);
        }
        if (this.mPlanFileText.getText() != null && this.mPlanFileText.getText().trim().length() > 0) {
            this.mPlanFileText.setCaretPosition(0);
        }
    }

    private JPanel setupPlanPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString(PLAN_PANEL)));
        jPanel.setLayout(new GridBagLayout());
        this.mPlanMultilineTextArea.setBackground(jPanel.getBackground());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, DialogUtil.getComponentGroupGap() * 2, insets.bottom, insets.right);
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.setupFilePanel(this.mPlanFileLabel, (JTextField)((Object)this.mPlanFileText), this.mPlanBrowseButton), gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        insets2.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mPlanMultilineTextArea, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupJointProbPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString(JP_PANEL)));
        jPanel.setLayout(new GridBagLayout());
        this.mJPMultilineTextArea.setBackground(jPanel.getBackground());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, DialogUtil.getComponentGroupGap(), insets.bottom, insets.right);
        int n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mJPMultilineTextArea, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(insets.top, insets.left, insets.bottom, 0);
        DialogUtil.addUsingGBL(jPanel, this.mUseDefFileRadio, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n2 = UIToolDialogUtil.getStandardDialogInsets().left;
        insets2.set(insets.top + 4, n2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mUseDefFileText), gridBagConstraints, 1, 1, 1, 1, n, insets2);
        insets2.set(insets.top, insets.left, insets.bottom, 0);
        DialogUtil.addUsingGBL(jPanel, this.mOpenDatasetRadio, gridBagConstraints, 0, 2, 2, 1, n, insets2);
        insets2.set(insets.top, DialogUtil.getComponentGroupGap() * 5, insets.bottom, insets.right);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mOpenDatasetScroll, gridBagConstraints, 0, 3, 2, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets2.set(insets.top, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mCustomFileRadio, gridBagConstraints, 0, 4, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.setupFilePanel(this.mCustomFileLabel, (JTextField)((Object)this.mCustomFileText), this.mCustomBrowseButton), gridBagConstraints, 0, 5, 2, 1, n, insets);
        this.mJointProbButtonGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupFilePanel(JLabel jLabel, JTextField jTextField, JButton jButton) {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, DialogUtil.getComponentGroupGap() * 2, insets.bottom, insets.right);
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jTextField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.setupPlanPanel(), gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupJointProbPanel(), gridBagConstraints, 0, 1, 1, 1, n, null);
    }

    private boolean isSelectedFileOnRemoteHost(String string, String string2, String string3, JTextField jTextField) {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        remoteFileChooser.setDialogTitle(this.getResString(string));
        String string4 = this.getResString(string3);
        if (string4 == null) {
            string4 = string3;
        }
        RefFileFilter refFileFilter = new RefFileFilter(this.getResString(string2), string4, ",");
        remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(true);
        remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.setFileSelectionMode(0);
        int n = remoteFileChooser.showOpenDialog(this.getParent());
        if (n == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            String string5 = remoteFileChooser.getSelectedFilePath();
            jTextField.setText(string5);
        }
        return remoteFileChooser.isServerFileSystem();
    }

    private String[] getDataSetList() {
        SpssFrame[] spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments();
        String[] stringArray = new String[spssFrameArray.length];
        int n = 0;
        for (SpssFrame spssFrame : spssFrameArray) {
            if (!(spssFrame instanceof DataFrame)) continue;
            DataFrame dataFrame = (DataFrame)spssFrame;
            String string = dataFrame.getCoreDocument().getDocName();
            String string2 = dataFrame.getDatasetName();
            stringArray[n] = string + " [" + string2 + "]";
            ++n;
        }
        return stringArray;
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mPlanFileText);
        vector.add(this.mPlanBrowseButton);
        vector.add(this.mJointProbButtonGroup);
        vector.add(this.mOpenDatasetList);
        vector.add(this.mCustomFileText);
        vector.add(this.mCustomBrowseButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void setJointProbEnabled(boolean bl, boolean bl2) {
        int n;
        this.mContinueAction.setEnabled(false);
        this.mOpenDatasetList.setEnabled(bl);
        if (this.mOpenDatasetList.getModel().getSize() > 0 && (n = this.mOpenDatasetList.getSelectedIndex()) >= 0) {
            this.mOpenDatasetList.setSelectedIndex(n);
            this.mContinueAction.setEnabled(true);
        }
        this.mCustomFileLabel.setEnabled(bl2);
        this.mCustomFileText.setEnabled(bl2);
        this.mCustomFileText.setOpaque(bl2);
        this.mCustomBrowseButton.setEnabled(bl2);
    }

    private void setContinueEnabled() {
        if (this.mPlanFileText.getText() != null && this.mPlanFileText.getDocument().getLength() > 0) {
            if (this.mOpenDatasetRadio.isSelected()) {
                if (this.mOpenDatasetList.getSelectedIndex() > -1) {
                    this.mContinueAction.setEnabled(true);
                } else {
                    this.mContinueAction.setEnabled(false);
                }
            } else if (this.mCustomFileRadio.isSelected()) {
                if (this.mCustomFileText.getText() != null && this.mCustomFileText.getDocument().getLength() > 0) {
                    this.mContinueAction.setEnabled(true);
                } else {
                    this.mContinueAction.setEnabled(false);
                }
            } else {
                this.mContinueAction.setEnabled(true);
            }
        } else {
            this.mContinueAction.setEnabled(false);
        }
    }

    private void setDefFileText() {
        String string = this.mPlanFileText.getText().trim();
        if (string.equals("")) {
            this.mUseDefFileText.setText(this.getResString(JP_USE_DEF_FILE_TEXT));
        } else if (string.equals("")) {
            this.mUseDefFileText.setText(this.getResString(JP_USE_DEF_FILE_TEXT));
        } else {
            if (string.contains(".")) {
                string = new StringBuffer(string).substring(0, string.indexOf("."));
            }
            StringBuffer stringBuffer = new StringBuffer("(");
            stringBuffer.append(string);
            stringBuffer.append(".sav");
            stringBuffer.append(")");
            string = stringBuffer.toString();
            this.mUseDefFileText.setText(string);
            this.mUseDefFileText.setCaretPosition(0);
        }
    }

    private boolean canClickContinue() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DialogUtil.readTempDirLocationPrefs());
        if (stringBuffer.length() > 0 && !Character.toString(stringBuffer.charAt(stringBuffer.length() - 1)).equals(System.getProperties().getProperty("file.separator"))) {
            stringBuffer.append(System.getProperties().getProperty("file.separator"));
        }
        stringBuffer.append("spss_temp");
        String string = stringBuffer.toString();
        new File(string).deleteOnExit();
        String string2 = this.mPlanFileText.getText().trim();
        if (string2.length() > 0) {
            ErrorCodeType errorCodeType;
            String string3 = String.format(this.getResString("ERR_PFA_PLAN_FILE_NOT_FOUND"), string2);
            UtilityProxy utilityProxy = UtilityProxy.getUtilProxy();
            if (!utilityProxy.copyServerFile(string2, string, true)) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string3, VersionInfo.getAppVersionString());
                return false;
            }
            Specification specification = new Specification();
            Importer importer = new Importer(specification);
            try {
                errorCodeType = importer.getAnalysisPlan(string);
            }
            catch (Exception exception) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_CS_PLAN_NOT_VALID_PLAN"), VersionInfo.getAppVersionString());
                this.mPlanFileText.requestFocus();
                this.mPlanFileText.selectAll();
                return false;
            }
            if (errorCodeType == ErrorCodeType.CSXML_ERROR_NONE) {
                if (specification.isAnalysisMode()) {
                    String string4;
                    Object object;
                    StageInformation stageInformation;
                    mPlanElements.clear();
                    sPlanFileName = "";
                    sPlanFileName = string2;
                    mWeightElements = specification.getWeight();
                    long l = specification.getStageListSize();
                    for (long i = 1L; i <= l; ++i) {
                        StageInformation.KeyType keyType;
                        long l2;
                        stageInformation = specification.getStage(i);
                        mEqualWORArrayElements.add(stageInformation.getPopulationSize());
                        mEqualWORArrayElements.add(stageInformation.getInclusionProbability());
                        long l3 = stageInformation.getStrataListSize();
                        for (l2 = 0L; l2 < l3; ++l2) {
                            mPlanElements.addElement(stageInformation.getStrataVariable(l2));
                        }
                        l2 = stageInformation.getClusterListSize();
                        for (long j = 0L; j < l2; ++j) {
                            mPlanElements.addElement(stageInformation.getClusterVariable(j));
                        }
                        if (stageInformation.getParameterVariable().trim().length() > 0) {
                            mIncludePopulateElments = stageInformation.getParameterVariable();
                        }
                        if ((keyType = stageInformation.getKey()).compareTo(StageInformation.KeyType.UNEQUAL_WOR) != 0) continue;
                        this.mEstimationType = true;
                    }
                    int n = mPlanElements.size();
                    LocallyUniqueId locallyUniqueId = ((DataFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC)).getDatasetId();
                    stageInformation = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
                    int n2 = stageInformation.columnCount();
                    String string5 = "";
                    boolean bl = true;
                    for (int i = 0; i < n; ++i) {
                        String string6 = mPlanElements.elementAt(i);
                        if (string6.length() <= 0 || stageInformation.findVarIndex(string6) >= 0) continue;
                        if (!bl) {
                            string5 = string5 + ", " + string6;
                            continue;
                        }
                        string5 = string6;
                        bl = false;
                    }
                    if (mWeightElements.length() > 0 && stageInformation.findVarIndex(mWeightElements) < 0) {
                        if (!bl) {
                            string5 = string5 + ", " + mWeightElements;
                        } else {
                            string5 = mWeightElements;
                            bl = false;
                        }
                    }
                    if (mIncludePopulateElments.length() > 0 && stageInformation.findVarIndex(mIncludePopulateElments) < 0) {
                        string5 = !bl ? string5 + ", " + mIncludePopulateElments : mIncludePopulateElments;
                    }
                    if (string5.length() > 0) {
                        String string7 = String.format(this.getResString("ERR_CS_PLAN_VARIABLES_DO_NOT_MATCH"), string5);
                        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string7, VersionInfo.getAppVersionString());
                        this.mPlanFileText.requestFocus();
                        this.mPlanFileText.selectAll();
                        return false;
                    }
                    if (this.mEstimationType) {
                        UtilityProxy utilityProxy2;
                        if (this.mUseDefFileRadio.isSelected()) {
                            String string8 = this.mUseDefFileText.getText();
                            if (string8.length() > 0) {
                                object = new StringBuffer();
                                ((StringBuffer)object).append(DialogUtil.readTempDirLocationPrefs());
                                ((StringBuffer)object).append(System.getProperties().getProperty("file.separator"));
                                ((StringBuffer)object).append("temp_use_def");
                                string4 = ((StringBuffer)object).toString();
                                new File(string4).deleteOnExit();
                                string8 = string8.substring(1, string8.length() - 1);
                                utilityProxy2 = UtilityProxy.getUtilProxy();
                                if (!utilityProxy2.copyServerFile(string8, string4, true)) {
                                    String string9 = this.getResString("ERR_CS_PLAN_JOINT_PROBABILITIES_FILE_NOT_FOUND");
                                    string9 = String.format(string9, this.mUseDefFileText.getText());
                                    string9 = String.format(string9, "(" + this.mUseDefFileText.getText() + ")");
                                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string9, VersionInfo.getAppVersionString());
                                    return false;
                                }
                            }
                        } else if (this.mCustomFileRadio.isSelected()) {
                            String string10 = this.mCustomFileText.getText().trim();
                            if (string2.length() > 0) {
                                object = new StringBuffer();
                                ((StringBuffer)object).append(DialogUtil.readTempDirLocationPrefs());
                                ((StringBuffer)object).append(System.getProperties().getProperty("file.separator"));
                                ((StringBuffer)object).append("temp_custom");
                                string4 = ((StringBuffer)object).toString();
                                new File(string4).deleteOnExit();
                                utilityProxy2 = UtilityProxy.getUtilProxy();
                                if (!utilityProxy2.copyServerFile(string10, string4, true)) {
                                    String string11 = this.getResString("ERR_CS_PLAN_JOINT_PROBABILITIES_FILE_NOT_FOUND");
                                    string11 = String.format(string11, "(" + this.mCustomFileText.getText() + ")");
                                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string11, VersionInfo.getAppVersionString());
                                    return false;
                                }
                            }
                        }
                    } else if (!this.mUseDefFileRadio.isSelected()) {
                        SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), this.getResString("ERR_CS_PLAN_WR_PLAN_JOINT_PROBABILITIES_FILE_IGNORE"), VersionInfo.getAppVersionString());
                        this.mUseDefFileRadio.setSelected(true);
                    }
                    for (int i = 0; i < n2; ++i) {
                        object = stageInformation.getVariable(i);
                        if (!object.getName().equals(mWeightElements) || object.getType() == 0) continue;
                        string4 = this.getResString("ERR_CS_PLAN_VARIABLES_REQUIRED_NUMERIC");
                        string4 = String.format(string4, mWeightElements);
                        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string4, VersionInfo.getAppVersionString());
                        this.mPlanFileText.requestFocus();
                        this.mPlanFileText.selectAll();
                        return false;
                    }
                    if (this.mEstimationType) {
                        StringBuffer stringBuffer2 = new StringBuffer();
                        stringBuffer2.append(SyntaxUtil.getSubCommand("/JOINTPROB FILE="));
                        if (this.mUseDefFileRadio.isSelected()) {
                            stringBuffer2.delete(0, stringBuffer2.length());
                        } else if (this.mOpenDatasetRadio.isSelected()) {
                            object = (String)this.mOpenDatasetList.getSelectedValue();
                            int n3 = ((String)object).indexOf(91);
                            int n4 = ((String)object).indexOf(93);
                            stringBuffer2.append(CharacterUtil.smartQuote((String)((String)object).substring(n3 + 1, n4)));
                        } else if (this.mCustomFileRadio.isSelected() && this.mCustomFileText.getText().trim().length() > 0) {
                            stringBuffer2.append(CharacterUtil.smartQuote((String)this.mCustomFileText.getText().trim()));
                        } else if (this.mCustomFileRadio.isSelected() && this.mCustomFileText.getText().trim().length() == 0) {
                            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_CS_PLAN_JOINT_PROBABILITIES_FILE_SPECIFY"), VersionInfo.getAppVersionString());
                            return false;
                        }
                        if (stringBuffer2.length() > 0) {
                            stringBuffer2.append("\n");
                        }
                        mUnequalSyntaxLine = stringBuffer2.toString();
                    }
                }
            } else if (errorCodeType == ErrorCodeType.CSXML_PARSER_ERROR) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_CS_PLAN_NOT_VALID_PLAN"), VersionInfo.getAppVersionString());
                this.mPlanFileText.requestFocus();
                this.mPlanFileText.selectAll();
                return false;
            }
        }
        return true;
    }

    private void enableOpenDataSetScroll(boolean bl) {
        this.mOpenDatasetScroll.getVerticalScrollBar().setEnabled(bl);
        this.mOpenDatasetScroll.getHorizontalScrollBar().setEnabled(bl);
        this.mOpenDatasetScroll.setWheelScrollingEnabled(bl);
    }

    public static class varTargetMoveHandler
    implements IVarMoveHandler {
        private String errorMessage;
        private Vector<String> strErrorStrings;
        private Vector<VariableList> vectBlockTargets;
        private boolean differentErrorMsgFlag;

        public varTargetMoveHandler(String string) {
            this.errorMessage = string;
        }

        public varTargetMoveHandler(String string, Vector<VariableList> vector) {
            this.errorMessage = string;
            this.vectBlockTargets = vector;
        }

        public varTargetMoveHandler(Vector<VariableList> vector, Vector<String> vector2) {
            this.strErrorStrings = vector2;
            this.vectBlockTargets = vector;
            this.differentErrorMsgFlag = true;
        }

        @Override
        public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                String string = iSpssVariable.getName();
                if (!this.inPlanElements(string)) continue;
                if (this.vectBlockTargets != null && !this.vectBlockTargets.contains(variableList)) {
                    return true;
                }
                if (this.differentErrorMsgFlag && this.vectBlockTargets != null) {
                    this.errorMessage = this.strErrorStrings.elementAt(this.vectBlockTargets.indexOf(variableList));
                }
                Object object = null;
                object = OSInfo.getOSType() == OSInfo.OSType.MAC ? (Window)mComplexSamplePlan.getParent() : mComplexSamplePlan;
                SpssAlertOptionPane.showWarningMessageDialog((Window)object, this.errorMessage, VersionInfo.getAppVersionString());
                return false;
            }
            return true;
        }

        boolean inPlanElements(String string) {
            for (String string2 : mPlanElements) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }
    }

    public static class sourceCsCoxRegFilter
    implements IVarFilter {
        @Override
        public boolean canIncludeVariable(ISpssVariable iSpssVariable) {
            if (iSpssVariable.getName().equalsIgnoreCase("T_")) {
                return false;
            }
            for (String string : mEqualWORArrayElements) {
                if (!iSpssVariable.getName().equals(string)) continue;
                return false;
            }
            if (iSpssVariable.getName().equals(mWeightElements)) {
                return false;
            }
            return !iSpssVariable.getName().equals(mIncludePopulateElments);
        }
    }

    public static class sourceListWtFilter
    implements IVarFilter {
        @Override
        public boolean canIncludeVariable(ISpssVariable iSpssVariable) {
            for (String string : mEqualWORArrayElements) {
                if (!iSpssVariable.getName().equals(string)) continue;
                return false;
            }
            if (iSpssVariable.getName().equals(mWeightElements)) {
                return false;
            }
            return !iSpssVariable.getName().equals(mIncludePopulateElments);
        }
    }
}

