/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.AbstractDropListener;
import com.spss.java_client.ui.controls.drag_drop.AbstractTableDropListener;
import com.spss.java_client.ui.controls.drag_drop.ListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PlainTableDragAdapter;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesGLMComboBoxModel;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesUtils;
import com.spss.java_client.ui.dialogs.complex_samples.logistic_regression.LogisticRegressionDlg;
import com.spss.java_client.ui.dialogs.complex_samples.ordinal_regression.OrdinalRegressionDlg;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;

public class ComplexSamplesOddsRatios
extends BaseSubDialog
implements FocusListener,
ListSelectionListener,
KeyListener {
    public static final String FACTOR_TABLE_ID_KEY = "FACTOR_TABLE_ID";
    public static final String COVARIATE_TABLE_ID_KEY = "COVARIATE_TABLE_ID";
    public static final String FACTOR_TABLE_IDENTIFIER_KEY = "FactorTableData";
    public static final String COVARIATE_TABLE_IDENTIFIER_KEY = "CovariateTableData";
    public static final String FACTOR_LIST_IDENTIFIER_KEY = "OddsRatioFactor";
    public static final String COVARIATE_LIST_IDENTIFIER_KEY = "OddsRatioCovariate";
    private PlainTable mFactorsTable;
    private DefaultTableModel mFactorsModel;
    private PlainTable mCovariateTable;
    private DefaultTableModel mCovariateModel;
    private GridBagConstraints mConstraints;
    private Insets mInsets;
    private TargetVariableList mFactorsList;
    private ComponentsArrowButton mFactorsArrowButton;
    private TargetVariableList mCovariatesList;
    private ComponentsArrowButton mCovariatesArrowButton;
    private HashMap<String, ComplexSamplesGLMComboBoxModel> mMapOfModels;
    private JTextArea mMessageLabel;
    private HashMap<Integer, Object> mFactorsLocallyUniqueIdMap;
    private HashMap<Integer, Object> mCovariatesLocallyUniqueIdMap;
    private JScrollPane mFactorsScrollPane;
    private JScrollPane mCovariatesScrollPane;
    private Border mDefaultScrollPaneBorder;
    private boolean mShowLabel;

    public ComplexSamplesOddsRatios(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        if (this.getParent() instanceof OrdinalRegressionDlg) {
            this.mShowLabel = ((OrdinalRegressionDlg)baseProcedureDialog).getMainPanel().mSrcVarList.getShowVarLabels();
        } else if (this.getParent() instanceof LogisticRegressionDlg) {
            this.mShowLabel = ((LogisticRegressionDlg)baseProcedureDialog).getMainPanel().mSrcVarList.getShowVarLabels();
        }
        this.mFactorsList.setShowVarLabels(this.mShowLabel, false);
        this.mCovariatesList.setShowVarLabels(this.mShowLabel, false);
    }

    @Override
    public String getDialogHelpID() {
        if (this.getParent() instanceof LogisticRegressionDlg) {
            return "idh_idd_cslr_ratios";
        }
        if (this.getParent() instanceof OrdinalRegressionDlg) {
            return "idh_idd_csord_ratios";
        }
        return "idh_idd_gee_statistics";
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        block2: {
            block3: {
                int n = keyEvent.getKeyCode();
                if (n != 127) break block2;
                if (!this.mFactorsTable.hasFocus()) break block3;
                int[] nArray = this.mFactorsTable.getSelectedRows();
                keyEvent.consume();
                for (int i = 0; i < nArray.length; ++i) {
                    this.mFactorsModel.removeRow(nArray[i] - i);
                }
                break block2;
            }
            if (!this.mCovariateTable.hasFocus()) break block2;
            int[] nArray = this.mCovariateTable.getSelectedRows();
            keyEvent.consume();
            for (int i = 0; i < nArray.length; ++i) {
                this.mCovariateModel.removeRow(nArray[i] - i);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.mFactorsTable.hasFocus() && this.mFactorsModel.getRowCount() > 0) {
            this.mFactorsArrowButton.setEnabled(true);
            this.mFactorsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
        }
        if (this.mFactorsList.hasFocus() && this.mFactorsList.getModel().getSize() > 0) {
            this.mFactorsArrowButton.setEnabled(true);
            this.mFactorsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        }
        if (this.mCovariateTable.hasFocus() && this.mCovariateModel.getRowCount() > 0) {
            this.mCovariatesArrowButton.setEnabled(true);
            this.mCovariatesArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
        }
        if (this.mCovariatesList.hasFocus() && this.mCovariatesList.getModel().getSize() > 0) {
            this.mCovariatesArrowButton.setEnabled(true);
            this.mCovariatesArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mFactorsTable) {
            this.mFactorsScrollPane.setBorder(this.mDefaultScrollPaneBorder);
        }
        if (focusEvent.getSource() == this.mCovariateTable) {
            this.mCovariatesScrollPane.setBorder(this.mDefaultScrollPaneBorder);
        }
    }

    @Override
    public boolean continuePressed() {
        if (this.mCovariateTable.getCellEditor() != null) {
            this.mCovariateTable.getCellEditor().stopCellEditing();
        }
        if (this.mFactorsTable.getCellEditor() != null) {
            this.mFactorsTable.getCellEditor().stopCellEditing();
        }
        return this.isNumber() && !this.areDuplicatesPresent(this.mFactorsModel) && !this.areDuplicatesPresent(this.mCovariateModel);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.mFactorsList.getSelectedIndex() == -1) {
            this.mFactorsArrowButton.setEnabled(false);
        } else {
            this.mFactorsArrowButton.setEnabled(true);
        }
        if (this.mCovariatesList.getSelectedIndex() == -1) {
            this.mCovariatesArrowButton.setEnabled(false);
        } else {
            this.mCovariatesArrowButton.setEnabled(true);
        }
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            DialogUtil.removeDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this));
            this.addDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this), this.mVarMoveHandler);
        }
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        int n;
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        Object[] objectArray;
        Object object4;
        Object object5;
        HashMap<Integer, Object> hashMap = dialogDataModel.getMap(FACTOR_TABLE_IDENTIFIER_KEY);
        if (hashMap != null) {
            object5 = hashMap.keySet().iterator();
            this.mFactorsLocallyUniqueIdMap = dialogDataModel.getMap(FACTOR_TABLE_ID_KEY);
            while (object5.hasNext()) {
                object4 = (Integer)object5.next();
                if (!this.mFactorsLocallyUniqueIdMap.containsKey(object4)) {
                    hashMap.remove(object4);
                    continue;
                }
                objectArray = (String[])hashMap.get(object4);
                object3 = objectArray[0];
                object2 = this.mParentDlg.getDialogDataModel().getBoolean("FACTOR_TABLE_IDENTIFIER_KEY");
                if (!(object2 != null && ((Boolean)object2).booleanValue() || !objectArray[1].contains("Missing") && !objectArray[1].contains("missing"))) {
                    objectArray[1] = this.getResString("IDS_LOGISTIC_REGRESSION_ODDS_RATIOS_COMBOBOX_HIGHEST_OPTION");
                }
                if (this.mShowLabel) {
                    if (!object3.contains("[")) {
                        ISpssVariable iSpssVariable = this.getISpssVariable(this.mFactorsList, object3.trim());
                        objectArray[0] = object3 = iSpssVariable.getLabel() + " [" + iSpssVariable.getName() + "]";
                    }
                    object = object3.substring(object3.indexOf("[") + 1, object3.indexOf("]"));
                } else if (object3.contains("[")) {
                    objectArray[0] = object = object3.substring(object3.indexOf("[") + 1, object3.indexOf("]"));
                } else {
                    object = object3;
                }
                bl = false;
                for (n = 0; n < this.mFactorsList.getModel().getSize(); ++n) {
                    if (!this.mFactorsList.getModel().getElementAt(n).getName().equals(object)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                this.mFactorsModel.addRow(objectArray);
            }
        }
        if ((object5 = dialogDataModel.getMap(COVARIATE_TABLE_IDENTIFIER_KEY)) != null) {
            object4 = ((HashMap)object5).keySet().iterator();
            this.mCovariatesLocallyUniqueIdMap = dialogDataModel.getMap(COVARIATE_TABLE_ID_KEY);
            while (object4.hasNext()) {
                objectArray = (Object[])object4.next();
                if (!this.mCovariatesLocallyUniqueIdMap.containsKey(objectArray)) {
                    object4.remove();
                    continue;
                }
                object3 = (String[])((HashMap)object5).get(objectArray);
                object2 = object3[0];
                object3[1] = this.convertToExponentialValue(object3[1]);
                if (this.mShowLabel) {
                    if (!((String)object2).contains("[")) {
                        ISpssVariable iSpssVariable = this.getISpssVariable(this.mCovariatesList, ((String)object2).trim());
                        object3[0] = object2 = iSpssVariable.getLabel() + " [" + iSpssVariable.getName() + "]";
                    }
                    object = ((String)object2).substring(((String)object2).indexOf("[") + 1, ((String)object2).indexOf("]"));
                } else if (((String)object2).contains("[")) {
                    object3[0] = object = ((String)object2).substring(((String)object2).indexOf("[") + 1, ((String)object2).indexOf("]"));
                } else {
                    object = object2;
                }
                bl = false;
                for (n = 0; n < this.mCovariatesList.getModel().getSize(); ++n) {
                    if (!this.mCovariatesList.getModel().getElementAt(n).getName().equals(object)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                this.mCovariateModel.addRow((Object[])object3);
            }
        }
        if (this.mFactorsList.getModel().getSize() > 0) {
            this.mFactorsList.setSelectedIndex(0);
            this.mFactorsArrowButton.setEnabled(true);
        } else {
            this.mFactorsArrowButton.setEnabled(false);
        }
        if (this.mCovariatesList.getModel().getSize() > 0) {
            this.mCovariatesList.setSelectedIndex(0);
            this.mCovariatesArrowButton.setEnabled(true);
        } else {
            this.mCovariatesArrowButton.setEnabled(false);
        }
        this.mFactorsList.addFocusListener(this);
        this.mFactorsList.addListSelectionListener(this);
        this.mCovariatesList.addFocusListener(this);
        this.mCovariatesList.addListSelectionListener(this);
        this.setVisible(true);
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        LinkedHashMap<Integer, Object> linkedHashMap = this.saveTableModel(this.mFactorsModel);
        LinkedHashMap<Integer, Object> linkedHashMap2 = this.saveTableModel(this.mCovariateModel);
        dialogDataModel.putMap(FACTOR_TABLE_IDENTIFIER_KEY, linkedHashMap);
        dialogDataModel.putMap(COVARIATE_TABLE_IDENTIFIER_KEY, linkedHashMap2);
        dialogDataModel.putMap(FACTOR_TABLE_ID_KEY, this.mFactorsLocallyUniqueIdMap);
        dialogDataModel.putMap(COVARIATE_TABLE_ID_KEY, this.mCovariatesLocallyUniqueIdMap);
        return true;
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.initializeTargetList();
        this.setupUI(jPanel);
        this.pack();
        this.mMessageLabel.setMinimumSize(this.mMessageLabel.getMinimumSize());
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mFactorsList);
        vector.add(this.mFactorsArrowButton);
        vector.add(this.mFactorsTable);
        vector.add(this.mCovariatesList);
        vector.add(this.mCovariatesArrowButton);
        vector.add(this.mCovariateTable);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            Component component = this.mCmdButtonPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    private void addDragAdapters(DragPane dragPane, Component component, IVarMoveHandler iVarMoveHandler) {
        JComponent jComponent = null;
        if (component instanceof VariableList) {
            TargetVariableList targetVariableList = (TargetVariableList)component;
            ListDragAdapter listDragAdapter = null;
            if (targetVariableList == this.mCovariatesList) {
                jComponent = this.mCovariateTable;
                listDragAdapter = new ListDragAdapter(targetVariableList, dragPane, "CovariatesList");
            }
            if (targetVariableList == this.mFactorsList) {
                jComponent = this.mFactorsTable;
                listDragAdapter = new ListDragAdapter(targetVariableList, dragPane, "FactorsList");
            }
            DialogUtil.modifyMouseInputListeners(targetVariableList, listDragAdapter);
            dragPane.addDropListener((IDropListener)new OddsRatiosListDropListner(targetVariableList, jComponent));
        } else if (component instanceof PlainTable) {
            PlainTable plainTable = (PlainTable)component;
            PlainTableDragAdapter plainTableDragAdapter = null;
            if (plainTable == this.mCovariateTable) {
                jComponent = this.mCovariatesList;
                plainTableDragAdapter = new PlainTableDragAdapter(plainTable, dragPane, "CovariatesTable");
            }
            if (plainTable == this.mFactorsTable) {
                jComponent = this.mFactorsList;
                plainTableDragAdapter = new PlainTableDragAdapter(plainTable, dragPane, "FactorsTable");
            }
            DialogUtil.modifyMouseInputListeners(plainTable, plainTableDragAdapter);
            dragPane.addDropListener((IDropListener)new OddsRatioTableDropListener(plainTable, iVarMoveHandler, jComponent));
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (Component component2 : container.getComponents()) {
                this.addDragAdapters(dragPane, component2, iVarMoveHandler);
            }
        }
    }

    private void setupUI(JPanel jPanel) {
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        int n3 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_LOGISTIC_REGRESSION_ODDS_RATIOS_FACTORS_LABEL");
        jLabel.setLabelFor(this.mFactorsList);
        this.mInsets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_LOGISTIC_REGRESSION_ODDS_RATIOS_COMPARING_FACTORS_LABEL");
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_LOGISTIC_REGRESSION_ODDS_RATIOS_COVARIATES_VALUES_LABEL");
        if (this.getParent() instanceof OrdinalRegressionDlg) {
            jLabel2 = DialogUtil.createLabel(this, "IDS_CS_ORDINAL_ODD_RATIOS_FACTOR_TABLE_TITLE");
            jLabel3 = DialogUtil.createLabel(this, "IDS_CS_ORDINAL_ODD_RATIOS_COVARIATE_TABLE_TITLE");
        }
        jLabel2.setLabelFor(this.mFactorsTable);
        this.mConstraints.weightx = 1.0;
        this.mInsets.set(n2, insets.left, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jLabel2, this.mConstraints, 2, 0, 1, 1, n, this.mInsets);
        JScrollPane jScrollPane = new JScrollPane(this.mFactorsList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setPreferredSize(this.mFactorsList.getMinimumSize());
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(insets.top, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, this.mConstraints, 0, 1, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mFactorsArrowButton, this.mConstraints, 1, 1, 1, 1, 10, insets2);
        this.mFactorsScrollPane = new JScrollPane(this.mFactorsTable);
        this.mFactorsScrollPane.setHorizontalScrollBarPolicy(31);
        this.mFactorsScrollPane.setVerticalScrollBarPolicy(20);
        this.mFactorsScrollPane.setPreferredSize(this.mFactorsTable.getMinimumSize());
        this.mDefaultScrollPaneBorder = this.mFactorsScrollPane.getBorder();
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(insets.top, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mFactorsScrollPane, this.mConstraints, 2, 1, 1, 1, n, this.mInsets);
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_LOGISTIC_REGRESSION_ODDS_RATIOS_COVARIATES_LABEL");
        jLabel4.setLabelFor(this.mCovariatesList);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        this.mInsets.set(n3, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel4, this.mConstraints, 0, 2, 1, 1, n, this.mInsets);
        jLabel3.setLabelFor(this.mCovariateTable);
        this.mConstraints.weightx = 1.0;
        this.mInsets.set(n3, insets.left, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jLabel3, this.mConstraints, 2, 2, 1, 1, n, this.mInsets);
        jScrollPane = new JScrollPane(this.mCovariatesList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setPreferredSize(this.mCovariatesList.getMinimumSize());
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(insets.top, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, this.mConstraints, 0, 3, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mCovariatesArrowButton, this.mConstraints, 1, 3, 1, 1, 10, insets2);
        this.mCovariatesScrollPane = new JScrollPane(this.mCovariateTable);
        this.mCovariatesScrollPane.setHorizontalScrollBarPolicy(31);
        this.mCovariatesScrollPane.setVerticalScrollBarPolicy(20);
        this.mCovariatesScrollPane.setPreferredSize(this.mCovariateTable.getMinimumSize());
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(insets.top, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mCovariatesScrollPane, this.mConstraints, 2, 3, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(n3, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mMessageLabel, this.mConstraints, 0, 4, 3, 1, n, this.mInsets);
    }

    private void initVars() {
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        vector2.add(this.getResString("IDS_LOGISTIC_REGRESSION_ODDS_RATIOS_FACTOR_COLUMN_LABEL"));
        vector2.add(this.getResString("IDS_LOGISTIC_REGRESSION_ODDS_RATIOS_REF_CAT_COLUMN_LABEL"));
        this.mFactorsModel = new DefaultTableModel(vector, vector2){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 != 0;
            }
        };
        this.mFactorsTable = new PlainTable();
        this.mFactorsTable.setModel(this.mFactorsModel);
        this.mFactorsTable.addFocusListener(this);
        this.mFactorsTable.setRowSelectionAllowed(true);
        this.mFactorsTable.setSelectionMode(0);
        this.mFactorsTable.setColumnSelectionAllowed(false);
        JComboBox jComboBox = new JComboBox(new ComplexSamplesGLMComboBoxModel(new String[]{this.getResString("IDS_LOGISTIC_REGRESSION_ODDS_RATIOS_COMBOBOX_HIGHEST_OPTION"), this.getResString("IDS_LOGISTIC_REGRESSION_ODDS_RATIOS_COMBOBOX_LOWEST_OPTION")}, this.mFactorsTable));
        this.mFactorsTable.getColumnModel().getColumn(1).setCellRenderer(new CategoryCellRenderer());
        this.mFactorsTable.getColumnModel().getColumn(1).setCellEditor(new CategoryCellEditor(jComboBox));
        JTableHeader jTableHeader = this.mFactorsTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        Font font = jTableHeader.getFont().deriveFont(1);
        TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
        jTableHeader.setDefaultRenderer(new BoldFontRenderer(tableCellRenderer, font));
        vector2 = new Vector();
        vector2.add(this.getResString("IDS_LOGISTIC_REGRESSION_ODDS_RATIOS_COVARIATE_COLUMN_LABEL"));
        vector2.add(this.getResString("IDS_LOGISTIC_REGRESSION_ODDS_RATIOS_UNITSOFCHANGE_COLUMN_LABEL"));
        vector = new Vector();
        this.mCovariateModel = new DefaultTableModel(vector, vector2){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 != 0;
            }
        };
        this.mCovariateTable = new PlainTable(){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                final Component component = this.getEditorComponent();
                if (component != null && component instanceof JTextComponent) {
                    if (eventObject == null) {
                        ((JTextComponent)component).selectAll();
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((JTextComponent)component).selectAll();
                            }
                        });
                    }
                }
                return bl;
            }
        };
        this.mCovariateTable.setModel(this.mCovariateModel);
        this.mCovariateTable.addFocusListener(this);
        this.mCovariateTable.setRowSelectionAllowed(true);
        this.mCovariateTable.setSelectionMode(0);
        this.mCovariateTable.setColumnSelectionAllowed(false);
        FloatTextField floatTextField = new FloatTextField();
        ColumnCellEditor columnCellEditor = new ColumnCellEditor(floatTextField);
        this.mCovariateTable.getColumnModel().getColumn(1).setCellEditor(columnCellEditor);
        jTableHeader = this.mCovariateTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        font = jTableHeader.getFont().deriveFont(1);
        tableCellRenderer = jTableHeader.getDefaultRenderer();
        jTableHeader.setDefaultRenderer(new BoldFontRenderer(tableCellRenderer, font));
        this.mConstraints = new GridBagConstraints();
        this.mInsets = new Insets(0, 0, 0, 0);
        this.mFactorsList = new TargetVariableList();
        this.mFactorsList.setIdentifier(FACTOR_LIST_IDENTIFIER_KEY);
        this.mFactorsArrowButton = new ComponentsArrowButton();
        this.mFactorsArrowButton.setEnabled(false);
        this.mFactorsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mFactorsArrowButton.registerComponents(this.mFactorsList, SpssArrowButton.ButtonOrientation.right);
        this.mFactorsArrowButton.registerComponents(this.mFactorsTable, SpssArrowButton.ButtonOrientation.left);
        this.mFactorsArrowButton.addActionListener(new ArrowActionListener());
        this.mCovariatesList = new TargetVariableList();
        this.mCovariatesList.setIdentifier(COVARIATE_LIST_IDENTIFIER_KEY);
        this.mCovariatesArrowButton = new ComponentsArrowButton();
        this.mCovariatesArrowButton.setEnabled(false);
        this.mCovariatesArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mCovariatesArrowButton.registerComponents(this.mCovariatesList, SpssArrowButton.ButtonOrientation.right);
        this.mCovariatesArrowButton.registerComponents(this.mCovariateTable, SpssArrowButton.ButtonOrientation.left);
        this.mCovariatesArrowButton.addActionListener(new ArrowActionListener());
        this.mMapOfModels = new HashMap();
        String string = this.getResString("IDS_LOGISTIC_REGRESSION_ODDS_RATIOS_GENERAL_LABEL");
        if (this.getParent() instanceof OrdinalRegressionDlg) {
            string = this.getResString("IDS_CS_ORDINAL_ODD_RATIOS_GENERAL_LEVEL_COMMENT");
        }
        this.mMessageLabel = new JTextArea(string);
        this.mMessageLabel.setEditable(false);
        this.mMessageLabel.setOpaque(false);
        this.mMessageLabel.setWrapStyleWord(true);
        this.mMessageLabel.setLineWrap(true);
        this.mMessageLabel.setRows(3);
        this.mFactorsLocallyUniqueIdMap = new HashMap();
        this.mCovariatesLocallyUniqueIdMap = new HashMap();
        this.mFactorsTable.addKeyListener(this);
        this.mCovariateTable.addKeyListener(this);
        this.mShowLabel = true;
    }

    private void initializeTargetList() {
        DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
        VarListModel varListModel = this.mFactorsList.getModel();
        TargetVariableList targetVariableList = this.getParent() instanceof LogisticRegressionDlg ? ((LogisticRegressionDlg)this.mParentDlg).getMainPanel().getFactorList() : ((OrdinalRegressionDlg)this.mParentDlg).getMainPanel().getFactorList();
        VarListModel varListModel2 = targetVariableList.getModel();
        ISpssVariable[] iSpssVariableArray = new ISpssVariable[varListModel2.getSize()];
        for (int i = 0; i < varListModel2.getSize(); ++i) {
            ISpssVariable iSpssVariable;
            iSpssVariableArray[i] = iSpssVariable = varListModel2.getElementAt(i);
            varListModel.addElement(iSpssVariable);
        }
        dialogDataModel.putVarArray(this.mFactorsList.getIdentifier(), iSpssVariableArray);
        varListModel = this.mCovariatesList.getModel();
        TargetVariableList targetVariableList2 = this.getParent() instanceof LogisticRegressionDlg ? ((LogisticRegressionDlg)this.mParentDlg).getMainPanel().getCovariateList() : ((OrdinalRegressionDlg)this.mParentDlg).getMainPanel().getCovariateList();
        varListModel2 = targetVariableList2.getModel();
        iSpssVariableArray = new ISpssVariable[varListModel2.getSize()];
        for (int i = 0; i < varListModel2.getSize(); ++i) {
            ISpssVariable iSpssVariable;
            iSpssVariableArray[i] = iSpssVariable = varListModel2.getElementAt(i);
            varListModel.addElement(iSpssVariable);
        }
        dialogDataModel.putVarArray(this.mCovariatesList.getIdentifier(), iSpssVariableArray);
    }

    private LinkedHashMap<Integer, Object> saveTableModel(DefaultTableModel defaultTableModel) {
        LinkedHashMap<Integer, Object> linkedHashMap = new LinkedHashMap<Integer, Object>();
        int n = defaultTableModel.getRowCount();
        int n2 = defaultTableModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String[] stringArray = new String[n2];
            for (int j = 0; j < n2; ++j) {
                stringArray[j] = (String)defaultTableModel.getValueAt(i, j);
            }
            linkedHashMap.put(i, stringArray);
        }
        return linkedHashMap;
    }

    private String convertToExponentialValue(String string) {
        Float f = Float.valueOf(Float.parseFloat(string));
        String string2 = f + "";
        if ((string2 = string2.replaceAll("E", "e+")).charAt(string2.length() - 1) == '0' && string2.charAt(string2.length() - 2) == '.') {
            string2 = string2.substring(0, string2.indexOf("."));
        }
        return string2;
    }

    private boolean areDuplicatesPresent(DefaultTableModel defaultTableModel) {
        int n = defaultTableModel.getRowCount();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (int i = 0; i < n; ++i) {
            if (linkedHashSet.add(defaultTableModel.getValueAt(i, 0) + (String)defaultTableModel.getValueAt(i, 1))) continue;
            int n2 = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_LOGISTIC_REGRESSION_ODDS_RATIOS_DUPLICATE_TABLE_ELEMENTS_MESSAGE"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            if (n2 == 0) {
                while (defaultTableModel.getRowCount() > 0) {
                    linkedHashSet.add(defaultTableModel.getValueAt(0, 0) + (String)defaultTableModel.getValueAt(0, 1));
                    defaultTableModel.removeRow(0);
                }
                Iterator iterator = linkedHashSet.iterator();
                Object[] objectArray = new String[2];
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    String string2 = string.substring(0, string.indexOf("]") + 1);
                    String string3 = string.substring(string.indexOf("]") + 1);
                    objectArray[0] = string2;
                    objectArray[1] = string3;
                    defaultTableModel.addRow(objectArray);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isNumber() {
        int n = this.mCovariateModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            try {
                float f = Float.parseFloat((String)this.mCovariateModel.getValueAt(i, 1));
                if ((double)f != 0.0) continue;
                throw new NumberFormatException();
            }
            catch (NumberFormatException numberFormatException) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_LOGISTIC_REGRESSION_ODDS_RATIOS_INVALID_NUMBER_MESSAGE"), VersionInfo.getAppVersionString());
                this.mCovariateTable.requestFocus();
                this.mCovariateTable.setRowSelectionInterval(i, i);
                return false;
            }
        }
        return true;
    }

    private void factorsTransfer(ISpssVariable[] iSpssVariableArray) {
        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
            Object[] objectArray;
            String string = iSpssVariable.getLabel();
            String string2 = iSpssVariable.getName();
            if (this.mShowLabel) {
                objectArray = new Object[]{string + " [" + string2 + "]", this.getResString("IDS_LOGISTIC_REGRESSION_ODDS_RATIOS_COMBOBOX_HIGHEST_OPTION")};
                this.mFactorsModel.addRow(objectArray);
            } else {
                objectArray = new Object[]{string2, this.getResString("IDS_LOGISTIC_REGRESSION_ODDS_RATIOS_COMBOBOX_HIGHEST_OPTION")};
                this.mFactorsModel.addRow(objectArray);
            }
            int n = this.mFactorsModel.getRowCount() - 1;
            this.mFactorsLocallyUniqueIdMap.put(n, iSpssVariable.getName());
        }
        int n = this.mFactorsModel.getRowCount() - 1;
        this.mFactorsTable.requestFocus();
        this.mFactorsTable.setRowSelectionInterval(n, n);
    }

    private void covariatesTranfer(ISpssVariable[] iSpssVariableArray) {
        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
            Object[] objectArray;
            String string = iSpssVariable.getLabel();
            String string2 = iSpssVariable.getName();
            if (this.mShowLabel) {
                objectArray = new Object[]{string + " [" + string2 + "]", "1"};
                this.mCovariateModel.addRow(objectArray);
            } else {
                objectArray = new Object[]{string2, "1"};
                this.mCovariateModel.addRow(objectArray);
            }
            int n = this.mCovariateModel.getRowCount() - 1;
            this.mCovariatesLocallyUniqueIdMap.put(n, iSpssVariable.getName());
        }
        int n = this.mCovariateModel.getRowCount() - 1;
        this.mCovariateTable.requestFocus();
        this.mCovariateTable.setRowSelectionInterval(n, n);
    }

    private ISpssVariable getISpssVariable(TargetVariableList targetVariableList, String string) {
        VarListModel varListModel = targetVariableList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            ISpssVariable iSpssVariable = varListModel.getElementAt(i);
            if (!iSpssVariable.getName().equals(string)) continue;
            return iSpssVariable;
        }
        return null;
    }

    class ColumnCellEditor
    extends DefaultCellEditor {
        FloatTextField floatTextField;

        public ColumnCellEditor(FloatTextField floatTextField) {
            super((JTextField)floatTextField);
            this.floatTextField = floatTextField;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.floatTextField.setText(object.toString());
            return this.floatTextField;
        }
    }

    private class OddsRatiosListDropListner
    extends AbstractDropListener {
        private Component mRegisteredSource;

        public OddsRatiosListDropListner(VariableList variableList, Component component) {
            super(variableList);
            this.mRegisteredSource = component;
        }

        @Override
        public void itemDropped(DropEvent dropEvent) {
            boolean bl;
            Component component = dropEvent.getSource();
            if (this.mLastPosition != null) {
                this.mLastPosition = null;
                if (this.mTimer != null) {
                    this.mTimer.stop();
                }
            }
            this.setHighlightBorder(false);
            boolean bl2 = bl = this.contains(dropEvent.getDropLocation()) && this.canDrop(dropEvent.getDragSourceAdapter());
            if (bl && this.mDropTarget != null) {
                if (this.mDropTarget instanceof PlainTable) {
                    return;
                }
                if (component instanceof PlainTable) {
                    PlainTable plainTable = (PlainTable)component;
                    Vector<Object[]> vector = plainTable.getSelectedValues();
                    Object[] objectArray = vector.toArray();
                    Point point = (Point)dropEvent.getDropLocation().clone();
                    SwingUtilities.convertPointFromScreen(point, this.mDropTarget);
                    int n = ((VariableList)this.mDropTarget).locationToIndex(point);
                    this.importData(objectArray, (JComponent)component, n);
                    this.mSwapFlag = false;
                }
            }
        }

        @Override
        public void importData(Object object, JComponent jComponent, int n) {
            if (!(this.mDropTarget instanceof VariableList)) {
                assert (false);
                return;
            }
            if (jComponent instanceof PlainTable) {
                int n2;
                if (this.mDropTarget == ComplexSamplesOddsRatios.this.mCovariatesList) {
                    if (ComplexSamplesOddsRatios.this.mCovariateTable.getSelectedRow() != -1) {
                        n2 = ComplexSamplesOddsRatios.this.mCovariateTable.getSelectedRow();
                        ComplexSamplesOddsRatios.this.mCovariateModel.removeRow(n2);
                        ComplexSamplesOddsRatios.this.mCovariatesLocallyUniqueIdMap.remove(n2);
                    }
                    ComplexSamplesOddsRatios.this.mCovariatesList.requestFocus();
                }
                if (this.mDropTarget == ComplexSamplesOddsRatios.this.mFactorsList) {
                    if (ComplexSamplesOddsRatios.this.mFactorsTable.getSelectedRow() != -1) {
                        n2 = ComplexSamplesOddsRatios.this.mFactorsTable.getSelectedRow();
                        ComplexSamplesOddsRatios.this.mFactorsModel.removeRow(n2);
                        ComplexSamplesOddsRatios.this.mFactorsLocallyUniqueIdMap.remove(n2);
                    }
                    ComplexSamplesOddsRatios.this.mFactorsList.requestFocus();
                }
            }
        }

        @Override
        public boolean canDrop(DragDropAdapter dragDropAdapter) {
            boolean bl = false;
            if (!(this.mDropTarget instanceof VariableList)) {
                return bl;
            }
            if (!(this.mDropTarget.isEnabled() && this.mDropTarget.isShowing() && ((VariableList)this.mDropTarget).isDragSupported())) {
                return bl;
            }
            Object object = dragDropAdapter.getTransferData();
            if (object instanceof PlainTable.TransferData) {
                PlainTable.TransferData transferData = (PlainTable.TransferData)object;
                if (transferData.getSource() != null && this.getRegisteredSource() != transferData.getSource()) {
                    return bl;
                }
                Vector<Object[]> vector = transferData.getVectorData();
                if (vector != null && vector.size() > 0) {
                    bl = true;
                }
            }
            return bl;
        }

        @Override
        protected void finish(JComponent jComponent, int n, int[] nArray, int n2) {
        }

        @Override
        protected void showDropFeedback(Point point) {
        }

        @Override
        protected void setHighlightBorder(boolean bl) {
        }

        public Component getRegisteredSource() {
            return this.mRegisteredSource;
        }

        @Override
        public Cursor dragItemOver(Point point, DragDropAdapter dragDropAdapter) {
            Cursor cursor = null;
            Point point2 = (Point)point.clone();
            SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
            boolean bl = false;
            if (this.contains(point)) {
                this.mCanImport = this.canDrop(dragDropAdapter);
                if (this.mCanImport) {
                    bl = true;
                    this.showDropFeedback(point2);
                    cursor = Cursor.getPredefinedCursor(12);
                } else {
                    this.showDropFeedback(null);
                    cursor = DragPane.getNoDropCursor();
                }
            } else {
                this.showDropFeedback(null);
            }
            this.setHighlightBorder(bl);
            return cursor;
        }
    }

    private class OddsRatioTableDropListener
    extends AbstractTableDropListener {
        private Component mRegisteredSource;

        public OddsRatioTableDropListener(PlainTable plainTable, Component component) {
            super(plainTable, component);
            this.mRegisteredSource = component;
        }

        public OddsRatioTableDropListener(PlainTable plainTable, IVarMoveHandler iVarMoveHandler, Component component) {
            super(plainTable, iVarMoveHandler, component);
            this.mRegisteredSource = component;
        }

        @Override
        protected void importData(Object object, JComponent jComponent, int n) {
            if (!(this.mDropTarget instanceof PlainTable)) {
                assert (false);
                return;
            }
            if (object instanceof ISpssVariable[]) {
                if (this.mDropTarget == ComplexSamplesOddsRatios.this.mFactorsTable) {
                    ISpssVariable[] iSpssVariableArray = (ISpssVariable[])object;
                    ComplexSamplesOddsRatios.this.factorsTransfer(iSpssVariableArray);
                } else if (this.mDropTarget == ComplexSamplesOddsRatios.this.mCovariateTable) {
                    ISpssVariable[] iSpssVariableArray = (ISpssVariable[])object;
                    ComplexSamplesOddsRatios.this.covariatesTranfer(iSpssVariableArray);
                }
            }
        }

        @Override
        public boolean canDrop(DragDropAdapter dragDropAdapter) {
            boolean bl = false;
            if (!(this.mDropTarget instanceof PlainTable)) {
                return bl;
            }
            if (!(this.mDropTarget.isEnabled() && this.mDropTarget.isShowing() && ((PlainTable)this.mDropTarget).isDragSupported())) {
                return bl;
            }
            Object object = dragDropAdapter.getTransferData();
            if (object instanceof VariableList.TransferData) {
                if (dragDropAdapter instanceof ListDragAdapter && ((ListDragAdapter)dragDropAdapter).getSourceList() != this.getRegisteredSource()) {
                    return false;
                }
                VariableList.TransferData transferData = (VariableList.TransferData)object;
                ISpssVariable[] iSpssVariableArray = transferData.getVariables();
                if (iSpssVariableArray != null && iSpssVariableArray.length > 0) {
                    bl = true;
                }
            }
            return bl;
        }

        @Override
        public void itemDropped(DropEvent dropEvent) {
            boolean bl;
            Component component = dropEvent.getSource();
            if (this.mLastPosition != null) {
                this.mLastPosition = null;
                if (this.mTimer != null) {
                    this.mTimer.stop();
                }
            }
            this.setHighlightBorder(false);
            boolean bl2 = bl = this.contains(dropEvent.getDropLocation()) && this.canDrop(dropEvent.getDragSourceAdapter());
            if (bl && this.mDropTarget != null) {
                if (component != this.mRegisteredSource || this.mDropTarget instanceof TargetVariableList) {
                    return;
                }
                if (component instanceof TargetVariableList) {
                    TargetVariableList targetVariableList = (TargetVariableList)component;
                    ISpssVariable[] iSpssVariableArray = targetVariableList.getSelectedValues();
                    Point point = (Point)dropEvent.getDropLocation().clone();
                    SwingUtilities.convertPointFromScreen(point, this.mDropTarget);
                    int n = ((PlainTable)this.mDropTarget).rowAtPoint(point);
                    this.importData(iSpssVariableArray, (JComponent)component, n);
                    this.mSwapFlag = false;
                }
            }
        }

        @Override
        public Cursor dragItemOver(Point point, DragDropAdapter dragDropAdapter) {
            Cursor cursor = null;
            Point point2 = (Point)point.clone();
            SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
            boolean bl = false;
            if (this.contains(point)) {
                this.mCanImport = this.canDrop(dragDropAdapter);
                if (this.mCanImport) {
                    bl = true;
                    this.showDropFeedback(point2);
                    cursor = Cursor.getPredefinedCursor(12);
                } else {
                    this.showDropFeedback(null);
                    cursor = DragPane.getNoDropCursor();
                }
            } else {
                this.showDropFeedback(null);
            }
            this.setHighlightBorder(bl);
            return cursor;
        }
    }

    private class ArrowActionListener
    implements ActionListener {
        private ArrowActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ComplexSamplesOddsRatios.this.mFactorsArrowButton && ComplexSamplesOddsRatios.this.mFactorsArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right) {
                if (ComplexSamplesOddsRatios.this.mFactorsList.getModel().getSize() == 0) {
                    return;
                }
                ISpssVariable[] iSpssVariableArray = ComplexSamplesOddsRatios.this.mFactorsList.getSelectedValues();
                ComplexSamplesOddsRatios.this.factorsTransfer(iSpssVariableArray);
            } else if (object == ComplexSamplesOddsRatios.this.mFactorsArrowButton && ComplexSamplesOddsRatios.this.mFactorsArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.left) {
                if (ComplexSamplesOddsRatios.this.mFactorsTable.getSelectedRow() != -1) {
                    int n = ComplexSamplesOddsRatios.this.mFactorsTable.getSelectedRow();
                    ComplexSamplesOddsRatios.this.mFactorsModel.removeRow(n);
                    ComplexSamplesOddsRatios.this.mFactorsLocallyUniqueIdMap.remove(n);
                }
                ComplexSamplesOddsRatios.this.mFactorsList.requestFocus();
            } else if (object == ComplexSamplesOddsRatios.this.mCovariatesArrowButton && ComplexSamplesOddsRatios.this.mCovariatesArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right) {
                if (ComplexSamplesOddsRatios.this.mCovariatesList.getModel().getSize() == 0) {
                    return;
                }
                ISpssVariable[] iSpssVariableArray = ComplexSamplesOddsRatios.this.mCovariatesList.getSelectedValues();
                ComplexSamplesOddsRatios.this.covariatesTranfer(iSpssVariableArray);
            } else if (object == ComplexSamplesOddsRatios.this.mCovariatesArrowButton && ComplexSamplesOddsRatios.this.mCovariatesArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.left) {
                if (ComplexSamplesOddsRatios.this.mCovariateTable.getSelectedRow() != -1) {
                    int n = ComplexSamplesOddsRatios.this.mCovariateTable.getSelectedRow();
                    ComplexSamplesOddsRatios.this.mCovariateModel.removeRow(n);
                    ComplexSamplesOddsRatios.this.mCovariatesLocallyUniqueIdMap.remove(n);
                }
                ComplexSamplesOddsRatios.this.mCovariatesList.requestFocus();
            }
        }
    }

    private class CategoryCellEditor
    extends DefaultCellEditor {
        private JComboBox mComboBox;

        public CategoryCellEditor(JComboBox jComboBox) {
            super(jComboBox);
            this.mComboBox = jComboBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string;
            ISpssVariable iSpssVariable;
            String string2 = (String)ComplexSamplesOddsRatios.this.mFactorsModel.getValueAt(n, 0);
            if (ComplexSamplesOddsRatios.this.mShowLabel) {
                if (!string2.contains("[")) {
                    iSpssVariable = ComplexSamplesOddsRatios.this.getISpssVariable(ComplexSamplesOddsRatios.this.mFactorsList, string2.trim());
                    string2 = iSpssVariable.getLabel() + " [" + iSpssVariable.getName() + "]";
                }
                string = string2.substring(string2.indexOf("[") + 1, string2.indexOf("]"));
            } else {
                string = string2;
            }
            iSpssVariable = ComplexSamplesOddsRatios.this.getISpssVariable(ComplexSamplesOddsRatios.this.mFactorsList, string);
            ArrayList<String> arrayList = ComplexSamplesUtils.getMissingValues(iSpssVariable);
            Boolean bl2 = ComplexSamplesOddsRatios.this.mParentDlg.getDialogDataModel().getBoolean("IDS_COMPLEX_SAMPLES_COMMON_OPTIONS_VALID_RADIOBUTTON");
            IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
            Set set = iValueLabelMap.getValueLabelEntries();
            if (set.size() > 0) {
                int n3 = 0;
                for (Map.Entry entry : set) {
                    OBS oBS = (OBS)entry.getKey();
                    if (iSpssVariable.isMissing(oBS) && (bl2 == null || !bl2.booleanValue())) {
                        arrayList.remove(n3);
                        continue;
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(((String)entry.getValue()).trim());
                    arrayList.set(n3, stringBuffer.toString());
                    ++n3;
                }
            }
            arrayList.add(0, ComplexSamplesOddsRatios.this.getResString("IDS_LOGISTIC_REGRESSION_ODDS_RATIOS_COMBOBOX_HIGHEST_OPTION"));
            arrayList.add(1, ComplexSamplesOddsRatios.this.getResString("IDS_LOGISTIC_REGRESSION_ODDS_RATIOS_COMBOBOX_LOWEST_OPTION"));
            String string3 = string + n;
            if (ComplexSamplesOddsRatios.this.mMapOfModels.containsKey(string3.trim())) {
                this.mComboBox.setModel((ComboBoxModel)ComplexSamplesOddsRatios.this.mMapOfModels.get(string3.trim()));
                ((ComplexSamplesGLMComboBoxModel)this.mComboBox.getModel()).setSelectedItem(object.toString(), n, 1);
            } else {
                ComplexSamplesOddsRatios.this.mMapOfModels.put(string3.trim(), new ComplexSamplesGLMComboBoxModel(arrayList.toArray(), ComplexSamplesOddsRatios.this.mFactorsTable));
                this.mComboBox.setModel((ComboBoxModel)ComplexSamplesOddsRatios.this.mMapOfModels.get(string3.trim()));
                ((ComplexSamplesGLMComboBoxModel)this.mComboBox.getModel()).setSelectedItem(object.toString(), n, 1);
            }
            ComplexSamplesOddsRatios.this.mFactorsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            return this.mComboBox;
        }
    }

    private class CategoryCellRenderer
    extends DefaultTableCellRenderer {
        private CategoryCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                this.setText(object.toString());
            }
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }

        @Override
        public void setToolTipText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setToolTipText(string);
            }
        }
    }

    private class BoldFontRenderer
    implements TableCellRenderer {
        private TableCellRenderer mHeaderRenderer;
        private Font mBoldFont;

        BoldFontRenderer(TableCellRenderer tableCellRenderer, Font font) {
            this.mHeaderRenderer = tableCellRenderer;
            this.mBoldFont = font;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = null;
            component = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? this.mHeaderRenderer.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : this.mHeaderRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            component.setFont(this.mBoldFont);
            return component;
        }
    }
}

