/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.IRetrieveFormatCallBack;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.VarFormatDocument;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesGLMComboBoxModel;
import com.spss.shared.core_tools.format.CellValueFormatter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ComplexSamplesGLMTablePanel
extends JPanel
implements FocusListener,
KeyListener,
MouseListener {
    public DefaultTableModel mTableModel;
    static final String CONTRAST_CHOICE = "IDS_GLM_CONTRAST_CHOICE";
    static final String CATEGORY_CHOICE = "IDS_GLM_CATEGORY_CHOICE";
    static final String SOURCE_KEY = "IDS_SOURCE_KEY";
    public PlainList mSrcVarList;
    public JCheckBox mDisplayMeanCheck;
    public PlainTable mDisplayTable;
    public ComponentsArrowButton mArrowButton;
    private VarListModel mSourceModel;
    private JComboBox mCategoryCombo;
    private HashMap<String, ComplexSamplesGLMComboBoxModel> mMapOfModels;
    private Vector<String> mNamesOfColumns;
    private int mRow;
    private BaseSubDialog mParent;
    private Vector<String> mModelStringVector;
    private JScrollPane mTableScrollPane;
    private Border mDefaultScrollPaneBorder;
    private Border mBlueBorder = BorderFactory.createLineBorder(Color.BLUE);

    public ComplexSamplesGLMTablePanel(BaseSubDialog baseSubDialog, VarListModel varListModel, Vector<String> vector, Vector<String> vector2) {
        super(true);
        this.mSourceModel = varListModel;
        this.mParent = baseSubDialog;
        this.mNamesOfColumns = vector;
        this.init();
        this.mModelStringVector = vector2;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.isCategoryValueValid();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n != 127) {
            this.mCategoryCombo.setEditable(true);
            this.mCategoryCombo.getEditor().selectAll();
            this.mCategoryCombo.getEditor().setItem(Character.valueOf(keyEvent.getKeyChar()));
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 127) {
            int[] nArray = this.mDisplayTable.getSelectedRows();
            keyEvent.consume();
            for (int i = 0; i < nArray.length; ++i) {
                this.mTableModel.removeRow(nArray[i] - i);
            }
            this.mSrcVarList.requestFocus();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mSrcVarList) {
            if (this.mSrcVarList.getSelectedIndex() >= 0) {
                this.mArrowButton.setEnabled(true);
            } else {
                this.mArrowButton.setEnabled(false);
            }
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        } else {
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            this.mTableScrollPane.setBorder(this.mBlueBorder);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mDisplayTable) {
            this.mTableScrollPane.setBorder(this.mDefaultScrollPaneBorder);
        }
    }

    public boolean isDisplayCheckSelected() {
        return this.mDisplayMeanCheck.isSelected();
    }

    public void loadState(DialogDataModel dialogDataModel, Vector<String> vector) {
        this.mSrcVarList.setModel(new DefaultListModel());
        DefaultListModel defaultListModel = (DefaultListModel)this.mSrcVarList.getModel();
        if (this.mModelStringVector != null) {
            for (String objectArray : this.mModelStringVector) {
                defaultListModel.addElement(objectArray);
            }
        }
        if (dialogDataModel.getArray("IDS_TABLE_HASH_MAP") != null) {
            Object[] objectArray2 = dialogDataModel.getArray("IDS_TABLE_HASH_MAP");
            Object[] objectArray = new Object[3];
            if (objectArray2 != null) {
                int n = 0;
                Object[] objectArray3 = objectArray2;
                int n2 = objectArray3.length;
                for (int i = 0; i < n2; ++i) {
                    Object object;
                    objectArray[n] = object = objectArray3[i];
                    if (++n <= 2) continue;
                    this.mTableModel.addRow(objectArray);
                    n = 0;
                }
            }
        }
        if (vector != null) {
            this.deleteExtraElement(this.mTableModel, vector);
        }
        this.getValueAtDisplayTable();
        if (this.mSrcVarList.getModel().getSize() > 0) {
            this.mSrcVarList.setSelectedIndex(0);
        }
    }

    public boolean saveState(DialogDataModel dialogDataModel) {
        if (!this.isCategoryValueValid()) {
            return false;
        }
        this.areDuplicatesPresent();
        ArrayList<String> arrayList = this.saveTableModel(this.mTableModel);
        dialogDataModel.putArray("IDS_TABLE_HASH_MAP", arrayList.toArray());
        return true;
    }

    protected void init() {
        this.initVars();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(this, this.setupPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
    }

    private boolean areDuplicatesPresent() {
        int n;
        int n2 = this.mTableModel.getRowCount();
        HashSet<String> hashSet = new HashSet<String>();
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 0; n < n2; ++n) {
            if (hashSet.add(this.mTableModel.getValueAt(n, 0) + "," + this.mTableModel.getValueAt(n, 1) + "," + this.mTableModel.getValueAt(n, 2))) continue;
            vector.add(n);
        }
        if (vector.size() > 0 && (n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mParent), this.mParent.getResString("ERR_GLM_TABLE_PANEL_DUPLICATE_MESSAGE"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) == 0) {
            for (int i = vector.size() - 1; i >= 0; --i) {
                String string = this.mTableModel.getValueAt((Integer)vector.get(i), 0).toString();
                String string2 = this.mTableModel.getValueAt((Integer)vector.get(i), 1).toString();
                this.mTableModel.removeRow((Integer)vector.get(i));
                this.removeKeyFromMap(string + string2 + vector.get(i));
            }
        }
        return true;
    }

    private Vector<SpssVariable> getFactorInteractionList() {
        Vector<SpssVariable> vector = new Vector<SpssVariable>();
        for (int i = 0; i < this.mSourceModel.getSize(); ++i) {
            vector.add((SpssVariable)this.mSourceModel.getElementAt(i));
        }
        return vector;
    }

    private void deleteExtraElement(DefaultTableModel defaultTableModel, Vector<String> vector) {
        int n;
        boolean bl = false;
        Vector<Integer> vector2 = new Vector<Integer>();
        for (n = 0; n < defaultTableModel.getRowCount(); ++n) {
            for (String string : vector) {
                if (!defaultTableModel.getValueAt(n, 0).toString().equals(string)) continue;
                bl = true;
            }
            if (!bl) {
                vector2.add(n);
            }
            bl = false;
        }
        for (int i = vector2.size() - 1; i >= 0; --i) {
            String string;
            n = (Integer)vector2.get(i);
            string = defaultTableModel.getValueAt(n, 0).toString();
            String string2 = defaultTableModel.getValueAt(n, 1).toString();
            this.mTableModel.removeRow(n);
            this.removeKeyFromMap(string + string2 + n);
        }
    }

    private ISpssVariable convertIntoIspssVariable(String string) {
        Vector<SpssVariable> vector = this.getFactorInteractionList();
        for (SpssVariable spssVariable : vector) {
            if (!spssVariable.getName().equals(string)) continue;
            return spssVariable;
        }
        return null;
    }

    private void initVars() {
        this.mRow = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        this.mMapOfModels = new HashMap();
        this.mSrcVarList = new PlainList(SOURCE_KEY);
        this.mSrcVarList.addFocusListener(this);
        Vector vector = new Vector();
        this.mTableModel = new DefaultTableModel(vector, this.mNamesOfColumns){

            @Override
            public boolean isCellEditable(int n, int n2) {
                if (n2 == 0) {
                    ComplexSamplesGLMTablePanel.this.isCategoryValueValid();
                    return false;
                }
                if (n2 == 1) {
                    ComplexSamplesGLMTablePanel.this.isCategoryValueValid();
                }
                if (ComplexSamplesGLMTablePanel.this.mTableModel.getValueAt(n, 0).toString().contains("*")) {
                    ComplexSamplesGLMTablePanel.this.setBackground(ComplexSamplesGLMTablePanel.this.mArrowButton.getBackground());
                    return false;
                }
                return true;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (object != null && object.toString().length() > 0) {
                    object = ComplexSamplesGLMTablePanel.this.getFirstPartOfCategoryCombo(object.toString());
                }
                super.setValueAt(object, n, n2);
            }
        };
        this.mDisplayTable = new PlainTable();
        this.mDisplayTable.setModel(this.mTableModel);
        JTableHeader jTableHeader = this.mDisplayTable.getTableHeader();
        final Font font = jTableHeader.getFont().deriveFont(1);
        final TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
        jTableHeader.setDefaultRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = null;
                component = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? tableCellRenderer.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                component.setFont(font);
                return component;
            }
        });
        this.mArrowButton = new ComponentsArrowButton();
        this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents(this.mDisplayTable, SpssArrowButton.ButtonOrientation.left);
        this.mArrowButton.addActionListener(new ArrowActionListener());
        ComboboxAction comboboxAction = new ComboboxAction(this.mParent, CATEGORY_CHOICE);
        this.mCategoryCombo = new JComboBox();
        this.mCategoryCombo.setModel(new ComplexSamplesGLMComboBoxModel(arrayList.toArray(), this.mDisplayTable));
        this.mCategoryCombo.setMaximumRowCount(5);
        this.mCategoryCombo.setAction(comboboxAction);
        this.mCategoryCombo.addKeyListener(this);
        JComboBox jComboBox = new JComboBox();
        comboboxAction = new ComboboxAction(this.mParent, CONTRAST_CHOICE);
        jComboBox.setModel(new ComplexSamplesGLMComboBoxModel(arrayList.toArray(), this.mDisplayTable));
        jComboBox.setMaximumRowCount(5);
        jComboBox.setAction(comboboxAction);
        this.mCategoryCombo.setEnabled(false);
        ContrastCellRenderer contrastCellRenderer = new ContrastCellRenderer();
        ContrastCellEditor contrastCellEditor = new ContrastCellEditor(jComboBox);
        this.mDisplayTable.getColumnModel().getColumn(1).setCellRenderer(contrastCellRenderer);
        this.mDisplayTable.getColumnModel().getColumn(1).setCellEditor(contrastCellEditor);
        CategoryCellRenderer categoryCellRenderer = new CategoryCellRenderer();
        CategoryCellEditor categoryCellEditor = new CategoryCellEditor(this.mCategoryCombo);
        this.mDisplayTable.getColumnModel().getColumn(2).setCellRenderer(categoryCellRenderer);
        this.mDisplayTable.getColumnModel().getColumn(2).setCellEditor(categoryCellEditor);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.mDisplayTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mDisplayTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mDisplayTable.getActionMap().put("tabIn", abstractAction2);
        this.mDisplayTable.getActionMap().put("tabOut", abstractAction);
        this.mDisplayTable.setRowHeight(20);
        jTableHeader.setReorderingAllowed(false);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_GLM_DISPLAY_MEAN_CHECK");
        this.mDisplayMeanCheck = new JCheckBox(toggleButtonAction);
        this.mModelStringVector = new Vector();
        this.mDisplayMeanCheck.addMouseListener(this);
        this.mDisplayTable.addKeyListener(this);
        this.mDisplayTable.setSelectionMode(0);
    }

    private JPanel setupPanel() {
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_FACTOR_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_GLM_DISPLAY_LABEL");
        jLabel2.setLabelFor(this.mDisplayTable);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets = DialogUtil.getArrowButtonInsets();
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mTableScrollPane = new JScrollPane(this.mDisplayTable);
        this.mTableScrollPane.setMinimumSize(this.mDisplayTable.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, this.mTableScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mDisplayMeanCheck, gridBagConstraints, 2, 2, 1, 1, n, insets);
        this.mDefaultScrollPaneBorder = this.mTableScrollPane.getBorder();
        return jPanel;
    }

    private ArrayList<String> saveTableModel(DefaultTableModel defaultTableModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = defaultTableModel.getRowCount();
        int n2 = defaultTableModel.getColumnCount();
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                arrayList.add(n3, defaultTableModel.getValueAt(i, j).toString());
                ++n3;
            }
        }
        return arrayList;
    }

    private void removeKeyFromMap(String string) {
        this.mMapOfModels.remove(string.trim());
    }

    private ArrayList<String> getMissingValues(ISpssVariable iSpssVariable) {
        SPSS_Format sPSS_Format = iSpssVariable.getFormat();
        FormatType formatType = sPSS_Format.getFormatType();
        boolean bl = formatType.isStringFormat() || formatType.isDateOrTimeFormat();
        IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
        Set set = iValueLabelMap.getValueLabelEntries();
        int n = 0;
        Object[] objectArray = new String[set.size()];
        for (Map.Entry entry : set) {
            OBS oBS = (OBS)entry.getKey();
            String string = (String)entry.getValue();
            if (oBS.isEmpty()) continue;
            String string2 = bl ? oBS.getString().trim() : CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)sPSS_Format);
            objectArray[n] = string2 + " " + string;
            ++n;
        }
        Arrays.sort(objectArray);
        ArrayList arrayList = new ArrayList();
        arrayList.add("");
        arrayList.addAll(Arrays.asList(objectArray));
        if (arrayList.size() > 1) {
            arrayList.remove(0);
        }
        return arrayList;
    }

    public String getFirstPartOfCategoryCombo(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.hasMoreElements()) {
            return stringTokenizer.nextElement().toString();
        }
        return null;
    }

    private void getValueAtDisplayTable() {
        int n;
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        for (n = 0; n < this.mSrcVarList.getModel().getSize(); ++n) {
            vector.addElement(this.mSrcVarList.getModel().getElementAt(n).toString());
        }
        for (n = 0; n < this.mDisplayTable.getModel().getRowCount(); ++n) {
            if (vector.size() != 0) continue;
            this.mTableModel.removeRow(n);
            bl = true;
        }
        if (bl) {
            try {
                this.mTableModel.removeRow(0);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.mDisplayTable.setModel(this.mTableModel);
        this.mDisplayTable.repaint();
    }

    private boolean isCategoryValueValid() {
        boolean bl = true;
        for (int i = 0; i < this.mDisplayTable.getModel().getRowCount(); ++i) {
            for (int j = 0; j < this.mDisplayTable.getModel().getColumnCount(); ++j) {
                TableCellEditor tableCellEditor = this.mDisplayTable.getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.stopCellEditing();
                    this.mDisplayTable.getSelectionModel().clearSelection();
                }
                if (j != 2) continue;
                OBS oBS = new OBS();
                String string = this.mDisplayTable.getModel().getValueAt(i, 1).toString();
                if (this.mDisplayTable.getModel().getValueAt(i, 0).toString().contains("*") || !string.equals(this.mParent.getResString("IDS_GLM_ESTIMTE_MEANS_SIMPLE_VALUE")) && !string.equals(this.mParent.getResString("IDS_GLM_ESTIMTE_MEANS_DEVIATION_VALUE"))) continue;
                ISpssVariable iSpssVariable = this.convertIntoIspssVariable(this.mDisplayTable.getModel().getValueAt(i, 0).toString());
                if (CellValueFormatter.stringToObs((String)this.mDisplayTable.getModel().getValueAt(i, 2).toString(), (SPSS_Format)iSpssVariable.getFormat(), (OBS)oBS)) {
                    bl = true;
                    continue;
                }
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mParent), this.mParent.getResString("ERR_ESTIMATED_MEANS_CATEGORY_VALUE_ERROR_MESSAGE"), VersionInfo.getAppVersionString());
                this.mDisplayTable.requestFocus();
                this.mDisplayTable.changeSelection(i, 2, false, false);
                return false;
            }
        }
        return bl;
    }

    class CategoryCellEditor
    extends DefaultCellEditor
    implements IRetrieveFormatCallBack {
        JComboBox comboToHold;

        public CategoryCellEditor(JComboBox jComboBox) {
            super(jComboBox);
            this.comboToHold = jComboBox;
            ((JTextField)this.comboToHold.getEditor().getEditorComponent()).setDocument(new VarFormatDocument(this));
        }

        @Override
        public SPSS_Format getCurrentVarFormat() {
            int n = ComplexSamplesGLMTablePanel.this.mDisplayTable.getSelectedRow();
            if (n != -1) {
                String string = ComplexSamplesGLMTablePanel.this.mTableModel.getValueAt(n, 0).toString();
                ISpssVariable iSpssVariable = ComplexSamplesGLMTablePanel.this.convertIntoIspssVariable(string);
                return iSpssVariable.getFormat();
            }
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = ComplexSamplesGLMTablePanel.this.mTableModel.getValueAt(n, 0).toString();
            String string2 = ComplexSamplesGLMTablePanel.this.mTableModel.getValueAt(n, 1).toString();
            ISpssVariable iSpssVariable = ComplexSamplesGLMTablePanel.this.convertIntoIspssVariable(string);
            ArrayList arrayList = ComplexSamplesGLMTablePanel.this.getMissingValues(iSpssVariable);
            if (string2.equals(ComplexSamplesGLMTablePanel.this.mParent.getResString("IDS_GLM_ESTIMTE_MEANS_SIMPLE_VALUE")) || string2.equals(ComplexSamplesGLMTablePanel.this.mParent.getResString("IDS_GLM_ESTIMTE_MEANS_DEVIATION_VALUE"))) {
                this.comboToHold.setEnabled(true);
                String string3 = string + string2 + n;
                if (ComplexSamplesGLMTablePanel.this.mMapOfModels.containsKey(string3.trim())) {
                    this.comboToHold.setModel((ComboBoxModel)ComplexSamplesGLMTablePanel.this.mMapOfModels.get(string3.trim()));
                    ((ComplexSamplesGLMComboBoxModel)this.comboToHold.getModel()).setSelectedItem(object.toString(), n, 2);
                    if (this.comboToHold.getModel().getSize() == 1 && this.comboToHold.getModel().getElementAt(0).equals("")) {
                        this.comboToHold.setEditable(true);
                    } else {
                        this.comboToHold.setEditable(false);
                    }
                } else {
                    ComplexSamplesGLMTablePanel.this.mMapOfModels.put(string3.trim(), new ComplexSamplesGLMComboBoxModel(arrayList.toArray(), ComplexSamplesGLMTablePanel.this.mDisplayTable));
                    this.comboToHold.setModel((ComboBoxModel)ComplexSamplesGLMTablePanel.this.mMapOfModels.get(string3.trim()));
                    ((ComplexSamplesGLMComboBoxModel)this.comboToHold.getModel()).setSelectedItem(object.toString(), n, 2);
                    if (arrayList.size() == 1 && ((String)arrayList.get(0)).equals("")) {
                        this.comboToHold.setEditable(true);
                    } else {
                        this.comboToHold.setEditable(false);
                    }
                }
            } else {
                ((ComplexSamplesGLMComboBoxModel)this.comboToHold.getModel()).setSelectedItem("", n, 2);
                this.comboToHold.setEditable(false);
                this.comboToHold.setEnabled(false);
            }
            ComplexSamplesGLMTablePanel.this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            return this.comboToHold;
        }
    }

    class CategoryCellRenderer
    extends DefaultTableCellRenderer {
        CategoryCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color = ComplexSamplesGLMTablePanel.this.mArrowButton.getBackground();
            String string = ComplexSamplesGLMTablePanel.this.mTableModel.getValueAt(n, 1).toString();
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                string = ComponentState.removeBidiDirectionMarks((String)string);
            }
            if (object != null) {
                if (!string.equals(ComplexSamplesGLMTablePanel.this.mParent.getResString("IDS_GLM_ESTIMTE_MEANS_SIMPLE_VALUE")) && !string.equals(ComplexSamplesGLMTablePanel.this.mParent.getResString("IDS_GLM_ESTIMTE_MEANS_DEVIATION_VALUE"))) {
                    if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                        super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2);
                    } else {
                        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    }
                    this.setBackground(color);
                } else {
                    this.setBackground(Color.WHITE);
                    super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
                String string2 = ComplexSamplesGLMTablePanel.this.getFirstPartOfCategoryCombo(object.toString());
                this.setText(string2);
            }
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }

        @Override
        public void setToolTipText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setToolTipText(string);
            }
        }
    }

    class ContrastCellEditor
    extends DefaultCellEditor {
        JComboBox comboToHold;

        public ContrastCellEditor(JComboBox jComboBox) {
            super(jComboBox);
            this.comboToHold = jComboBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            ComplexSamplesGLMTablePanel.this.mRow = n;
            this.comboToHold.setModel(new ComplexSamplesGLMComboBoxModel(ComplexSamplesGLMTablePanel.this.mParent.getResStringArray("IDS_GLM_COMBO_VALUES"), ComplexSamplesGLMTablePanel.this.mDisplayTable));
            ((ComplexSamplesGLMComboBoxModel)this.comboToHold.getModel()).setSelectedItem(object.toString(), n, 1);
            ComplexSamplesGLMTablePanel.this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            return this.comboToHold;
        }
    }

    class ContrastCellRenderer
    extends DefaultTableCellRenderer {
        ContrastCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                this.setText(object.toString());
            }
            if (ComplexSamplesGLMTablePanel.this.mRow == n) {
                if (ComplexSamplesGLMTablePanel.this.mTableModel.getValueAt(n, n2 + 1) == null || ComplexSamplesGLMTablePanel.this.mTableModel.getValueAt(n, n2 + 1).toString().equals("")) {
                    ComplexSamplesGLMTablePanel.this.mTableModel.setValueAt("", n, n2 + 1);
                }
                if (object != null && !object.toString().equals(ComplexSamplesGLMTablePanel.this.mParent.getResString("IDS_GLM_ESTIMTE_MEANS_SIMPLE_VALUE")) && !object.toString().equals(ComplexSamplesGLMTablePanel.this.mParent.getResString("IDS_GLM_ESTIMTE_MEANS_DEVIATION_VALUE"))) {
                    ComplexSamplesGLMTablePanel.this.mTableModel.setValueAt("", n, n2 + 1);
                }
            }
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }

        @Override
        public void setToolTipText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setToolTipText(string);
            }
        }
    }

    private class ArrowActionListener
    implements ActionListener {
        private ArrowActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ComplexSamplesGLMTablePanel.this.isCategoryValueValid()) {
                return;
            }
            if (ComplexSamplesGLMTablePanel.this.mArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right) {
                int[] nArray = ComplexSamplesGLMTablePanel.this.mSrcVarList.getSelectedIndices();
                String[] stringArray = ComplexSamplesGLMTablePanel.this.mParent.getResStringArray("IDS_GLM_COMBO_VALUES");
                String string = stringArray[0];
                for (int n : nArray) {
                    Object e = ComplexSamplesGLMTablePanel.this.mSrcVarList.getModel().getElementAt(n);
                    if (ComplexSamplesGLMTablePanel.this.mSrcVarList.getSelectedValue().toString().contains("*")) {
                        string = "";
                    }
                    Object[] objectArray = new Object[]{e.toString(), string, ""};
                    ComplexSamplesGLMTablePanel.this.mTableModel.addRow(objectArray);
                    int n2 = ComplexSamplesGLMTablePanel.this.mDisplayTable.getRowCount() - 1;
                    ComplexSamplesGLMTablePanel.this.mDisplayTable.setRowSelectionInterval(n2, n2);
                }
                ComplexSamplesGLMTablePanel.this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
                ComplexSamplesGLMTablePanel.this.mDisplayTable.requestFocus();
                ComplexSamplesGLMTablePanel.this.mDisplayTable.setValueAt(string, ComplexSamplesGLMTablePanel.this.mDisplayTable.getRowCount() - 1, 1);
            } else {
                if (ComplexSamplesGLMTablePanel.this.mDisplayTable.getSelectedRowCount() >= 1) {
                    ComplexSamplesGLMTablePanel.this.repaint();
                    ComplexSamplesGLMTablePanel.this.mDisplayTable.getColumn(ComplexSamplesGLMTablePanel.this.mNamesOfColumns.get(1)).getCellEditor().stopCellEditing();
                    ComplexSamplesGLMTablePanel.this.mDisplayTable.getColumn(ComplexSamplesGLMTablePanel.this.mNamesOfColumns.get(2)).getCellEditor().stopCellEditing();
                    if (ComplexSamplesGLMTablePanel.this.mDisplayTable.getSelectedRowCount() == 1) {
                        int n = ComplexSamplesGLMTablePanel.this.mDisplayTable.getSelectedRow();
                        String string = ComplexSamplesGLMTablePanel.this.mTableModel.getValueAt(ComplexSamplesGLMTablePanel.this.mDisplayTable.getSelectedRow(), 0).toString();
                        String string2 = ComplexSamplesGLMTablePanel.this.mTableModel.getValueAt(ComplexSamplesGLMTablePanel.this.mDisplayTable.getSelectedRow(), 1).toString();
                        ComplexSamplesGLMTablePanel.this.removeKeyFromMap(string + string2 + n);
                        ComplexSamplesGLMTablePanel.this.mTableModel.removeRow(n);
                    } else {
                        int[] nArray = ComplexSamplesGLMTablePanel.this.mDisplayTable.getSelectedRows();
                        for (int i = nArray.length - 1; i >= 0; --i) {
                            String string = ComplexSamplesGLMTablePanel.this.mTableModel.getValueAt(nArray[i], 0).toString();
                            String string3 = ComplexSamplesGLMTablePanel.this.mTableModel.getValueAt(nArray[i], 1).toString();
                            ComplexSamplesGLMTablePanel.this.mTableModel.removeRow(nArray[i]);
                            ComplexSamplesGLMTablePanel.this.removeKeyFromMap(string + string3 + nArray[i]);
                        }
                    }
                }
                ComplexSamplesGLMTablePanel.this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
                ComplexSamplesGLMTablePanel.this.mSrcVarList.requestFocusInWindow();
            }
        }
    }
}

