/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.dialogs.common.AbstractModelSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonDialogType;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesUtils;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.CharacterUtil;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JTextField;

public class ComplexSamplesCommonSyntaxUtils {
    private static String mOutfileDataFile;
    private static String mOutfileModelFile;
    private static DecimalFormatSymbols fSymbol;

    public static String generateModelSyntax(DialogDataModel dialogDataModel, String string, String string2, ComplexSamplesCommonDialogType complexSamplesCommonDialogType) {
        Serializable serializable;
        Object object;
        if (string.trim().length() == 0 && string2.trim().length() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SyntaxUtil.getSubCommand("/MODEL "));
        String string3 = stringBuilder.toString();
        StringBuilder stringBuilder2 = new StringBuilder();
        Boolean bl = dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_MODEL_CUSTOM_RADIOBUTTON");
        if (bl != null && bl.booleanValue()) {
            object = dialogDataModel.getArray(AbstractModelSubDialog.MODEL_TERMS_KEY);
            serializable = ComplexSamplesCommonSyntaxUtils.SyncModelWithFactorAndCovariateLists((Object[])object, string, string2);
            if (((ArrayList)serializable).size() > 0) {
                stringBuilder2.append(((AbstractCollection)((Object)serializable)).toString().replaceAll("[\\[\\],]", ""));
            }
        } else {
            stringBuilder2.append(string).append(" ");
            stringBuilder2.append(string2).append(" ");
        }
        stringBuilder.append(stringBuilder2.toString().trim());
        if (string3.equals(stringBuilder.toString())) {
            return "";
        }
        if (complexSamplesCommonDialogType != ComplexSamplesCommonDialogType.ORDINAL_REGRESSION) {
            stringBuilder.append("\n");
            stringBuilder.append(SyntaxUtil.getSubCommand("/INTERCEPT "));
            object = dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_MODEL_INCLUDE_CHECKBOX");
            serializable = dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_MODEL_DISPLAY_CHECKBOX");
            if (object == null) {
                stringBuilder.append("INCLUDE=YES SHOW=YES");
            } else if (((Boolean)object).booleanValue()) {
                stringBuilder.append("INCLUDE=YES ");
                if (serializable != null && ((Boolean)serializable).booleanValue()) {
                    stringBuilder.append("SHOW=YES");
                } else {
                    stringBuilder.append("SHOW=NO");
                }
            } else {
                stringBuilder.append("INCLUDE=NO");
            }
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private static ArrayList<String> SyncModelWithFactorAndCovariateLists(Object[] objectArray, String string, String string2) {
        String string3 = Arrays.toString(objectArray);
        string3 = string3.replaceAll("[\\[\\],]", "");
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string3.split(" ")));
        ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(string.split(" ")));
        arrayList2.addAll(Arrays.asList(string2.split(" ")));
        ListIterator<String> listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            String string4 = listIterator.next();
            boolean bl = false;
            block1: for (String string5 : arrayList2) {
                if (string4.contains("(") || string4.contains("*")) {
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, "*()");
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList3.add(stringTokenizer.nextToken());
                    }
                    bl = true;
                    block3: for (String string6 : arrayList3) {
                        for (String string7 : arrayList2) {
                            if (!string6.equals(string7)) continue;
                            continue block3;
                        }
                        bl = false;
                        continue block1;
                    }
                    continue;
                }
                if (!string4.equals(string5)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            listIterator.remove();
        }
        return arrayList;
    }

    public static String generateStatisticSyntax(DialogDataModel dialogDataModel, ComplexSamplesCommonDialogType complexSamplesCommonDialogType) {
        StringBuilder stringBuilder = new StringBuilder();
        Boolean bl = complexSamplesCommonDialogType == ComplexSamplesCommonDialogType.LOGLINEAR_REGRESSION || complexSamplesCommonDialogType == ComplexSamplesCommonDialogType.ORDINAL_REGRESSION ? dialogDataModel.getBoolean("IDS_LOGISTIC_REGRESSION_STATISTICS_PSEUDO_CHECKBOX") : dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_ESTIMATE_CHECKBOX");
        if (bl != null) {
            boolean bl2 = false;
            stringBuilder.append(SyntaxUtil.getSubCommand("/STATISTICS"));
            if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_ESTIMATE_CHECKBOX").booleanValue()) {
                stringBuilder.append(" PARAMETER");
                bl2 = true;
            }
            if ((complexSamplesCommonDialogType == ComplexSamplesCommonDialogType.LOGLINEAR_REGRESSION || complexSamplesCommonDialogType == ComplexSamplesCommonDialogType.ORDINAL_REGRESSION) && dialogDataModel.getBoolean("IDS_LOGISTIC_REGRESSION_STATISTICS_EXP_ESTIMATE_CHECKBOX").booleanValue()) {
                stringBuilder.append(" EXP");
                bl2 = true;
            }
            if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_STD_ERROR_CHECKBOX").booleanValue()) {
                stringBuilder.append(" SE");
                bl2 = true;
            }
            if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_CONFIDENCE_INTERVAL_CHECKBOX").booleanValue()) {
                stringBuilder.append(" CINTERVAL");
                bl2 = true;
            }
            if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_T_TEST_CHECKBOX").booleanValue()) {
                stringBuilder.append(" TTEST");
                bl2 = true;
            }
            if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_DESIGN_CHECKBOX").booleanValue()) {
                stringBuilder.append(" DEFF");
                bl2 = true;
            }
            if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_SQUAREROOT_CHECKBOX").booleanValue()) {
                stringBuilder.append(" DEFFSQRT");
                bl2 = true;
            }
            if (complexSamplesCommonDialogType == ComplexSamplesCommonDialogType.ORDINAL_REGRESSION && (dialogDataModel.getBoolean("IDS_CS_ORDINAL_STATISTICS_WALD_CHECKBOX") != null || dialogDataModel.getBoolean("IDS_CS_ORDINAL_STATISTICS_PARAMETER_CHECKBOX") != null || dialogDataModel.getBoolean("IDS_CS_ORDINAL_STATISTICS_GENERALIZED_CHECKBOX") != null)) {
                StringBuilder stringBuilder2 = new StringBuilder();
                Boolean bl3 = dialogDataModel.getBoolean("IDS_CS_ORDINAL_STATISTICS_WALD_CHECKBOX");
                if (bl3 != null && bl3.booleanValue()) {
                    stringBuilder2.append(" TEST");
                }
                if ((bl3 = dialogDataModel.getBoolean("IDS_CS_ORDINAL_STATISTICS_PARAMETER_CHECKBOX")) != null && bl3.booleanValue()) {
                    stringBuilder2.append(" PARAMETER");
                }
                if ((bl3 = dialogDataModel.getBoolean("IDS_CS_ORDINAL_STATISTICS_GENERALIZED_CHECKBOX")) != null && bl3.booleanValue()) {
                    stringBuilder2.append(" COVB");
                }
                if (stringBuilder2.length() > 1) {
                    stringBuilder.append("\n").append(SyntaxUtil.getSubCommand("/NONPARALLEL")).append((CharSequence)stringBuilder2);
                    bl2 = true;
                }
            }
            stringBuilder.append("\n");
            if (!bl2) {
                stringBuilder.setLength(0);
            }
        }
        return stringBuilder.toString();
    }

    public static String generateLogisticPrintSyntax(DialogDataModel dialogDataModel) {
        StringBuilder stringBuilder = new StringBuilder();
        Boolean bl = dialogDataModel.getBoolean("IDS_LOGISTIC_REGRESSION_STATISTICS_PSEUDO_CHECKBOX");
        stringBuilder.append(SyntaxUtil.getSubCommand("/PRINT"));
        if (bl == null) {
            stringBuilder.append(" SUMMARY");
            stringBuilder.append(" VARIABLEINFO");
            stringBuilder.append(" SAMPLEINFO");
            stringBuilder.append(ComplexSamplesCommonSyntaxUtils.generateHistorySyntax(dialogDataModel));
            stringBuilder.append(SyntaxUtil.terminateSyntax());
        } else {
            String string;
            int n = 0;
            if (bl.booleanValue()) {
                stringBuilder.append(" SUMMARY");
                ++n;
            }
            if (dialogDataModel.getBoolean("IDS_LOGISTIC_REGRESSION_STATISTICS_CLASSIFICATION_CHECKBOX").booleanValue()) {
                stringBuilder.append(" CLASSTABLE");
                ++n;
            }
            if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_COVARIANCE_CHECKBOX").booleanValue()) {
                stringBuilder.append(" COVB");
                ++n;
            }
            if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_CORRELATION_CHECKBOX").booleanValue()) {
                stringBuilder.append(" CORB");
                ++n;
            }
            if (dialogDataModel.getBoolean("IDS_LOGISTIC_REGRESSION_STATISTICS_SUMMARY_CHECKBOX").booleanValue()) {
                stringBuilder.append(" VARIABLEINFO");
                ++n;
            }
            if (dialogDataModel.getBoolean("IDS_LOGISTIC_REGRESSION_STATISTICS_SAMPLE_CHECKBOX").booleanValue()) {
                stringBuilder.append(" SAMPLEINFO");
                ++n;
            }
            if ((string = ComplexSamplesCommonSyntaxUtils.generateHistorySyntax(dialogDataModel)).trim().length() > 0) {
                stringBuilder.append(string);
                ++n;
            }
            if (n == 0) {
                stringBuilder.append(" NONE");
            }
            stringBuilder.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuilder.toString();
    }

    public static String generateGLMPrintSyntax(DialogDataModel dialogDataModel) {
        StringBuilder stringBuilder = new StringBuilder();
        Boolean bl = dialogDataModel.getBoolean("IDS_LOGISTIC_REGRESSION_STATISTICS_MODEL_FIT_LABEL");
        stringBuilder.append(SyntaxUtil.getSubCommand("/PRINT"));
        if (bl == null) {
            stringBuilder.append(" SUMMARY");
            stringBuilder.append(" VARIABLEINFO");
            stringBuilder.append(" SAMPLEINFO");
            stringBuilder.append("\n");
        } else {
            boolean bl2 = false;
            if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_COVARIANCE_CHECKBOX").booleanValue()) {
                stringBuilder.append(" COVB");
                bl2 = true;
            }
            if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_CORRELATION_CHECKBOX").booleanValue()) {
                stringBuilder.append(" CORB");
                bl2 = true;
            }
            if (bl.booleanValue()) {
                stringBuilder.append(" SUMMARY");
                bl2 = true;
            }
            if (dialogDataModel.getBoolean("IDS_GENERAL_LINEAR_MODEL_POPULATION_CHECK").booleanValue()) {
                stringBuilder.append(" VARIABLEINFO");
                bl2 = true;
            }
            if (dialogDataModel.getBoolean("IDS_LOGISTIC_REGRESSION_STATISTICS_SAMPLE_CHECKBOX").booleanValue()) {
                stringBuilder.append(" SAMPLEINFO");
                bl2 = true;
            }
            if (!bl2) {
                stringBuilder.append(" NONE");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static String generateHypothesisTestSyntax(DialogDataModel dialogDataModel) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SyntaxUtil.getSubCommand("/TEST TYPE="));
        Boolean bl = dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_F_RADIOBUTTON");
        if (bl == null) {
            stringBuilder.append("F PADJUST=LSD\n");
        } else {
            if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_F_RADIOBUTTON").booleanValue()) {
                stringBuilder.append("F");
            } else if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_ADJUSTED_F_RADIOBUTTON").booleanValue()) {
                stringBuilder.append("ADJF");
            } else if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_CHISQUARE_RADIOBUTTON").booleanValue()) {
                stringBuilder.append("CHISQUARE");
            } else if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_ADJUSTED_CHISQUARE_RADIOBUTTON").booleanValue()) {
                stringBuilder.append("ADJCHISQUARE");
            }
            stringBuilder.append(" PADJUST=");
            if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_LEAST_RADIOBUTTON").booleanValue()) {
                stringBuilder.append("LSD");
            } else if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_SEQUENTIAL_SIDAK_RADIOBUTTON").booleanValue()) {
                stringBuilder.append("SEQSIDAK");
            } else if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_SEQUENTIAL_BONFERRONI_RADIOBUTTON").booleanValue()) {
                stringBuilder.append("SEQBONFERRONI");
            } else if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_SIDAK_RADIOBUTTON").booleanValue()) {
                stringBuilder.append("SIDAK");
            } else if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_BONFERRONI_RADIOBUTTON").booleanValue()) {
                stringBuilder.append("BONFERRONI");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static String generateLogisticSaveSyntax(DialogDataModel dialogDataModel) {
        mOutfileDataFile = null;
        mOutfileModelFile = null;
        StringBuilder stringBuilder = new StringBuilder();
        Boolean bl = dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_SAVE_PREDICTED_CAT_CHECKBOX");
        if (bl != null) {
            if (bl.booleanValue() || dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_SAVE_PREDICTED_PROB_CHECKBOX").booleanValue()) {
                stringBuilder.append(SyntaxUtil.getSubCommand("/SAVE"));
                if (bl.booleanValue()) {
                    stringBuilder.append(" PREDVAL");
                }
                if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_SAVE_PREDICTED_PROB_CHECKBOX").booleanValue()) {
                    stringBuilder.append(" PREDPROB");
                }
                stringBuilder.append("\n");
            }
            ComplexSamplesCommonSyntaxUtils.commonSaveSyntax(dialogDataModel, stringBuilder);
        }
        return stringBuilder.toString();
    }

    public static String generateLogisticOddsRatiosSyntax(DialogDataModel dialogDataModel, BaseDialog baseDialog, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<Integer, Object> hashMap = dialogDataModel.getMap("FactorTableData");
        ComplexSamplesCommonSyntaxUtils.generateOddsSyntax(hashMap, baseDialog, "FACTOR", stringBuilder, bl);
        HashMap<Integer, Object> hashMap2 = dialogDataModel.getMap("CovariateTableData");
        ComplexSamplesCommonSyntaxUtils.generateOddsSyntax(hashMap2, baseDialog, "COVARIATE", stringBuilder, bl);
        return stringBuilder.toString();
    }

    public static String generateGeneralSaveSyntax(DialogDataModel dialogDataModel) {
        mOutfileDataFile = null;
        mOutfileModelFile = null;
        StringBuilder stringBuilder = new StringBuilder();
        Boolean bl = dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_GENERAL_LINEAR_SAVE_PREDICTED_VALUES_CHECKBOX");
        if (bl != null) {
            if (bl.booleanValue() || dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_GENERAL_LINEAR_SAVE_RESIDUALS_CHECKBOX").booleanValue()) {
                stringBuilder.append(SyntaxUtil.getSubCommand("/SAVE"));
                if (bl.booleanValue()) {
                    stringBuilder.append(" PRED");
                }
                if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_GENERAL_LINEAR_SAVE_RESIDUALS_CHECKBOX").booleanValue()) {
                    stringBuilder.append(" RESID");
                }
                stringBuilder.append("\n");
            }
            ComplexSamplesCommonSyntaxUtils.commonSaveSyntax(dialogDataModel, stringBuilder);
        }
        return stringBuilder.toString();
    }

    public static String generateMissingValuesSyntax(DialogDataModel dialogDataModel) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SyntaxUtil.getSubCommand("/MISSING CLASSMISSING="));
        Boolean bl = dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_OPTIONS_INVALID_RADIOBUTTON");
        if (bl != null) {
            if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_OPTIONS_INVALID_RADIOBUTTON").booleanValue()) {
                stringBuilder.append("EXCLUDE\n");
            } else if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_OPTIONS_VALID_RADIOBUTTON").booleanValue()) {
                stringBuilder.append("INCLUDE\n");
            }
        } else {
            stringBuilder.append("EXCLUDE\n");
        }
        return stringBuilder.toString();
    }

    public static String generateOptionsSyntax(DialogDataModel dialogDataModel, ComplexSamplesCommonDialogType complexSamplesCommonDialogType) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SyntaxUtil.getSubCommand("/CRITERIA"));
        String string = dialogDataModel.getString("IDS_LOGISTIC_REGRESSION_OPTIONS_MAX_ITERATION_LABEL");
        if (string == null) {
            stringBuilder.append(" MXITER=100");
            stringBuilder.append(" MXSTEP=5");
            stringBuilder.append(" PCONVERGE=[1e-006 RELATIVE] LCONVERGE=[0]");
            if (complexSamplesCommonDialogType == ComplexSamplesCommonDialogType.ORDINAL_REGRESSION) {
                stringBuilder.append(" METHOD=NEWTON");
            }
            stringBuilder.append(" CHKSEP=20");
            stringBuilder.append(" CILEVEL=95");
        } else {
            String string2;
            int n;
            stringBuilder.append(" MXITER=").append(string);
            stringBuilder.append(" MXSTEP=").append(dialogDataModel.getString("IDS_LOGISTIC_REGRESSION_OPTIONS_MAX_STEP_LABEL"));
            stringBuilder.append(" PCONVERGE=[");
            if (dialogDataModel.getBoolean("IDS_LOGISTIC_REGRESSION_OPTIONS_LIMIT_ITERATIONS_PARA_ESTIMATES_CHECKBOX").booleanValue()) {
                object = dialogDataModel.getString("MIN_CHANGE_PARAMETER_KEY");
                n = dialogDataModel.getInteger("TYPE_PARAMETER_KEY") == 0 ? 13 : 13;
                stringBuilder.append(ComplexSamplesCommonSyntaxUtils.formattedSyntaxString((String)object, n));
                string2 = dialogDataModel.getInteger("TYPE_PARAMETER_KEY") == 1 ? "ABSOLUTE" : "RELATIVE";
                stringBuilder.append(" ").append(string2).append("]");
            } else {
                stringBuilder.append("0]");
            }
            stringBuilder.append(" LCONVERGE=[");
            if (dialogDataModel.getBoolean("IDS_LOGISTIC_REGRESSION_OPTIONS_LIMIT_ITERATIONS_LOG_CHECKBOX").booleanValue()) {
                object = dialogDataModel.getString("MIN_CHANGE_LOG_KEY");
                n = dialogDataModel.getInteger("TYPE_LOG_KEY") == 0 ? 13 : 13;
                stringBuilder.append(ComplexSamplesCommonSyntaxUtils.formattedSyntaxString((String)object, n));
                string2 = dialogDataModel.getInteger("TYPE_LOG_KEY") == 1 ? "ABSOLUTE" : "RELATIVE";
                stringBuilder.append(" ").append(string2).append("]");
            } else {
                stringBuilder.append("0]");
            }
            if (complexSamplesCommonDialogType == ComplexSamplesCommonDialogType.ORDINAL_REGRESSION && dialogDataModel.getBoolean("IDS_CS_ORDINAL_NEWTON_RADIO") != null) {
                object = dialogDataModel.getBoolean("IDS_CS_ORDINAL_NEWTON_RADIO");
                if (object != null && ((Boolean)object).booleanValue()) {
                    stringBuilder.append(" METHOD=NEWTON");
                } else {
                    object = dialogDataModel.getBoolean("IDS_CS_ORDINAL_FISHER_RADIO");
                    if (object != null && ((Boolean)object).booleanValue()) {
                        stringBuilder.append(" METHOD=FISHER");
                    } else {
                        object = dialogDataModel.getBoolean("IDS_CS_ORDINAL_NEW_FISHER_RADIO");
                        if (object != null && ((Boolean)object).booleanValue()) {
                            stringBuilder.append(" METHOD=FISHER(").append(dialogDataModel.getString("IDS_CS_ORDINAL_BEFORE_SWITCHING_FIELD")).append(")");
                        }
                    }
                }
            }
            if (dialogDataModel.getBoolean("IDS_LOGISTIC_REGRESSION_OPTIONS_CHECK_DATAPOINTS_CHECKBOX").booleanValue()) {
                stringBuilder.append(" CHKSEP=");
                stringBuilder.append(dialogDataModel.getString("IDS_LOGISTIC_REGRESSION_OPTIONS_START_ITERATION_LABEL"));
            } else {
                stringBuilder.append(" CHKSEP=0");
            }
            stringBuilder.append(" CILEVEL=");
            object = dialogDataModel.getString("CONFIDENCE_TEXT_KEY");
            stringBuilder.append((String)object);
        }
        object = dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_BONFERRONI_RADIOBUTTON");
        if (object != null) {
            stringBuilder.append(ComplexSamplesCommonSyntaxUtils.generateDegreesOfFreedomSyntax(dialogDataModel));
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public static String generateCriteriaSyntax(DialogDataModel dialogDataModel) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SyntaxUtil.getSubCommand("/CRITERIA"));
        String string = dialogDataModel.getString("CONFIDENCE_TEXT_KEY");
        if (string == null) {
            stringBuilder.append(" CILEVEL=95");
        } else {
            stringBuilder.append(" CILEVEL=");
            stringBuilder.append(string);
        }
        Boolean bl = dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_FIXED_RADIOBUTTON");
        String string2 = dialogDataModel.getString("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_VALUE_LABEL");
        if (bl != null && bl.booleanValue() && string2 != null) {
            stringBuilder.append(" DF=").append(string2);
        }
        stringBuilder.append(SyntaxUtil.terminateSyntax());
        return stringBuilder.toString();
    }

    public static boolean isEnabledTextFieldEmpty(JTextField jTextField) {
        return jTextField.isEnabled() && jTextField.getText().length() == 0;
    }

    public static String getOrdinalSaveDialogSyntax(DialogDataModel dialogDataModel) {
        String string;
        Boolean bl;
        Map.Entry<String, String> entry2;
        mOutfileDataFile = null;
        mOutfileModelFile = null;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        StringBuffer stringBuffer2 = new StringBuffer();
        LinkedHashMap<String, String> linkedHashMap = ComplexSamplesCommonSyntaxUtils.getOrdinalSaveMap();
        int n = 0;
        for (Map.Entry<String, String> entry2 : linkedHashMap.entrySet()) {
            bl = dialogDataModel.getBoolean(entry2.getKey());
            if (bl != null && bl.booleanValue()) {
                if (!bl2) {
                    stringBuffer.append(SyntaxUtil.getSubCommand("/SAVE "));
                    bl2 = true;
                } else {
                    stringBuffer2.append(" ");
                }
                stringBuffer2.append((String)entry2.getValue()).append(" (");
                string = "SAVE_TEXT_FIELD" + n;
                stringBuffer2.append(dialogDataModel.getString(string)).append(")");
            }
            ++n;
        }
        StringBuffer stringBuffer3 = new StringBuffer();
        bl = dialogDataModel.getBoolean("IDS_CS_ORDINAL_SAVE_EXPORT_MODEL_CHECK");
        entry2 = dialogDataModel.getBoolean("IDS_CS_ORDINAL_SAVE_EXPORT_XML_CHECK");
        if (bl != null && bl.booleanValue() || entry2 != null && ((Boolean)((Object)entry2)).booleanValue()) {
            stringBuffer3.append("\n").append(SyntaxUtil.getSubCommand("/OUTFILE "));
        }
        if (bl != null && bl.booleanValue()) {
            bl = dialogDataModel.getBoolean("IDS_CS_ORDINAL_SAVE_COVARIANCE_RADIO");
            string = bl != null && bl != false ? "COVB" : "CORB";
            bl = dialogDataModel.getBoolean("IDS_CS_ORDINAL_SAVE_CREATE_DATA_RADIO");
            if (bl != null && bl.booleanValue()) {
                stringBuffer3.append(string).append("=").append(CharacterUtil.smartQuote((String)dialogDataModel.getString("IDS_DATA_SET_TEXT_FIELD")));
            } else {
                mOutfileDataFile = dialogDataModel.getString("IDS_DATASET_FILE_TEXT_FIELD");
                stringBuffer3.append(string).append("=").append(CharacterUtil.smartQuote((String)mOutfileDataFile));
            }
        }
        if ((bl = dialogDataModel.getBoolean("IDS_CS_ORDINAL_SAVE_EXPORT_XML_CHECK")) != null && bl.booleanValue()) {
            bl = dialogDataModel.getBoolean("IDS_CS_ORDINAL_SAVE_XML_COVARIANCE_RADIO");
            mOutfileModelFile = dialogDataModel.getString("IDS_CS_ORDINAL_SAVE_DATA_FILE_PATH");
            if (bl != null && bl.booleanValue()) {
                stringBuffer3.append(" MODEL=").append(CharacterUtil.smartQuote((String)mOutfileModelFile));
            } else {
                stringBuffer3.append(" PARAMETER=").append(CharacterUtil.smartQuote((String)mOutfileModelFile));
            }
        }
        if (!stringBuffer3.toString().trim().equals("")) {
            stringBuffer2.append(stringBuffer3);
        }
        if (stringBuffer2.toString().trim().equals("")) {
            return "";
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append(stringBuffer2.toString());
        } else if (stringBuffer2.substring(0, 1).equals("\n")) {
            stringBuffer.append(stringBuffer2.substring(1));
        } else {
            stringBuffer.append(stringBuffer2.toString());
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static String formattedSyntaxString(String string) {
        if (string.startsWith("0.0000") || string.startsWith(".0000")) {
            double d = Double.parseDouble(string);
            String string2 = string.substring(string.indexOf(".") + 1);
            String string3 = "#";
            for (int i = 1; i < string2.length(); ++i) {
                string3 = string3 + "#";
            }
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(ResUtil.getLocale());
            decimalFormat.applyPattern("0." + string3 + "E000");
            return decimalFormat.format(d);
        }
        if (string.startsWith(".")) {
            return "0" + string;
        }
        return string;
    }

    private static void generateOddsSyntax(HashMap<Integer, Object> hashMap, BaseDialog baseDialog, String string, StringBuilder stringBuilder, boolean bl) {
        if (hashMap != null) {
            for (Integer n : hashMap.keySet()) {
                String[] stringArray = (String[])hashMap.get(n);
                String string2 = bl ? stringArray[0].substring(stringArray[0].indexOf("[") + 1, stringArray[0].indexOf("]")) : stringArray[0];
                stringBuilder.append(SyntaxUtil.getSubCommand("/ODDSRATIOS ")).append(string).append("=[").append(string2);
                if (stringArray[1].equals(baseDialog.getResString("IDS_LOGISTIC_REGRESSION_ODDS_RATIOS_COMBOBOX_HIGHEST_OPTION"))) {
                    stringBuilder.append("(HIGH)]\n");
                    continue;
                }
                if (stringArray[1].equals(baseDialog.getResString("IDS_LOGISTIC_REGRESSION_ODDS_RATIOS_COMBOBOX_LOWEST_OPTION"))) {
                    stringBuilder.append("(LOW)]\n");
                    continue;
                }
                if (string.equals("FACTOR")) {
                    LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
                    ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
                    boolean bl2 = false;
                    int n2 = iSpssDataSrc.findVarIndex(string2);
                    if (n2 > -1) {
                        ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n2);
                        Map<String, String> map = ComplexSamplesUtils.getMissingValuesMap(iSpssVariable);
                        String string3 = map.get(stringArray[1]);
                        string3 = iSpssVariable.getFormat().getFormatType().isStringFormat() ? "'" + string3 + "'" : string3.replace(",", ".");
                        stringBuilder.append("(").append(string3).append(")]\n");
                        bl2 = true;
                    }
                    if (bl2) continue;
                    stringBuilder.append("(HIGH)]\n");
                    continue;
                }
                stringBuilder.append("(").append(stringArray[1]).append(")]\n");
            }
        }
    }

    private static void commonSaveSyntax(DialogDataModel dialogDataModel, StringBuilder stringBuilder) {
        if (dialogDataModel.getString("IDS_FILE_SPSS_PANEL") != null || dialogDataModel.getString("IDS_FILE_XML_PANEL") != null) {
            String string = stringBuilder.toString();
            stringBuilder.append(SyntaxUtil.getSubCommand("/OUTFILE"));
            int n = 0;
            StringBuilder stringBuilder2 = new StringBuilder();
            if (dialogDataModel.getString("IDS_FILE_SPSS_PANEL") != null) {
                if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_SAVE_PARAMETER_COVARIANCE_SPSS_RADIOBUTTON").booleanValue()) {
                    stringBuilder2.append(" COVB=");
                } else if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_SAVE_PARAMETER_CORRELATION_RADIOBUTTON").booleanValue()) {
                    stringBuilder2.append(" CORB=");
                }
                if (dialogDataModel.getString("IDS_FILE_SPSS_PANEL").trim().length() > 0) {
                    mOutfileDataFile = dialogDataModel.getString("IDS_FILE_SPSS_PANEL");
                    stringBuilder2.append(CharacterUtil.smartQuote((String)mOutfileDataFile));
                    stringBuilder.append(stringBuilder2.toString());
                    ++n;
                }
                stringBuilder2.setLength(0);
            }
            if (dialogDataModel.getString("IDS_FILE_XML_PANEL") != null) {
                if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_SAVE_PARAMETER_COVARIANCE_XML_RADIOBUTTON").booleanValue()) {
                    stringBuilder2.append(" MODEL=");
                } else if (dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_SAVE_PARAMETER_ESTIMATES_ONLY_RADIOBUTTON").booleanValue()) {
                    stringBuilder2.append(" PARAMETER=");
                }
                if (dialogDataModel.getString("IDS_FILE_XML_PANEL").trim().length() > 0) {
                    mOutfileModelFile = dialogDataModel.getString("IDS_FILE_XML_PANEL");
                    stringBuilder2.append(CharacterUtil.smartQuote((String)mOutfileModelFile));
                    stringBuilder.append(stringBuilder2.toString());
                    ++n;
                }
                stringBuilder2.setLength(0);
            }
            if (n == 0) {
                stringBuilder.setLength(0);
                stringBuilder.append(string);
            } else {
                stringBuilder.append("\n");
            }
        }
    }

    public static String commonPerAttributesSyntax() {
        String string;
        String string2 = "";
        PesFile pesFile = PES_Repository.getPesFile((String)mOutfileDataFile);
        if (pesFile != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            string2 = string2 + string;
        }
        if ((pesFile = PES_Repository.getPesFile((String)mOutfileModelFile)) != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            string2 = string2 + string;
        }
        return string2;
    }

    public static String formattedSyntaxString(String string, int n) {
        if ((string = string.replace(fSymbol.getDecimalSeparator(), '.')).indexOf(".") == -1) {
            return string;
        }
        if (string.startsWith("0.")) {
            double d = Double.parseDouble(string);
            String string2 = string.substring(string.indexOf(".") + 1);
            String string3 = "#";
            for (int i = 1; i < string2.length(); ++i) {
                string3 = string3 + "#";
            }
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(ResUtil.getLocale());
            decimalFormat.applyPattern("0." + string3 + "E000");
            return decimalFormat.format(d);
        }
        String string4 = string.substring(string.indexOf(".") + 1);
        if (string4.length() > n) {
            String string5 = string.substring(0, string.indexOf("."));
            string5 = string5 + "." + string4.substring(0, n);
            return string5;
        }
        double d = Double.parseDouble(string);
        Formatter formatter = new Formatter().format(Locale.ENGLISH, "%." + string4.length() + "f", d);
        return formatter.toString();
    }

    private static String generateDegreesOfFreedomSyntax(DialogDataModel dialogDataModel) {
        StringBuilder stringBuilder = new StringBuilder();
        Boolean bl = dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_FIXED_RADIOBUTTON");
        String string = dialogDataModel.getString("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_VALUE_LABEL");
        if (bl != null && bl.booleanValue() && string != null) {
            stringBuilder.append(" DF=").append(string);
        }
        return stringBuilder.toString();
    }

    private static String generateHistorySyntax(DialogDataModel dialogDataModel) {
        StringBuilder stringBuilder = new StringBuilder();
        Boolean bl = dialogDataModel.getBoolean("IDS_LOGISTIC_REGRESSION_OPTIONS_DISPLAY_ITERATION_CHECKBOX");
        if (bl != null && bl.booleanValue()) {
            stringBuilder.append(" HISTORY(").append(dialogDataModel.getString("IDS_LOGISTIC_REGRESSION_OPTIONS_INCREMENT_LABEL")).append(")");
        }
        return stringBuilder.toString();
    }

    private static LinkedHashMap<String, String> getOrdinalSaveMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("IDS_CS_ORDINAL_SAVE_CHECK0", "PREDVAL");
        linkedHashMap.put("IDS_CS_ORDINAL_SAVE_CHECK1", "PREDVALPROB");
        linkedHashMap.put("IDS_CS_ORDINAL_SAVE_CHECK2", "OBSVALPROB");
        linkedHashMap.put("IDS_CS_ORDINAL_SAVE_CHECK3", "CUMPROB");
        linkedHashMap.put("IDS_CS_ORDINAL_SAVE_CHECK4", "PREDPROB");
        return linkedHashMap;
    }

    static {
        fSymbol = new DecimalFormatSymbols(UIToolResUtil.getSPSSLocale());
    }
}

