/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFile;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class ComplexSamplesCommonSave
extends BaseSubDialog {
    public static final String FILE_PATH_SPSS_PANEL = "IDS_FILE_SPSS_PANEL";
    public static final String FILE_PATH_XML_PANEL = "IDS_FILE_XML_PANEL";
    private GridBagConstraints mConstraints;
    private Insets mInsets;
    private JCheckBox mSaveVariablesCheckBox1;
    private JCheckBox mSaveVariablesCheckBox2;
    private FileTextField mSpssFileTextField;
    private FileTextField mXmlFileTextField;
    private JButton mBrowseSpssButton;
    private JButton mBrowseXmlButton;
    private JRadioButton mCovarianceSPSSRadioButton;
    private JRadioButton mCorrelationsSPSSRadioButton;
    private JRadioButton mCovarianceXMLRadioButton;
    private JRadioButton mEstimatesOnlyRadioButton;
    private Vector<Object> mFocus;

    public ComplexSamplesCommonSave(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        if (this.getTitle().equals(this.getResString("IDS_COMPLEX_SAMPLES_COMMON_SAVE_TITLE"))) {
            return "idh_idd_cslr_save";
        }
        return "idh_idd_csgl_save";
    }

    @Override
    public boolean continuePressed() {
        return this.validateFilePath();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setSavePanel(jPanel);
        Vector<Object> vector = this.mFocus;
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            Component component = this.mCmdButtonPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private void initVars() {
        this.mFocus = new Vector();
        this.mConstraints = new GridBagConstraints();
        this.mInsets = new Insets(0, 0, 0, 0);
        if (this.getTitle().equals(this.getResString("IDS_COMPLEX_SAMPLES_COMMON_SAVE_TITLE"))) {
            this.mSaveVariablesCheckBox1 = new JCheckBox(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_SAVE_PREDICTED_CAT_CHECKBOX"));
            this.mSaveVariablesCheckBox2 = new JCheckBox(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_SAVE_PREDICTED_PROB_CHECKBOX"));
        } else if (this.getTitle().equals(this.getResString("IDS_COMPLEX_SAMPLES_GLM_SAVE_TITLE"))) {
            this.mSaveVariablesCheckBox1 = new JCheckBox(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_GENERAL_LINEAR_SAVE_PREDICTED_VALUES_CHECKBOX"));
            this.mSaveVariablesCheckBox2 = new JCheckBox(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_GENERAL_LINEAR_SAVE_RESIDUALS_CHECKBOX"));
        }
        this.mSpssFileTextField = new FileTextField();
        this.mSpssFileTextField.setColumns(31);
        this.mSpssFileTextField.setAction(new TextFieldAction(this, FILE_PATH_SPSS_PANEL));
        this.mXmlFileTextField = new FileTextField();
        this.mXmlFileTextField.setColumns(31);
        this.mXmlFileTextField.setAction(new TextFieldAction(this, FILE_PATH_XML_PANEL));
        this.mBrowseSpssButton = new JButton(new BrowseButton(this, "IDS_COMPLEX_SAMPLES_COMMON_SAVE_DATA_BROWSE_BUTTON"));
        this.mBrowseXmlButton = new JButton(new BrowseButton(this, "IDS_COMPLEX_SAMPLES_COMMON_SAVE_XML_BROWSE_BUTTON"));
        this.mCovarianceSPSSRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_SAVE_PARAMETER_COVARIANCE_SPSS_RADIOBUTTON"));
        this.mCorrelationsSPSSRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_SAVE_PARAMETER_CORRELATION_RADIOBUTTON"));
        this.mCovarianceXMLRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_SAVE_PARAMETER_COVARIANCE_XML_RADIOBUTTON"));
        this.mEstimatesOnlyRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_SAVE_PARAMETER_ESTIMATES_ONLY_RADIOBUTTON"));
    }

    private void setDefaults() {
        this.mCovarianceSPSSRadioButton.setSelected(true);
        this.mCovarianceXMLRadioButton.setSelected(true);
    }

    private boolean validateFilePath() {
        boolean bl;
        boolean bl2;
        String string = this.mSpssFileTextField.getText();
        if (string != null && string.length() > 0 && !(bl2 = FileValidator.validatePath((Component)((Object)this), string, true, DataServerProxy.getDataProxy().isRemoteConnection()))) {
            this.mSpssFileTextField.requestFocus();
            return false;
        }
        String string2 = this.mXmlFileTextField.getText();
        if (string2 != null && string2.length() > 0 && !(bl = FileValidator.validatePath((Component)((Object)this), string, true, DataServerProxy.getDataProxy().isRemoteConnection()))) {
            this.mXmlFileTextField.requestFocus();
            return false;
        }
        return true;
    }

    private boolean warningDialog(String string) {
        int n;
        if (string.indexOf(".") != -1 && string.indexOf(File.separator) != -1 && (n = string.lastIndexOf(File.separator) + 1) != string.length()) {
            File[] fileArray;
            String string2 = string.substring(n);
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
            String string3 = remoteFileChooser.getFileSystemView().getDefaultDirectory().getAbsolutePath();
            FileSystemView fileSystemView = remoteFileChooser.getFileSystemView();
            for (File file : fileArray = fileSystemView.getFiles((File)new RefFile(string3), false)) {
                String string4;
                int n2;
                if (!file.getName().toString().equals(string2) || (n2 = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mParentDlg), string4 = String.format(this.getResString("ERR_PROXSCAL_EXISTING_ERROR_MESSAGE"), string), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) == 0) continue;
                return false;
            }
        }
        return true;
    }

    private void setSavePanel(JPanel jPanel) {
        JPanel jPanel2 = this.setupSaveVariablesPanel();
        JPanel jPanel3 = this.setupExportSPSSDataPanel();
        JPanel jPanel4 = this.setupExportXMLPanel();
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel3, this.mConstraints, 0, 1, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel4, this.mConstraints, 0, 2, 1, 1, n, null);
    }

    private JPanel setupSaveVariablesPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mSaveVariablesCheckBox1, this.mSaveVariablesCheckBox2};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_COMPLEX_SAMPLES_COMMON_SAVE_SAVE_VARIABLES_LABEL"));
        DialogUtil.createButtonGroup(jPanel);
        this.mFocus.add(this.mSaveVariablesCheckBox1);
        this.mFocus.add(this.mSaveVariablesCheckBox2);
        return jPanel;
    }

    private JPanel setupExportSPSSDataPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_COMPLEX_SAMPLES_COMMON_SAVE_EXPORT_MODEL_SPSS_LABEL")));
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_COMPLEX_SAMPLES_COMMON_SAVE_FILE_LABEL");
        jLabel.setLabelFor((Component)((Object)this.mSpssFileTextField));
        this.mInsets.set(10, 15, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mConstraints, 0, 0, 1, 1, n2, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(10, 10, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mSpssFileTextField), this.mConstraints, 1, 0, 1, 1, n2, this.mInsets);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.fill = 0;
        this.mInsets.set(10, 10, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mBrowseSpssButton, this.mConstraints, 2, 0, 1, 1, n2, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mInsets.set(insets.top, 15, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mCovarianceSPSSRadioButton, this.mConstraints, 1, 1, 1, 1, n2, this.mInsets);
        this.mConstraints.weighty = 1.0;
        this.mInsets.set(0, 15, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mCorrelationsSPSSRadioButton, this.mConstraints, 1, 2, 1, 1, n2, this.mInsets);
        SpssButtonGroup spssButtonGroup = DialogUtil.createButtonGroup(jPanel);
        this.mFocus.add(this.mSpssFileTextField);
        this.mFocus.add(this.mBrowseSpssButton);
        this.mFocus.add(spssButtonGroup);
        return jPanel;
    }

    private JPanel setupExportXMLPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_COMPLEX_SAMPLES_COMMON_SAVE_EXPORT_MODEL_XML_LABEL")));
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_COMPLEX_SAMPLES_COMMON_SAVE_FILE_LABEL1");
        jLabel.setLabelFor((Component)((Object)this.mXmlFileTextField));
        this.mInsets.set(10, 15, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mConstraints, 0, 0, 1, 1, n2, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(10, 10, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mXmlFileTextField), this.mConstraints, 1, 0, 1, 1, n2, this.mInsets);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.fill = 0;
        this.mInsets.set(10, 10, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mBrowseXmlButton, this.mConstraints, 2, 0, 1, 1, n2, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mInsets.set(insets.top, 15, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mCovarianceXMLRadioButton, this.mConstraints, 1, 1, 1, 1, n2, this.mInsets);
        this.mConstraints.weighty = 1.0;
        this.mInsets.set(0, 15, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mEstimatesOnlyRadioButton, this.mConstraints, 1, 2, 1, 1, n2, this.mInsets);
        SpssButtonGroup spssButtonGroup = DialogUtil.createButtonGroup(jPanel);
        this.mFocus.add(this.mXmlFileTextField);
        this.mFocus.add(this.mBrowseXmlButton);
        this.mFocus.add(spssButtonGroup);
        return jPanel;
    }

    private String getSelectedFilePath(JButton jButton) {
        String string;
        String string2;
        String string3;
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        if (jButton == this.mBrowseSpssButton) {
            string3 = this.getResString("IDS_COMPLEX_SAMPLES_COMMON_SAVE_SPSS_FILE_DIALOG_TITLE");
            string2 = this.getResString("IDS_COMPLEX_SAMPLES_COMMON_SAVE_SPSS_FILE_FILTER");
            string = this.getResString("IDS_COMPLEX_SAMPLES_COMMON_SAVE_SPSS_FILE_EXTENSION");
        } else {
            string3 = this.getResString("IDS_COMPLEX_SAMPLES_COMMON_SAVE_XML_FILE_DIALOG_TITLE");
            string2 = this.getResString("IDS_COMPLEX_SAMPLES_COMMON_SAVE_XML_FILE_FILTER");
            string = this.getResString("IDS_COMPLEX_SAMPLES_COMMON_SAVE_XML_FILE_EXTENSION");
        }
        remoteFileChooser.setDialogTitle(string3);
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(string2, string));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        remoteFileChooser.setFileSelectionMode(0);
        int n = remoteFileChooser.showSaveDialog(this.getParent());
        if (n == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            String string4 = remoteFileChooser.getSelectedFilePath();
            return string4;
        }
        return "";
    }

    private class BrowseButton
    extends ToggleButtonAction {
        public BrowseButton(BaseDialog baseDialog, String string) {
            super(baseDialog, string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == ComplexSamplesCommonSave.this.mBrowseSpssButton) {
                ComplexSamplesCommonSave.this.mSpssFileTextField.setText(ComplexSamplesCommonSave.this.getSelectedFilePath(jButton));
                ComplexSamplesCommonSave.this.mSpssFileTextField.setCaretPosition(0);
            } else {
                ComplexSamplesCommonSave.this.mXmlFileTextField.setText(ComplexSamplesCommonSave.this.getSelectedFilePath(jButton));
                ComplexSamplesCommonSave.this.mXmlFileTextField.setCaretPosition(0);
            }
        }
    }
}

