/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonDialogType;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class ComplexSamplesCommonOptionsPanel
extends JPanel
implements ItemListener {
    static final String CONFIDENCE_KEY = "CONFIDENCE_TEXT_KEY";
    private static final int CONFIDENCE_INTERVAL = 95;
    private BaseDialog mBaseDialog;
    private JRadioButton mValidRadioButton;
    private JRadioButton mInValidRadioButton;
    private JTextArea mLabelTextArea;
    private JLabel mConfidenceLabel;
    private FloatTextField mConfidenceTextField;
    private SpssButtonGroup mGroup;
    private GridBagConstraints mConstraints;
    private Insets mInsets;
    private ComplexSamplesCommonDialogType mDialogType;
    private DialogDataModel mDataModel;
    private boolean mIsLoadingComplete;

    public ComplexSamplesCommonOptionsPanel(ComplexSamplesCommonDialogType complexSamplesCommonDialogType, BaseDialog baseDialog, DialogDataModel dialogDataModel) {
        this.mDataModel = dialogDataModel;
        this.mDialogType = complexSamplesCommonDialogType;
        this.mBaseDialog = baseDialog;
        this.setLayout(new GridBagLayout());
        this.initVars();
        this.setDefaults();
        this.setupComponents();
        this.mIsLoadingComplete = true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        HashMap<Integer, Object> hashMap;
        if (this.mIsLoadingComplete && itemEvent.getSource() == this.mInValidRadioButton && this.mInValidRadioButton.isSelected() && this.mDataModel != null && (hashMap = this.mDataModel.getMap("FactorTableData")) != null) {
            for (Integer n : hashMap.keySet()) {
                String[] stringArray = (String[])hashMap.get(n);
                String string = stringArray[1];
                if (!string.contains(" (Missing)")) continue;
                this.showMissingValueError();
                return;
            }
        }
    }

    private void showMissingValueError() {
        int n = SpssAlertOptionPane.showConfirmDialog((Window)this.mBaseDialog, this.mBaseDialog.getResString("ERR_COMPLEX_SAMPLES_COMMON_OPTIONS_MISSING_VALUES_PRESENT_ERROR"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
        if (n == 3) {
            this.mValidRadioButton.setSelected(true);
        }
    }

    public FloatTextField getConfidenceTextField() {
        return this.mConfidenceTextField;
    }

    public Vector<Object> getTabTraversalComponents() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mGroup);
        return vector;
    }

    private void initVars() {
        this.mInValidRadioButton = new JRadioButton(new ToggleButtonAction(this.mBaseDialog, "IDS_COMPLEX_SAMPLES_COMMON_OPTIONS_INVALID_RADIOBUTTON"));
        this.mValidRadioButton = new JRadioButton(new ToggleButtonAction(this.mBaseDialog, "IDS_COMPLEX_SAMPLES_COMMON_OPTIONS_VALID_RADIOBUTTON"));
        if (this.mDialogType == ComplexSamplesCommonDialogType.LOGLINEAR_REGRESSION) {
            this.mLabelTextArea = new JTextArea(this.mBaseDialog.getResString("IDS_LOGISTIC_REGRESSION_OPTIONS_GENERAL_LABEL"));
        } else if (this.mDialogType == ComplexSamplesCommonDialogType.GENERAL_LINEAR_MODEL) {
            this.mLabelTextArea = new JTextArea(this.mBaseDialog.getResString("IDS_GENERAL_LINEAR_OPTIONS_GENERAL_LABEL"));
        }
        this.mLabelTextArea.setOpaque(true);
        this.mLabelTextArea.setLineWrap(true);
        this.mLabelTextArea.setWrapStyleWord(true);
        this.mLabelTextArea.setBorder(BorderFactory.createEmptyBorder());
        this.mLabelTextArea.setBackground(this.getBackground());
        this.mLabelTextArea.setEditable(false);
        this.mLabelTextArea.setRows(2);
        this.mLabelTextArea.setFocusable(false);
        if (this.mDialogType == ComplexSamplesCommonDialogType.LOGLINEAR_REGRESSION) {
            this.mLabelTextArea.setPreferredSize(new Dimension(240, this.mLabelTextArea.getHeight()));
        } else if (this.mDialogType == ComplexSamplesCommonDialogType.GENERAL_LINEAR_MODEL) {
            this.mLabelTextArea.setPreferredSize(new Dimension(320, this.mLabelTextArea.getHeight()));
        }
        this.mConfidenceLabel = DialogUtil.createLabel(this.mBaseDialog, "IDS_COMPLEX_SAMPLES_COMMON_OPTIONS_CONFIDENCE_LABEL");
        this.mConfidenceTextField = new FloatTextField(50.0, 100.0, -1, true);
        this.mConfidenceTextField.setIncludeMaxRange(false);
        this.mConfidenceTextField.setAction((Action)new TextFieldAction(this.mBaseDialog, CONFIDENCE_KEY));
        this.mConfidenceLabel.setLabelFor((Component)this.mConfidenceTextField);
        this.mConstraints = new GridBagConstraints();
        this.mInsets = new Insets(0, 0, 0, 0);
        this.mInValidRadioButton.addItemListener(this);
    }

    private void setDefaults() {
        this.mInValidRadioButton.setSelected(true);
        this.mConfidenceTextField.setText("95");
    }

    private void setupComponents() {
        JPanel jPanel = this.setupUserMissingValuesPanel();
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(this, jPanel, this.mConstraints, 0, 0, 2, 1, n, null);
    }

    public JPanel setupConfidencePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mConstraints.weighty = 0.0;
        int n = 23;
        this.mConstraints.fill = 0;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        this.mInsets.set(n2, n2, n2, 0);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 1.0;
        this.mInsets.set(n2, 3 * n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mConfidenceLabel, this.mConstraints, 0, 1, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mInsets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mConfidenceTextField, this.mConstraints, 1, 1, 1, 1, n, this.mInsets);
        return jPanel;
    }

    private JPanel setupUserMissingValuesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mBaseDialog.getResString("IDS_COMPLEX_SAMPLES_COMMON_OPTIONS_USER_MISSING_VALUES_LABEL")));
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mInsets.set(insets.top, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mInValidRadioButton, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
        this.mInsets.set(insets.top, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mValidRadioButton, this.mConstraints, 0, 1, 1, 1, n, this.mInsets);
        this.mInsets.set(n2, 2 * n2, n2, n2);
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mLabelTextArea, this.mConstraints, 0, 2, 1, 1, n, this.mInsets);
        this.mGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }
}

