/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.ListFocusTraversalPolicy;
import com.spss.java_client.ui.controls.ListTravArrowButtonFactory;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.AbstractDropListener;
import com.spss.java_client.ui.dialogs.common.AbstractModelSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.gen_lin_model.ComplexSamplesGLMDlg;
import com.spss.java_client.ui.dialogs.complex_samples.logistic_regression.LogisticRegressionDlg;
import com.spss.java_client.ui.dialogs.complex_samples.ordinal_regression.OrdinalRegressionDlg;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class ComplexSamplesCommonModel
extends AbstractModelSubDialog {
    static final String COMMON_MODEL_MAIN_EFFECT = "IDS_COMPLEX_SAMPLES_COMMON_MODEL_MAINEFFECTS_RADIOBUTTON";
    static final String COMMON_MODEL_INCLUDE_MODEL = "IDS_COMPLEX_SAMPLES_COMMON_MODEL_INCLUDE_CHECKBOX";
    static final String COMMON_MODEL_DISPLAY_STAT = "IDS_COMPLEX_SAMPLES_COMMON_MODEL_DISPLAY_CHECKBOX";
    static final String COMMON_MODEL_TERM = "IDS_COMMON_MODEL_TERM";
    private boolean mInitOverFlag;
    private boolean mErrorFlag;
    private JPanel mUpDownArrowButton;
    private ArrowButton mNestedTermArrow;
    private StringTextField mTermTextField;
    private JButton mInteractionButton;
    private JButton mNestingButton;
    private JButton mAddModelButton;
    private JButton mClearButton;
    private JCheckBox mIncludeModelCheck;
    private JCheckBox mDisplayStatCheck;
    private JLabel mTermLabel;
    private ArrayList<String> mAddedElements;
    private VarListModel mFactorModel;
    private VarListModel mCovariateModel;
    private ListTravArrowButtonFactory mListArrowButtonFactory;

    public ComplexSamplesCommonModel(BaseProcedureDialog baseProcedureDialog, String string, VarListModel varListModel, VarListModel varListModel2, VarListModel varListModel3, String string2) {
        super(baseProcedureDialog, string, varListModel, varListModel2, varListModel3, string2);
        this.mFactorModel = varListModel;
        this.mCovariateModel = varListModel2;
        ListFocusTraversalPolicy listFocusTraversalPolicy = new ListFocusTraversalPolicy(new ListTravArrowButtonFactory[]{this.mListArrowButtonFactory}, this.mTabOrder, false);
        this.setFocusTraversalPolicy(listFocusTraversalPolicy);
        Component component = this.getGlassPane();
        if (component instanceof DragPane) {
            ((DragPane)component).addDropListener((IDropListener)new TermsTextFieldDropListener((JTextField)((Object)this.mTermTextField)));
        }
    }

    @Override
    public String getDialogHelpID() {
        if (this.getParent() instanceof LogisticRegressionDlg || this.getParent() instanceof ComplexSamplesGLMDlg) {
            return "idh_idd_csgl_model";
        }
        if (this.getParent() instanceof OrdinalRegressionDlg) {
            return "idh_idd_csord_model";
        }
        return "idh_idd_gee_model";
    }

    @Override
    public boolean continuePressed() {
        if (this.mTermTextField.getText().trim().length() > 0 && this.mAddModelButton.isEnabled()) {
            int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mParentDlg), this.getResString("ERR_COMPLEX_SAMPLES_COMMON_MODEL_TERM_EXIST_CONTINUE_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            if (n == 3 || n == -1) {
                return false;
            }
            String string = this.mTermTextField.getText().trim();
            if (string.length() > 0) {
                DefaultListModel defaultListModel = (DefaultListModel)this.mTermsVarList.getModel();
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string);
                this.filterUniqueItems(arrayList, defaultListModel);
                if (arrayList.size() == 0) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mParentDlg), this.getResString("ERR_MODEL_DUPLICATE_MSG1"), VersionInfo.getAppVersionString());
                } else {
                    defaultListModel.addElement(string);
                }
                this.mTermTextField.setText("");
            }
        } else if (this.mTermTextField.getText().trim().length() > 0 && !this.mAddModelButton.isEnabled()) {
            int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mParentDlg), this.getResString("ERR_COMPLEX_SAMPLES_COMMON_MODEL_TERM_EXIST_CONTINUE_ERR_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            if (n == 3 || n == -1) {
                return false;
            }
            this.mTermTextField.setText("");
        }
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mNonCustRadio) {
            this.setComponentEnableState(this.mFactorTermPanel, false);
            if (this.mInitOverFlag) {
                this.mNestedTermArrow.setEnabled(false);
                this.mTermTextField.setEnabled(false);
                this.mTermLabel.setEnabled(false);
                this.setAllButtonsEnabled(false);
            }
            this.enableContinue(true);
        } else if (object == this.mCustomRadio) {
            this.setComponentEnableState(this.mFactorTermPanel, true);
            if (this.mInitOverFlag) {
                this.mNestedTermArrow.setEnabled(true);
                this.mTermTextField.setEnabled(true);
                this.mTermLabel.setEnabled(true);
                this.setRespectiveButtonsEnabled();
            }
            this.enableContinue(this.mTermsVarList.getModel().getSize() > 0);
        }
        if (this.mInitOverFlag) {
            if (this.mIncludeModelCheck.isSelected()) {
                this.mDisplayStatCheck.setEnabled(true);
            } else {
                this.mDisplayStatCheck.setEnabled(false);
            }
        }
        if (this.mFactorsVarList != null && this.mFactorsVarList.getModel().getSize() > 0) {
            this.mFactorsVarList.setSelectedIndex(0);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        Object object = focusEvent.getSource();
        if (object == this.mTermTextField && this.mTermTextField.isEnabled()) {
            this.mTermTextField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.mNestedTermArrow) {
            this.mErrorFlag = false;
            ISpssVariable[] iSpssVariableArray = this.mFactorsVarList.getSelectedValues();
            if (iSpssVariableArray.length > 1) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mParentDlg), this.getResString("ERR_COMPLEX_SAMPLES_COMMON_MODEL_ONLY_ONE_VAR_MSG"), VersionInfo.getAppVersionString());
                this.mFactorsVarList.requestFocusInWindow();
                return;
            }
            ISpssVariable iSpssVariable = (ISpssVariable)this.mFactorsVarList.getSelectedValue();
            String string = iSpssVariable.getName();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.removeAll(this.mAddedElements);
            if (this.isPresentInFactorsList(iSpssVariable) && arrayList.size() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mParentDlg), this.getResString("ERR_COMPLEX_SAMPLES_COMMON_MODEL_FACTOR_UNIQUE_MSG"), VersionInfo.getAppVersionString());
                this.mFactorsVarList.requestFocusInWindow();
                return;
            }
            if (this.mTermTextField.getText().trim().length() == 0) {
                this.mTermTextField.setText(string);
            } else {
                this.mTermTextField.setText(this.getElementNameAddedText(this.mTermTextField.getText(), string, this.isPresentInCovariatesList(iSpssVariable)));
            }
            if (!this.mErrorFlag) {
                this.setAllButtonsEnabled(true);
                this.mNestedTermArrow.setEnabled(false);
            }
            this.mAddedElements.add(string);
        }
    }

    @Override
    protected void initSubDialog(JPanel jPanel, JPanel jPanel2) {
        this.initVars();
        this.mInitOverFlag = true;
        JPanel jPanel3 = this.setupNestedTermPanel();
        this.mBuildTermCombo.setMaximumRowCount(6);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        JPanel jPanel4 = new JPanel(new GridBagLayout(), true);
        jPanel4.setBorder(new TitledBorder(this.getResString("IDS_COMPLEX_SAMPLES_COMMON_MODEL_SPECIFY_LABEL")));
        JPanel jPanel5 = (JPanel)jPanel.getComponent(0);
        DialogUtil.createButtonGroup(jPanel5);
        DialogUtil.addUsingGBL(jPanel4, jPanel5, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(n2, 2 * n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel4, (JPanel)jPanel.getComponent(0), gridBagConstraints, 0, 1, 1, 1, n, insets);
        int n3 = jPanel4.getComponentCount();
        for (int i = 0; i < n3; ++i) {
            JPanel jPanel6 = (JPanel)jPanel4.getComponent(i);
            jPanel6.setBorder(null);
        }
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets = new Insets(2 * n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel4, this.mUpDownArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        n = 10;
        DialogUtil.addUsingGBL(jPanel2, this.mNestedTermArrow, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        insets = new Insets(0, 2 * n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel4, jPanel3, gridBagConstraints, 0, 3, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 0, 1, 1, n, insets);
        if (this.getParent() instanceof LogisticRegressionDlg || this.getParent() instanceof ComplexSamplesGLMDlg) {
            DialogUtil.addUsingGBL(jPanel, this.setupInterceptPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        }
        this.setDefaults();
    }

    @Override
    protected String getTermsListLabel() {
        return this.getResString("IDS_COMPLEX_SAMPLES_COMMON_MODEL_MODEL_LABEL");
    }

    @Override
    protected void subDialogTabOrder() {
        this.mTabOrder.add(this.mListArrowButtonFactory.getUpArrowButton());
        this.mTabOrder.add(this.mListArrowButtonFactory.getDownArrowButton());
        this.mTabOrder.add(this.mNestedTermArrow);
        this.mTabOrder.add(this.mTermTextField);
        this.mTabOrder.add(this.mInteractionButton);
        this.mTabOrder.add(this.mNestingButton);
        this.mTabOrder.add(this.mAddModelButton);
        this.mTabOrder.add(this.mClearButton);
        if (this.getParent() instanceof LogisticRegressionDlg || this.getParent() instanceof ComplexSamplesGLMDlg) {
            this.mTabOrder.add(this.mIncludeModelCheck);
            this.mTabOrder.add(this.mDisplayStatCheck);
        }
    }

    @Override
    protected void filterUniqueItems(ArrayList<String> arrayList, DefaultListModel defaultListModel) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        if (arrayList.get(0).contains("(") || arrayList.get(0).contains("*")) {
            StringTokenizer stringTokenizer = new StringTokenizer(arrayList.get(0), "*()");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                arrayList4.add(string);
            }
        }
        int n = defaultListModel.getSize();
        for (int i = 0; i < n; ++i) {
            String string = (String)defaultListModel.getElementAt(i);
            arrayList2.add(string);
            arrayList3.clear();
            if (string.contains("(") || string.contains("*")) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.mTermsVarList.getModel().getElementAt(i).toString(), "*()");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    arrayList3.add(string2);
                }
            }
            Collections.sort(arrayList4);
            Collections.sort(arrayList3);
            if (arrayList3.size() > 0 && arrayList4.size() > 0 && arrayList3.size() == arrayList4.size() && arrayList3.containsAll(arrayList4)) {
                arrayList.remove(0);
                continue;
            }
            if (arrayList3.size() != 0 || arrayList4.size() != 0) continue;
            arrayList.removeAll(arrayList2);
        }
    }

    private void initVars() {
        ControlAction controlAction = new ToggleButtonAction(this, COMMON_MODEL_INCLUDE_MODEL);
        this.mIncludeModelCheck = new JCheckBox(controlAction);
        this.mIncludeModelCheck.addItemListener(this);
        controlAction = new ToggleButtonAction(this, COMMON_MODEL_DISPLAY_STAT);
        this.mDisplayStatCheck = new JCheckBox(controlAction);
        controlAction = new TextFieldAction(this, COMMON_MODEL_TERM);
        this.mTermTextField = new StringTextField();
        this.mTermTextField.setAction(controlAction);
        this.mTermTextField.addFocusListener(this);
        this.mListArrowButtonFactory = new ListTravArrowButtonFactory(this.mTermsVarList, false);
        this.mUpDownArrowButton = this.mListArrowButtonFactory.getArrowButtonPanel();
        this.mNestedTermArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.down);
        this.mNestedTermArrow.addActionListener(this);
        this.mNonCustRadio.addItemListener(this);
        this.mCustomRadio.addItemListener(this);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_MODEL_INTERACTION_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComplexSamplesCommonModel.this.mTermTextField.setText(ComplexSamplesCommonModel.this.getInteractionAddedText(ComplexSamplesCommonModel.this.mTermTextField.getText(), "*"));
                ComplexSamplesCommonModel.this.setOnlyFunctionsEnabled(false);
                ComplexSamplesCommonModel.this.mNestedTermArrow.setEnabled(true);
                ComplexSamplesCommonModel.this.mTermTextField.requestFocusInWindow();
            }
        };
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_MODEL_NESTING_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComplexSamplesCommonModel.this.mTermTextField.setText(ComplexSamplesCommonModel.this.getInteractionAddedText(ComplexSamplesCommonModel.this.mTermTextField.getText(), "()"));
                ComplexSamplesCommonModel.this.setOnlyFunctionsEnabled(false);
                ComplexSamplesCommonModel.this.mNestedTermArrow.setEnabled(true);
                ComplexSamplesCommonModel.this.mTermTextField.requestFocusInWindow();
            }
        };
        ToggleButtonAction toggleButtonAction3 = new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_MODEL_ADDTOMODEL_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ComplexSamplesCommonModel.this.mTermTextField.getText().trim();
                if (string.length() > 0) {
                    DefaultListModel defaultListModel = (DefaultListModel)ComplexSamplesCommonModel.this.mTermsVarList.getModel();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(string);
                    ComplexSamplesCommonModel.this.filterUniqueItems(arrayList, defaultListModel);
                    if (arrayList.size() == 0) {
                        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)ComplexSamplesCommonModel.this.mParentDlg), ComplexSamplesCommonModel.this.getResString("ERR_MODEL_DUPLICATE_MSG1"), VersionInfo.getAppVersionString());
                        return;
                    }
                    defaultListModel.addElement(string);
                    ComplexSamplesCommonModel.this.mTermTextField.setText("");
                    ComplexSamplesCommonModel.this.mAddedElements.clear();
                    ComplexSamplesCommonModel.this.setAllButtonsEnabled(false);
                    ComplexSamplesCommonModel.this.mNestedTermArrow.setEnabled(true);
                    ComplexSamplesCommonModel.this.mTermsVarList.setSelectedIndex(defaultListModel.getSize() - 1);
                    ComplexSamplesCommonModel.this.mTermsVarList.requestFocusInWindow();
                }
            }
        };
        ToggleButtonAction toggleButtonAction4 = new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_MODEL_CLEAR_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComplexSamplesCommonModel.this.mTermTextField.setText("");
                ComplexSamplesCommonModel.this.mAddedElements.clear();
                ComplexSamplesCommonModel.this.setAllButtonsEnabled(false);
                ComplexSamplesCommonModel.this.mNestedTermArrow.setEnabled(true);
                ComplexSamplesCommonModel.this.mFactorsVarList.requestFocusInWindow();
            }
        };
        this.mInteractionButton = new JButton(toggleButtonAction);
        this.mNestingButton = new JButton(toggleButtonAction2);
        this.mAddModelButton = new JButton(toggleButtonAction3);
        this.mClearButton = new JButton(toggleButtonAction4);
        this.mAddedElements = new ArrayList();
    }

    private void setDefaults() {
        this.mIncludeModelCheck.setSelected(true);
        this.mDisplayStatCheck.setSelected(true);
        this.mInteractionButton.setEnabled(false);
        this.mTermTextField.setEnabled(false);
        this.mNestingButton.setEnabled(false);
        this.mAddModelButton.setEnabled(false);
        this.mClearButton.setEnabled(false);
        this.mTermTextField.setEditable(false);
        this.mTermTextField.setOpaque(true);
        this.mNestedTermArrow.setEnabled(false);
        this.mTermLabel.setEnabled(false);
        this.mCustomRadio.setAction(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_MODEL_CUSTOM_RADIOBUTTON"));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            this.mTermsLbl.setDisplayedMnemonic(this.getDlgAccessKey("IDK_COMPLEX_SAMPLES_COMMON_MODEL_MODEL_LABEL_KEY"));
        }
        this.mBuildTermCombo.setSelectedIndex(1);
    }

    private JPanel setupNestedTermPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_COMPLEX_SAMPLES_COMMON_MODEL_NESTED_LABEL")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n2 = 10;
        Insets insets = new Insets(n, n, 0, n);
        gridBagConstraints.fill = 0;
        this.mTermLabel = DialogUtil.createLabel(this, "IDS_COMPLEX_SAMPLES_COMMON_MODEL_TERM_LABEL");
        DialogUtil.addUsingGBL(jPanel, this.mTermLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        this.mTermLabel.setLabelFor((Component)((Object)this.mTermTextField));
        gridBagConstraints.weightx = 1.0;
        n2 = 23;
        insets = new Insets(n, 0, 0, n);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mTermTextField), gridBagConstraints, 1, 0, 5, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets = new Insets(n, 0, n, n);
        DialogUtil.addUsingGBL(jPanel, this.mInteractionButton, gridBagConstraints, 2, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mNestingButton, gridBagConstraints, 3, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mAddModelButton, gridBagConstraints, 4, 1, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mClearButton, gridBagConstraints, 5, 1, 1, 1, n2, insets);
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    private JPanel setupInterceptPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mIncludeModelCheck, this.mDisplayStatCheck};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_COMPLEX_SAMPLES_COMMON_MODEL_INTERCEPT_LABEL"), 2);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private void setAllButtonsEnabled(boolean bl) {
        this.mInteractionButton.setEnabled(bl);
        this.mNestingButton.setEnabled(bl);
        this.mAddModelButton.setEnabled(bl);
        this.mClearButton.setEnabled(bl);
    }

    private void setOnlyFunctionsEnabled(boolean bl) {
        this.mInteractionButton.setEnabled(bl);
        this.mNestingButton.setEnabled(bl);
        this.mAddModelButton.setEnabled(bl);
    }

    private void setRespectiveButtonsEnabled() {
        String string = this.mTermTextField.getText().trim();
        if (string.length() == 0) {
            this.setAllButtonsEnabled(false);
        } else if (string.endsWith("()") || string.endsWith("*")) {
            this.setOnlyFunctionsEnabled(false);
            this.mClearButton.setEnabled(true);
        } else {
            this.setAllButtonsEnabled(true);
        }
    }

    private String getInteractionAddedText(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (c == '(' || c == ')' || c == '*') continue;
            stringBuffer.insert(i + 1, string2);
            break;
        }
        return stringBuffer.toString();
    }

    private String getElementNameAddedText(String string, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string.lastIndexOf("(");
        int n2 = string.lastIndexOf("*");
        if (n2 > n) {
            stringBuffer.insert(n2 + 1, string2);
        } else if (n2 < n) {
            if (bl) {
                this.mErrorFlag = true;
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mParentDlg), this.getResString("ERR_COMPLEX_SAMPLES_COMMON_MODEL_NO_NESTING_COVAR_MSG"), VersionInfo.getAppVersionString());
                this.mFactorsVarList.requestFocusInWindow();
                return stringBuffer.toString();
            }
            stringBuffer.insert(n + 1, string2);
        }
        return stringBuffer.toString();
    }

    private boolean isPresentInCovariatesList(ISpssVariable iSpssVariable) {
        for (int i = 0; i < this.mCovariateModel.getSize(); ++i) {
            ISpssVariable iSpssVariable2 = this.mCovariateModel.getElementAt(i);
            if (!iSpssVariable2.getName().equals(iSpssVariable.getName()) || !iSpssVariable2.getLabel().equals(iSpssVariable.getLabel())) continue;
            return true;
        }
        return false;
    }

    private boolean isPresentInFactorsList(ISpssVariable iSpssVariable) {
        for (int i = 0; i < this.mFactorModel.getSize(); ++i) {
            ISpssVariable iSpssVariable2 = this.mFactorModel.getElementAt(i);
            if (!iSpssVariable2.getName().equals(iSpssVariable.getName()) || !iSpssVariable2.getLabel().equals(iSpssVariable.getLabel())) continue;
            return true;
        }
        return false;
    }

    class TermsTextFieldDropListener
    extends AbstractDropListener {
        public TermsTextFieldDropListener(JTextField jTextField) {
            super(jTextField);
        }

        @Override
        public Cursor dragItemOver(Point point, DragDropAdapter dragDropAdapter) {
            Cursor cursor;
            boolean bl;
            Point point2 = (Point)point.clone();
            SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
            boolean bl2 = bl = this.canDrop(dragDropAdapter) && this.contains(point);
            if (bl) {
                JTextField jTextField = (JTextField)this.mDropTarget;
                jTextField.setCaretPosition(jTextField.viewToModel(point2));
                jTextField.getCaret().setVisible(true);
                cursor = Cursor.getPredefinedCursor(0);
            } else {
                ((JTextField)this.mDropTarget).getCaret().setVisible(false);
                cursor = DragPane.getNoDropCursor();
            }
            return cursor;
        }

        @Override
        public boolean canDrop(DragDropAdapter dragDropAdapter) {
            VariableList.TransferData transferData;
            ISpssVariable[] iSpssVariableArray;
            boolean bl = false;
            if (!this.mDropTarget.isEnabled() || !this.mDropTarget.isShowing()) {
                return bl;
            }
            Object object = dragDropAdapter.getTransferData();
            if (object instanceof VariableList.TransferData && (iSpssVariableArray = (transferData = (VariableList.TransferData)object).getVariables()) != null && iSpssVariableArray.length > 0 && this.mDropTarget instanceof JTextField) {
                return iSpssVariableArray.length <= 1;
            }
            return bl;
        }

        @Override
        public void itemDropped(DropEvent dropEvent) {
            Component component = dropEvent.getSource();
            if (this.mLastPosition != null) {
                this.mLastPosition = null;
                if (this.mTimer != null) {
                    this.mTimer.stop();
                }
            }
            boolean bl = this.contains(dropEvent.getDropLocation()) && this.canDrop(dropEvent.getDragSourceAdapter());
            Point point = (Point)dropEvent.getDropLocation().clone();
            SwingUtilities.convertPointFromScreen(point, this.mDropTarget);
            if (bl && this.mDropTarget != null && component instanceof VariableList) {
                VariableList variableList = (VariableList)component;
                Object object = dropEvent.getTransferData();
                if (object == null || !(object instanceof VariableList.TransferData)) {
                    return;
                }
                VariableList.TransferData transferData = (VariableList.TransferData)object;
                ISpssVariable[] iSpssVariableArray = transferData.getVariables();
                JTextField jTextField = (JTextField)this.mDropTarget;
                int n = jTextField.viewToModel(point);
                this.importData(iSpssVariableArray, variableList, n);
            }
        }

        @Override
        protected void importData(Object object, JComponent jComponent, int n) {
            final JTextField jTextField = (JTextField)this.mDropTarget;
            if (object instanceof ISpssVariable[] && ((ISpssVariable[])object).length == 1 && jComponent instanceof VariableList) {
                ISpssVariable iSpssVariable = ((ISpssVariable[])object)[0];
                String string = iSpssVariable.getName();
                if (ComplexSamplesCommonModel.this.mNestedTermArrow.isEnabled()) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(string);
                    arrayList.removeAll(ComplexSamplesCommonModel.this.mAddedElements);
                    if (ComplexSamplesCommonModel.this.isPresentInFactorsList(iSpssVariable) && arrayList.size() == 0) {
                        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)ComplexSamplesCommonModel.this), ComplexSamplesCommonModel.this.getResString("ERR_COMPLEX_SAMPLES_COMMON_MODEL_FACTOR_UNIQUE_MSG"), VersionInfo.getAppVersionString());
                        return;
                    }
                    if (ComplexSamplesCommonModel.this.mTermTextField.getText().trim().length() == 0) {
                        ComplexSamplesCommonModel.this.mTermTextField.setText(string);
                    } else {
                        ComplexSamplesCommonModel.this.mTermTextField.setText(ComplexSamplesCommonModel.this.getElementNameAddedText(ComplexSamplesCommonModel.this.mTermTextField.getText(), string, ComplexSamplesCommonModel.this.isPresentInCovariatesList(iSpssVariable)));
                    }
                    if (!ComplexSamplesCommonModel.this.mErrorFlag) {
                        ComplexSamplesCommonModel.this.setAllButtonsEnabled(true);
                        ComplexSamplesCommonModel.this.mNestedTermArrow.setEnabled(false);
                    }
                    ComplexSamplesCommonModel.this.mAddedElements.add(string);
                } else if (!ComplexSamplesCommonModel.this.mTermTextField.getText().endsWith("*") && !ComplexSamplesCommonModel.this.mTermTextField.getText().endsWith("()")) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)ComplexSamplesCommonModel.this), ComplexSamplesCommonModel.this.getResString("ERR_COMPLEX_SAMPLES_COMMON_MODEL_VAR_CAN_NOT_BE_ADDED"), VersionInfo.getAppVersionString());
                    return;
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jTextField.requestFocus();
                }
            });
        }

        @Override
        protected void showDropFeedback(Point point) {
        }

        @Override
        protected void setHighlightBorder(boolean bl) {
        }

        @Override
        protected void finish(JComponent jComponent, int n, int[] nArray, int n2) {
        }
    }
}

