/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.CommonReferenceCategory;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonDialogType;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesPlan;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesUtils;
import com.spss.java_client.ui.dialogs.complex_samples.gen_lin_model.ComplexSamplesGLMDlg;
import com.spss.java_client.ui.dialogs.complex_samples.logistic_regression.LogisticRegressionDlg;
import com.spss.java_client.ui.dialogs.complex_samples.logistic_regression.LogisticRegressionReferenceCategory;
import com.spss.java_client.ui.dialogs.complex_samples.ordinal_regression.OrdinalRegressionDlg;
import com.spss.java_client.ui.dialogs.complex_samples.ordinal_regression.OrdinalRegressionResponseProbability;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ComplexSamplesCommonMainDialogPanel
extends JPanel
implements ListDataListener,
ItemListener {
    public static String LINK_COMBO_BOX = "IDS_LINK_COMBO_BOX";
    public static String DEPENDENT_LIST_IDENTIFIER;
    public Object mComboValue = null;
    public JComboBox mCategoryCombo;
    public JComboBox mLinkCombo;
    public SrcVariableList mSrcVarList;
    public TargetVariableList mTargetDependentList;
    private ComplexSamplesCommonDialogType mDialogType;
    private TargetVariableList mTargetFactorsList;
    private TargetVariableList mTargetCovariateList;
    private TargetVariableList mTargetVariableList;
    private BaseProcedureDialog mBaseDialog;
    private JButton mRefCategoryButton;
    private ArrowButton mDependentArrowButton;
    private ArrowButton mFactorArrowButton;
    private ArrowButton mCovariateArrowButton;
    private ArrowButton mVariableArrowButton;
    private FixedLengthDocument documentFixed;
    private HashMap<String, String> mCategoryMap = new HashMap();

    public ComplexSamplesCommonMainDialogPanel(BaseProcedureDialog baseProcedureDialog, ComplexSamplesCommonDialogType complexSamplesCommonDialogType) {
        this.mBaseDialog = baseProcedureDialog;
        this.mDialogType = complexSamplesCommonDialogType;
        this.setLayout(new GridBagLayout());
        this.initVars();
        this.setDefaults();
        this.addComponentsToPanel(this);
    }

    public void setIdentifiersForComponents(String[] stringArray) {
        this.mSrcVarList.setIdentifier(stringArray[0]);
        this.mTargetDependentList.setIdentifier(stringArray[1]);
        DEPENDENT_LIST_IDENTIFIER = stringArray[1];
        this.mTargetFactorsList.setIdentifier(stringArray[2]);
        this.mTargetCovariateList.setIdentifier(stringArray[3]);
        this.mTargetVariableList.setIdentifier(stringArray[4]);
        ComboboxAction comboboxAction = new ComboboxAction(this.mBaseDialog, stringArray[5]);
        this.mCategoryCombo.setAction(comboboxAction);
        this.mCategoryCombo.setEnabled(false);
        ((JComponent)this.mCategoryCombo.getEditor().getEditorComponent()).setOpaque(false);
    }

    public String getVariablesOfDependentList() {
        return this.mTargetDependentList.getVariablesStringList();
    }

    public JButton getRefCatButton() {
        return this.mRefCategoryButton;
    }

    public String getVariablesOfFactorsList() {
        return this.mTargetFactorsList.getVariablesStringList();
    }

    public VarListModel getSrcModel() {
        return this.mSrcVarList.getModel();
    }

    public String getVariablesOfCovariatesList() {
        return this.mTargetCovariateList.getVariablesStringList();
    }

    public String getVariablesOfVariableList() {
        return this.mTargetVariableList.getVariablesStringList();
    }

    public String getSelectedValueOfCategoryCombo() {
        if (this.getVariablesOfVariableList().trim().length() > 0) {
            ISpssVariable iSpssVariable = this.mTargetVariableList.getModel().getElementAt(0);
            SPSS_Format sPSS_Format = iSpssVariable.getFormat();
            FormatType formatType = sPSS_Format.getFormatType();
            OBS oBS = new OBS();
            if (CellValueFormatter.stringToObs((String)this.mCategoryCombo.getSelectedItem().toString(), (SPSS_Format)sPSS_Format, (OBS)oBS)) {
                String string = CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)sPSS_Format);
                if (iSpssVariable.getType() > 0 || iSpssVariable.getType() == 0 && formatType.isCurrencyFormat() || iSpssVariable.getType() == 0 && formatType.isDateOrTimeFormat()) {
                    StringBuffer stringBuffer = new StringBuffer("''");
                    stringBuffer.insert(1, string);
                    return stringBuffer.toString();
                }
                string = string.replace(",", ".");
                return string;
            }
        }
        return "";
    }

    public boolean isSubpopulationCategoryEmpty() {
        boolean bl = false;
        String string = this.getVariablesOfVariableList().trim();
        Object object = this.mCategoryCombo.getSelectedItem();
        if (string.length() > 0 && (object == null || ((String)object).length() == 0)) {
            bl = true;
        }
        return bl;
    }

    public TargetVariableList getFactorList() {
        return this.mTargetFactorsList;
    }

    public TargetVariableList getCovariateList() {
        return this.mTargetCovariateList;
    }

    public TargetVariableList getDependentVariableList() {
        return this.mTargetDependentList;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mTargetVariableList.getModel()) {
            this.mCategoryCombo.setEnabled(true);
            ((JComponent)this.mCategoryCombo.getEditor().getEditorComponent()).setOpaque(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ComplexSamplesCommonMainDialogPanel.this.mCategoryCombo.setModel(ComplexSamplesCommonMainDialogPanel.this.fillCategoryCombo());
                    ISpssVariable iSpssVariable = (ISpssVariable)ComplexSamplesCommonMainDialogPanel.this.mTargetVariableList.getSelectedValue();
                    if (iSpssVariable.getType() >= 1) {
                        short s = iSpssVariable.getFormat().getWidth();
                        ComplexSamplesCommonMainDialogPanel.this.documentFixed = new FixedLengthDocument(s);
                        ((JTextField)ComplexSamplesCommonMainDialogPanel.this.mCategoryCombo.getEditor().getEditorComponent()).setDocument(ComplexSamplesCommonMainDialogPanel.this.documentFixed);
                    }
                    ComplexSamplesCommonMainDialogPanel.this.mCategoryCombo.setSelectedItem(ComplexSamplesCommonMainDialogPanel.this.mComboValue);
                }
            });
        } else if (listDataEvent.getSource() == this.mTargetDependentList.getModel()) {
            if (this.mTargetDependentList.getModel().getSize() > 0) {
                if (this.mDialogType == ComplexSamplesCommonDialogType.LOGLINEAR_REGRESSION) {
                    ((LogisticRegressionDlg)this.mBaseDialog).enableOkPasteButtons(true);
                    this.mRefCategoryButton.setEnabled(true);
                }
                if (this.mDialogType == ComplexSamplesCommonDialogType.ORDINAL_REGRESSION) {
                    ((OrdinalRegressionDlg)this.mBaseDialog).enableOkPasteButtons(true);
                    this.mRefCategoryButton.setEnabled(true);
                }
                if (this.mDialogType == ComplexSamplesCommonDialogType.GENERAL_LINEAR_MODEL) {
                    ((ComplexSamplesGLMDlg)this.mBaseDialog).enableOkPasteButtons(true);
                }
            }
        } else if (!(listDataEvent.getSource() != this.mTargetFactorsList.getModel() && listDataEvent.getSource() != this.mTargetCovariateList.getModel() || this.mTargetFactorsList.getModel().getSize() <= 0 && this.mTargetCovariateList.getModel().getSize() <= 0)) {
            if (this.mDialogType == ComplexSamplesCommonDialogType.LOGLINEAR_REGRESSION) {
                ((LogisticRegressionDlg)this.mBaseDialog).enableModelButton(true);
            }
            if (this.mDialogType == ComplexSamplesCommonDialogType.ORDINAL_REGRESSION) {
                ((OrdinalRegressionDlg)this.mBaseDialog).enableModelButton(true);
            }
            if (this.mDialogType == ComplexSamplesCommonDialogType.GENERAL_LINEAR_MODEL) {
                ((ComplexSamplesGLMDlg)this.mBaseDialog).enableModelButton(true);
            }
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mTargetVariableList.getModel()) {
            ((DefaultComboBoxModel)this.mCategoryCombo.getModel()).removeAllElements();
            this.mCategoryCombo.setSelectedItem("");
            this.mComboValue = null;
            this.mCategoryCombo.setEnabled(false);
            ((JComponent)this.mCategoryCombo.getEditor().getEditorComponent()).setOpaque(false);
            ((JTextField)this.mCategoryCombo.getEditor().getEditorComponent()).setDocument(new JTextField().getDocument());
        } else if (listDataEvent.getSource() == this.mTargetDependentList.getModel()) {
            if (this.mTargetDependentList.getModel().getSize() == 0) {
                if (this.mDialogType == ComplexSamplesCommonDialogType.LOGLINEAR_REGRESSION) {
                    ((LogisticRegressionDlg)this.mBaseDialog).enableOkPasteButtons(false);
                    DialogDataModel dialogDataModel = this.mBaseDialog.getDialogDataModel();
                    dialogDataModel.putInteger(CommonReferenceCategory.VALUE_KEY, null);
                    dialogDataModel.putString("IDS_LOGISTIC_REF_CAT_COMBO_VALUE", null);
                    dialogDataModel.putBoolean("IDS_LOGISTIC_REGRESSION_REF_CAT_HIGHEST_VALUE_RADIOBUTTON", true);
                    dialogDataModel.putBoolean("IDS_LOGISTIC_REGRESSION_REF_CAT_LOWEST_VALUE_RADIOBUTTON", null);
                    dialogDataModel.putBoolean("IDS_LOGISTIC_REGRESSION_REF_CAT_CUSTOM_RADIOBUTTON", null);
                    this.mRefCategoryButton.setEnabled(false);
                }
                if (this.mDialogType == ComplexSamplesCommonDialogType.ORDINAL_REGRESSION) {
                    ((OrdinalRegressionDlg)this.mBaseDialog).enableOkPasteButtons(false);
                    this.mRefCategoryButton.setEnabled(false);
                }
                if (this.mDialogType == ComplexSamplesCommonDialogType.GENERAL_LINEAR_MODEL) {
                    ((ComplexSamplesGLMDlg)this.mBaseDialog).enableOkPasteButtons(false);
                }
            }
        } else if (listDataEvent.getSource() == this.mTargetFactorsList.getModel() || listDataEvent.getSource() == this.mTargetCovariateList.getModel()) {
            if (this.mTargetFactorsList.getModel().getSize() == 0 && this.mTargetCovariateList.getModel().getSize() == 0) {
                if (this.mDialogType == ComplexSamplesCommonDialogType.LOGLINEAR_REGRESSION) {
                    ((LogisticRegressionDlg)this.mBaseDialog).enableModelButton(false);
                }
                if (this.mDialogType == ComplexSamplesCommonDialogType.ORDINAL_REGRESSION) {
                    ((OrdinalRegressionDlg)this.mBaseDialog).enableModelButton(false);
                }
                if (this.mDialogType == ComplexSamplesCommonDialogType.GENERAL_LINEAR_MODEL) {
                    ((ComplexSamplesGLMDlg)this.mBaseDialog).enableModelButton(false);
                }
            }
            if (this.mDialogType == ComplexSamplesCommonDialogType.LOGLINEAR_REGRESSION || this.mDialogType == ComplexSamplesCommonDialogType.ORDINAL_REGRESSION) {
                if (listDataEvent.getSource() == this.mTargetFactorsList.getModel()) {
                    this.validateTableSubDialog(this.mTargetFactorsList, "OddsRatioFactor", "FACTOR_TABLE_ID", "FactorTableData");
                } else if (listDataEvent.getSource() == this.mTargetCovariateList.getModel()) {
                    this.validateTableSubDialog(this.mTargetCovariateList, "OddsRatioCovariate", "COVARIATE_TABLE_ID", "CovariateTableData");
                }
            }
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)this.mCategoryCombo.getSelectedItem();
        if (string != null && string.trim().length() > 0) {
            this.mComboValue = this.mCategoryCombo.getSelectedItem();
            String string2 = this.mCategoryMap.get(string);
            if (string2 != null) {
                this.mCategoryCombo.setSelectedItem(string2);
            }
        }
    }

    public Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mDependentArrowButton);
        vector.add(this.mFactorArrowButton);
        vector.add(this.mCovariateArrowButton);
        vector.add(this.mVariableArrowButton);
        vector.add(this.mTargetDependentList);
        if (this.mDialogType == ComplexSamplesCommonDialogType.LOGLINEAR_REGRESSION || this.mDialogType == ComplexSamplesCommonDialogType.ORDINAL_REGRESSION) {
            vector.add(this.mRefCategoryButton);
        }
        vector.add(this.mTargetFactorsList);
        vector.add(this.mTargetCovariateList);
        if (this.mDialogType == ComplexSamplesCommonDialogType.ORDINAL_REGRESSION) {
            vector.add(this.mLinkCombo);
        }
        vector.add(this.mTargetVariableList);
        vector.add(this.mCategoryCombo);
        return vector;
    }

    public void setDefaults() {
        ((DefaultComboBoxModel)this.mCategoryCombo.getModel()).removeAllElements();
        this.mCategoryCombo.setEnabled(false);
        ((JComponent)this.mCategoryCombo.getEditor().getEditorComponent()).setOpaque(false);
        this.mTargetDependentList.removeAll();
        this.mTargetFactorsList.removeAll();
        this.mTargetCovariateList.removeAll();
        this.mTargetVariableList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        if (this.mDialogType == ComplexSamplesCommonDialogType.LOGLINEAR_REGRESSION) {
            this.mRefCategoryButton.setEnabled(false);
        }
        if (this.mDialogType == ComplexSamplesCommonDialogType.ORDINAL_REGRESSION) {
            this.mRefCategoryButton.setEnabled(false);
        }
    }

    public boolean isCategoryValueValid() {
        if (this.mTargetVariableList.getModel().getSize() > 0) {
            OBS oBS = new OBS();
            ISpssVariable iSpssVariable = this.mTargetVariableList.getModel().getElementAt(0);
            if (CellValueFormatter.stringToObs((String)this.mCategoryCombo.getSelectedItem().toString(), (SPSS_Format)iSpssVariable.getFormat(), (OBS)oBS)) {
                if (iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat()) {
                    if (oBS.getNum() > 0.0) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mBaseDialog), this.mBaseDialog.getResString("ERR_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_INCONSISTENT_CATEGORY_VALUE"), VersionInfo.getAppVersionString());
            this.mCategoryCombo.requestFocus();
            ((JTextField)this.mCategoryCombo.getEditor().getEditorComponent()).selectAll();
            return false;
        }
        return true;
    }

    private void validateTableSubDialog(TargetVariableList targetVariableList, String string, String string2, String string3) {
        VarListModel varListModel = targetVariableList.getModel();
        DialogDataModel dialogDataModel = this.mBaseDialog.getDialogDataModel();
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray(string);
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        if (iSpssVariableArray != null) {
            block0: for (int i = 0; i < varListModel.getSize(); ++i) {
                LocallyUniqueId locallyUniqueId = varListModel.getElementAt(i).getId();
                for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                    if (!locallyUniqueId.equals((Object)iSpssVariable.getId())) continue;
                    arrayList.add(iSpssVariable);
                    continue block0;
                }
            }
            if (varListModel.getSize() == 0) {
                dialogDataModel.putVarArray(string, null);
            } else {
                ISpssVariable[] iSpssVariableArray2 = new ISpssVariable[arrayList.size()];
                dialogDataModel.putVarArray(string, arrayList.toArray(iSpssVariableArray2));
            }
            ComplexSamplesUtils.validateTableContents(dialogDataModel, string2, string, string3);
        }
    }

    private void initVars() {
        ControlAction controlAction;
        ComplexSamplesPlan.varTargetMoveHandler varTargetMoveHandler2 = new ComplexSamplesPlan.varTargetMoveHandler(this.mBaseDialog.getResString("ERR_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_ARROW_BUTTON_VALID_MSG"));
        this.mSrcVarList = new SrcVariableList();
        this.mSrcVarList.addVarFilter(new ComplexSamplesPlan.sourceListWtFilter());
        this.mTargetDependentList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        if (!(this.mBaseDialog instanceof LogisticRegressionDlg)) {
            this.mTargetDependentList.addVarFilter(new SpssVarFilter(8, false));
        }
        this.mTargetDependentList.getModel().addListDataListener(this);
        Dimension dimension = new Dimension(DialogUtil.getVarListWidth(), DialogUtil.getVarListHeight() / 2);
        this.mTargetFactorsList = new TargetVariableList();
        this.mTargetFactorsList.setMinimumSize(dimension);
        this.mTargetFactorsList.getModel().addListDataListener(this);
        this.mTargetCovariateList = new TargetVariableList();
        this.mTargetCovariateList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetCovariateList.setMinimumSize(dimension);
        this.mTargetCovariateList.getModel().addListDataListener(this);
        this.mTargetVariableList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetVariableList.getModel().addListDataListener(this);
        this.mDependentArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDependentArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDependentArrowButton.registerVariableList(this.mTargetDependentList, SpssArrowButton.ButtonOrientation.left);
        this.mDependentArrowButton.setVarMoveHandler(varTargetMoveHandler2);
        this.mFactorArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mFactorArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mFactorArrowButton.registerVariableList(this.mTargetFactorsList, SpssArrowButton.ButtonOrientation.left);
        this.mFactorArrowButton.setVarMoveHandler(varTargetMoveHandler2);
        this.mCovariateArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCovariateArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mCovariateArrowButton.registerVariableList(this.mTargetCovariateList, SpssArrowButton.ButtonOrientation.left);
        this.mCovariateArrowButton.setVarMoveHandler(varTargetMoveHandler2);
        this.mVariableArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mVariableArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mVariableArrowButton.registerVariableList(this.mTargetVariableList, SpssArrowButton.ButtonOrientation.left);
        this.mCategoryCombo = new JComboBox();
        this.mCategoryCombo.setEditable(true);
        this.mCategoryCombo.addItemListener(this);
        this.mCategoryCombo.setPreferredSize(this.mTargetVariableList.getMinimumSize());
        String string = "IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_REFERENCE_BUTTON";
        if (this.mDialogType == ComplexSamplesCommonDialogType.ORDINAL_REGRESSION) {
            controlAction = new ComboboxAction(this.mBaseDialog, LINK_COMBO_BOX);
            string = "IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_PROBABILITY_BUTTON";
            this.mLinkCombo = new JComboBox<String>(this.mBaseDialog.getResStringArray("IDS_CS_ORDINAL_LINK_COMBO_VALUES"));
            this.mLinkCombo.setAction(controlAction);
        }
        if (this.mDialogType != ComplexSamplesCommonDialogType.GENERAL_LINEAR_MODEL) {
            controlAction = new ToggleButtonAction(this.mBaseDialog, string){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ComplexSamplesCommonMainDialogPanel.this.runRefCategorySubDialog();
                }
            };
            this.mRefCategoryButton = new JButton(controlAction);
        }
    }

    private void addComponentsToPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getComponentGroupGap();
        gridBagConstraints.fill = 0;
        int n2 = 23;
        JLabel jLabel = DialogUtil.createLabel(this.mBaseDialog, "IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_VARIABLES_LABEL");
        JLabel jLabel2 = DialogUtil.createLabel(this.mBaseDialog, "IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_DEPENDENT_VARIABLE_LABEL");
        JLabel jLabel3 = DialogUtil.createLabel(this.mBaseDialog, "IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_FACTORS_LABEL");
        JLabel jLabel4 = DialogUtil.createLabel(this.mBaseDialog, "IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_COVARIATES_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        jLabel2.setLabelFor(this.mTargetDependentList);
        jLabel3.setLabelFor(this.mTargetFactorsList);
        jLabel4.setLabelFor(this.mTargetCovariateList);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JScrollPane jScrollPane2 = new JScrollPane(this.mTargetDependentList);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        jScrollPane2.setPreferredSize(this.mTargetDependentList.getMinimumSize());
        JScrollPane jScrollPane3 = new JScrollPane(this.mTargetFactorsList);
        jScrollPane3.setPreferredSize(this.mTargetFactorsList.getMinimumSize());
        JScrollPane jScrollPane4 = new JScrollPane(this.mTargetCovariateList);
        jScrollPane4.setPreferredSize(this.mTargetCovariateList.getMinimumSize());
        Insets insets = new Insets(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, null);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n2, null);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 3, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 2, 5, 1, 1, n2, insets);
        gridBagConstraints.fill = 1;
        insets = new Insets(0, 0, 0, n);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 10, n2, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n2, insets);
        Insets insets2 = DialogUtil.getStandardControlInsets();
        insets = new Insets(insets2.top + 5, 0, 0, n);
        if (this.mDialogType == ComplexSamplesCommonDialogType.LOGLINEAR_REGRESSION || this.mDialogType == ComplexSamplesCommonDialogType.ORDINAL_REGRESSION) {
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, this.mRefCategoryButton, gridBagConstraints, 2, 2, 1, 1, n2, insets);
        }
        insets = new Insets(0, 0, 0, n);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 2, 4, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, jScrollPane4, gridBagConstraints, 2, 6, 1, 1, n2, insets);
        if (this.mDialogType == ComplexSamplesCommonDialogType.ORDINAL_REGRESSION) {
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            insets = new Insets(n, 0, 0, n);
            DialogUtil.addUsingGBL(jPanel, this.setupLinkPanel(), gridBagConstraints, 2, 7, 1, 1, n2, insets);
        }
        gridBagConstraints.weighty = 0.0;
        Insets insets3 = DialogUtil.getArrowButtonInsets();
        insets = new Insets(0, insets3.left, 0, insets3.right);
        gridBagConstraints.fill = 0;
        n2 = 20;
        DialogUtil.addUsingGBL(jPanel, this.mDependentArrowButton, gridBagConstraints, 1, 0, 1, 2, n2, insets);
        n2 = 10;
        DialogUtil.addUsingGBL(jPanel, this.mFactorArrowButton, gridBagConstraints, 1, 4, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCovariateArrowButton, gridBagConstraints, 1, 6, 1, 1, n2, insets);
        n2 = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets = new Insets(n, 5, 0, 0);
        JPanel jPanel2 = this.setupSubPopulationPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 9, 2, 1, n2, insets);
    }

    private JPanel setupLinkPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 0;
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this.mBaseDialog, "IDS_CS_ORDINAL_LINK_LABEL");
        jLabel.setLabelFor(this.mLinkCombo);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mLinkCombo, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupSubPopulationPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.mBaseDialog.getResString("IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_SUBPOPULATION_TITLE")));
        JLabel jLabel = DialogUtil.createLabel(this.mBaseDialog, "IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_SUBPOPULATION_VARIABLE_LABEL");
        JLabel jLabel2 = DialogUtil.createLabel(this.mBaseDialog, "IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_SUBPOPULATION_CATEGORY_LABEL");
        jLabel.setLabelFor(this.mTargetVariableList);
        jLabel2.setLabelFor(this.mCategoryCombo);
        JScrollPane jScrollPane = new JScrollPane(this.mTargetVariableList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(this.mTargetVariableList.getMinimumSize());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n, 0, 0, 0);
        gridBagConstraints.fill = 0;
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 1, 2, 1, 1, n2, insets);
        gridBagConstraints.fill = 2;
        insets = new Insets(0, 0, 0, n - 5);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets = new Insets(0, 0, n, n - 5);
        DialogUtil.addUsingGBL(jPanel, this.mCategoryCombo, gridBagConstraints, 1, 3, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n2 = 20;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        insets = new Insets(0, insets2.left - 10, 0, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mVariableArrowButton, gridBagConstraints, 0, 0, 1, 2, n2, insets);
        return jPanel;
    }

    private DefaultComboBoxModel fillCategoryCombo() {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        if (this.mTargetVariableList.getModel().getSize() > 0) {
            this.mTargetVariableList.setSelectedIndex(0);
            this.mCategoryMap.clear();
            ISpssVariable iSpssVariable = (ISpssVariable)this.mTargetVariableList.getSelectedValue();
            IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
            SPSS_Format sPSS_Format = iSpssVariable.getFormat();
            FormatType formatType = sPSS_Format.getFormatType();
            boolean bl = formatType.isStringFormat();
            Set set = iValueLabelMap.getValueLabelEntries();
            if (set.size() > 0) {
                boolean bl2 = true;
                Boolean bl3 = this.mBaseDialog.getDialogDataModel().getBoolean("IDS_COMPLEX_SAMPLES_COMMON_OPTIONS_INVALID_RADIOBUTTON");
                if (bl3 != null) {
                    bl2 = bl3 == false;
                }
                for (Map.Entry entry : set) {
                    OBS oBS = (OBS)entry.getKey();
                    if (bl2 && iSpssVariable.isMissing(oBS)) continue;
                    StringBuffer stringBuffer = new StringBuffer();
                    String string = bl ? CharacterUtil.rightTrim((String)oBS.getString()) : CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)sPSS_Format);
                    stringBuffer.append(string);
                    stringBuffer.append(" ");
                    stringBuffer.append((String)entry.getValue());
                    defaultComboBoxModel.addElement(stringBuffer.toString());
                    this.mCategoryMap.put(stringBuffer.toString(), string);
                }
            }
        }
        return defaultComboBoxModel;
    }

    private void runRefCategorySubDialog() {
        if (this.mDialogType == ComplexSamplesCommonDialogType.LOGLINEAR_REGRESSION) {
            this.mBaseDialog.runSubDialog(new LogisticRegressionReferenceCategory(this.mBaseDialog, this.mBaseDialog.getResString("IDS_LOGISTIC_REGRESSION_REF_CAT_TITLE"), true));
        } else {
            this.mBaseDialog.runSubDialog(new OrdinalRegressionResponseProbability(this.mBaseDialog, this.mBaseDialog.getResString("IDS_CS_ORDINAL_RESPONSE_PROBABILITY_TITLE"), true));
        }
    }
}

