/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonSyntaxUtils;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ComplexSamplesCommonHypothesisTests
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    private GridBagConstraints mConstraints;
    private Insets mInsets;
    private JRadioButton mFRadioButton;
    private JRadioButton mAdjustedFRadioButton;
    private JRadioButton mChiSquareRadioButton;
    private JRadioButton mAdjustedChiSquareRadioButton;
    private JRadioButton mLeastRadioButton;
    private JRadioButton mSeqSidakRadioButton;
    private JRadioButton mSeqBonRadioButton;
    private JRadioButton mSidakRadioButton;
    private JRadioButton mBonRadioButton;
    private JRadioButton mSampleDesignRadioButton;
    private JRadioButton mFixedRadioButton;
    private JLabel mValueLabel;
    private IntTextField mValueTextField;
    private Vector<Object> mFocus;

    public ComplexSamplesCommonHypothesisTests(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_csgl_htests";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        JRadioButton jRadioButton = (JRadioButton)itemEvent.getSource();
        if (jRadioButton == this.mFixedRadioButton) {
            this.mValueLabel.setEnabled(true);
            this.mValueTextField.setEnabled(true);
            this.mValueTextField.setOpaque(true);
        } else {
            this.mValueLabel.setEnabled(false);
            this.mValueTextField.setEnabled(false);
            this.mValueTextField.setOpaque(false);
        }
        this.enableContinue(!ComplexSamplesCommonSyntaxUtils.isEnabledTextFieldEmpty((JTextField)this.mValueTextField));
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(!ComplexSamplesCommonSyntaxUtils.isEnabledTextFieldEmpty((JTextField)this.mValueTextField));
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(!ComplexSamplesCommonSyntaxUtils.isEnabledTextFieldEmpty((JTextField)this.mValueTextField));
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(!ComplexSamplesCommonSyntaxUtils.isEnabledTextFieldEmpty((JTextField)this.mValueTextField));
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.setUpUI(jPanel);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            Component component = this.mCmdButtonPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            this.mFocus.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mFocus, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private void initVars() {
        this.mConstraints = new GridBagConstraints();
        this.mInsets = new Insets(0, 0, 0, 0);
        this.mFocus = new Vector();
        this.mFRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_F_RADIOBUTTON"));
        this.mAdjustedFRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_ADJUSTED_F_RADIOBUTTON"));
        this.mChiSquareRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_CHISQUARE_RADIOBUTTON"));
        this.mAdjustedChiSquareRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_ADJUSTED_CHISQUARE_RADIOBUTTON"));
        this.mLeastRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_LEAST_RADIOBUTTON"));
        this.mSeqSidakRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_SEQUENTIAL_SIDAK_RADIOBUTTON"));
        this.mSeqBonRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_SEQUENTIAL_BONFERRONI_RADIOBUTTON"));
        this.mSidakRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_SIDAK_RADIOBUTTON"));
        this.mBonRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_BONFERRONI_RADIOBUTTON"));
        this.mSampleDesignRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_BASED_RADIOBUTTON"));
        this.mSampleDesignRadioButton.addItemListener(this);
        this.mFixedRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_FIXED_RADIOBUTTON"));
        this.mFixedRadioButton.addItemListener(this);
        this.mValueLabel = DialogUtil.createLabel(this, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_VALUE_LABEL");
        this.mValueTextField = new IntTextField(1, Integer.MAX_VALUE, true);
        this.mValueTextField.setColumns(6);
        this.mValueTextField.setAction((Action)new TextFieldAction(this, "IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_VALUE_LABEL"));
        this.mValueTextField.getDocument().addDocumentListener(this);
        this.mValueLabel.setLabelFor((Component)this.mValueTextField);
    }

    private void setDefaults() {
        this.mFRadioButton.setSelected(true);
        this.mLeastRadioButton.setSelected(true);
        this.mSampleDesignRadioButton.setSelected(true);
        this.mValueLabel.setEnabled(false);
        this.mValueTextField.setEnabled(false);
        this.mValueTextField.setOpaque(false);
    }

    private void setUpUI(JPanel jPanel) {
        JPanel jPanel2 = this.setupStatisticPanel();
        JPanel jPanel3 = this.setupSamplingPanel();
        JPanel jPanel4 = this.setupAdjustmentPanel();
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, this.mConstraints, 1, 0, 1, 1, n, null);
        insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel4, this.mConstraints, 0, 1, 2, 1, n, insets);
    }

    private JPanel setupStatisticPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mFRadioButton, this.mAdjustedFRadioButton, this.mChiSquareRadioButton, this.mAdjustedChiSquareRadioButton};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_TEST_STATISTICS_LABEL"));
        SpssButtonGroup spssButtonGroup = DialogUtil.createButtonGroup(jPanel);
        this.mFocus.add(spssButtonGroup);
        return jPanel;
    }

    private JPanel setupAdjustmentPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mLeastRadioButton, this.mSeqSidakRadioButton, this.mSeqBonRadioButton, this.mSidakRadioButton, this.mBonRadioButton};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_ADJUSTMENT_LABEL"));
        SpssButtonGroup spssButtonGroup = DialogUtil.createButtonGroup(jPanel);
        this.mFocus.add(spssButtonGroup);
        return jPanel;
    }

    private JPanel setupSamplingPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_SAMPLING_DEGREES_LABEL")));
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        int n3 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mConstraints.weightx = 1.0;
        this.mInsets.set(insets.top, insets.left, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mSampleDesignRadioButton, this.mConstraints, 0, 0, 3, 1, n, this.mInsets);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 1.0;
        this.mInsets.set(insets.top, insets.left, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mFixedRadioButton, this.mConstraints, 0, 1, 1, 1, n, this.mInsets);
        this.mInsets.set(n2, n3, n3, 0);
        DialogUtil.addUsingGBL(jPanel, this.mValueLabel, this.mConstraints, 1, 1, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.fill = 0;
        this.mInsets.set(n2, n2, n3, 7 * n3);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mValueTextField, this.mConstraints, 2, 1, 1, 1, n, this.mInsets);
        SpssButtonGroup spssButtonGroup = DialogUtil.createButtonGroup(jPanel);
        this.mFocus.add(spssButtonGroup);
        this.mFocus.add(this.mValueTextField);
        return jPanel;
    }
}

