/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples;

import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.drag_drop.PlainTableDragAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ComplexSampleDragAdapter
extends PlainTableDragAdapter {
    public ComplexSampleDragAdapter(PlainTable plainTable, DragPane dragPane, String string) {
        super(plainTable, dragPane, string);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Rectangle rectangle;
        this.mDndArmedEvent = null;
        if (mouseEvent.isConsumed() || mouseEvent.getButton() != 1 && mouseEvent.getButton() != 2) {
            return;
        }
        Component component = mouseEvent.getComponent();
        if (component instanceof JTableHeader) {
            component = ((JTableHeader)component).getTable();
        }
        if (!(component instanceof PlainTable)) {
            assert (false);
            return;
        }
        PlainTable plainTable = (PlainTable)component;
        assert (this.mSourceTable == plainTable);
        if (!plainTable.isEnabled() || !plainTable.isDragSupported()) {
            return;
        }
        int n = this.mSourceTable.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.mSourceTable.columnAtPoint(mouseEvent.getPoint());
        Rectangle rectangle2 = rectangle = n > -1 ? this.mSourceTable.getCellRect(n, n2, false) : new Rectangle(0, 0, 0, 0);
        if (n > -1 && rectangle.contains(mouseEvent.getPoint())) {
            this.mDndArmedEvent = mouseEvent;
            mouseEvent.consume();
        }
    }

    @Override
    protected void startDrag(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        Component component = mouseEvent.getComponent();
        if (component instanceof JTableHeader) {
            component = ((JTableHeader)component).getTable();
            mouseEvent.setSource(component);
        }
        if (!(component instanceof PlainTable)) {
            assert (false);
            return;
        }
        PlainTable plainTable = (PlainTable)component;
        assert (this.mSourceTable == plainTable);
        super.startDrag(mouseEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BufferedImage getDragImage(Component component) {
        BufferedImage bufferedImage;
        if (!(component instanceof PlainTable)) {
            assert (false);
            return null;
        }
        Graphics graphics = null;
        try {
            PlainTable plainTable = (PlainTable)component;
            int n = plainTable.getSelectedColumn();
            if (n < 0 || n >= plainTable.getColumnCount() - 1) {
                BufferedImage bufferedImage2 = null;
                return bufferedImage2;
            }
            Dimension dimension = new Dimension(plainTable.getCellRect((int)0, (int)n, (boolean)false).width, plainTable.getRowHeight());
            Dimension dimension2 = new Dimension(dimension.width, dimension.height);
            bufferedImage = new BufferedImage(dimension2.width, dimension2.height, 3);
            graphics = bufferedImage.createGraphics();
            graphics.setClip(0, 0, dimension2.width, dimension2.height);
            Point point = new Point(0, 0);
            TableColumn tableColumn = plainTable.getColumnModel().getColumn(n);
            Object object = tableColumn.getHeaderValue();
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = plainTable.getDefaultRenderer(String.class);
            }
            JLabel jLabel = (JLabel)tableCellRenderer.getTableCellRendererComponent(plainTable, object, false, false, 0, n);
            jLabel.setLocation(new Point(0, 0));
            jLabel.setSize(dimension.width, dimension.height);
            ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(2, 0.5f));
            boolean bl = jLabel.isOpaque();
            jLabel.setOpaque(false);
            jLabel.paint(graphics);
            jLabel.setOpaque(bl);
            ((Graphics2D)graphics).translate(0, dimension.height);
            point.y += dimension.height;
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
        return bufferedImage;
    }
}

