/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples;

import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class CommonReferenceCategory
extends JPanel
implements ItemListener,
ActionListener {
    private BaseProcedureDialog mBaseDialog;
    private TargetVariableList mDependentList;
    private ISpssVariable mTargetVar;
    public static String VALUE_KEY = "IDS_VALUE_KEY";
    private JRadioButton mHighestRadioButton;
    private JRadioButton mLowestRadioButton;
    private JRadioButton mCustomRadioButton;
    private JLabel mValueLabel;
    private JComboBox mValueComboBox;
    private SpssButtonGroup mGroup;
    private GridBagConstraints mConstraints;
    private Insets mInsets;
    private Hashtable<String, String> mValueLabelAndValueTable = new Hashtable();
    private Vector<String> mValidValues = new Vector();

    public CommonReferenceCategory(BaseProcedureDialog baseProcedureDialog, TargetVariableList targetVariableList) {
        this.mBaseDialog = baseProcedureDialog;
        this.mDependentList = targetVariableList;
        this.setLayout(new GridBagLayout());
        this.initVars();
        this.setDefaults();
        this.setupRefCatPanel();
    }

    public Vector<Object> getSubDialogFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mGroup);
        vector.add(this.mValueComboBox);
        return vector;
    }

    public boolean isCustomRadioSelected() {
        return this.mCustomRadioButton.isSelected();
    }

    public boolean isHighestValueSelected() {
        return this.mHighestRadioButton.isSelected();
    }

    public void setLabelForHighestValueRadio(String string) {
        this.mHighestRadioButton.setAction(new ToggleButtonAction(this.mBaseDialog, string));
    }

    public void setLabelForLowestValueRadio(String string) {
        this.mLowestRadioButton.setAction(new ToggleButtonAction(this.mBaseDialog, string));
    }

    public JComboBox getValueComboBox() {
        return this.mValueComboBox;
    }

    public boolean isValidValue(String string) {
        if (this.mTargetVar == null) {
            return false;
        }
        boolean bl = false;
        SPSS_Format sPSS_Format = this.mTargetVar.getFormat();
        FormatType formatType = sPSS_Format.getFormatType();
        boolean bl2 = formatType.isStringFormat();
        for (String string2 : this.mValidValues) {
            if (bl2) {
                if (!CharacterUtil.rightTrim((String)string2).equals(CharacterUtil.rightTrim((String)string))) continue;
                bl = true;
                break;
            }
            if (Double.parseDouble(string) != Double.parseDouble(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        if (actionEvent.getSource() == this.mValueComboBox && (string = (String)this.mValueComboBox.getSelectedItem()) != null && string.trim().length() > 0) {
            if (this.mValueComboBox.getSelectedIndex() > -1) {
                String string2 = this.mValueLabelAndValueTable.get(string);
                ((JTextField)this.mValueComboBox.getEditor().getEditorComponent()).setText(string2);
            } else {
                ((JTextField)this.mValueComboBox.getEditor().getEditorComponent()).setText(string);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.mCustomRadioButton.isSelected()) {
            this.mValueLabel.setEnabled(true);
            this.mValueComboBox.setEnabled(true);
            ((JTextField)this.mValueComboBox.getEditor().getEditorComponent()).setOpaque(true);
        } else {
            this.mValueLabel.setEnabled(false);
            this.mValueComboBox.setEnabled(false);
            ((JTextField)this.mValueComboBox.getEditor().getEditorComponent()).setOpaque(false);
        }
    }

    public static ArrayList<String> getMissingValues(ISpssVariable iSpssVariable) {
        SPSS_Format sPSS_Format = iSpssVariable.getFormat();
        IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
        int n = 0;
        String[] stringArray = new String[iValueLabelMap.size()];
        Set set = iValueLabelMap.getValueLabelEntries();
        for (Map.Entry entry : set) {
            OBS oBS = (OBS)entry.getKey();
            String string = (String)entry.getValue();
            if (oBS.isEmpty() || sPSS_Format == null || iSpssVariable.isMissing(oBS)) continue;
            String string2 = CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)sPSS_Format);
            stringArray[n] = string2 + " " + string;
            ++n;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(Arrays.asList(stringArray));
        return arrayList;
    }

    private void initVars() {
        this.mHighestRadioButton = new JRadioButton(new ToggleButtonAction(this.mBaseDialog, "IDS_LOGISTIC_REGRESSION_REF_CAT_HIGHEST_VALUE_RADIOBUTTON"));
        this.mHighestRadioButton.addItemListener(this);
        this.mLowestRadioButton = new JRadioButton(new ToggleButtonAction(this.mBaseDialog, "IDS_LOGISTIC_REGRESSION_REF_CAT_LOWEST_VALUE_RADIOBUTTON"));
        this.mLowestRadioButton.addItemListener(this);
        this.mCustomRadioButton = new JRadioButton(new ToggleButtonAction(this.mBaseDialog, "IDS_LOGISTIC_REGRESSION_REF_CAT_CUSTOM_RADIOBUTTON"));
        this.mCustomRadioButton.addItemListener(this);
        this.mValueLabel = DialogUtil.createLabel(this.mBaseDialog, "IDS_LOGISTIC_REGRESSION_REF_CAT_VALUE_LABEL");
        this.mValueComboBox = new JComboBox();
        this.mValueComboBox.setEditable(true);
        this.mValueComboBox.addActionListener(this);
        ISpssVariable iSpssVariable = this.mDependentList.getModel().getElementAt(0);
        final short s = iSpssVariable.getFormat().getWidth();
        this.mValueComboBox.setEditor(new BasicComboBoxEditor(){
            private JTextField mTextField = new ContextEnabledTextField();
            {
                if (CommonReferenceCategory.this.mDependentList.getModel().getElementAt(0).getType() > 0) {
                    this.mTextField.setDocument(new FixedLengthDocument(s));
                }
            }

            @Override
            public Component getEditorComponent() {
                return this.mTextField;
            }
        });
        this.mValueComboBox.setAction(new ComboboxAction(this.mBaseDialog, VALUE_KEY));
        ArrayList<String> arrayList = this.loadSourceList(this.mBaseDialog.getDialogDataModel());
        this.mValueComboBox.setPreferredSize(new Dimension(120, 25));
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        if (arrayList != null) {
            for (String string : arrayList) {
                defaultComboBoxModel.addElement(string);
            }
        }
        this.mValueComboBox.setModel(defaultComboBoxModel);
        this.mValueComboBox.addItemListener(this);
        this.mValueLabel.setLabelFor(this.mValueComboBox);
        this.mConstraints = new GridBagConstraints();
        this.mInsets = new Insets(0, 0, 0, 0);
        this.mGroup = new SpssButtonGroup();
        this.mGroup.add(this.mHighestRadioButton);
        this.mGroup.add(this.mLowestRadioButton);
        this.mGroup.add(this.mCustomRadioButton);
    }

    private void setDefaults() {
        this.mHighestRadioButton.setSelected(true);
        this.mValueLabel.setEnabled(false);
        this.mValueComboBox.setEnabled(false);
        ((JTextField)this.mValueComboBox.getEditor().getEditorComponent()).setOpaque(false);
    }

    private void setupRefCatPanel() {
        this.setBorder(BorderFactory.createTitledBorder(this.mBaseDialog.getResString("IDS_LOGISTIC_REGRESSION_REF_CAT_LABEL")));
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mConstraints.weightx = 1.0;
        this.mInsets.set(insets.top, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(this, this.mHighestRadioButton, this.mConstraints, 0, 0, 2, 1, n, this.mInsets);
        DialogUtil.addUsingGBL(this, this.mLowestRadioButton, this.mConstraints, 0, 1, 2, 1, n, this.mInsets);
        DialogUtil.addUsingGBL(this, this.mCustomRadioButton, this.mConstraints, 0, 2, 2, 1, n, insets);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 1.0;
        this.mInsets.set(10, 28, 25, 0);
        DialogUtil.addUsingGBL(this, this.mValueLabel, this.mConstraints, 0, 3, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mInsets.set(10, insets.left, 25, n2);
        DialogUtil.addUsingGBL(this, this.mValueComboBox, this.mConstraints, 1, 3, 1, 1, n, this.mInsets);
        DialogUtil.createButtonGroup(this);
    }

    private ArrayList<String> loadSourceList(DialogDataModel dialogDataModel) {
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray(this.mDependentList.getIdentifier());
        if (iSpssVariableArray != null && iSpssVariableArray.length > 0) {
            this.mTargetVar = iSpssVariableArray[0];
            return this.createValueLabels(this.mTargetVar);
        }
        return null;
    }

    private ArrayList<String> createValueLabels(ISpssVariable iSpssVariable) {
        this.mValueLabelAndValueTable.clear();
        this.mValidValues.clear();
        IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
        Set set = iValueLabelMap.getValueLabelEntries();
        SPSS_Format sPSS_Format = iSpssVariable.getFormat();
        FormatType formatType = sPSS_Format.getFormatType();
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = formatType.isStringFormat();
        if (set.size() > 0) {
            for (Map.Entry entry : set) {
                String string;
                OBS oBS = (OBS)entry.getKey();
                if (iSpssVariable.isMissing(oBS)) continue;
                StringBuffer stringBuffer = new StringBuffer();
                if (bl) {
                    string = CharacterUtil.rightTrim((String)oBS.getString());
                    stringBuffer.append(string);
                } else {
                    string = CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)sPSS_Format);
                    stringBuffer.append(string);
                }
                stringBuffer.append(" ");
                stringBuffer.append((String)entry.getValue());
                this.mValueLabelAndValueTable.put(stringBuffer.toString(), string);
                this.mValidValues.add(string);
                arrayList.add(stringBuffer.toString());
            }
        }
        return arrayList;
    }
}

