/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import java.util.Collection;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;

public class WizardModel {
    private HashMap<String, AbstractWizardPage> mPageMap = new HashMap();
    private Stack<AbstractWizardPage> mPageTraversalStack = new Stack();

    public boolean registerPage(AbstractWizardPage abstractWizardPage) {
        if (this.mPageTraversalStack.isEmpty()) {
            this.mPageTraversalStack.push(abstractWizardPage);
        }
        if (this.mPageMap.containsKey(abstractWizardPage.getID())) {
            return false;
        }
        this.mPageMap.put(abstractWizardPage.getID(), abstractWizardPage);
        return true;
    }

    public boolean unregisterPage(AbstractWizardPage abstractWizardPage) {
        if (this.mPageMap.containsKey(abstractWizardPage.getID())) {
            this.mPageMap.remove(abstractWizardPage.getID());
            return true;
        }
        return false;
    }

    public AbstractWizardPage getNextPage() {
        AbstractWizardPage abstractWizardPage = this.mPageMap.get(this.getCurrentPage().getNextPage());
        if (abstractWizardPage != null) {
            this.mPageTraversalStack.push(abstractWizardPage);
        }
        return this.mPageTraversalStack.peek();
    }

    public boolean hasPreviousPage() {
        return this.mPageTraversalStack.size() > 1;
    }

    public AbstractWizardPage getPreviousPage() {
        this.mPageTraversalStack.pop();
        if (!this.mPageTraversalStack.isEmpty()) {
            return this.mPageTraversalStack.peek();
        }
        return null;
    }

    public AbstractWizardPage getPage(String string) {
        return this.mPageMap.get(string);
    }

    public AbstractWizardPage getCurrentPage() {
        return this.mPageTraversalStack.peek();
    }

    public void resetStackForTreeTraversal(Vector<AbstractWizardPage> vector) {
        this.mPageTraversalStack.clear();
        for (AbstractWizardPage abstractWizardPage : vector) {
            this.mPageTraversalStack.push(abstractWizardPage);
        }
    }

    public void clearPageMap() {
        this.mPageMap.clear();
    }

    public int getIndexOfPage(AbstractWizardPage abstractWizardPage) {
        return this.mPageTraversalStack.search(abstractWizardPage);
    }

    public Collection<AbstractWizardPage> getValues() {
        return this.mPageMap.values();
    }
}

