/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.IDatasourceAttributes;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.data.DataCellEdit;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class VariableInfoWindow
extends BaseDialog
implements ItemListener {
    private JLabel mVarName = null;
    private JTextArea mVarLabel = null;
    private JComboBox mValueLabelCombo = null;
    private JLabel mValueLabel = null;
    private JComboBox mAttribute = null;
    private JTextArea mAttributeVal = null;
    private ISpssVariable mVariable = null;
    private DataCellEdit mFormatterEdit = new DataCellEdit();
    private JLabel mAttributeLabel = null;
    private JScrollPane mAttrScrollPane = null;

    public VariableInfoWindow(BaseDialog baseDialog) {
        super(baseDialog, ResUtil.getCommonDlgString("IDS_VARIABLE_INFORMATION"), false, ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
        boolean bl;
        this.initializeControls();
        this.setDefaultCloseOperation(1);
        if (JDialog.isDefaultLookAndFeelDecorated() && (bl = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(3);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        IDatasourceAttributes iDatasourceAttributes = this.mVariable.getAttributes();
        if (iDatasourceAttributes != null && this.mAttribute != null) {
            String string = this.mAttribute.getSelectedItem().toString();
            for (int i = 0; i < iDatasourceAttributes.size(); ++i) {
                if (!string.equals(iDatasourceAttributes.name(i))) continue;
                this.fillAttributeTextArea(iDatasourceAttributes.values(i));
            }
        }
    }

    public void setVariable(ISpssVariable iSpssVariable) {
        this.mVariable = iSpssVariable;
        this.updateControls();
    }

    protected JPanel setupCmdButtonPanel() {
        return null;
    }

    private void initializeControls() {
        JPanel jPanel = this.getViewPanel();
        JLabel jLabel = new JLabel(ResUtil.getCommonDlgString("IDS_NAME_COLON"));
        JLabel jLabel2 = new JLabel(ResUtil.getCommonDlgString("IDS_LABEL_COLON"));
        this.mAttributeLabel = DialogUtil.createLabel(this, "IDS_ATTRIBUTES_COLON");
        this.mValueLabel = DialogUtil.createLabel(this, "IDS_VALUE_LABELS_COLON");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, n2 - 1, n2 - 1);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.top = n2 - 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mValueLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mAttributeLabel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.mVarName = new JLabel();
        this.mVarLabel = new JTextArea(1, 30);
        this.mVarLabel.setBackground(SystemColor.control);
        this.mVarLabel.setOpaque(false);
        this.mVarLabel.setFont(this.mVarName.getFont());
        this.mVarLabel.setLineWrap(true);
        this.mVarLabel.setWrapStyleWord(true);
        this.mVarLabel.setEditable(false);
        this.mVarLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.mAttributeVal = new JTextArea();
        this.mAttributeVal.setLineWrap(true);
        this.mAttributeVal.setWrapStyleWord(true);
        this.mAttributeVal.setEditable(false);
        this.mAttributeVal.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                VariableInfoWindow.this.mAttributeVal.setBorder(BorderFactory.createLineBorder(SystemColor.activeCaption));
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                VariableInfoWindow.this.mAttributeVal.setBorder(BorderFactory.createLineBorder(SystemColor.control));
            }
        });
        this.mAttrScrollPane = new JScrollPane(this.mAttributeVal);
        FontMetrics fontMetrics = this.mAttributeVal.getFontMetrics(this.mAttributeVal.getFont());
        this.mAttrScrollPane.getVerticalScrollBar().setUnitIncrement(fontMetrics.getHeight());
        Dimension dimension = this.mAttributeVal.getMinimumSize();
        if (OSInfo.getOSType() == OSInfo.OSType.MAC && dimension.height < 36) {
            dimension.height = 36;
        }
        this.mAttrScrollPane.setPreferredSize(dimension);
        this.mAttrScrollPane.setVerticalScrollBarPolicy(20);
        this.mValueLabelCombo = new JComboBox();
        this.mValueLabel.setLabelFor(this.mValueLabelCombo);
        this.mAttribute = new JComboBox();
        this.mAttributeLabel.setLabelFor(this.mAttribute);
        this.mAttribute.addItemListener(this);
        gridBagConstraints.fill = 2;
        insets.top = 0;
        insets.left = 10;
        DialogUtil.addUsingGBL(jPanel, this.mVarName, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.top = 4;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mVarLabel, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mValueLabelCombo, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mAttribute, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.9;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mAttrScrollPane, gridBagConstraints, 1, 4, 1, 1, n, insets);
        this.setTabTraversalOrder();
    }

    private void updateControls() {
        this.mVarName.setText(this.mVariable != null ? this.mVariable.getName() : "");
        this.mVarLabel.setText(this.mVariable != null ? this.mVariable.getLabel() : "");
        this.fillValueLabelCombo();
        this.fillAttributeCombo();
        this.pack();
    }

    private void fillAttributeCombo() {
        boolean bl;
        this.mAttribute.removeItemListener(this);
        this.mAttribute.removeAllItems();
        IDatasourceAttributes iDatasourceAttributes = this.mVariable.getAttributes();
        boolean bl2 = bl = iDatasourceAttributes != null && iDatasourceAttributes.size() > 0;
        if (bl) {
            for (int i = 0; i < iDatasourceAttributes.size(); ++i) {
                this.mAttribute.addItem(iDatasourceAttributes.name(i));
            }
            this.mAttribute.setSelectedIndex(0);
            this.fillAttributeTextArea(iDatasourceAttributes.values(0));
        } else {
            this.mAttributeVal.setText("");
        }
        this.mAttributeLabel.setEnabled(bl);
        this.mAttribute.setEnabled(bl);
        this.mAttributeVal.setBackground(bl ? Color.white : this.getBackground());
        this.mAttributeVal.setEnabled(bl);
        this.mAttrScrollPane.setEnabled(bl);
        this.mAttribute.addItemListener(this);
    }

    private void fillAttributeTextArea(Vector<String> vector) {
        this.mAttributeVal.setText("");
        for (int i = 0; i < vector.size(); ++i) {
            if (i > 0) {
                this.mAttributeVal.append("\n[" + (i + 1) + "] " + vector.elementAt(i));
                continue;
            }
            this.mAttributeVal.append("[" + (i + 1) + "] " + vector.elementAt(i));
        }
        this.mAttributeVal.setCaretPosition(0);
    }

    private void fillValueLabelCombo() {
        DataMgr dataMgr = DataMgr.getDataMgr();
        ISpssDataSrc iSpssDataSrc = dataMgr.getDataSource(dataMgr.getActiveDocumentId());
        this.mFormatterEdit.setFormat(iSpssDataSrc, this.mVariable != null ? this.mVariable.getFormat() : null);
        boolean bl = false;
        this.mValueLabelCombo.removeAllItems();
        if (this.mVariable != null) {
            IValueLabelMap iValueLabelMap = this.mVariable.getValueLabels();
            boolean bl2 = bl = iValueLabelMap.size() > 0;
            if (bl) {
                ArrayList arrayList = this.mVariable.getSortedValueLabels();
                for (String string : arrayList) {
                    this.mValueLabelCombo.addItem(string);
                }
            }
        }
        this.mValueLabel.setEnabled(bl);
        this.mValueLabelCombo.setEnabled(bl);
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mValueLabelCombo);
        vector.add(this.mAttribute);
        vector.add(this.mAttributeVal);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    public void doHelp() {
    }
}

