/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.dictionary.DateAndTimeVariable;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.LegacyStatVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssCalculatedScaleVar;
import com.spss.java_client.core.documents.data.dictionary.SpssCovariateVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssFactorVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssMRVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssPseudoVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssRandomVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.core.documents.data.dictionary.TimeDependentPredictors;
import com.spss.java_client.ui.dialogs.base.graphs.interactive.SpssIGraphVariable;
import com.spss.shared.core_tools.utils.SerializableObject;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class VarInfoBag
implements SerializableObject {
    private static final int FIRST_VERSION = 1;
    private static final int VERSION = 1;
    private LocallyUniqueId mVarId;
    private String mVarName;
    private String mVarLabel;
    private short mVarType;
    private SPSS_Format mVarFormat;
    private MeasurementLevel mMeasurement;
    private VariableFlavor mVarFlavor;
    private SpssIGraphVariable.SetType mSetType = null;
    private SpssIGraphVariable.VarMeasureType mVarMeasureType = null;
    private int mIGraphVarId = -1;
    private String mExpression = null;

    public VarInfoBag() {
        this(new LocallyUniqueId(), "", "", 0, new SPSS_Format(), MeasurementLevel.unknown);
    }

    public VarInfoBag(ISpssVariable iSpssVariable) throws Exception {
        this(iSpssVariable.getId(), iSpssVariable.getName(), iSpssVariable.getLabel(), iSpssVariable.getType(), iSpssVariable.getFormat(), iSpssVariable.getDisplayMeasurementLevel());
        if (iSpssVariable instanceof SpssMRVariable) {
            SpssMRVariable.MRVarType mRVarType = ((SpssMRVariable)iSpssVariable).getMRVarType();
            this.mVarFlavor = mRVarType == SpssMRVariable.MRVarType.categories ? VariableFlavor.MRCategories : VariableFlavor.MRDichotomies;
        } else if (iSpssVariable instanceof SpssFactorVariable) {
            this.mVarFlavor = VariableFlavor.FactorVariable;
        } else if (iSpssVariable instanceof SpssCovariateVariable) {
            this.mVarFlavor = VariableFlavor.CovariateVariable;
        } else if (iSpssVariable instanceof SpssRandomVariable) {
            this.mVarFlavor = VariableFlavor.RandomVariable;
        } else if (iSpssVariable instanceof DateAndTimeVariable) {
            this.mVarFlavor = VariableFlavor.DateAndTimeVariable;
        } else if (iSpssVariable instanceof TimeDependentPredictors) {
            this.mVarFlavor = VariableFlavor.TimeDependentPredictors;
            this.mExpression = ((TimeDependentPredictors)iSpssVariable).getExpression();
        } else if (iSpssVariable instanceof SpssPseudoVariable) {
            this.mVarFlavor = VariableFlavor.PseudoVariable;
        } else if (iSpssVariable instanceof SpssCalculatedScaleVar) {
            this.mVarFlavor = VariableFlavor.CalculatedScaleVar;
        } else if (iSpssVariable instanceof SpssIGraphVariable) {
            this.mVarFlavor = VariableFlavor.IGraphVariable;
            this.mSetType = ((SpssIGraphVariable)iSpssVariable).getSetType();
            this.mVarMeasureType = ((SpssIGraphVariable)iSpssVariable).getVarMeasureType();
            this.mIGraphVarId = ((SpssIGraphVariable)iSpssVariable).getIGraphVarId();
        } else if (iSpssVariable instanceof LegacyStatVariable) {
            this.mVarFlavor = VariableFlavor.LegacyStatVar;
        } else if (!(iSpssVariable instanceof SpssVariable)) {
            throw new Exception("Need to add new variable type to VarInfoBag and DialogDataModel");
        }
    }

    public VarInfoBag(LocallyUniqueId locallyUniqueId, String string, String string2, short s, SPSS_Format sPSS_Format, MeasurementLevel measurementLevel) {
        this.mVarId = locallyUniqueId;
        this.mVarName = string;
        this.mVarLabel = string2;
        this.mVarType = s;
        this.mVarFormat = sPSS_Format;
        this.mMeasurement = measurementLevel;
        this.mVarFlavor = VariableFlavor.Standard;
    }

    public VariableFlavor getVarFlavor() {
        return this.mVarFlavor;
    }

    public SPSS_Format getVarFormat() {
        return this.mVarFormat;
    }

    public void setVarFormat(SPSS_Format sPSS_Format) {
        this.mVarFormat = sPSS_Format;
    }

    public String getVarLabel() {
        return this.mVarLabel;
    }

    public void setVarLabel(String string) {
        this.mVarLabel = string;
    }

    public String getVarName() {
        return this.mVarName;
    }

    public void setVarName(String string) {
        this.mVarName = string;
    }

    public short getVarType() {
        return this.mVarType;
    }

    public void setVarType(short s) {
        this.mVarType = s;
    }

    public MeasurementLevel getMeasurementLevel() {
        return this.mMeasurement;
    }

    public void setMeasurementLevel(MeasurementLevel measurementLevel) {
        this.mMeasurement = measurementLevel;
    }

    public LocallyUniqueId getVarId() {
        return this.mVarId;
    }

    public void setVarId(LocallyUniqueId locallyUniqueId) {
        this.mVarId = locallyUniqueId;
    }

    public int getIGraphVarId() {
        return this.mIGraphVarId;
    }

    public SpssIGraphVariable.SetType getSetType() {
        return this.mSetType;
    }

    public SpssIGraphVariable.VarMeasureType getVarMeasureType() {
        return this.mVarMeasureType;
    }

    public String getExpression() {
        return this.mExpression;
    }

    public String getClassName() {
        return "com.spss.java_client.ui.dialogs.common.VarInfoBag";
    }

    public boolean readVersionedObject(ObjectInputStream objectInputStream, int n) throws Exception {
        int n2 = objectInputStream.readInt();
        if (n2 > 1) {
            throw new ClassNotFoundException("Bad VarInfoBag version");
        }
        this.mVarFlavor = VariableFlavor.fromInt(objectInputStream.readInt());
        this.mVarId = new LocallyUniqueId(objectInputStream.readInt());
        this.mVarName = objectInputStream.readUTF();
        this.mVarLabel = objectInputStream.readUTF();
        this.mVarType = objectInputStream.readShort();
        this.mVarFormat = new SPSS_Format(objectInputStream.readInt());
        this.mMeasurement = MeasurementLevel.fromShort((short)objectInputStream.readShort());
        if (this.mVarFlavor == VariableFlavor.IGraphVariable) {
            this.mSetType = SpssIGraphVariable.SetType.fromInt(objectInputStream.readInt());
            this.mVarMeasureType = SpssIGraphVariable.VarMeasureType.fromInt(objectInputStream.readInt());
            this.mIGraphVarId = objectInputStream.readInt();
        } else if (this.mVarFlavor == VariableFlavor.TimeDependentPredictors) {
            this.mExpression = objectInputStream.readUTF();
        }
        return true;
    }

    public boolean writeVersionedObject(ObjectOutputStream objectOutputStream, int n) throws Exception {
        objectOutputStream.writeInt(1);
        objectOutputStream.writeInt(this.mVarFlavor.ordinal());
        objectOutputStream.writeInt(this.mVarId.asInt());
        objectOutputStream.writeUTF(this.mVarName);
        objectOutputStream.writeUTF(this.mVarLabel);
        objectOutputStream.writeShort(this.mVarType);
        objectOutputStream.writeInt(this.mVarFormat.asInt());
        objectOutputStream.writeShort(this.mMeasurement.value());
        if (this.mVarFlavor == VariableFlavor.IGraphVariable) {
            objectOutputStream.writeInt(this.mSetType.ordinal());
            objectOutputStream.writeInt(this.mVarMeasureType.ordinal());
            objectOutputStream.writeInt(this.mIGraphVarId);
        } else if (this.mVarFlavor == VariableFlavor.TimeDependentPredictors) {
            objectOutputStream.writeUTF(this.mExpression);
        }
        return true;
    }

    public static final class VariableFlavor
    extends Enum<VariableFlavor> {
        public static final /* enum */ VariableFlavor Standard = new VariableFlavor();
        public static final /* enum */ VariableFlavor MRCategories = new VariableFlavor();
        public static final /* enum */ VariableFlavor MRDichotomies = new VariableFlavor();
        public static final /* enum */ VariableFlavor FactorVariable = new VariableFlavor();
        public static final /* enum */ VariableFlavor CovariateVariable = new VariableFlavor();
        public static final /* enum */ VariableFlavor RandomVariable = new VariableFlavor();
        public static final /* enum */ VariableFlavor DateAndTimeVariable = new VariableFlavor();
        public static final /* enum */ VariableFlavor TimeDependentPredictors = new VariableFlavor();
        public static final /* enum */ VariableFlavor PseudoVariable = new VariableFlavor();
        public static final /* enum */ VariableFlavor CalculatedScaleVar = new VariableFlavor();
        public static final /* enum */ VariableFlavor IGraphVariable = new VariableFlavor();
        public static final /* enum */ VariableFlavor LegacyStatVar = new VariableFlavor();
        private static final /* synthetic */ VariableFlavor[] $VALUES;

        public static VariableFlavor[] values() {
            return (VariableFlavor[])$VALUES.clone();
        }

        public static VariableFlavor valueOf(String string) {
            return Enum.valueOf(VariableFlavor.class, string);
        }

        public static VariableFlavor fromInt(int n) {
            switch (n) {
                default: {
                    assert (false);
                }
                case 0: {
                    return Standard;
                }
                case 1: {
                    return MRCategories;
                }
                case 2: {
                    return MRDichotomies;
                }
                case 3: {
                    return FactorVariable;
                }
                case 4: {
                    return CovariateVariable;
                }
                case 5: {
                    return RandomVariable;
                }
                case 6: {
                    return DateAndTimeVariable;
                }
                case 7: {
                    return TimeDependentPredictors;
                }
                case 8: {
                    return PseudoVariable;
                }
                case 9: {
                    return CalculatedScaleVar;
                }
                case 10: {
                    return IGraphVariable;
                }
                case 11: 
            }
            return LegacyStatVar;
        }

        static {
            $VALUES = new VariableFlavor[]{Standard, MRCategories, MRDichotomies, FactorVariable, CovariateVariable, RandomVariable, DateAndTimeVariable, TimeDependentPredictors, PseudoVariable, CalculatedScaleVar, IGraphVariable, LegacyStatVar};
        }
    }
}

