/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.PassEncrypt;
import com.spss.java_client.core.comp_util.SyntaxCrypt;
import com.spss.java_client.core.documents.data.SaveSyntaxGenerator;
import com.spss.java_client.core.documents.syntax.ISyntaxDocument;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.base.file.EncryptionEnterPasswordDlg;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.uitools.util.IOptionConstants;
import com.spss.uitools.util.PASWFileUtil;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.prefs.Preferences;

public class SyntaxUtil {
    public static StringBuffer startSyntax() {
        return new StringBuffer();
    }

    public static StringBuffer getMainCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (string == null || string.trim().length() == 0) {
            return stringBuffer;
        }
        stringBuffer.append(string);
        return stringBuffer;
    }

    public static StringBuffer getMainCommandParamters(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (string == null || string.trim().length() == 0) {
            return stringBuffer;
        }
        stringBuffer.append(" ");
        stringBuffer.append(string);
        return stringBuffer;
    }

    public static StringBuffer getSubCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (string == null || string.trim().length() == 0) {
            return stringBuffer;
        }
        stringBuffer.append("  ");
        stringBuffer.append(string);
        return stringBuffer;
    }

    public static StringBuffer getCommand(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (string == null) {
            return stringBuffer;
        }
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public static StringBuffer getCommand(String string) {
        return SyntaxUtil.getCommand(string, true);
    }

    public static StringBuffer getMultiParameterSubCommand(String string, List<String> list, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (string == null || list == null) {
            return stringBuffer;
        }
        stringBuffer.append("/");
        stringBuffer.append(string);
        for (String string2 : list) {
            if (string2 == null) continue;
            stringBuffer.append(" ");
            stringBuffer.append(string2);
        }
        if (bl) {
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public static StringBuffer getMultiParameterSubCommand(String string, List<String> list) {
        return SyntaxUtil.getMultiParameterSubCommand(string, list, true);
    }

    public static StringBuffer getSingleParameterSubCommand(String string, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (string == null || string2 == null || string.equals("") || string2.equals("")) {
            return stringBuffer;
        }
        stringBuffer.append("  /");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        if (bl) {
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public static StringBuffer getSingleParameterSubCommand(String string, String string2) {
        return SyntaxUtil.getSingleParameterSubCommand(string, string2, true);
    }

    public static StringBuffer getMultiValueSubCommand(String string, List<String> list, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (string == null || list == null) {
            return stringBuffer;
        }
        String string2 = "";
        for (String string3 : list) {
            if (string3 == null) continue;
            string2 = string2 + " ";
            string2 = string2 + string3;
        }
        if ((string2 = string2.trim()).length() <= 0) {
            return stringBuffer;
        }
        stringBuffer.append("  /");
        stringBuffer.append(string);
        stringBuffer.append("=");
        stringBuffer.append(string2);
        if (bl) {
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public static StringBuffer getMultiValueSubCommand(String string, List<String> list) {
        return SyntaxUtil.getMultiValueSubCommand(string, list, true);
    }

    public static StringBuffer getSingleValueSubCommand(String string, String string2, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (string == null || string2 == null || string.equals("") || string2.equals("")) {
            return stringBuffer;
        }
        if (bl2) {
            stringBuffer.append("  /");
        } else {
            stringBuffer.append("  ");
        }
        stringBuffer.append(string);
        stringBuffer.append("=");
        stringBuffer.append(string2);
        if (bl) {
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public static StringBuffer getSingleValueSubCommand(String string, String string2, boolean bl) {
        return SyntaxUtil.getSingleValueSubCommand(string, string2, bl, true);
    }

    public static StringBuffer getSingleValueSubCommand(String string, String string2) {
        return SyntaxUtil.getSingleValueSubCommand(string, string2, true, true);
    }

    public static StringBuffer getBracedSingleValueSubCommand(String string, String string2, String string3) {
        return SyntaxUtil.getBracedSingleValueSubCommand(string, string2, string3, true);
    }

    public static StringBuffer getBracedSingleValueSubCommand(String string, String string2, String string3, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (string == null || string2 == null || string.equals("") || string2.equals("") || string3.equals("")) {
            return stringBuffer;
        }
        stringBuffer.append("  /");
        stringBuffer.append(string);
        stringBuffer.append("=");
        stringBuffer.append(string2);
        stringBuffer.append("(");
        stringBuffer.append(string3);
        stringBuffer.append(")");
        if (bl) {
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public static String getDelimitedStringFromStringList(ArrayList<String> arrayList, String string) {
        return SyntaxUtil.getDelimitedStringFromStringList(arrayList, string, null);
    }

    public static String getDelimitedStringFromStringList(ArrayList<String> arrayList, String string, Character c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i);
            if (string2 == null || string2.length() <= 0) continue;
            if (c != null) {
                string2 = SyntaxUtil.wrapText(string2, c.charValue());
            }
            stringBuffer.append(string2);
            if (i + 1 >= arrayList.size()) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString().length() > 0 ? stringBuffer.toString() : null;
    }

    public static String wrapTextSingleQuotes(String string) {
        return SyntaxUtil.wrapText(string, '\'', '\'');
    }

    public static String wrapTextDoubleQuotes(String string) {
        return SyntaxUtil.wrapText(string, '\"', '\"');
    }

    public static String wrapText(String string, char c) {
        return SyntaxUtil.wrapText(string, c, c);
    }

    public static String wrapText(String string, char c, char c2) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(c);
        stringBuffer.append(string);
        stringBuffer.append(c2);
        return stringBuffer.toString();
    }

    public static String quoteAndWrapText(String string, boolean bl, char c, char c2) {
        char c3 = bl ? (char)'\'' : '\"';
        String string2 = SyntaxUtil.wrapText(string, c3);
        return SyntaxUtil.wrapText(string2, c, c2);
    }

    public static StringBuffer getBracedMultiValueSubCommand(String string, ArrayList<String> arrayList, ArrayList<String> arrayList2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (string == null || arrayList == null || arrayList2 == null || string.equals("")) {
            return stringBuffer;
        }
        String string2 = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = arrayList.get(i);
            String string4 = arrayList2.get(i);
            if (string3 == null || string4 == null || string3.equals("") || string4.equals("")) continue;
            string2 = string2 + " ";
            string2 = string2 + string3;
            string2 = string2 + "(";
            string2 = string2 + string4;
            string2 = string2 + ")";
        }
        if ((string2 = string2.trim()).length() <= 0) {
            return stringBuffer;
        }
        stringBuffer.append("  /");
        stringBuffer.append(string);
        stringBuffer.append("=");
        stringBuffer.append(string2);
        if (bl) {
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public static StringBuffer getBracedMultiValueSubCommand(String string, ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        return SyntaxUtil.getBracedMultiValueSubCommand(string, arrayList, arrayList2, true);
    }

    public static StringBuffer terminateSyntax() {
        return new StringBuffer(".\n");
    }

    public static boolean readTransformationMergePrefs() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("options");
        Preferences preferences3 = preferences2.node("data");
        return preferences3.get("transformation_merge", PrefDefaults.DEF_TRANSFORMATION_MERGE_OPTION).equals(IOptionConstants.TRANSFORMATION_MERGE_OPTIONS_VALUES[0]);
    }

    public static String prepareFloatForSyntax(float f, int n) {
        if (n < 2) {
            n = 2;
        }
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        decimalFormat.setMinimumFractionDigits(n);
        return decimalFormat.format(f);
    }

    public static int getDecimalDigits(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return 0;
        }
        return string.length() - n - 1;
    }

    public static String removeLeadingZeros(String string) {
        int n = 0;
        while (string.charAt(n) == '0') {
            ++n;
        }
        if (n != 0) {
            string = string.substring(n);
        }
        return string;
    }

    public static ISyntaxDocument openEncryptedSyntaxDocument(File file) {
        String string = null;
        File file2 = file;
        String string2 = SyntaxUtil.getCanonicalPath(file);
        EncryptionEnterPasswordDlg encryptionEnterPasswordDlg = new EncryptionEnterPasswordDlg(SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame(), file.getName());
        encryptionEnterPasswordDlg.setVisible(true);
        if (!encryptionEnterPasswordDlg.isOkSelected()) {
            return null;
        }
        string = encryptionEnterPasswordDlg.getEncryptFilePassword();
        String string3 = PrefsMgr.getPrefsMgr().getTempPath();
        try {
            file2 = PASWFileUtil.createTempFile((String)"decrypt", (String)".sps", (File)new File(string3));
            string3 = file2.getAbsolutePath();
            file2.deleteOnExit();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        if (!SyntaxCrypt.decrypt((String)string, (String)string2, (String)string3)) {
            String string4 = String.format(ComponentState.getSPSSLocale(), CoreResUtil.getString((String)"ERR_FILE_OPEN_PASSWORD_FAILED"), new Object[0]);
            SpssAlertOptionPane.showErrorMessageDialog(SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame(), string4, VersionInfo.getAppVersionString());
            return null;
        }
        ISyntaxDocument iSyntaxDocument = null;
        iSyntaxDocument = SyntaxMgr.getSyntaxMgr().openSyntaxDocument(file, file2);
        if (iSyntaxDocument != null && string != null) {
            iSyntaxDocument.setPassword(string, false);
        }
        return iSyntaxDocument;
    }

    private static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static String getEncryptPasswordSyntax(String string) {
        PassEncrypt passEncrypt = new PassEncrypt();
        byte[] byArray = passEncrypt.encryptPrintableString(string.getBytes(), "'\"");
        String string2 = new String(byArray);
        String string3 = SaveSyntaxGenerator.getEncryptFileSyntax((String)string2, (boolean)true);
        return string3;
    }
}

