/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import java.awt.EventQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class SwingWorker<V>
implements Future<V>,
Runnable {
    private static final Executor EXECUTOR = new Executor(){

        @Override
        public void execute(Runnable runnable) {
            new Thread(runnable).start();
        }
    };
    private Executor executor;
    private boolean started;
    private final FutureTask<V> task = new FutureTask<V>(new Callable<V>(){

        @Override
        public V call() throws Exception {
            return SwingWorker.this.construct();
        }
    }){

        @Override
        protected void done() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingWorker.this.finished();
                }
            });
        }
    };

    public SwingWorker() {
        this(EXECUTOR);
    }

    protected SwingWorker(Executor executor) {
        this.setExecutor(executor);
    }

    public synchronized void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public synchronized Executor getExecutor() {
        return this.executor;
    }

    public synchronized void start() {
        if (!this.started) {
            this.executor.execute(this);
            this.started = true;
        }
    }

    protected abstract V construct() throws Exception;

    protected void finished() {
    }

    @Override
    public void run() {
        this.task.run();
    }

    @Override
    public boolean cancel(boolean bl) {
        return this.task.cancel(bl);
    }

    @Override
    public boolean isCancelled() {
        return this.task.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.task.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.task.get();
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.task.get(l, timeUnit);
    }
}

