/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.commoncode.fieldchooser.util.WindowUtil;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.script.ScriptingUtil;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMUtilities;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.utilities.SpssDateFormatHelper;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.ConsumeStream;
import com.spss.uitools.controls.FocusableLabel;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.apache.commons.codec.binary.Base64;

public class StartupDialog
extends BaseDialog {
    private static String JAVA_CLIENT_PORT = "JAVA_CLIENT_PORT";
    public static final String BUY_STATISTICS_LINK = "http://www.ibm.com/marketplace/spss-statistics/us/en-us?step=Plan&S_TACT=M161008W";
    public static final String BUY_MODELER_LINK = "http://www.ibm.com/marketplace/spss-modeler/us/en-us?step=Plan&S_TACT=M161008W";
    public static final String INVISIBLE_WINDOW = "InvisibleWelcomeWindow";
    StartDialogSelection mStartDialogSelection = StartDialogSelection.UNKNOWN;
    JButton mCancelButton;
    JButton mBuyNowButton;
    JButton mLicenseProductButton;
    JButton mStartTrialButton;
    FocusableLabel mWelcomeToSPSSLabel;
    FocusableTextArea mIfYouAlreadyPurchasedSPSSTextArea;
    FocusableTextArea mPurchaseSPSSLabel;
    FocusableTextArea mLearnMoreAndPurchaseLabel;
    FocusableLabel mTrialDaysLeftLabel;
    FocusableLabel mTrialHasExpiredLabel;
    FocusableLabel mTrialWillStopFunctioningSoonLabel;
    FocusableLabel mInternetConnectionRequiredLabel;
    FocusableLabel mPleaseConnectToTheInternetLabel;
    FocusableLabel mLinuxToLicenseProductLabel;
    JButton mSupportLinkButton;
    JButton mTutorialsLinkButton;
    JButton mVisitCommunitiesLinkButton;
    private static JCheckBox mDontShowMessageAgainSheckbox;
    private String mProductVersionNumber;
    private String mProductName;
    private String mPlatform;
    private String mArchitecture32or64;
    private String mDataMessage;
    private String mTitle;
    private long mDaysLeftOnTrial = -1L;
    private boolean mHasInternetConnection = true;
    private boolean mIsInTrial = true;
    private boolean mIsSpss = true;
    private boolean mBaseInitComplete = false;
    static StartupDialogCallback mStartupDialogCallback;
    private FocusableLabel mStartTrialClickButtonLabel;
    private FocusableTextArea mTrialFirstTimeNoInternetTextArea;
    private FocusableTextArea mInTrialNoInternetTextArea;
    public static boolean mUserIBMIdAuthenticated;

    public static StartDialogSelection showFirstTimeStartupDialog(JFrame jFrame, StartupDialogCallback startupDialogCallback) {
        StartupDialog startupDialog = new StartupDialog(jFrame, true, startupDialogCallback);
        startupDialog.setVisible(true);
        return startupDialog.getStartDialogSelection();
    }

    public static StartDialogSelectionInfo showTrialUseStartupDialog(JFrame jFrame, StartupDialogCallback startupDialogCallback) {
        StartupDialog startupDialog = new StartupDialog(jFrame, false, startupDialogCallback);
        startupDialog.setVisible(true);
        return new StartDialogSelectionInfo(startupDialog.getStartDialogSelection(), startupDialog.isDontShowMessageAgain());
    }

    private StartupDialog(JFrame jFrame, boolean bl, StartupDialogCallback startupDialogCallback) throws HeadlessException {
        super(jFrame, "", ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
        if (startupDialogCallback.getFrameImage() != null) {
            this.setIconImage(startupDialogCallback.getFrameImage());
        }
        this.mBaseInitComplete = true;
        this.mIsInTrial = !bl;
        this.setModal(true);
        this.initInfo(bl, startupDialogCallback);
        this.doInit();
        this.enableControls();
        WindowUtil.centreOnScreen((Window)((Object)this));
        this.enableEvents(208L);
        jFrame.toFront();
    }

    private void enableControls() {
        if (this.mStartTrialButton != null) {
            this.mStartTrialButton.setEnabled(true);
        }
        this.mBuyNowButton.setEnabled(this.mHasInternetConnection || this.hasTrialExpired());
    }

    private boolean isFirstTimeDialog() {
        return !this.mIsInTrial;
    }

    private void initInfo(boolean bl, StartupDialogCallback startupDialogCallback) {
        this.mIsSpss = startupDialogCallback.isSpss();
        this.mHasInternetConnection = StartupDialog.testInternetConnection();
        this.mProductName = this.mIsSpss ? "spss-statistics" : "spss-modeler";
        this.mProductVersionNumber = startupDialogCallback.getProductVersionNumber();
        this.mPlatform = this.getPlatformText();
        this.mDaysLeftOnTrial = startupDialogCallback.getTrialDaysLeft();
        this.mDataMessage = "first-use";
        this.mArchitecture32or64 = OSInfo.is64Bit() ? ResUtil.getCommonDlgString("IDS_HELP_CLIENT_INFO_64BIT") : ResUtil.getCommonDlgString("IDS_HELP_CLIENT_INFO_32BIT");
        this.mTitle = bl ? (this.mIsSpss ? this.getResString("IDS_STARTUP_DLG_SPSS_TITLE") : this.getResString("IDS_STARTUP_DLG_MODELER_TITLE")) : (this.mIsSpss ? this.getResString("IDS_STARTUP_TRIAL_DLG_SPSS_TITLE") : this.getResString("IDS_STARTUP_TRIAL_DLG_MODELER_TITLE"));
        this.setTitle(this.mTitle);
    }

    public String getPlatformText() {
        String string = "";
        OSInfo.OSType oSType = OSInfo.getOSType();
        if (oSType == OSInfo.OSType.WIN) {
            string = this.getResString("IDS_STARTUP_DLG_WIN");
        } else if (oSType == OSInfo.OSType.MAC) {
            string = this.getResString("IDS_STARTUP_DLG_MAC");
        } else if (oSType == OSInfo.OSType.LINUX) {
            string = this.getResString("IDS_STARTUP_DLG_LINUX");
        }
        return string;
    }

    private String getTimeStamp() {
        String string = "";
        long l = Calendar.getInstance().getTimeInMillis();
        return TCMUtilities.formatDateValueToISO8601(l, SpssDateFormatHelper.SimpleDateTimeType.DATETIME);
    }

    protected void doInit() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setUpUI(jPanel);
        this.setAlwaysOnTop(false);
        this.addWindowClosingListener();
        this.pack();
    }

    private void addWindowClosingListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                StartupDialog.this.mStartDialogSelection = !StartupDialog.this.mHasInternetConnection ? StartDialogSelection.CANCEL_EXIT_SELECTED : (StartupDialog.this.mIsInTrial ? (StartupDialog.this.hasTrialExpired() ? StartDialogSelection.CANCEL_EXIT_SELECTED : StartDialogSelection.CONTINUE_TRIAL_SELECTED) : StartDialogSelection.CANCEL_EXIT_SELECTED);
            }
        });
    }

    private boolean hasTrialExpired() {
        return this.mIsInTrial && this.mDaysLeftOnTrial <= 1L;
    }

    private void initVars() {
        this.mWelcomeToSPSSLabel = new FocusableLabel(this.mIsSpss ? this.getResString("IDS_STARTUP_DLG_SPSS_WELCOME_TEXT") : this.getResString("IDS_STARTUP_DLG_MODELER_WELCOME_TEXT"));
        this.mIfYouAlreadyPurchasedSPSSTextArea = this.getIfYouAlreadyPurchasedTextArea();
        if (this.mIsInTrial) {
            String string = this.mIsSpss ? "IBM SPSS Statistics" : "IBM SPSS Modeler";
            this.mTrialHasExpiredLabel = mStartupDialogCallback.getTrialDaysLeft() == 1L ? new FocusableLabel(MessageFormat.format(this.getResString("IDS_STARTUP_TRIAL_DLG_TRIAL_EXPIRED_ONE_DAY_TEXT"), string)) : new FocusableLabel(MessageFormat.format(this.getResString("IDS_STARTUP_TRIAL_DLG_TRIAL_EXPIRED_TEXT"), string));
            this.modifyFontSize(this.mTrialHasExpiredLabel, 4.0f);
            this.mTrialWillStopFunctioningSoonLabel = new FocusableLabel(MessageFormat.format(this.getResString("IDS_STARTUP_TRIAL_DLG_TRIAL_WILL_STOP_FUNCTIONING_SOON_TEXT"), string));
            this.mLearnMoreAndPurchaseLabel = new FocusableTextArea(MessageFormat.format(this.mHasInternetConnection ? this.getResString("IDS_STARTUP_DLG_LEARN_MORE_AND_PURCHASE") : this.getResString("IDS_STARTUP_DLG_CONNECT_TO_LEARN_MORE_AND_PURCHASE"), string));
            this.autoSizeTextArea(this.mLearnMoreAndPurchaseLabel);
            this.mTrialDaysLeftLabel = new FocusableLabel(MessageFormat.format(this.getResString("IDS_STARTUP_TRIAL_DLG_TRIAL_WILL_EXPIRE_TEXT"), string, this.mDaysLeftOnTrial));
            this.modifyFontSize(this.mTrialDaysLeftLabel, 4.0f);
            this.mSupportLinkButton = this.createLinkedTitleButton("IDS_STARTUP_TRIAL_DLG_GET_SUPPORT_BUTTON", new WebLinkAction("https://www.ibm.com/analytics/us/en/spss/spss-support/"));
            this.mTutorialsLinkButton = this.createLinkedTitleButton(this.mIsSpss ? "IDS_STARTUP_TRIAL_DLG_VIEW_SPSS_TUTORIALS_BUTTON" : "IDS_STARTUP_TRIAL_DLG_VIEW_MODELER_TUTORIALS_BUTTON", new HelpLinkAction());
            this.mVisitCommunitiesLinkButton = this.createLinkedTitleButton("IDS_STARTUP_TRIAL_DLG_VISIT_ANALYTICS_COMMUNITY_BUTTON", new WebLinkAction("https://developer.ibm.com/predictiveanalytics"));
            if (mStartupDialogCallback.getTrialDaysLeft() > 1L) {
                mDontShowMessageAgainSheckbox = DialogUtil.createCheckBox(this, "IDS_STARTUP_TRIAL_DLG_DO_NOT_SHOW_THIS_MESSAGE_AGAIN");
            }
            this.mLinuxToLicenseProductLabel = new FocusableLabel(this.mIsSpss ? this.getResString("IDS_STARTUP_TRIAL_DLG_LINUX_TO_LICENSE_SPSS_STATISTICS_LABEL") : this.getResString("IDS_STARTUP_TRIAL_DLG_LINUX_TO_LICENSE_SPSS_MODELER_LABEL"));
            this.mInTrialNoInternetTextArea = new FocusableTextArea(this.getResString("IDS_STARTUP_DLG_IN_TRIAL_NO_INTERNET"));
            this.mInTrialNoInternetTextArea.doAutoSize();
        } else {
            this.mPurchaseSPSSLabel = new FocusableTextArea(this.mHasInternetConnection ? this.getResString("IDS_STARTUP_DLG_PURCHASE_SPSS_MODELER_TEXT") : this.getResString("IDS_STARTUP_DLG_CONNECT_TO_LEARN_MORE_AND_PURCHASE"));
            this.mPurchaseSPSSLabel.doAutoSize();
            this.mInternetConnectionRequiredLabel = new FocusableLabel(this.getResString("IDS_STARTUP_DLG_INTERNET_CONNECTION_REQUIRED_LABEL"));
            this.mPleaseConnectToTheInternetLabel = new FocusableLabel(this.mIsSpss ? this.getResString("IDS_STARTUP_DLG_PLEASE_CONNECT_TO_INTERNET_SPSS_LABEL") : this.getResString("IDS_STARTUP_DLG_PLEASE_CONNECT_TO_INTERNET_MODELER_LABEL"));
            this.mStartTrialClickButtonLabel = new FocusableLabel(this.getResString("IDS_STARTUP_DLG_CLICK_BUTTON_SIGN_IN_IBM_ID"));
            this.mTrialFirstTimeNoInternetTextArea = new FocusableTextArea(this.getResString("IDS_STARTUP_DLG_TRIAL_FIRST_TIME_NO_INTERNET"));
            this.mTrialFirstTimeNoInternetTextArea.doAutoSize();
        }
    }

    private FocusableTextArea getIfYouAlreadyPurchasedTextArea() {
        String string = this.isLinux() ? (this.mIsSpss ? "IDS_STARTUP_DLG_IF_YOU_YOU_ALREADY_PURCHASED_SPSS_STATISTICS_LINUX_TEXT" : "IDS_STARTUP_DLG_IF_YOU_YOU_ALREADY_PURCHASED_SPSS_MODELER_LINUX_TEXT") : (this.mIsSpss ? "IDS_STARTUP_DLG_IF_YOU_YOU_ALREADY_PURCHASED_SPSS_STATISTICS_TEXT" : "IDS_STARTUP_DLG_IF_YOU_YOU_ALREADY_PURCHASED_SPSS_MODELER_TEXT");
        FocusableTextArea focusableTextArea = new FocusableTextArea(this.getResString(string));
        this.autoSizeTextArea(focusableTextArea);
        return focusableTextArea;
    }

    public Dimension autoSizeTextArea(FocusableTextArea focusableTextArea) {
        Dimension dimension = this.getStringDimension(focusableTextArea, focusableTextArea.getText());
        focusableTextArea.setPreferredSize(dimension);
        return dimension;
    }

    private void modifyFontSize(FocusableLabel focusableLabel, float f) {
        focusableLabel.setFont(focusableLabel.getFont().deriveFont((float)focusableLabel.getFont().getSize() + f));
    }

    private Dimension getStringDimension(JComponent jComponent, String string) {
        FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
        String[] stringArray = string.split("\n");
        int n = 0;
        int n2 = 0;
        for (String string2 : stringArray) {
            n2 = fontMetrics.stringWidth(string2);
            n = n2 > n ? n2 : n;
        }
        return new Dimension(n + 10, fontMetrics.getHeight() * stringArray.length);
    }

    private void launchWebPage(String string) {
        try {
            Desktop.getDesktop().browse(new URI(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
    }

    private void setUpUI(JPanel jPanel) {
        if (this.mIsInTrial) {
            if (this.hasTrialExpired()) {
                this.createTrialExpiredLayout(jPanel);
            } else if (this.mHasInternetConnection) {
                this.createTrialInternetConnectionLayout(jPanel);
            } else {
                this.createTrialNoInternetConnectionLayout(jPanel);
            }
        } else {
            this.createFirstTimeInternetConnectionLayout(jPanel);
        }
    }

    private void createFirstTimeInternetConnectionLayout(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, 3, 2);
        Insets insets2 = new Insets(n2, 25, 3, 2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mWelcomeToSPSSLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.createStartTrialPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.createLicenseProductPanel(), gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.createBuyNowPanel(), gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, new JLabel("                   "), gridBagConstraints, 0, 4, 1, 1, n, insets);
    }

    private void createTrialExpiredLayout(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, 3, 2);
        Insets insets2 = new Insets(n2, 25, 3, 2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mWelcomeToSPSSLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.createStartTrialPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.createBuyNowPanel(), gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.createLicenseProductPanel(), gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, new JLabel("                   "), gridBagConstraints, 0, 4, 1, 1, n, insets);
    }

    private JPanel createStartTrialPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(""));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(5, 0, 3, 2);
        Insets insets2 = new Insets(n2, 25, 3, 2);
        int n3 = -1;
        if (this.mIsInTrial && this.hasTrialExpired()) {
            DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTrialHasExpiredLabel, gridBagConstraints, 0, ++n3, 1, 1, n, new Insets(5, 15, 3, 2));
        } else if (this.mIsInTrial && !this.mHasInternetConnection) {
            DialogUtil.addUsingGBL(jPanel, this.mInTrialNoInternetTextArea, gridBagConstraints, 0, ++n3, 1, 1, n, new Insets(5, 15, 3, 2));
            DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTrialDaysLeftLabel, gridBagConstraints, 0, ++n3, 1, 1, n, new Insets(5, 15, 3, 2));
        } else if (this.mHasInternetConnection) {
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            JPanel jPanel2 = this.createStartTrialRegisterWithIBMIDPanel();
            DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, ++n3, 1, 1, n, new Insets(5, 15, 3, 2));
            gridBagConstraints.weightx = 0.25;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, new JLabel("      "), gridBagConstraints, 1, n3, 1, 1, n, insets);
            gridBagConstraints.weightx = 0.25;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, this.mStartTrialButton, gridBagConstraints, 2, n3, 1, 1, 24, new Insets(10, 25, 3, 15));
        } else {
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            JPanel jPanel3 = this.createStartTrialNoInternetPanel();
            DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, ++n3, 1, 1, n, new Insets(5, 15, 3, 2));
        }
        return jPanel;
    }

    private JPanel createStartTrialRegisterWithIBMIDPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mStartTrialClickButtonLabel, gridBagConstraints, 0, 0, 1, 1, n, new Insets(n2 + 2, 0, 3, 2));
        return jPanel;
    }

    private JPanel createStartTrialNoInternetPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mTrialFirstTimeNoInternetTextArea, gridBagConstraints, 0, 0, 1, 1, n, new Insets(n2 + 2, 0, 3, 2));
        return jPanel;
    }

    private JPanel createLicenseProductPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(""));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = new Insets(5, 15, 8, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mIfYouAlreadyPurchasedSPSSTextArea, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, new JLabel("       "), gridBagConstraints, 1, 0, 1, 1, n, insets);
        if (!this.isLinux()) {
            gridBagConstraints.weightx = 0.05;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, this.mLicenseProductButton, gridBagConstraints, 2, 0, 1, 1, 24, new Insets(13, 25, 8, 15));
        }
        return jPanel;
    }

    private JPanel createBuyNowPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(""));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = new Insets(5, 15, 3, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mLearnMoreAndPurchaseLabel != null ? this.mLearnMoreAndPurchaseLabel : this.mPurchaseSPSSLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, new JLabel("        "), gridBagConstraints, 1, 0, 1, 1, n, insets);
        if (this.mHasInternetConnection) {
            gridBagConstraints.weightx = 0.25;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, this.mBuyNowButton, gridBagConstraints, 2, 0, 1, 1, 24, new Insets(8, 25, 8, 15));
        }
        return jPanel;
    }

    private void createTrialInternetConnectionLayout(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, 3, 2);
        Insets insets2 = new Insets(n2, 25, 3, 2);
        int n3 = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTrialDaysLeftLabel, gridBagConstraints, 0, ++n3, 1, 1, n, insets);
        if (!this.hasTrialExpired()) {
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, this.mSupportLinkButton, gridBagConstraints, 0, ++n3, 1, 1, n, insets2);
            DialogUtil.addUsingGBL(jPanel, this.mTutorialsLinkButton, gridBagConstraints, 0, ++n3, 1, 1, n, insets2);
            DialogUtil.addUsingGBL(jPanel, this.mVisitCommunitiesLinkButton, gridBagConstraints, 0, ++n3, 1, 1, n, insets2);
            if (this.isLinux()) {
                DialogUtil.addUsingGBL(jPanel, (JComponent)this.mLinuxToLicenseProductLabel, gridBagConstraints, 0, ++n3, 1, 1, n, insets);
            }
            if (mDontShowMessageAgainSheckbox != null) {
                DialogUtil.addUsingGBL(jPanel, mDontShowMessageAgainSheckbox, gridBagConstraints, 0, ++n3, 1, 1, n, insets);
            }
            DialogUtil.addUsingGBL(jPanel, new JLabel("                             "), gridBagConstraints, 0, ++n3, 1, 1, n, insets);
        }
    }

    private void createTrialNoInternetConnectionLayout(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, 3, 2);
        Insets insets2 = new Insets(n2, 25, 3, 2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mWelcomeToSPSSLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.createStartTrialPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.createLicenseProductPanel(), gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.createBuyNowPanel(), gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, new JLabel("                   "), gridBagConstraints, 0, 4, 1, 1, n, insets);
    }

    private void createTrialExpiredInternetConnectionLayout(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, 3, 2);
        Insets insets2 = new Insets(n2, 25, 3, 2);
        int n3 = 1;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTrialDaysLeftLabel, gridBagConstraints, 0, ++n3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSupportLinkButton, gridBagConstraints, 0, ++n3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mTutorialsLinkButton, gridBagConstraints, 0, ++n3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mVisitCommunitiesLinkButton, gridBagConstraints, 0, ++n3, 1, 1, n, insets2);
        if (mDontShowMessageAgainSheckbox != null) {
            DialogUtil.addUsingGBL(jPanel, mDontShowMessageAgainSheckbox, gridBagConstraints, 0, ++n3, 1, 1, n, insets);
        }
    }

    public void doHelp() {
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = null;
        if (this.mBaseInitComplete) {
            jPanel = new JPanel(true);
            Insets insets = DialogUtil.getStandardButtonInsets();
            boolean bl = DialogUtil.areCommandButtonsBelow();
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            String string = this.mIsInTrial && this.hasTrialExpired() || !this.mIsInTrial || !this.mHasInternetConnection ? this.getResString("IDS_EXIT") : this.getResString("IDS_CANCEL");
            this.mCancelButton = new JButton(new CancelAction(string));
            this.mBuyNowButton = DialogUtil.createButton(this, "IDS_STARTUP_DLG_BUY_NOW");
            this.mBuyNowButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StartupDialog.this.openBrowesrToPage(StartupDialog.this.getBuyNowLinkText());
                }
            });
            if (!this.isLinux()) {
                this.mLicenseProductButton = this.createLicenseProductButton();
            }
            String string2 = "IDS_STARTUP_DLG_START_TRIAL";
            if (this.mIsInTrial) {
                string2 = this.mHasInternetConnection ? (this.hasTrialExpired() ? "IDS_STARTUP_DLG_CONTINUE_TRIAL_EXPIRED" : "IDS_STARTUP_DLG_CONTINUE_TRIAL") : "IDS_EXIT";
            }
            this.mStartTrialButton = DialogUtil.createButton(this, string2);
            this.mStartTrialButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!StartupDialog.this.mIsInTrial) {
                        StartupDialog.this.processStartTrial();
                    } else {
                        StartupDialog.this.mStartDialogSelection = StartDialogSelection.CONTINUE_TRIAL_SELECTED;
                        StartupDialog.this.dispose();
                    }
                }
            });
            if (this.mIsInTrial && !this.hasTrialExpired() && this.mHasInternetConnection) {
                if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                    jPanel.setLayout(new GridBagLayout());
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    Insets insets2 = new Insets(0, n, 0, 0);
                    int n2 = 23;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.fill = 0;
                    int n3 = -1;
                    DialogUtil.addUsingGBL(jPanel, this.mStartTrialButton, gridBagConstraints, ++n3, 0, 1, 1, n2, insets2);
                    if (this.mLicenseProductButton != null) {
                        DialogUtil.addUsingGBL(jPanel, this.mLicenseProductButton, gridBagConstraints, ++n3, 0, 1, 1, n2, insets2);
                    }
                    if (this.mHasInternetConnection) {
                        DialogUtil.addUsingGBL(jPanel, this.mBuyNowButton, gridBagConstraints, ++n3, 0, 1, 1, n2, insets2);
                    }
                } else {
                    FlowLayout flowLayout = new FlowLayout(1, n, 0);
                    jPanel.setLayout(flowLayout);
                    if (this.mHasInternetConnection) {
                        jPanel.add(this.mBuyNowButton);
                    }
                    if (this.mLicenseProductButton != null) {
                        jPanel.add(this.mLicenseProductButton);
                    }
                    jPanel.add(this.mStartTrialButton);
                }
                DialogUtil.createCmdButtonGroup(jPanel);
            } else {
                FlowLayout flowLayout = new FlowLayout(2, n, 0);
                jPanel.setLayout(flowLayout);
                if (!this.mIsInTrial || this.hasTrialExpired() || !this.mHasInternetConnection) {
                    jPanel.add(this.mCancelButton);
                } else {
                    jPanel.add(this.mStartTrialButton);
                }
            }
            this.getRootPane().setDefaultButton(this.mCancelButton);
        }
        return jPanel;
    }

    private JButton createLicenseProductButton() {
        JButton jButton = null;
        if (!this.isLinux()) {
            jButton = DialogUtil.createButton(this, "IDS_STARTUP_DLG_LICENSE_PRODUCT");
            jButton.setToolTipText(ResUtil.getCommonDlgString("IDS_STARTUP_DLG_LICENSE_PRODUCT_TOOLTIP"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    String string = StartupDialog.getLAWPath(StartupDialog.this.mIsSpss);
                    boolean bl = new File(string).exists();
                    if (bl) {
                        object = new Vector<String>();
                        ((Vector)object).add(string);
                        bl = StartupDialog.launchDocument((Vector<String>)object);
                    }
                    if (bl) {
                        StartupDialog.this.mStartDialogSelection = StartDialogSelection.LICENSE_PRODUCT_SELECTED;
                        StartupDialog.this.dispose();
                    } else {
                        object = StartupDialog.this.mIsSpss ? "IBM SPSS Statistics" : "IBM SPSS Modeler";
                        String string2 = OSInfo.getOSType() == OSInfo.OSType.WIN ? "IDS_STARTUP_DLG_UNABLE_TO_LAUNCH_LAW_WINDOWS" : "IDS_STARTUP_DLG_UNABLE_TO_LAUNCH_LAW_MAC";
                        SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)StartupDialog.this), MessageFormat.format(StartupDialog.this.getResString(string2), object), StartupDialog.this.mTitle);
                    }
                }
            });
        }
        return jButton;
    }

    public static boolean launchDocument(Vector<String> vector) {
        boolean bl = true;
        if (vector != null && !vector.isEmpty() && vector.firstElement().length() > 0) {
            if (OSInfo.getOSType() == OSInfo.OSType.WIN) {
                try {
                    Vector<String> vector2 = new Vector<String>();
                    ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                    vector2.add("rundll32");
                    vector2.add("url.dll,FileProtocolHandler");
                    vector2.addAll(vector);
                    Map<String, String> map = processBuilder.environment();
                    map.put(JAVA_CLIENT_PORT, ScriptingUtil.getJCRpcId() + "");
                    processBuilder.command(vector2);
                    Process process = processBuilder.start();
                    new ConsumeStream(process.getInputStream(), System.out).start();
                    new ConsumeStream(process.getErrorStream(), System.err).start();
                }
                catch (Exception exception) {
                    bl = false;
                }
            } else if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                Runtime runtime = Runtime.getRuntime();
                try {
                    Process process = runtime.exec(StartupDialog.getLAWPath(mStartupDialogCallback.isSpss()));
                }
                catch (IOException iOException) {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public StartDialogSelection getStartDialogSelection() {
        return this.mStartDialogSelection;
    }

    public static boolean testInternetConnection() {
        try {
            URL uRL = new URL("https://www.ibm.com");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            Object object = httpURLConnection.getContent();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private String getBuyNowLinkText() {
        return this.mIsSpss ? BUY_STATISTICS_LINK : BUY_MODELER_LINK;
    }

    private void openBrowesrToPage(String string) {
        try {
            Desktop.getDesktop().browse(new URI(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
    }

    private void processStartTrial() {
    }

    private boolean isValidEmailAddress(boolean bl, String string) {
        if (string != null && string.trim().length() > 0) {
            try {
                InternetAddress internetAddress = new InternetAddress(string);
                internetAddress.validate();
            }
            catch (AddressException addressException) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private void sendProductInfo(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{\n");
        stringBuffer.append(SyntaxUtil.wrapTextDoubleQuotes("user_id") + ":" + SyntaxUtil.wrapTextDoubleQuotes(string == null ? "" : string));
        stringBuffer.append(",\n");
        stringBuffer.append(SyntaxUtil.wrapTextDoubleQuotes("install_uid") + ":" + SyntaxUtil.wrapTextDoubleQuotes(""));
        stringBuffer.append(",\n");
        stringBuffer.append(SyntaxUtil.wrapTextDoubleQuotes("timestamp") + ":" + SyntaxUtil.wrapTextDoubleQuotes(this.getTimeStamp()));
        stringBuffer.append(",\n");
        stringBuffer.append(SyntaxUtil.wrapTextDoubleQuotes("product") + ":" + SyntaxUtil.wrapTextDoubleQuotes(this.mProductName));
        stringBuffer.append(",\n");
        stringBuffer.append(SyntaxUtil.wrapTextDoubleQuotes("product_version") + ":" + SyntaxUtil.wrapTextDoubleQuotes(this.mProductVersionNumber) + ".2a");
        stringBuffer.append(",\n");
        stringBuffer.append(SyntaxUtil.wrapTextDoubleQuotes("platform") + ":" + SyntaxUtil.wrapTextDoubleQuotes(this.mPlatform));
        stringBuffer.append(",\n");
        stringBuffer.append(SyntaxUtil.wrapTextDoubleQuotes("architecture") + ":" + SyntaxUtil.wrapTextDoubleQuotes(this.mArchitecture32or64));
        stringBuffer.append(",\n");
        stringBuffer.append(SyntaxUtil.wrapTextDoubleQuotes("message_type") + ":" + SyntaxUtil.wrapTextDoubleQuotes(this.mDataMessage));
        stringBuffer.append("\n}");
        CloudantConnector.postJSONToRepository("https://apmetrix.cloudant.com/spss_metrics", stringBuffer.toString(), "ZnJvdmVzc2lnbmlnaHRsaWd5bXlzaXRo", "Y2VlY2Q5ODJkYzk5ZjMxNzM0MWIzNjVmY2Q1NmViZmRiMzc1MGNiOA==");
    }

    private JButton createLinkedTitleButton(String string, AbstractAction abstractAction) {
        final JButton jButton = new JButton();
        String string2 = this.getResString(string);
        jButton.setName("Button.label");
        jButton.setText(String.format("<HTML><FONT color=\"#000099\"><U>%s</U></FONT></HTML>", string2));
        jButton.setHorizontalAlignment(0);
        jButton.setBorderPainted(false);
        jButton.setOpaque(false);
        Dimension dimension = jButton.getPreferredSize();
        jButton.setPreferredSize(new Dimension(dimension.width, 23));
        jButton.setMaximumSize(new Dimension(dimension.width, 23));
        jButton.setMinimumSize(new Dimension(dimension.width, 23));
        jButton.addActionListener(abstractAction);
        jButton.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                jButton.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
            }
        });
        return jButton;
    }

    public static boolean doFirstTimeAndTrialDialog(StartupDialogCallback startupDialogCallback) {
        mStartupDialogCallback = startupDialogCallback;
        boolean bl = true;
        if (mStartupDialogCallback.isTrialLicense()) {
            if (!mStartupDialogCallback.isGoToTrialInUseDialog() && mStartupDialogCallback.getTrialDaysLeft() > 0L) {
                bl = StartupDialog.createFirstTimeStartupDialog();
            } else if (!mStartupDialogCallback.isDontShowTrialStartupDialog() || mStartupDialogCallback.isDontShowTrialStartupDialog() && mStartupDialogCallback.getTrialDaysLeft() <= 1L) {
                bl = StartupDialog.createTrialStartupAndExpiredDialog();
            }
        }
        return bl;
    }

    private static boolean createFirstTimeStartupDialog() {
        boolean bl = true;
        JFrame jFrame = StartupDialog.createTempFrame();
        StartDialogSelection startDialogSelection = StartupDialog.showFirstTimeStartupDialog(jFrame, mStartupDialogCallback);
        if (startDialogSelection == StartDialogSelection.CANCEL_EXIT_SELECTED || startDialogSelection == StartDialogSelection.LICENSE_PRODUCT_SELECTED) {
            bl = false;
        }
        if (startDialogSelection == StartDialogSelection.START_TRIAL_SELECTED) {
            mStartupDialogCallback.setGotoTrialInUseDlgFlag();
        }
        jFrame.pack();
        jFrame.setVisible(false);
        return bl;
    }

    private static String getLAWPath(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(System.getProperty("application.home"));
        stringBuffer.append(File.separator);
        if (!bl) {
            stringBuffer.append("bin");
            stringBuffer.append(File.separator);
        }
        stringBuffer.append(OSInfo.getOSType() == OSInfo.OSType.WIN ? "law.exe" : "licin.sh");
        return stringBuffer.toString();
    }

    private boolean isLinux() {
        return OSInfo.getOSType() == OSInfo.OSType.LINUX;
    }

    private static boolean createTrialStartupAndExpiredDialog() {
        boolean bl = true;
        JFrame jFrame = StartupDialog.createTempFrame();
        StartDialogSelectionInfo startDialogSelectionInfo = StartupDialog.showTrialUseStartupDialog(jFrame, mStartupDialogCallback);
        StartDialogSelection startDialogSelection = startDialogSelectionInfo.getStartDialogSelection();
        if (startDialogSelection == StartDialogSelection.CANCEL_EXIT_SELECTED || startDialogSelection == StartDialogSelection.LICENSE_PRODUCT_SELECTED) {
            bl = false;
        }
        if (startDialogSelection != StartDialogSelection.CANCEL_EXIT_SELECTED && startDialogSelectionInfo.isDontShowMessageAgain()) {
            mStartupDialogCallback.setDontShowTrialStartupDialogFlag();
        }
        jFrame.pack();
        jFrame.setVisible(false);
        return bl;
    }

    private static JFrame createTempFrame() {
        JFrame jFrame = new JFrame();
        ImageIcon imageIcon = new ImageIcon(ResUtil.getImageURL("IDI_DE_WINDOW_ACTIVE"));
        jFrame.setIconImage(imageIcon.getImage());
        jFrame.setTitle(VersionInfo.getAppVersionString());
        jFrame.setExtendedState(1);
        jFrame.setAlwaysOnTop(OSInfo.getOSType() != OSInfo.OSType.MAC);
        jFrame.setLocationRelativeTo(null);
        jFrame.setName(INVISIBLE_WINDOW);
        return jFrame;
    }

    private boolean isDontShowMessageAgain() {
        return mDontShowMessageAgainSheckbox != null ? mDontShowMessageAgainSheckbox.isSelected() : false;
    }

    static {
        mUserIBMIdAuthenticated = false;
    }

    public static enum StartDialogSelection {
        UNKNOWN,
        CANCEL_EXIT_SELECTED,
        START_TRIAL_SELECTED,
        CONTINUE_TRIAL_SELECTED,
        LICENSE_PRODUCT_SELECTED;

    }

    public static class CloudantConnector {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean postJSONToRepository(String string, String string2, String string3, String string4) {
            boolean bl = true;
            try {
                URL uRL = new URL(string);
                HttpURLConnection httpURLConnection = null;
                try {
                    Object object;
                    String string5;
                    Object object2;
                    Object object3;
                    Object object4;
                    httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    try {
                        object4 = Base64.decodeBase64((byte[])string3.getBytes());
                        object3 = new String((byte[])object4);
                        object2 = Base64.decodeBase64((byte[])string4.getBytes());
                        string5 = new String((byte[])object2);
                        object = (String)object3 + ":" + string5;
                        byte[] byArray = Base64.encodeBase64((byte[])((String)object).getBytes());
                        String string6 = new String(byArray);
                        httpURLConnection.setRequestMethod("POST");
                        httpURLConnection.setDoOutput(true);
                        httpURLConnection.setDoInput(true);
                        httpURLConnection.setUseCaches(false);
                        httpURLConnection.setAllowUserInteraction(false);
                        httpURLConnection.setRequestProperty("Content-Type", "application/json");
                        httpURLConnection.setRequestProperty("Authorization", "Basic " + string6);
                    }
                    catch (ProtocolException protocolException) {
                        protocolException.printStackTrace();
                        bl = false;
                    }
                    object4 = httpURLConnection.getOutputStream();
                    try {
                        object3 = new OutputStreamWriter((OutputStream)object4);
                        ((Writer)object3).write(string2);
                        ((OutputStreamWriter)object3).flush();
                        ((OutputStreamWriter)object3).close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        bl = false;
                    }
                    finally {
                        if (object4 != null) {
                            ((OutputStream)object4).close();
                        }
                    }
                    object3 = httpURLConnection.getInputStream();
                    string5 = null;
                    try {
                        object = new BufferedReader(new InputStreamReader((InputStream)object3));
                        while (true) {
                            String string7 = ((BufferedReader)object).readLine();
                            object2 = string7;
                            if (string7 == null) break;
                            string5 = string5 + (String)object2;
                        }
                        ((BufferedReader)object).close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        bl = false;
                    }
                    finally {
                        if (object3 != null) {
                            ((InputStream)object3).close();
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    bl = false;
                }
                finally {
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                bl = false;
            }
            return bl;
        }
    }

    public static class StartDialogSelectionInfo {
        StartDialogSelection mStartDialogSelection = StartDialogSelection.UNKNOWN;
        boolean mDontShowMessageAgain = false;

        StartDialogSelectionInfo(StartDialogSelection startDialogSelection, boolean bl) {
            this.mStartDialogSelection = startDialogSelection;
            this.mDontShowMessageAgain = bl;
        }

        public StartDialogSelection getStartDialogSelection() {
            return this.mStartDialogSelection;
        }

        public boolean isDontShowMessageAgain() {
            return this.mDontShowMessageAgain;
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction(String string) {
            this.putValue("Name", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StartupDialog.this.mStartDialogSelection = StartDialogSelection.CANCEL_EXIT_SELECTED;
            StartupDialog.this.dispose();
        }
    }

    public static abstract class StartupDialogCallback {
        public abstract boolean isSpss();

        public abstract void doHelp(HelpFlag var1);

        public abstract boolean getBooleanRegistry(RegistryFlag var1);

        public abstract void setBooleanRegistry(RegistryFlag var1, boolean var2);

        public abstract boolean isTrialLicense();

        public abstract long getTrialDaysLeft();

        public abstract String getProductVersionNumber();

        public abstract Image getFrameImage();

        public boolean isGoToTrialInUseDialog() {
            return this.getBooleanRegistry(RegistryFlag.GO_TO_TRIAL);
        }

        public boolean isDontShowTrialStartupDialog() {
            return this.getBooleanRegistry(RegistryFlag.USER_PREF_DONT_SHOW_TRIAL_DLG);
        }

        public void setGotoTrialInUseDlgFlag() {
            this.setBooleanRegistry(RegistryFlag.GO_TO_TRIAL, true);
        }

        public void setDontShowTrialStartupDialogFlag() {
            this.setBooleanRegistry(RegistryFlag.USER_PREF_DONT_SHOW_TRIAL_DLG, true);
        }

        public static enum HelpFlag {
            TUTORIAL;

        }

        public static enum RegistryFlag {
            GO_TO_TRIAL,
            USER_PREF_DONT_SHOW_TRIAL_DLG;

        }
    }

    private class HelpLinkAction
    extends AbstractAction {
        private HelpLinkAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            mStartupDialogCallback.doHelp(StartupDialogCallback.HelpFlag.TUTORIAL);
        }
    }

    private class WebLinkAction
    extends AbstractAction {
        String mWebLink = null;

        private WebLinkAction(String string) {
            this.mWebLink = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StartupDialog.this.launchWebPage(this.mWebLink);
        }
    }
}

