/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.ui.dialogs.common.SpssAboutSplashPanel;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.prefs.Preferences;
import javax.swing.JWindow;

public class SpssSplashWnd
extends JWindow
implements MouseListener {
    private static final int SPLASH_SCREEN_IMAGE_NOT_FOUND = -1;
    private static final int SPLASH_SCREEN_IMAGE_DEFAULT = 0;
    private static final int SPLASH_SCREEN_IMAGE_FULLCLIENT = 1;
    private static final int SPLASH_SCREEN_IMAGE_DEVELOPER = 2;
    private static final int SPLASH_SCREEN_IMAGE_STUDENT = 3;

    public SpssSplashWnd() {
        this.init();
        this.setPreferredSize(new Dimension(650, 503));
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension2.width / 2 - dimension.width / 2, dimension2.height / 2 - dimension.height / 2);
        this.setVisible(true);
        this.toFront();
    }

    private void init() {
        String string;
        this.setLayout(new BorderLayout());
        if (VersionInfo.isStudentVersion()) {
            ComponentState.trace1((String)"* * Splash Screen detected Student version.", (int)32);
            string = ResUtil.getCommonDlgString("IDS_SPLASH_FILENAME_STUDENT");
        } else if (VersionInfo.IsApplicationOnCloud()) {
            string = ResUtil.getCommonDlgString("IDS_SPLASH_FILENAME_CLOUD");
        } else {
            int n = this.getSplashScreenImageToUse();
            if (n == -1) {
                if (VersionInfo.isStatsLiteVersion()) {
                    ComponentState.trace1((String)"* * Splash Screen detected Developer version.", (int)32);
                    string = ResUtil.getCommonDlgString("IDS_SPLASH_FILENAME_DEVELOPR");
                } else {
                    ComponentState.trace1((String)"* * Splash Screen detected Statistics version.", (int)32);
                    string = ResUtil.getCommonDlgString("IDS_SPLASH_FILENAME");
                }
            } else {
                switch (n) {
                    case 3: {
                        string = ResUtil.getCommonDlgString("IDS_SPLASH_FILENAME_STUDENT");
                        break;
                    }
                    case 2: {
                        string = ResUtil.getCommonDlgString("IDS_SPLASH_FILENAME_DEVELOPR");
                        break;
                    }
                    default: {
                        string = ResUtil.getCommonDlgString("IDS_SPLASH_FILENAME");
                    }
                }
            }
        }
        if (VersionInfo.IsApplicationOnCloud()) {
            this.add(new SpssAboutSplashPanel(ResUtil.getCommonDlgString("IDS_HELP_STATS_COPYRIGHT_STMT"), "", false, "", "", ResUtil.getCommonDlgImageResource(string)));
        } else {
            this.add(new SpssAboutSplashPanel(ResUtil.getCommonDlgString("IDS_HELP_STATS_COPYRIGHT_STMT"), ResUtil.getCommonDlgString("IDS_HELP_STATS_VERSION_NUM"), false, "", "", ResUtil.getCommonDlgImageResource(string)));
        }
        this.addMouseListener(this);
    }

    private int getSplashScreenImageToUse() {
        int n = -1;
        Preferences preferences = PrefsMgr.getPrefsMgr().getWorkUserPrefs();
        if (preferences != null) {
            n = preferences.getInt("ISS", -1);
        }
        if (n == -1 && (preferences = PrefsMgr.getPrefsMgr().getBaseSystemPrefs()) != null) {
            n = preferences.getInt("ISS", -1);
        }
        return n;
    }

    public void ensureActive() {
        this.setVisible(true);
        this.toFront();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.setVisible(true);
        this.toFront();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

