/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.core.server.messages.adminmsg.P2PEventMsg;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class SpssP2PMessageDialog
extends BaseDialog {
    private static final String sLineSeparator = "\n";
    private JTextArea mMessageArea;
    private JLabel mIconLabel;
    private String mMessage;
    private JButton mYesOkButton;

    public SpssP2PMessageDialog(P2PEventMsg p2PEventMsg) throws HeadlessException {
        super((JFrame)SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame(), VersionInfo.getAppVersionString(), true, CoreResUtil.getBundle((String)"", (Locale)CoreResUtil.getLocale()), "");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1, ComponentState.getSPSSLocale());
        Date date = new Date();
        String string = dateFormat.format(date);
        this.mMessage = CoreResUtil.getString((String)"IDS_P2P_MESSAGE_TTTLE") + sLineSeparator + CoreResUtil.getString((String)"IDS_P2P_MESSAGE_TO") + ": " + p2PEventMsg.getDestName() + sLineSeparator + CoreResUtil.getString((String)"IDS_P2P_MESSAGE_FROM") + ": " + p2PEventMsg.getSrcName() + sLineSeparator + CoreResUtil.getString((String)"IDS_P2P_MESSAGE_TIME") + ": " + string + sLineSeparator + sLineSeparator + CoreResUtil.getString((String)"IDS_P2P_MESSAGE_1") + ": " + sLineSeparator + p2PEventMsg.getMessage1() + sLineSeparator;
        this.doInit();
        this.pack();
    }

    public void doHelp() {
    }

    public void setMessageText(String string) {
        this.mMessageArea.setText(string);
        FontMetrics fontMetrics = this.getFontMetrics(this.mMessageArea.getFont());
        String[] stringArray = string.split(sLineSeparator);
        int n = 0;
        int n2 = 0;
        for (String string2 : stringArray) {
            n2 = fontMetrics.stringWidth(string2);
            n = n2 > n ? n2 : n;
        }
        int n3 = (int)Math.ceil((float)n / 434.0f);
        this.mMessageArea.setRows(n3 + stringArray.length - 1);
        int n4 = n >= 434 ? 40 : (int)Math.ceil(n / 11) + 1;
        this.mMessageArea.setColumns(n4);
    }

    protected JPanel setupCmdButtonPanel() {
        return null;
    }

    protected void initVars() {
        this.mMessageArea = new JTextArea(this.mMessage);
        this.setMessageText(this.mMessage);
        this.mMessageArea.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.mMessageArea.setOpaque(false);
        this.mMessageArea.setFocusable(false);
        this.mMessageArea.setEditable(false);
        this.mMessageArea.setLineWrap(true);
        this.mMessageArea.setWrapStyleWord(true);
        Icon icon = null;
        this.mIconLabel = new JLabel();
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        UIDefaults uIDefaults = lookAndFeel != null ? lookAndFeel.getDefaults() : UIManager.getDefaults();
        icon = uIDefaults.getIcon("OptionPane.warningIcon", ResUtil.getLocale());
        this.mIconLabel.setIcon(icon);
    }

    protected void addComponents(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(this.mViewPanel, this.mIconLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        if (!bl) {
            gridBagConstraints.weighty = 1.0;
        }
        insets.set(DialogUtil.getGroupBoxInnerMargin() * 2, DialogUtil.getGroupBoxInnerMargin() * 3, 0, DialogUtil.getGroupBoxInnerMargin());
        JScrollPane jScrollPane = new JScrollPane(this.mMessageArea);
        jScrollPane.setPreferredSize(new Dimension(400, 200));
        DialogUtil.addUsingGBL(this.mViewPanel, jScrollPane, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mCmdButtonPanel = this.setupCmdButtons();
        boolean bl2 = UIToolDialogUtil.areCommandButtonsBelow();
        this.mViewPanel.getParent().add((Component)this.mCmdButtonPanel, bl2 ? "South" : "East");
    }

    protected JPanel setupCmdButtons() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        int n = insets.left + insets.right;
        YesOkAction yesOkAction = new YesOkAction();
        this.mYesOkButton = new JButton(yesOkAction);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets2 = new Insets(0, n, 0, 0);
        int n2 = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mYesOkButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
        this.getRootPane().setDefaultButton(this.mYesOkButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    protected boolean canDispose() {
        return true;
    }

    private void doInit() {
        this.initVars();
        this.addComponents(false);
    }

    class YesOkAction
    extends AbstractAction {
        YesOkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpssP2PMessageDialog.this.dispose();
        }
    }
}

