/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.ui.controls.FocusHighlighter;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.DlgKeyAdapter;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class SpssAlertDialog
extends BaseDialog {
    private static final String sLineSeparator = "\n";
    protected ContextTextArea mMessageArea;
    protected String mMessage;
    protected JLabel mIconLabel;
    private int mButtonPressedValue;
    private SpssAlertOptionPane.OptionType mOptionType;
    private SpssAlertOptionPane.IconType mIconType;
    private Object[] mOptions;
    private Object mDefaultSelection;
    private JButton mYesOkButton;
    private JButton mNoButton;
    protected Vector<String> mDateVarNames = null;

    public SpssAlertDialog(JDialog jDialog, ResourceBundle resourceBundle, String string, String string2, SpssAlertOptionPane.IconType iconType) {
        super(jDialog, string2, true, resourceBundle, "");
        this.commonAlertInit(string, iconType, null, null, null);
    }

    public SpssAlertDialog(BaseDialog baseDialog, ResourceBundle resourceBundle, String string, String string2, SpssAlertOptionPane.IconType iconType) {
        super(baseDialog, string2, true, resourceBundle, "");
        this.commonAlertInit(string, iconType, null, null, null);
    }

    public SpssAlertDialog(JDialog jDialog, ResourceBundle resourceBundle, String string, String string2, SpssAlertOptionPane.IconType iconType, SpssAlertOptionPane.OptionType optionType, Object[] objectArray, Object object) {
        super(jDialog, string2, true, resourceBundle, "");
        this.commonAlertInit(string, iconType, optionType, objectArray, object);
    }

    public SpssAlertDialog(BaseDialog baseDialog, ResourceBundle resourceBundle, String string, String string2, SpssAlertOptionPane.IconType iconType, SpssAlertOptionPane.OptionType optionType, Object[] objectArray, Object object) {
        super(baseDialog, string2, true, resourceBundle, "");
        this.commonAlertInit(string, iconType, optionType, objectArray, object);
    }

    public SpssAlertDialog(JFrame jFrame, ResourceBundle resourceBundle, String string, String string2, SpssAlertOptionPane.IconType iconType) throws HeadlessException {
        super(jFrame, string2, true, resourceBundle, "");
        this.commonAlertInit(string, iconType, null, null, null);
    }

    public SpssAlertDialog(JFrame jFrame, ResourceBundle resourceBundle, String string, String string2, SpssAlertOptionPane.IconType iconType, Vector<String> vector) throws HeadlessException {
        super(jFrame, string2, true, resourceBundle, "");
        this.mDateVarNames = vector;
        this.commonAlertInit(string, iconType, null, null, null);
    }

    public SpssAlertDialog(JFrame jFrame, ResourceBundle resourceBundle, String string, String string2, SpssAlertOptionPane.IconType iconType, SpssAlertOptionPane.OptionType optionType, Object[] objectArray, Object object) throws HeadlessException {
        super(jFrame, string2, true, resourceBundle, "");
        this.commonAlertInit(string, iconType, optionType, objectArray, object);
    }

    protected JTextArea getMessageArea() {
        return this.mMessageArea;
    }

    private void commonAlertInit(String string, SpssAlertOptionPane.IconType iconType, SpssAlertOptionPane.OptionType optionType, Object[] objectArray, Object object) {
        this.mMessage = string;
        this.mOptionType = optionType;
        this.mIconType = iconType;
        this.mOptions = objectArray;
        this.mDefaultSelection = object;
        if (this.mOptions != null || this.mOptionType == SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION) {
            this.setDefaultCloseOperation(2);
        } else if (this.mOptionType != null && this.mOptionType == SpssAlertOptionPane.OptionType.YES_NO_OPTION) {
            this.setDefaultCloseOperation(2);
        } else {
            this.setDefaultCloseOperation(2);
        }
        this.doInit();
        this.setTabTraversal();
        this.pack();
    }

    public void doHelp() {
    }

    public void setMessageText(String string) {
        this.mMessageArea.setText(string);
        FontMetrics fontMetrics = this.getFontMetrics(this.mMessageArea.getFont());
        String[] stringArray = string.split(sLineSeparator);
        int n = 0;
        for (String string2 : stringArray) {
            int n2 = fontMetrics.stringWidth(string2);
            n = n2 > n ? n2 : n;
        }
        int n3 = (int)Math.ceil((float)n / 434.0f);
        this.mMessageArea.setRows(n3 + stringArray.length - 1);
        int n4 = fontMetrics.stringWidth("A");
        int n5 = n >= 434 ? 40 : (int)Math.ceil(n / n4) + 1;
        n5 = Math.max(n5, 20);
        this.mMessageArea.setColumns(n5);
    }

    int getButtonPressedValue() {
        return this.mButtonPressedValue;
    }

    protected JPanel setupCmdButtonPanel() {
        return null;
    }

    protected void setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        if (this.mOptions != null) {
            for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
                JButton jButton = (JButton)this.mCmdButtonPanel.getComponent(n);
                String string = jButton.getText();
                if (!string.equalsIgnoreCase((String)this.mDefaultSelection)) continue;
                vector.add(jButton);
                break;
            }
            for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
                if (vector.contains(this.mCmdButtonPanel.getComponent(n)) || !(this.mCmdButtonPanel.getComponent(n) instanceof JButton)) continue;
                vector.add(this.mCmdButtonPanel.getComponent(n));
            }
        } else if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            for (n = this.mCmdButtonPanel.getComponentCount() - 1; n >= 0; --n) {
                if (!(this.mCmdButtonPanel.getComponent(n) instanceof JButton)) continue;
                vector.add(this.mCmdButtonPanel.getComponent(n));
            }
        } else {
            for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
                if (!(this.mCmdButtonPanel.getComponent(n) instanceof JButton)) continue;
                vector.add(this.mCmdButtonPanel.getComponent(n));
            }
        }
        vector.add(this.mMessageArea);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        if (this.mOptionType == SpssAlertOptionPane.OptionType.YES_NO_OPTION) {
            dialogFocusTraversalPolicy.setDefaultComponent(this.mNoButton);
        }
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    protected void initVars() {
        UIDefaults uIDefaults;
        this.mMessageArea = new ContextTextArea(this.mMessage);
        this.setMessageText(this.mMessage);
        this.mMessageArea.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.mMessageArea.setOpaque(false);
        this.mMessageArea.setFocusable(true);
        this.mMessageArea.setEditable(false);
        this.mMessageArea.setLineWrap(true);
        this.mMessageArea.setWrapStyleWord(true);
        Icon icon = null;
        this.mIconLabel = new JLabel();
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        UIDefaults uIDefaults2 = uIDefaults = lookAndFeel != null ? lookAndFeel.getDefaults() : UIManager.getDefaults();
        if (this.mIconType == SpssAlertOptionPane.IconType.eError) {
            icon = uIDefaults.getIcon("OptionPane.errorIcon", ResUtil.getLocale());
        } else if (this.mIconType == SpssAlertOptionPane.IconType.eInformation) {
            icon = uIDefaults.getIcon("OptionPane.informationIcon", ResUtil.getLocale());
        } else if (this.mIconType == SpssAlertOptionPane.IconType.eWarning) {
            icon = uIDefaults.getIcon("OptionPane.warningIcon", ResUtil.getLocale());
        } else if (this.mIconType == SpssAlertOptionPane.IconType.eQuestion) {
            icon = uIDefaults.getIcon("OptionPane.questionIcon", ResUtil.getLocale());
        }
        this.mIconLabel.setIcon(icon);
    }

    protected void addComponents(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        if (this.mIconType != SpssAlertOptionPane.IconType.eNone) {
            DialogUtil.addUsingGBL(this.mViewPanel, this.mIconLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            if (!bl) {
                gridBagConstraints.weighty = 1.0;
            }
            insets.set(DialogUtil.getGroupBoxInnerMargin() * 2, DialogUtil.getGroupBoxInnerMargin() * 3, 0, DialogUtil.getGroupBoxInnerMargin());
            DialogUtil.addUsingGBL(this.mViewPanel, this.mMessageArea, gridBagConstraints, 1, 0, 1, 1, n, insets);
        } else {
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            if (!bl) {
                gridBagConstraints.weighty = 1.0;
            }
            insets.set(DialogUtil.getGroupBoxInnerMargin() * 2, DialogUtil.getGroupBoxInnerMargin() * 3, 0, DialogUtil.getGroupBoxInnerMargin());
            DialogUtil.addUsingGBL(this.mViewPanel, this.mMessageArea, gridBagConstraints, 0, 0, 1, 1, n, insets);
        }
    }

    protected JPanel setupCmdButtons() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        int n = insets.left + insets.right;
        YesOkAction yesOkAction = new YesOkAction();
        this.mYesOkButton = new JButton(yesOkAction);
        if (this.mOptionType == null) {
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                FlowLayout flowLayout = new FlowLayout(2, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mYesOkButton);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mYesOkButton);
            }
        } else if (this.mOptionType == SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION) {
            CancelAction cancelAction = new CancelAction();
            JButton jButton = new JButton(cancelAction);
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                FlowLayout flowLayout = new FlowLayout(2, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(this.mYesOkButton);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mYesOkButton);
                jPanel.add(jButton);
            }
        } else if (this.mOptionType == SpssAlertOptionPane.OptionType.YES_NO_OPTION) {
            yesOkAction.putValue("Name", this.getResString("IDS_YES"));
            yesOkAction.putValue("MnemonicKey", this.getDlgAccessKey("IDK_YES_KEY"));
            NoAction noAction = new NoAction();
            noAction.putValue("Name", this.getResString("IDS_NO"));
            noAction.putValue("MnemonicKey", this.getDlgAccessKey("IDK_NO_KEY"));
            this.mNoButton = new JButton(noAction);
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                FlowLayout flowLayout = new FlowLayout(2, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mNoButton);
                jPanel.add(this.mYesOkButton);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mYesOkButton);
                jPanel.add(this.mNoButton);
            }
        } else if (this.mOptionType == SpssAlertOptionPane.OptionType.YES_NO_CANCEL_OPTION) {
            yesOkAction.putValue("Name", this.getResString("IDS_YES"));
            yesOkAction.putValue("MnemonicKey", this.getDlgAccessKey("IDK_YES_KEY"));
            NoAction noAction = new NoAction();
            noAction.putValue("Name", this.getResString("IDS_NO"));
            noAction.putValue("MnemonicKey", this.getDlgAccessKey("IDK_NO_KEY"));
            this.mNoButton = new JButton(noAction);
            CancelAction cancelAction = new CancelAction();
            JButton jButton = new JButton(cancelAction);
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, this.mNoButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mYesOkButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mYesOkButton);
                jPanel.add(this.mNoButton);
                jPanel.add(jButton);
            }
        }
        if (this.mOptionType == SpssAlertOptionPane.OptionType.YES_NO_OPTION) {
            this.getRootPane().setDefaultButton(this.mNoButton);
        } else {
            this.getRootPane().setDefaultButton(this.mYesOkButton);
        }
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    protected boolean canDispose() {
        this.mButtonPressedValue = -1;
        return true;
    }

    protected void addDlgKeyAdapter() {
        this.mKeyAdapter = new AlertDlgKeyAdapter(this);
    }

    protected void prepareAutomationState() {
    }

    protected void yesOKActionPerformed() {
        this.mButtonPressedValue = this.mOptionType == SpssAlertOptionPane.OptionType.YES_NO_OPTION || this.mOptionType == SpssAlertOptionPane.OptionType.YES_NO_CANCEL_OPTION ? 1 : 0;
        this.dispose();
    }

    private void doInit() {
        this.initVars();
        this.addComponents(false);
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SpssAlertDialog.this.mButtonPressedValue = -1;
            }
        };
        this.addWindowListener(windowAdapter);
        if (this.mCmdButtonPanel == null) {
            this.mCmdButtonPanel = this.mOptions != null ? this.setupOptionButtons() : this.setupCmdButtons();
            if (this.mCmdButtonPanel != null) {
                UIToolDialogUtil.normalizeButtonWidths((JPanel)this.mCmdButtonPanel);
                boolean bl = UIToolDialogUtil.areCommandButtonsBelow();
                this.mViewPanel.getParent().add((Component)this.mCmdButtonPanel, bl ? "South" : "East");
            }
        }
    }

    private JPanel setupOptionButtons() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        int n = insets.left + insets.right;
        FlowLayout flowLayout = new FlowLayout(1, n, 0);
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            flowLayout = new FlowLayout(2, n, 0);
        }
        jPanel.setLayout(flowLayout);
        OptionsButtonAction optionsButtonAction = new OptionsButtonAction();
        JButton jButton = null;
        for (Object object : this.mOptions) {
            String string = (String)object;
            JButton jButton2 = new JButton(optionsButtonAction);
            jButton2.setText(string);
            jPanel.add(jButton2);
            if (!string.equalsIgnoreCase((String)this.mDefaultSelection)) continue;
            jButton = jButton2;
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    class ContextTextArea
    extends JTextArea {
        protected FocusHighlighter mFocusHighlighter;

        ContextTextArea(String string) {
            super(string);
            this.mFocusHighlighter = new FocusHighlighter(this);
            if (this.accessibleContext == null) {
                this.accessibleContext = this.getAccessibleContext();
                this.accessibleContext.setAccessibleName(string);
                this.accessibleContext.setAccessibleDescription(string);
                this.addFocusListener(this.mFocusHighlighter);
            }
        }

        public void setAccessibleContextName(String string) {
            this.accessibleContext.setAccessibleName(string);
        }

        public void setAccessibleContextDescription(String string) {
            this.accessibleContext.setAccessibleDescription(string);
        }
    }

    class OptionsButtonAction
    extends AbstractAction {
        OptionsButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < SpssAlertDialog.this.mCmdButtonPanel.getComponentCount(); ++i) {
                Component component = SpssAlertDialog.this.mCmdButtonPanel.getComponent(i);
                if (!(component instanceof JButton) || !(actionEvent.getSource() instanceof JButton) || !actionEvent.getSource().equals(component)) continue;
                SpssAlertDialog.this.mButtonPressedValue = i;
                break;
            }
            SpssAlertDialog.this.dispose();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpssAlertDialog.this.mButtonPressedValue = 3;
            SpssAlertDialog.this.dispose();
        }
    }

    class NoAction
    extends AbstractAction {
        NoAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_NO"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpssAlertDialog.this.mButtonPressedValue = 2;
            SpssAlertDialog.this.dispose();
        }
    }

    class YesOkAction
    extends AbstractAction {
        YesOkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpssAlertDialog.this.yesOKActionPerformed();
        }
    }

    class AlertDlgKeyAdapter
    extends DlgKeyAdapter {
        AlertDlgKeyAdapter(BaseDialog baseDialog) {
            super(baseDialog);
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 27) {
                if (SpssAlertDialog.this.canDispose()) {
                    if (SpssAlertDialog.this.mOptionType != null && SpssAlertDialog.this.mOptionType == SpssAlertOptionPane.OptionType.YES_NO_OPTION) {
                        SpssAlertDialog.this.mButtonPressedValue = 2;
                    } else {
                        SpssAlertDialog.this.mButtonPressedValue = 3;
                    }
                    SpssAlertDialog.this.dispose();
                }
            } else if (n == ResUtil.getCommonDlgAccessKey("IDK_YES")) {
                if (SpssAlertDialog.this.mOptionType == SpssAlertOptionPane.OptionType.YES_NO_OPTION || SpssAlertDialog.this.mOptionType == SpssAlertOptionPane.OptionType.YES_NO_CANCEL_OPTION) {
                    SpssAlertDialog.this.mYesOkButton.doClick();
                }
            } else if (n == ResUtil.getCommonDlgAccessKey("IDK_NO") && (SpssAlertDialog.this.mOptionType == SpssAlertOptionPane.OptionType.YES_NO_OPTION || SpssAlertDialog.this.mOptionType == SpssAlertOptionPane.OptionType.YES_NO_CANCEL_OPTION)) {
                SpssAlertDialog.this.mNoButton.doClick();
            }
        }
    }
}

