/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.help.BrowserLaunch;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.text.AttributedString;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

public class SpssAboutSplashPanel
extends JPanel {
    AttributedString mParagraphText;
    boolean mShowAboutInfo;
    String mReleaseText;
    String mClientInfo;
    URL mImageURL;
    AttributedString mVersionNum;
    JButton mTermsLinkButton;

    public SpssAboutSplashPanel(String string, String string2, boolean bl, String string3, String string4, URL uRL) {
        this.setBackground(Color.WHITE);
        this.mParagraphText = new AttributedString(string);
        this.mShowAboutInfo = bl;
        this.mReleaseText = string3;
        this.mClientInfo = string4;
        this.mImageURL = uRL;
        int n = (int)VersionInfo.getMajorMinorVersion();
        this.mVersionNum = new AttributedString(string2 + " " + n);
        this.setupPanel();
    }

    private void setupPanel() {
        if (VersionInfo.IsApplicationOnCloud() && this.mShowAboutInfo) {
            this.mTermsLinkButton = new JButton(new TermsAndConditionsAction());
            this.mTermsLinkButton.setContentAreaFilled(false);
            this.mTermsLinkButton.setBorderPainted(false);
            this.mTermsLinkButton.setCursor(new Cursor(12));
            Dimension dimension = new Dimension(50, 70);
            this.mTermsLinkButton.setPreferredSize(dimension);
            BoxLayout boxLayout = new BoxLayout(this, 1);
            this.setLayout(boxLayout);
            this.add(Box.createVerticalGlue());
            this.add(this.mTermsLinkButton);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Rectangle rectangle = this.getBounds();
        rectangle.grow(-20, -10);
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(this.mImageURL);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        graphics.drawImage(bufferedImage, 0, 0, null);
        float f = 19.0f;
        float f2 = 310.0f;
        int n = 10;
        Font font = new Font("SansSerif", 0, n);
        graphics.setFont(font);
        if (this.mShowAboutInfo) {
            if (this.mReleaseText != null) {
                graphics.drawString(this.mReleaseText, (int)f + 2, (int)f2 + 163);
            }
            if (this.mClientInfo != null) {
                graphics.drawString(this.mClientInfo, (int)f + 2, (int)f2 + 180);
            }
        }
        if (!VersionInfo.IsApplicationOnCloud()) {
            TextLayout textLayout;
            this.mParagraphText.addAttribute(TextAttribute.FONT, new Font("SansSerif", 0, n));
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(this.mParagraphText.getIterator(), new FontRenderContext(null, true, false));
            Vector<TextLayout> vector = new Vector<TextLayout>();
            while ((textLayout = lineBreakMeasurer.nextLayout(rectangle.width)) != null) {
                vector.add(textLayout);
            }
            for (TextLayout textLayout2 : vector) {
                textLayout2.draw((Graphics2D)graphics, f, f2 += textLayout2.getAscent());
                f2 += textLayout2.getDescent() + textLayout2.getLeading();
            }
            this.mVersionNum.addAttribute(TextAttribute.FONT, new Font("SansSerif", 1, 12));
            lineBreakMeasurer = new LineBreakMeasurer(this.mVersionNum.getIterator(), new FontRenderContext(null, true, false));
            textLayout = lineBreakMeasurer.nextLayout(rectangle.width);
            textLayout.draw((Graphics2D)graphics, 20.0f, 280.0f);
        }
    }

    class TermsAndConditionsAction
    extends AbstractAction {
        TermsAndConditionsAction() {
            String string = "IDS_TERM_CONDITIONS_KEY";
            this.putValue("Name", "<html><font color=#151B8D><u/>" + ResUtil.getCommonDlgString(string) + "</font></html>");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BrowserLaunch browserLaunch = BrowserLaunch.getBrowserLaunch();
            browserLaunch.openURL("http://www-03.ibm.com/software/sla/sladb.nsf/sla/sd-7669-05");
        }
    }
}

