/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.ibm.statistics.lighttable.ui.LtResUtil;
import com.ibm.statistics.lighttable.ui.util.LtEditorUtil;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.DlgKeyAdapter;
import com.spss.uitools.dialogs.DlgKeyPressListener;
import com.spss.uitools.dialogs.IDlgKeyPressListener;
import com.spss.uitools.dialogs.ResizeConstrainer;
import com.spss.uitools.drop_menu_button.DropButton;
import com.spss.uitools.drop_menu_button.DropButtonDrawer;
import com.spss.uitools.drop_menu_button.DropButtonEx;
import com.spss.uitools.drop_menu_button.FillButtonDrawer;
import com.spss.uitools.drop_menu_button.TextButtonDrawer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SelectTextColorDlg
extends BaseDialog {
    private static final String TEXT_CHAR = LtResUtil.getString((String)"ToolbarTextColorSampleChar");
    protected final String okButtonTxt = ResUtil.getCommonDlgString("IDS_OK");
    protected final String cancelButtonTxt = ResUtil.getCommonDlgString("IDS_CANCEL");
    protected final String helpButtonTxt = ResUtil.getCommonDlgString("IDS_HELP");
    protected JButton mOkButton = null;
    protected JButton mCancelButton = null;
    protected JButton mHelpButton = null;
    protected DropButton mTextColorButton;
    protected DropButton mBKColorButton;
    Color mDefaultBKColor;
    Color mDefaultTextColor;
    boolean mOKSelected = false;

    public SelectTextColorDlg(JDialog jDialog, Color color, Color color2) throws HeadlessException {
        super(jDialog, ResUtil.getCommonDlgString("IDS_CELL_COLOR_DLG_TITLE"), true, ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
        this.init(color, color2);
    }

    public SelectTextColorDlg(SpssFrame spssFrame, Color color, Color color2) throws HeadlessException {
        super((JFrame)spssFrame, ResUtil.getCommonDlgString("IDS_CELL_COLOR_DLG_TITLE"), true, ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
        this.init(color, color2);
    }

    private void init(Color color, Color color2) {
        block5: {
            this.mDefaultBKColor = color;
            this.mDefaultTextColor = color2;
            try {
                Point point;
                Dimension dimension = ProcedureDlgMgr.getMgr().getDialogSize("select_color_dialog");
                if (dimension != null) {
                    this.setSize(dimension);
                }
                if ((point = ProcedureDlgMgr.getMgr().getDialogLocation("select_color_dialog")) != null) {
                    this.setLocation(point);
                } else {
                    this.setLocationRelativeTo(null);
                }
                this.mKeyAdapter = new DlgKeyAdapter((BaseDialog)this);
                this.mKeyAdapter.addDlgKeyPressListener((IDlgKeyPressListener)new DlgKeyPressListener());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!(exception instanceof HeadlessException)) break block5;
                throw (HeadlessException)exception;
            }
        }
        this.layoutPanel();
    }

    private void layoutPanel() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setupPane();
        this.setupBottomPane();
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(this.mOkButton);
        this.pack();
        ResizeConstrainer resizeConstrainer = new ResizeConstrainer((Container)((Object)this), this.getSize());
        this.addComponentListener((ComponentListener)resizeConstrainer);
    }

    protected void setupPane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.mTextColorButton = this.createTextDropButton(true);
        this.mTextColorButton.setUserSelectedColor(this.mDefaultTextColor);
        this.mBKColorButton = this.createFillDropButton(true);
        this.mBKColorButton.setUserSelectedColor(this.mDefaultBKColor);
        Insets insets = new Insets(3, 3, 3, 20);
        JLabel jLabel = new JLabel(ResUtil.getCommonDlgString("IDS_TEXT_COLOR_LABEL"));
        insets = new Insets(3, 3, 3, 3);
        jLabel.setLabelFor((Component)this.mTextColorButton);
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            jLabel.setDisplayedMnemonic(ResUtil.getCommonDlgAccessKey("IDK_TEXT_COLOR_LABEL"));
        }
        gridBagConstraints.fill = 2;
        insets = new Insets(3, 3, 3, 20);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 17, insets);
        insets = new Insets(3, 3, 3, 3);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTextColorButton, gridBagConstraints, 1, 0, 1, 1, 13, insets);
        jLabel = new JLabel(ResUtil.getCommonDlgString("IDS_BK_COLOR_LABEL"));
        jLabel.setLabelFor((Component)this.mBKColorButton);
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            jLabel.setDisplayedMnemonic(ResUtil.getCommonDlgAccessKey("IDK_BK_COLOR_LABEL"));
        }
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, 17, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mBKColorButton, gridBagConstraints, 1, 1, 1, 1, 13, insets);
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.getContentPane(), jPanel, gridBagConstraints, 1, 0, 1, 1, 11, new Insets(15, 1, 5, 5));
        DialogUtil.createCmdButtonGroup(jPanel);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        Component component = FocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (keyEvent.getKeyChar() == '(' && (component == this.mBKColorButton || component == this.mTextColorButton)) {
            keyEvent.consume();
        }
        super.processKeyEvent(keyEvent);
    }

    protected void setupBottomPane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.mOkButton = new JButton(new LogonButtonAction(this.okButtonTxt));
        this.mCancelButton = new JButton(new LogonButtonAction(this.cancelButtonTxt));
        this.mHelpButton = new JButton(new LogonButtonAction(this.helpButtonTxt));
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            Insets insets = new Insets(0, 5, 0, 0);
            int n = 23;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            DialogUtil.setupMacHelpButton(this.mHelpButton);
            DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, 0, 0, 1, 1, n, null);
            n = 24;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        } else {
            Insets insets = new Insets(5, 5, 5, 5);
            DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 0, 0, 1, 1, 10, insets);
            DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 1, 0, 1, 1, 10, insets);
            DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, 2, 0, 1, 1, 10, insets);
        }
        DialogUtil.normalizeButtonWidths((JPanel)jPanel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.getContentPane(), jPanel, gridBagConstraints, 0, 2, 2, 1, 11, new Insets(5, 5, 5, 5));
        DialogUtil.createCmdButtonGroup(jPanel);
    }

    public DropButton createTextDropButton(boolean bl) {
        TextButtonDrawer textButtonDrawer = new TextButtonDrawer(TEXT_CHAR, 0);
        textButtonDrawer.setFontSize(bl ? 24 : 16);
        ToolbarColorButton toolbarColorButton = new ToolbarColorButton((DropButtonDrawer)textButtonDrawer, bl);
        LtEditorUtil.setDropButtonColors((DropButton)toolbarColorButton);
        toolbarColorButton.setToolTipText(LtResUtil.getString((String)"DropBtnTextColor"));
        toolbarColorButton.setFocusable(true);
        return toolbarColorButton;
    }

    public DropButton createFillDropButton(boolean bl) {
        FillButtonDrawer fillButtonDrawer = new FillButtonDrawer();
        ToolbarColorButton toolbarColorButton = new ToolbarColorButton((DropButtonDrawer)fillButtonDrawer, bl);
        LtEditorUtil.setDropButtonColors((DropButton)toolbarColorButton);
        toolbarColorButton.setToolTipText(LtResUtil.getString((String)"DropBtnFillColor"));
        toolbarColorButton.setFocusable(true);
        toolbarColorButton.setUserSelectedColor(Color.WHITE);
        return toolbarColorButton;
    }

    public void doHelp() {
    }

    public Color getSelectedBKColor() {
        return this.mBKColorButton.getUserSelectedColor();
    }

    public Color getSelectedTextColor() {
        return this.mTextColorButton.getUserSelectedColor();
    }

    public boolean isOKSelected() {
        return this.mOKSelected;
    }

    protected JPanel setupCmdButtonPanel() {
        return null;
    }

    public class LogonButtonAction
    extends AbstractAction {
        public LogonButtonAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SelectTextColorDlg.this.mOkButton) {
                ProcedureDlgMgr.getMgr().saveDialogSize("select_color_dialog", SelectTextColorDlg.this.getSize());
                ProcedureDlgMgr.getMgr().saveDialogLocation("select_color_dialog", SelectTextColorDlg.this.getLocation());
                SelectTextColorDlg.this.mOKSelected = true;
                SelectTextColorDlg.this.dispose();
            } else if (object == SelectTextColorDlg.this.mCancelButton) {
                SelectTextColorDlg.this.dispose();
            } else if (object == SelectTextColorDlg.this.mHelpButton) {
                SelectTextColorDlg.this.doHelp();
            }
        }
    }

    class ToolbarColorButton
    extends DropButtonEx {
        private Dimension mDimension;

        ToolbarColorButton(DropButtonDrawer dropButtonDrawer, boolean bl) {
            super(dropButtonDrawer);
            this.mDimension = bl ? new Dimension(40, 35) : new Dimension(30, 25);
        }

        public Dimension getPreferredSize() {
            return this.mDimension;
        }
    }
}

