/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SPSSFontColorRenderer;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.texteditor.SpssTextPane;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.FontUtil;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.SPSSTextField;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.AttributedString;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;

public class SPSSFontChooser
extends BaseDialog
implements ListSelectionListener,
ActionListener,
KeyListener,
ItemListener {
    private static ResourceBundle sBundle = ResUtil.getBundle("com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle", ResUtil.getLocale());
    private static String[] sStyles = new String[]{sBundle.getString("IDS_FONT_REGULAR"), sBundle.getString("IDS_FONT_ITALIC"), sBundle.getString("IDS_FONT_BOLD"), sBundle.getString("IDS_FONT_BOLD_ITALIC")};
    private static String[] sSizes = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    private static String[] sSizesReduced;
    private ContextEnabledTextField mFontNameText;
    private ContextEnabledTextField mFontStyleText;
    private SPSSTextField mFontSizeText;
    private JList mFontNameList;
    private JList mFontStyleList;
    private JList mFontSizeList;
    private JButton mOkButton = new JButton(sBundle.getString("IDS_OK"));
    private JButton mCancelButton = new JButton(sBundle.getString("IDS_CANCEL"));
    private String mSampleString = "AaBbYyZz";
    private String mMessageString = sBundle.getString("IDS_FONT_SAMPLE_MESG");
    private JTextArea mMessageArea;
    private JPanel mSamplePanel;
    private SampleConvas mSampleCanvas = new SampleConvas(this.mSampleString);
    private int mReturnValue;
    private Font mFont;
    private boolean mNeedEffectsPanel;
    private JCheckBox mStrikeOutCheck;
    private JCheckBox mUnderLineCheck;
    private JComboBox mColorCombo;
    private boolean mReadOnlySize;
    private boolean mInListSearch;

    public SPSSFontChooser(Window window, boolean bl, String string, int n, int n2) {
        this(window, bl, string, n, n2, true, false, null);
    }

    public SPSSFontChooser(Window window, boolean bl, String string, int n, int n2, boolean bl2, boolean bl3, LinkedHashMap<String, Object> linkedHashMap) {
        this(window, bl, string, n, n2, bl2, bl3, linkedHashMap, true);
    }

    public SPSSFontChooser(Window window, boolean bl, String string, int n, float f, boolean bl2, boolean bl3, LinkedHashMap<String, Object> linkedHashMap, boolean bl4) {
        super(window, sBundle.getString("IDS_FONT_CHOOSER_DIALOG_TITLE"), bl, sBundle, null);
        Point point;
        this.mNeedEffectsPanel = bl3;
        this.mReadOnlySize = !bl4;
        this.mInListSearch = false;
        this.init(string, n, f, bl2, bl4);
        if (bl3) {
            this.mUnderLineCheck.setSelected((Boolean)linkedHashMap.get("IDS_UNDERLINE_VALUE"));
            this.mStrikeOutCheck.setSelected((Boolean)linkedHashMap.get("IDS_STRIKE_VALUE"));
            int n2 = FontUtil.convertColorToIndex((Color)((Color)linkedHashMap.get("IDS_COLOR_VALUE")));
            this.mSampleCanvas.setForeground(FontUtil.convertIndexToColor((int)n2));
            this.mColorCombo.setSelectedIndex(n2);
        }
        this.pack();
        this.setResizable(true);
        this.setFocusTraversalPolicy(bl2);
        Dimension dimension = ProcedureDlgMgr.getMgr().getDialogSize("view_fonts");
        if (dimension != null) {
            this.setSize(dimension);
        }
        if ((point = ProcedureDlgMgr.getMgr().getDialogLocation("view_fonts")) != null) {
            this.setLocation(point);
        } else {
            this.setLocationRelativeTo(window);
        }
        this.setVisible(true);
    }

    public SPSSFontChooser(Window window, boolean bl, String string, int n, int n2, boolean bl2) {
        this(window, bl, string, n, n2, bl2, false, null);
    }

    public int getReturnValue() {
        return this.mReturnValue;
    }

    public boolean isUnderLine() {
        return this.mUnderLineCheck.isSelected();
    }

    public boolean isStrikeThrough() {
        return this.mStrikeOutCheck.isSelected();
    }

    public int getSelectedColorIndex() {
        if (this.mNeedEffectsPanel) {
            return this.mColorCombo.getSelectedIndex();
        }
        return 0;
    }

    public Font getSelectedFont() {
        return this.mFont;
    }

    private void init(String string, int n, float f, boolean bl, boolean bl2) {
        JComponent jComponent;
        int n2;
        Integer[] integerArray;
        Color[] colorArray;
        Serializable serializable;
        if (this.mNeedEffectsPanel) {
            serializable = new ToggleButtonAction("IDS_FONTCHOOSER_STRIKE_CHECK");
            this.mStrikeOutCheck = new JCheckBox((Action)((Object)serializable));
            serializable = new ToggleButtonAction("IDS_FONTCHOOSER_UNDERLINE_CHECK");
            this.mUnderLineCheck = new JCheckBox((Action)((Object)serializable));
            colorArray = new Color[]{Color.BLACK, new Color(160, 0, 0), new Color(53, 94, 59), new Color(128, 128, 0), new Color(0, 0, 128), new Color(128, 0, 128), new Color(0, 128, 128), Color.GRAY, new Color(192, 192, 192), Color.RED, Color.GREEN, Color.YELLOW, Color.BLUE, new Color(255, 0, 255), new Color(0, 255, 255), Color.WHITE};
            integerArray = new Integer[colorArray.length];
            for (n2 = 0; n2 < colorArray.length; ++n2) {
                integerArray[n2] = n2;
            }
            this.mColorCombo = new JComboBox<Integer>(integerArray);
            this.mColorCombo.setRenderer(new SPSSFontColorRenderer(sBundle.getStringArray("IDS_FONT_CHOOSER_COLOR_COMBO"), colorArray, sBundle.getLocale()));
            this.mColorCombo.setMaximumRowCount(16);
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.mColorCombo.setPreferredSize(new Dimension(100, 20));
            }
        }
        serializable = new JPanel();
        ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        colorArray = this.getContentPane();
        colorArray.add((Component)serializable);
        ((Container)serializable).setLayout(new GridBagLayout());
        integerArray = new GridBagConstraints();
        n2 = 23;
        Insets insets = new Insets(0, 0, 0, 5);
        integerArray.weightx = 0.0;
        integerArray.weighty = 0.0;
        integerArray.fill = 0;
        JLabel jLabel = new JLabel(sBundle.getString("IDS_FONT"));
        JLabel jLabel2 = new JLabel(sBundle.getString("IDS_FONT_STYLE"));
        JLabel jLabel3 = new JLabel(sBundle.getString("IDS_FONT_SIZE"));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            jLabel.setDisplayedMnemonic((Integer)ResUtil.getObject("IDK_FONT_KEY", sBundle));
            jLabel2.setDisplayedMnemonic((Integer)ResUtil.getObject("IDK_FONT_STYLE_KEY", sBundle));
            jLabel3.setDisplayedMnemonic((Integer)ResUtil.getObject("IDK_FONT_SIZE_KEY", sBundle));
        }
        integerArray.weightx = 1.0;
        DialogUtil.addUsingGBL((Container)serializable, jLabel, (GridBagConstraints)integerArray, 0, 0, 1, 1, n2, insets);
        integerArray.weightx = 0.0;
        DialogUtil.addUsingGBL((Container)serializable, jLabel2, (GridBagConstraints)integerArray, 1, 0, 1, 1, n2, insets);
        if (bl) {
            DialogUtil.addUsingGBL((Container)serializable, jLabel3, (GridBagConstraints)integerArray, 2, 0, 1, 1, n2, insets);
        }
        this.mFontNameList = new JList<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(ResUtil.getLocale()));
        this.mFontNameList.setPreferredSize(new Dimension(this.mFontNameList.getPreferredSize().width + 20, this.mFontNameList.getPreferredSize().height));
        this.mFontStyleList = new JList<String>(sStyles);
        this.mFontStyleList.setPreferredSize(new Dimension(this.mFontStyleList.getPreferredSize().width + 20, this.mFontStyleList.getPreferredSize().height));
        this.mFontSizeList = bl2 ? new JList<String>(sSizes) : new JList<String>(sSizesReduced);
        this.mFontSizeList.setPreferredSize(new Dimension(this.mFontSizeList.getPreferredSize().width + 20, this.mFontSizeList.getPreferredSize().height));
        this.mFontNameList.setSelectionMode(0);
        this.mFontStyleList.setSelectionMode(0);
        this.mFontSizeList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.mFontNameList);
        JScrollPane jScrollPane2 = new JScrollPane(this.mFontStyleList);
        JScrollPane jScrollPane3 = new JScrollPane(this.mFontSizeList);
        integerArray.fill = 1;
        integerArray.weightx = 1.0;
        integerArray.weighty = 1.0;
        DialogUtil.addUsingGBL((Container)serializable, jScrollPane, (GridBagConstraints)integerArray, 0, 2, 1, 2, n2, insets);
        integerArray.fill = 3;
        integerArray.weightx = 0.0;
        integerArray.weighty = 0.0;
        DialogUtil.addUsingGBL((Container)serializable, jScrollPane2, (GridBagConstraints)integerArray, 1, 2, 1, 2, n2, insets);
        if (bl) {
            DialogUtil.addUsingGBL((Container)serializable, jScrollPane3, (GridBagConstraints)integerArray, 2, 2, 1, 2, n2, insets);
        }
        this.mFontNameText = new ContextEnabledTextField();
        this.mFontNameText.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width, this.mFontNameText.getPreferredSize().height));
        this.mFontStyleText = new ContextEnabledTextField();
        this.mFontStyleText.setPreferredSize(new Dimension(jScrollPane2.getPreferredSize().width, this.mFontStyleText.getPreferredSize().height));
        this.mFontSizeText = bl2 ? new IntTextField(3, 100, true) : new FloatTextField();
        this.mFontSizeText.setPreferredSize(new Dimension(jScrollPane3.getPreferredSize().width, this.mFontSizeText.getPreferredSize().height));
        integerArray.fill = 2;
        integerArray.weightx = 1.0;
        DialogUtil.addUsingGBL((Container)serializable, (JComponent)this.mFontNameText, (GridBagConstraints)integerArray, 0, 1, 1, 1, n2, insets);
        integerArray.weightx = 0.0;
        DialogUtil.addUsingGBL((Container)serializable, (JComponent)this.mFontStyleText, (GridBagConstraints)integerArray, 1, 1, 1, 1, n2, insets);
        if (bl) {
            integerArray.fill = 2;
            DialogUtil.addUsingGBL((Container)serializable, (JComponent)this.mFontSizeText, (GridBagConstraints)integerArray, 2, 1, 1, 1, n2, insets);
        } else {
            jComponent = new JLabel();
            jComponent.setPreferredSize(jScrollPane3.getPreferredSize());
            DialogUtil.addUsingGBL((Container)serializable, jComponent, (GridBagConstraints)integerArray, 2, 2, 1, 2, n2, insets);
        }
        if (!bl2) {
            this.mFontSizeText.setEditable(false);
            this.mFontSizeText.setBackground(Color.lightGray);
        }
        this.mSamplePanel = new JPanel();
        this.mSamplePanel.setLayout(new BorderLayout());
        this.mSamplePanel.setBorder(BorderFactory.createTitledBorder(sBundle.getString("IDS_FONT_SAMPLE")));
        this.mSampleCanvas.setHorizontalAlignment(0);
        this.mSampleCanvas.setBorder(BorderFactory.createLoweredBevelBorder());
        this.mSampleCanvas.setPreferredSize(new Dimension(this.mSampleCanvas.getPreferredSize().height + 20, this.mSampleCanvas.getPreferredSize().width));
        this.mSamplePanel.add(this.mSampleCanvas);
        integerArray.fill = 2;
        if (this.mNeedEffectsPanel) {
            DialogUtil.addUsingGBL((Container)serializable, this.mSamplePanel, (GridBagConstraints)integerArray, 1, 4, 2, 1, n2, insets);
        } else {
            DialogUtil.addUsingGBL((Container)serializable, this.mSamplePanel, (GridBagConstraints)integerArray, 0, 4, 3, 1, n2, insets);
        }
        this.setUpMessageArea();
        integerArray.weighty = this.mNeedEffectsPanel ? 0.0 : 1.0;
        integerArray.fill = 2;
        if (this.mNeedEffectsPanel) {
            DialogUtil.addUsingGBL((Container)serializable, this.mMessageArea, (GridBagConstraints)integerArray, 1, 5, 3, 1, n2, insets);
        } else {
            DialogUtil.addUsingGBL((Container)serializable, this.mMessageArea, (GridBagConstraints)integerArray, 0, 5, 3, 1, n2, insets);
        }
        if (this.mNeedEffectsPanel) {
            insets = new Insets(0, 0, 1, 5);
            DialogUtil.addUsingGBL((Container)serializable, this.setUpEffectPanel(), (GridBagConstraints)integerArray, 0, 4, 1, 2, n2, insets);
            jComponent = new JTextArea(sBundle.getString("IDS_FONT_STATIC_TEXT"));
            ((JTextArea)jComponent).setLineWrap(true);
            ((JTextArea)jComponent).setWrapStyleWord(true);
            jComponent.setBorder(null);
            jComponent.setOpaque(false);
            jComponent.setFocusable(false);
            jComponent.setPreferredSize(new Dimension(300, 30));
            integerArray.weighty = 1.0;
            DialogUtil.addUsingGBL((Container)serializable, jComponent, (GridBagConstraints)integerArray, 0, 6, 3, 1, n2, insets);
        }
        jComponent = new JPanel();
        jComponent.setLayout(new GridLayout(2, 1));
        jComponent.add(this.mOkButton);
        jComponent.add(this.mCancelButton);
        integerArray.fill = 0;
        integerArray.weightx = 0.0;
        integerArray.weighty = 0.0;
        DialogUtil.addUsingGBL((Container)serializable, this.mOkButton, (GridBagConstraints)integerArray, 3, 1, 1, 2, n2, new Insets(0, 0, 5, 0));
        integerArray.weighty = 1.0;
        DialogUtil.addUsingGBL((Container)serializable, this.mCancelButton, (GridBagConstraints)integerArray, 3, 3, 1, 1, n2, new Insets(0, 0, 5, 0));
        DialogUtil.normalizeButtonWidths((JPanel)serializable);
        jLabel.setLabelFor((Component)this.mFontNameText);
        jLabel2.setLabelFor((Component)this.mFontStyleText);
        jLabel3.setLabelFor((Component)this.mFontSizeText);
        this.getRootPane().setDefaultButton(this.mOkButton);
        Font font = Font.decode(string);
        this.mFontNameList.setSelectedValue(font.getFamily(), true);
        this.mFontStyleList.setSelectedIndex(FontUtil.convertStyleToIndex((int)n));
        String string2 = bl2 ? SpssTextPane.formatLogicalFontSize(f) : SpssTextPane.formatLogicalFontSize(FontUtil.physicalToLogicalSize((float)f));
        this.mFontSizeList.setSelectedValue(string2, true);
        this.addListeners();
        this.mFontSizeText.setText(string2);
        this.mFont = FontUtil.makeFont((String)font.getFamily(), (int)FontUtil.convertIndexToStyle((int)this.mFontStyleList.getSelectedIndex()), (float)f, (boolean)bl2);
        if (this.mNeedEffectsPanel) {
            this.mSampleCanvas.setForeground(FontUtil.convertIndexToColor((int)this.mColorCombo.getSelectedIndex()));
        }
        if (this.mFont.canDisplayUpTo(this.mSampleString) >= 0) {
            this.mMessageArea.setText(this.mMessageString);
        } else {
            this.mMessageArea.setText("");
        }
        this.mSampleCanvas.repaint();
        this.mReturnValue = 0;
    }

    private void addListeners() {
        this.mFontNameList.addListSelectionListener(this);
        this.mFontNameList.addKeyListener(this);
        this.mFontStyleList.addListSelectionListener(this);
        this.mFontSizeList.addListSelectionListener(this);
        this.mOkButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mFontNameText.addKeyListener((KeyListener)this);
        this.mFontStyleText.addKeyListener((KeyListener)this);
        this.mFontSizeText.addKeyListener((KeyListener)this);
        if (this.mNeedEffectsPanel) {
            this.mUnderLineCheck.addItemListener(this);
            this.mStrikeOutCheck.addItemListener(this);
            this.mColorCombo.addItemListener(this);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.callMakeFontFunction(listSelectionEvent);
    }

    private void callMakeFontFunction(Object object) {
        Object object2 = ((EventObject)object).getSource();
        String string = (String)this.mFontNameList.getSelectedValue();
        String string2 = (String)this.mFontStyleList.getSelectedValue();
        String string3 = (String)this.mFontSizeList.getSelectedValue();
        if (object2 == this.mFontNameList) {
            if (!this.mInListSearch) {
                this.mFontNameText.setText(string);
                this.mFontNameText.setSelectionStart(0);
                this.mFontNameText.setSelectionEnd(string.length());
                this.mFontNameText.requestFocus();
            }
        } else if (object2 == this.mFontStyleList) {
            if (!this.mInListSearch) {
                this.mFontStyleText.setText(string2);
                this.mFontStyleText.setSelectionStart(0);
                this.mFontStyleText.setSelectionEnd(string2.length());
                this.mFontStyleText.requestFocus();
            }
        } else if (object2 == this.mFontSizeList) {
            if (string3 != null) {
                this.mFontSizeText.setText(string3);
                if (!this.mReadOnlySize) {
                    this.mFontSizeText.setSelectionStart(0);
                    this.mFontSizeText.setSelectionEnd(string3.length());
                }
            }
            if (!this.mReadOnlySize) {
                this.mFontSizeText.requestFocus();
            }
        }
        if (!this.mReadOnlySize && string3 == null && this.mFontSizeText.getText().length() > 0) {
            string3 = this.mFontSizeText.getText();
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(ComponentState.getSPSSLocale());
        float f = 9.0f;
        try {
            if (string3 != null) {
                f = numberFormat.parse(string3).floatValue();
            }
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        this.mFont = FontUtil.makeFont((String)string, (int)FontUtil.convertIndexToStyle((int)this.mFontStyleList.getSelectedIndex()), (float)f, (boolean)true);
        if (this.mNeedEffectsPanel) {
            this.mSampleCanvas.setForeground(FontUtil.convertIndexToColor((int)this.mColorCombo.getSelectedIndex()));
        }
        if (this.mFont.canDisplayUpTo(this.mSampleString) >= 0) {
            this.mMessageArea.setText(this.mMessageString);
        } else {
            this.mMessageArea.setText("");
        }
        this.mSampleCanvas.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        ProcedureDlgMgr.getMgr().saveDialogSize("view_fonts", this.getSize());
        ProcedureDlgMgr.getMgr().saveDialogLocation("view_fonts", this.getLocation());
        if (object == this.mOkButton) {
            this.mReturnValue = 0;
            this.dispose();
        } else {
            this.mReturnValue = 2;
            this.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.callMakeFontFunction(itemEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.mFontNameText) {
            StringBuffer stringBuffer = new StringBuffer(this.mFontNameText.getText() + keyEvent.getKeyChar());
            int n = stringBuffer.length();
            ListModel listModel = this.mFontNameList.getModel();
            int n2 = -1;
            for (int i = 0; i < listModel.getSize(); ++i) {
                String string = (String)listModel.getElementAt(i);
                if (string.length() < n || !string.substring(0, n).equalsIgnoreCase(stringBuffer.toString())) continue;
                n2 = i;
                break;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            this.mFontNameList.ensureIndexIsVisible(n2);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
            int n;
            int n2 = n = keyEvent.getKeyCode() == 38 ? -1 : 1;
            if (object == this.mFontNameText) {
                int n3 = this.mFontNameList.getSelectedIndex() + n;
                this.mFontNameList.setSelectedIndex(n3);
                this.mFontNameList.ensureIndexIsVisible(n3);
            } else if (object == this.mFontStyleText) {
                int n4 = this.mFontStyleList.getSelectedIndex() + n;
                this.mFontStyleList.setSelectedIndex(n4);
                this.mFontStyleList.ensureIndexIsVisible(n4);
            } else if (object == this.mFontSizeText) {
                int n5 = this.mFontSizeList.getSelectedIndex() + n;
                this.mFontSizeList.setSelectedIndex(n5);
                this.mFontSizeList.ensureIndexIsVisible(n5);
            }
        } else if (object == this.mFontSizeText) {
            // empty if block
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (object == this.mFontNameText) {
            this.mInListSearch = true;
            this.mFontNameList.setSelectedIndex(this.mFontNameList.getNextMatch(this.mFontNameText.getText(), this.mFontNameList.getSelectedIndex(), Position.Bias.Forward));
            this.mFontNameList.ensureIndexIsVisible(this.mFontNameList.getSelectedIndex());
            this.mInListSearch = false;
        } else if (object == this.mFontStyleText) {
            this.mInListSearch = true;
            this.mFontStyleList.setSelectedIndex(this.mFontStyleList.getNextMatch(this.mFontStyleText.getText(), this.mFontStyleList.getSelectedIndex(), Position.Bias.Forward));
            this.mFontStyleList.ensureIndexIsVisible(this.mFontStyleList.getSelectedIndex());
            this.mInListSearch = false;
        } else if (object == this.mFontSizeText) {
            String string = this.mFontSizeText.getText();
            if (string == null) {
                this.mFontSizeList.clearSelection();
                this.mFontSizeList.scrollRectToVisible(this.mFontSizeList.getCellBounds(0, 0));
            } else if (!string.equals(this.mFontSizeList.getSelectedValue())) {
                ListModel listModel = this.mFontSizeList.getModel();
                int n = listModel.getSize();
                for (int i = 0; i < n; ++i) {
                    if (!string.equals(listModel.getElementAt(i))) continue;
                    this.mFontSizeList.setSelectedIndex(i);
                    this.mFontSizeList.ensureIndexIsVisible(i);
                    this.repaint();
                    return;
                }
                this.mFontSizeList.clearSelection();
                this.mFontSizeList.scrollRectToVisible(this.mFontSizeList.getCellBounds(0, 0));
                this.callMakeFontFunction(keyEvent);
            }
            this.repaint();
        }
    }

    private JPanel setUpEffectPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(sBundle.getString("IDS_FONT_CHOOSER_EFFECT_PANEL_TITLE")));
        JLabel jLabel = new JLabel(sBundle.getString("IDS_FONT_CHOOSER_COLOR_LABEL"), 10);
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            jLabel.setDisplayedMnemonic((Integer)ResUtil.getObject("IDK_FONT_CHOOSER_COLOR_LABEL_KEY", sBundle));
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n, n, 0, 0);
        int n2 = 23;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mStrikeOutCheck, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mUnderLineCheck, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 2, 2, 1, n2, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mColorCombo, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        return jPanel;
    }

    private void setUpMessageArea() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.mMessageArea = new JTextArea();
        Dimension dimension = this.mMessageArea.getPreferredSize();
        dimension.width = this.mSamplePanel.getPreferredSize().width + 40;
        this.mMessageArea.setPreferredSize(dimension);
        this.mMessageArea.setRows(2);
        this.mMessageArea.setOpaque(false);
        Font font = this.mSamplePanel.getFont();
        Font font2 = new Font(font.getFontName(), font.getStyle(), 10);
        this.mMessageArea.setFont(font2);
        this.mMessageArea.setLineWrap(true);
        this.mMessageArea.setWrapStyleWord(true);
        this.mMessageArea.setText("");
        this.mMessageArea.setFocusable(false);
    }

    private void setFocusTraversalPolicy(boolean bl) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mFontNameText);
        vector.add(this.mFontNameList);
        vector.add(this.mFontStyleText);
        vector.add(this.mFontStyleList);
        if (bl) {
            vector.add(this.mFontSizeText);
            vector.add(this.mFontSizeList);
        }
        if (this.mNeedEffectsPanel) {
            vector.add(this.mStrikeOutCheck);
            vector.add(this.mUnderLineCheck);
            vector.add(this.mColorCombo);
        }
        vector.add(this.mOkButton);
        vector.add(this.mCancelButton);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    public void doHelp() {
    }

    protected JPanel setupCmdButtonPanel() {
        return null;
    }

    static {
        float[] fArray = SpssTextPane.getLogicalFontSizes();
        sSizesReduced = new String[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            SPSSFontChooser.sSizesReduced[i] = SpssTextPane.formatLogicalFontSize(fArray[i]);
        }
    }

    class SampleConvas
    extends JLabel {
        public SampleConvas(String string) {
            super(string);
        }

        @Override
        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Font font = new Font(SPSSFontChooser.this.mFont.getAttributes());
            AttributedString attributedString = new AttributedString(SPSSFontChooser.this.mSampleString);
            attributedString.addAttribute(TextAttribute.FONT, font);
            if (SPSSFontChooser.this.mUnderLineCheck != null && SPSSFontChooser.this.mUnderLineCheck.isSelected()) {
                attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_TWO_PIXEL);
            } else {
                attributedString.addAttribute(TextAttribute.UNDERLINE, false);
            }
            if (SPSSFontChooser.this.mStrikeOutCheck != null && SPSSFontChooser.this.mStrikeOutCheck.isSelected()) {
                attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            } else {
                attributedString.addAttribute(TextAttribute.STRIKETHROUGH, false);
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            int n = fontMetrics.getDescent();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(SPSSFontChooser.this.mSampleString, graphics2D);
            Dimension dimension = this.getSize();
            int n2 = (int)(((double)dimension.width - rectangle2D.getWidth()) / 2.0);
            int n3 = (int)(((double)dimension.height + rectangle2D.getHeight()) / 2.0);
            graphics2D.drawString(attributedString.getIterator(), Math.abs(n2), Math.abs(n3) - n);
        }
    }
}

