/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.error_handler.ErrorDispatcher;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.core.server.IReconnectListener;
import com.spss.java_client.core.server.ReconnectReadThread;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.dialogs.IProgressUIAgent;
import com.spss.uitools.util.TraceSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Calendar;
import java.util.Random;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class ReconnectDialog
extends JDialog
implements WindowListener,
ActionListener,
IProgressUIAgent,
IReconnectListener {
    private JButton mCancelButton;
    private JTextArea mStatusTextArea;
    private JProgressBar mProgressBar;
    protected MessagePanel mStatusMessage;
    protected JPanel mMessagePanel;
    private boolean mIsCancel = false;
    private Thread mInterruptThread;
    private Calendar mEndTime;
    private int totalTimeoutSeconds;

    public ReconnectDialog(JFrame jFrame, String string, int n) {
        super((Frame)jFrame, string);
        this.setModal(true);
        this.mInterruptThread = null;
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        ImageIcon imageIcon = new ImageIcon(ResUtil.getImageURL("IDI_DE_WINDOW_ACTIVE"));
        this.setIconImage(imageIcon.getImage());
        this.mStatusTextArea = new JTextArea();
        this.mStatusTextArea.setEditable(false);
        this.mStatusTextArea.setWrapStyleWord(true);
        this.mStatusTextArea.setLineWrap(true);
        Dimension dimension = new Dimension(100, 100);
        this.mStatusTextArea.setPreferredSize(dimension);
        this.mStatusTextArea.setMinimumSize(dimension);
        this.mStatusTextArea.setText(ResUtil.getString("IDS_RECONNECT_ATTEMPT_TEXT"));
        this.mEndTime = Calendar.getInstance();
        this.mEndTime.add(12, n);
        this.totalTimeoutSeconds = n * 60;
        this.creatPanel();
        container.add(this.mMessagePanel);
        this.addWindowListener(this);
        this.setLocationRelativeTo(null);
        this.pack();
    }

    public ReconnectDialog() {
        this.mEndTime = Calendar.getInstance();
        this.mEndTime.add(12, 1);
        this.totalTimeoutSeconds = 60;
        this.creatPanel();
    }

    public JPanel getMessagePanel() {
        return this.mMessagePanel;
    }

    public String getRemainingValues(long l) {
        int n = (int)l / 3600;
        String string = String.format("%02d:%02d:%02d", n, l / 60L % 60L, l % 60L);
        return String.format(ComponentState.getSPSSLocale(), ResUtil.getString("IDS_RECONNECT_PROGRESS_TEXT"), string);
    }

    public void setDeterminateMode() {
        this.mProgressBar.setIndeterminate(false);
        this.mProgressBar.setStringPainted(false);
        this.mProgressBar.setMinimum(0);
        this.mProgressBar.setMaximum(100);
        this.mProgressBar.setValue(0);
    }

    public void setMessage(String string) {
        this.mStatusMessage.updateInfoText(string);
    }

    public void setValue(int n) {
        this.mProgressBar.setIndeterminate(false);
        this.mProgressBar.setValue(n);
    }

    public int getPercentage(long l) {
        return 100 - (int)(100L * l / (long)this.totalTimeoutSeconds);
    }

    public long getRemainingSecond() {
        Calendar calendar = Calendar.getInstance();
        return (this.mEndTime.getTimeInMillis() - calendar.getTimeInMillis()) / 1000L;
    }

    public int getValue() {
        return this.mProgressBar.getValue();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.mIsCancel = true;
        this.abortThread();
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        int n = SpssAlertOptionPane.showConfirmDialog(this, ResUtil.getString("IDS_CANCEL_RECONNECT_TEXT"), this.getTitle(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
        if (n == 1) {
            ComponentState.SetReconnectState((ReconnectReadThread.ReconnectStateEnum)ReconnectReadThread.ReconnectStateEnum.SHUTTINGDOWN);
            Calendar calendar = Calendar.getInstance();
            TraceSettings.trace1((String)("Reconnect TimeOut expired at " + String.format("%tc", calendar)), (int)3840);
            ComponentState.setProcessorAvailable((boolean)false);
            DataServerProxy.getDataProxy().disconnect(false);
            ErrorDispatcher.getErrorDispatcher().dispatchError(CoreResUtil.getString((String)"SRS_ReconnectFailed"), "");
            this.mIsCancel = true;
            this.abortThread();
            this.dispose();
        }
    }

    public synchronized boolean abort() {
        return this.mIsCancel;
    }

    public void setInterruptThread(Thread thread) {
        this.mInterruptThread = thread;
    }

    public void setCancel(boolean bl) {
        this.mIsCancel = bl;
    }

    public void reconnected() {
        this.mIsCancel = true;
        this.abortThread();
        this.dispose();
    }

    private void abortThread() {
        if (this.mInterruptThread != null && this.mInterruptThread.isAlive()) {
            try {
                this.mInterruptThread.interrupt();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.mInterruptThread = null;
        }
    }

    private static void addUsingGBL(JPanel jPanel, JComponent jComponent, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, Insets insets) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.insets = insets == null ? new Insets(0, 0, 0, 0) : insets;
        jPanel.add((Component)jComponent, gridBagConstraints);
    }

    private void creatPanel() {
        this.mMessagePanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(5, 10, 5, 10);
        int n = 23;
        UIDefaults uIDefaults = UIManager.getDefaults();
        Icon icon = uIDefaults.getIcon("OptionPane.errorIcon", ResUtil.getLocale());
        Font font = new JTextArea().getFont();
        MessagePanel messagePanel = new MessagePanel(font, true);
        messagePanel.setFocusable(false);
        messagePanel.setTextAndIcon(ResUtil.getString("IDS_RECONNECT_ATTEMPT_TEXT"), icon, 4);
        messagePanel.setPreferredSize(new Dimension(400, 80));
        messagePanel.setMinimumSize(new Dimension(400, 80));
        this.mProgressBar = new JProgressBar(0, 100);
        this.mProgressBar.setPreferredSize(new Dimension(350, 30));
        this.mProgressBar.setMinimumSize(new Dimension(350, 30));
        this.mProgressBar.setIndeterminate(false);
        this.mProgressBar.setStringPainted(false);
        this.mProgressBar.setValue(0);
        this.mStatusMessage = new MessagePanel(font, false);
        int n2 = 0;
        String string = this.getRemainingValues(n2);
        this.mStatusMessage.setTextAndIcon(string, null, 1);
        this.mStatusMessage.setFocusable(false);
        this.mStatusMessage.setPreferredSize(new Dimension(120, 30));
        this.mStatusMessage.setMinimumSize(new Dimension(120, 30));
        this.mCancelButton = new JButton(ResUtil.getString("IDS_RECONNECT_ATTEMPT_CLOSE"));
        this.mCancelButton.setMnemonic(ResUtil.getAccessKey("IDK_RECONNECT_ATTEMPT_CLOSE"));
        this.mCancelButton.addActionListener(this);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mMessagePanel, messagePanel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        insets.set(5, 10, 5, 2);
        DialogUtil.addUsingGBL(this.mMessagePanel, this.mProgressBar, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(8, 2, 5, 10);
        DialogUtil.addUsingGBL(this.mMessagePanel, this.mStatusMessage, gridBagConstraints, 1, 1, 1, 1, n, insets);
        JSeparator jSeparator = new JSeparator();
        insets.set(15, 10, 5, 10);
        ReconnectDialog.addUsingGBL(this.mMessagePanel, jSeparator, gridBagConstraints, 0, 3, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(10, 10, 5, 10);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mMessagePanel, this.mCancelButton, gridBagConstraints, 0, 4, 2, 1, 10, insets);
        Vector<Object> vector = new Vector<Object>();
        vector.add(messagePanel);
        vector.add(this.mStatusMessage);
        vector.add(this.mCancelButton);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    public void start() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                int n = 0;
                long l = ReconnectDialog.this.totalTimeoutSeconds;
                while (l > 0L && !ReconnectDialog.this.abort()) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    long l2 = ReconnectDialog.this.getRemainingSecond();
                    n = ReconnectDialog.this.getPercentage(l2);
                    if (n > ReconnectDialog.this.getValue()) {
                        ReconnectDialog.this.setValue(Math.min(n, 100));
                    }
                    if (l2 == l) continue;
                    ReconnectDialog.this.setMessage(ReconnectDialog.this.getRemainingValues(l2));
                    l = l2;
                }
                ReconnectDialog.this.dispose();
            }
        };
        thread.start();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Reconnect Progress Bar Demo");
        ReconnectDialog reconnectDialog = new ReconnectDialog();
        reconnectDialog.setCursor(Cursor.getPredefinedCursor(3));
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(reconnectDialog.getMessagePanel());
        jFrame.pack();
        jFrame.setVisible(true);
        int n = 0;
        Random random = new Random();
        while (n < 100 && !reconnectDialog.abort()) {
            long l;
            try {
                Thread.sleep(random.nextInt(100));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((n = reconnectDialog.getPercentage(l = reconnectDialog.getRemainingSecond())) <= reconnectDialog.getValue()) continue;
            reconnectDialog.setValue(Math.min(n, 100));
            reconnectDialog.setMessage(reconnectDialog.getRemainingValues(l));
        }
        if (reconnectDialog.abort()) {
            jFrame.dispose();
        }
    }

    public static class MessagePanel
    extends JPanel {
        private JTextArea mInfoDesc;
        private JLabel mIconLabel;
        private boolean mHasIcon;

        public MessagePanel(Font font, boolean bl) {
            this.mHasIcon = bl;
            this.setLayout(new GridBagLayout());
            this.initLayout(font);
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    MessagePanel.this.repaint();
                    MessagePanel.this.getAccessibleContext().setAccessibleName("");
                    MessagePanel.this.getAccessibleContext().setAccessibleDescription(MessagePanel.this.mInfoDesc.getText());
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    MessagePanel.this.repaint();
                    MessagePanel.this.getAccessibleContext().setAccessibleName("");
                    MessagePanel.this.getAccessibleContext().setAccessibleDescription("");
                }
            });
        }

        protected void initLayout(Font font) {
            this.mInfoDesc = new JTextArea();
            this.mInfoDesc.setOpaque(false);
            this.mInfoDesc.setFont(font);
            this.mInfoDesc.setLineWrap(true);
            this.mInfoDesc.setWrapStyleWord(true);
            this.mInfoDesc.setText("");
            this.mInfoDesc.setFocusable(false);
            if (this.mHasIcon) {
                this.mIconLabel = new JLabel();
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            int n = 23;
            int n2 = 0;
            int n3 = 0;
            Insets insets = new Insets(6, 4, 2, 2);
            if (this.mHasIcon) {
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(this, this.mIconLabel, gridBagConstraints, n2, 0, 1, 1, n, insets);
                ++n2;
                insets = null;
            }
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            DialogUtil.addUsingGBL(this, this.mInfoDesc, gridBagConstraints, n2, n3, 1, 1, n, insets);
        }

        public void setTextAndIcon(String string, Icon icon, int n) {
            this.mInfoDesc.setText(string);
            this.mInfoDesc.setRows(n);
            this.mInfoDesc.setEnabled(true);
            if (this.mHasIcon && icon != null) {
                this.mIconLabel.setIcon(icon);
                this.mIconLabel.setEnabled(true);
            }
        }

        public void updateInfoText(String string) {
            this.mInfoDesc.setText(string);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.hasFocus()) {
                this.paintFocus(graphics);
            }
        }

        public void paintFocus(Graphics graphics) {
            Color color = UIManager.getColor("ToggleButton.focus");
            graphics.setColor(color);
            Rectangle rectangle = new Rectangle(0, 0, this.getBounds().width, this.getBounds().height);
            rectangle.grow(-1, -1);
            BasicGraphicsUtils.drawDashedRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

