/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.uitools.util.WindowUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class ProcedureDlgMgr {
    private static final int MAX_RECALL_ITEMS = 12;
    private static ProcedureDlgMgr sDialogMgr = null;
    private HashMap<String, BaseProcedureDialog> mDialogMap = new HashMap();
    private HashMap<Integer, HashMap<String, DialogDataModel>> mDatasetMaps = new HashMap();
    private LinkedList<RecallItem> mTotalRecall = new LinkedList();
    private BaseProcedureDialog mLastDialog = null;
    LinkedList<WindowInfo> mWindowInfoList;
    public static final String WINDOW_INFO_PREFS = "WINDOW_INFO_PREFS";
    public static final String WINDOW_SIZE_LOCATION = "WINDOW_SIZE_LOCATION";
    public static final int MAX_WINDOW_PREFS = 250;

    public static ProcedureDlgMgr getMgr() {
        if (sDialogMgr == null) {
            sDialogMgr = new ProcedureDlgMgr();
        }
        return sDialogMgr;
    }

    public LocallyUniqueId getActiveDatasetId() {
        LocallyUniqueId locallyUniqueId = null;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
        }
        return locallyUniqueId;
    }

    public BaseProcedureDialog getProcedureDialog(String string) {
        BaseProcedureDialog baseProcedureDialog = null;
        if (this.mDialogMap.containsKey(string)) {
            baseProcedureDialog = this.mDialogMap.get(string);
        }
        return baseProcedureDialog;
    }

    public boolean addProcedureDialog(String string, BaseProcedureDialog baseProcedureDialog) {
        this.mLastDialog = baseProcedureDialog;
        if (this.mDialogMap.containsKey(string)) {
            BaseProcedureDialog baseProcedureDialog2 = this.mDialogMap.get(string);
            if (baseProcedureDialog2.isVisible()) {
                ComponentState.trace1((String)("Use existing procedure dialog: " + string), (int)1);
                baseProcedureDialog.dispose();
                this.mDialogMap.put(string, baseProcedureDialog2);
                baseProcedureDialog2.toFront();
                return false;
            }
            baseProcedureDialog2.dispose();
            this.mDialogMap.remove(string);
        }
        ComponentState.trace1((String)("Adding procedure dialog: " + string), (int)1);
        this.mDialogMap.put(string, baseProcedureDialog);
        return true;
    }

    public boolean removeProcedureDialog(String string) {
        ComponentState.trace1((String)("Removing procedure dialog: " + string), (int)1);
        if (this.mLastDialog != null && this.mDialogMap.containsKey(string) && this.mDialogMap.get(string) == this.mLastDialog) {
            this.mLastDialog = null;
        }
        return this.mDialogMap.remove(string) != null;
    }

    public void closeAllProcedureDialogs() {
        ComponentState.trace1((String)"Closing all procedure dialogs", (int)1);
        HashMap<String, BaseProcedureDialog> hashMap = new HashMap<String, BaseProcedureDialog>();
        hashMap.putAll(this.mDialogMap);
        for (Map.Entry entry : hashMap.entrySet()) {
            if (ProcedureDlgMgr.isExceptionDialog(((BaseProcedureDialog)((Object)entry.getValue())).getIActionKey())) continue;
            ((BaseProcedureDialog)((Object)entry.getValue())).setVisible(false);
            ((BaseProcedureDialog)((Object)entry.getValue())).dispose();
        }
        this.mLastDialog = null;
    }

    public void clearDatasetMaps() {
        this.mDatasetMaps.clear();
    }

    public boolean anyProcedureDialogsRunning(boolean bl) {
        if (bl) {
            for (Map.Entry<String, BaseProcedureDialog> entry : this.mDialogMap.entrySet()) {
                if (ProcedureDlgMgr.isExceptionDialog(entry.getKey())) continue;
                return true;
            }
            return false;
        }
        return this.mDialogMap.size() > 0;
    }

    public static boolean isExceptionDialog(String string) {
        return string.equals("utilities_oms_control_panel") || string.equals("utilities_oms_identifiers") || string.equals("data_ortho_design_generate") || string.equals("data_copy_data_property") || string.equals("transform_random_number_generators") || string.equals("analyze_stem_data_preparation") || string.equals("analyze_power_analysys_compare_means_one_way") || string.equals("analyze_power_analysys_compare_means_one_ttest") || string.equals("analyze_power_analysys_compare_means_paired_ttest") || string.equals("analyze_power_analysys_compare_means_independent_ttest");
    }

    public static boolean isSpecialDialog(String string) {
        return string.equals("utilities_monte_carlo_simulation_dialog") || string.equals("utilities_monte_carlo_simulation_model_dialog") || string.equals("utilities_monte_carlo_simulation_create_data_dialog");
    }

    public boolean keepCurrentDialogOpen() {
        HashMap<String, BaseProcedureDialog> hashMap = new HashMap<String, BaseProcedureDialog>();
        hashMap.putAll(this.mDialogMap);
        for (Map.Entry entry : hashMap.entrySet()) {
            if (!ProcedureDlgMgr.isSpecialDialog(((BaseProcedureDialog)((Object)entry.getValue())).getIActionKey())) continue;
            return true;
        }
        return false;
    }

    public void saveDialogSize(String string, Dimension dimension) {
        this.addWindowInfo(string, dimension, null);
        this.saveWindowInfoStringToPrefsNode();
    }

    private void saveWindowInfoStringToPrefsNode() {
        String string = this.createWindowInfoPrefsString();
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node(WINDOW_INFO_PREFS);
        preferences.put(WINDOW_SIZE_LOCATION, string);
    }

    public void saveDialogLocation(String string, Point point) {
        this.addWindowInfo(string, null, point);
        this.saveWindowInfoStringToPrefsNode();
    }

    public Dimension getDialogSize(String string) {
        WindowInfo windowInfo = this.findWindowInfo(string);
        return windowInfo != null ? windowInfo.getSize() : null;
    }

    public Point getDialogLocation(String string) {
        Rectangle rectangle;
        WindowInfo windowInfo = this.findWindowInfo(string);
        if (windowInfo != null && windowInfo.getLocation() != null && WindowUtil.intersectsScreen((Rectangle)(rectangle = new Rectangle(windowInfo.getLocation(), windowInfo.getSize())))) {
            return windowInfo.getLocation();
        }
        return null;
    }

    private WindowInfo findWindowInfo(String string) {
        WindowInfo windowInfo = null;
        for (WindowInfo windowInfo2 : this.mWindowInfoList) {
            if (!windowInfo2.getID().equalsIgnoreCase(string)) continue;
            windowInfo = windowInfo2;
            break;
        }
        return windowInfo;
    }

    private void addWindowInfo(String string, Dimension dimension, Point point) {
        WindowInfo windowInfo = null;
        for (int i = 0; i < this.mWindowInfoList.size() && i < 250; ++i) {
            WindowInfo windowInfo2 = this.mWindowInfoList.get(i);
            if (windowInfo2.getID() == null || !windowInfo2.getID().equalsIgnoreCase(string)) continue;
            windowInfo = windowInfo2;
            break;
        }
        if (windowInfo != null) {
            this.mWindowInfoList.remove(windowInfo);
            if (dimension != null) {
                windowInfo.setSize(dimension);
            }
            if (point != null) {
                windowInfo.setLocation(point);
            }
        } else {
            windowInfo = new WindowInfo(string, dimension, point);
        }
        this.mWindowInfoList.add(0, windowInfo);
    }

    public String createWindowInfoPrefsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (WindowInfo windowInfo : this.mWindowInfoList) {
            StringBuilder stringBuilder2 = new StringBuilder();
            if (windowInfo != null) {
                stringBuilder2.append(windowInfo.getID());
                stringBuilder2.append("=");
                int n = windowInfo.getSize() == null ? -1 : (int)windowInfo.getSize().getWidth();
                int n2 = windowInfo.getSize() == null ? -1 : (int)windowInfo.getSize().getHeight();
                stringBuilder2.append(n);
                stringBuilder2.append(",");
                stringBuilder2.append(n2);
                int n3 = windowInfo.getLocation() == null ? -1 : (int)windowInfo.getLocation().getX();
                int n4 = windowInfo.getLocation() == null ? -1 : (int)windowInfo.getLocation().getY();
                stringBuilder2.append("#");
                stringBuilder2.append(n3);
                stringBuilder2.append(",");
                stringBuilder2.append(n4);
                stringBuilder2.append(";");
            }
            if (stringBuilder.length() + stringBuilder2.length() > 8192) break;
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        return stringBuilder.toString();
    }

    public void resetWindowSizeAndLocation() {
        this.mWindowInfoList = new LinkedList();
    }

    public boolean hasWindowInfos() {
        return this.mWindowInfoList != null && this.mWindowInfoList.size() > 0;
    }

    protected void restoreFromPrefs() {
        if (this.mWindowInfoList == null) {
            this.mWindowInfoList = new LinkedList();
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node(WINDOW_INFO_PREFS);
            String string = preferences.get(WINDOW_SIZE_LOCATION, "");
            if (string != null) {
                String[] stringArray;
                for (String string2 : stringArray = string.trim().split(";")) {
                    if (string2 == null) continue;
                    String string3 = null;
                    Dimension dimension = null;
                    Point point = null;
                    String[] stringArray2 = string2.trim().split("=");
                    if (stringArray2.length == 2) {
                        string3 = stringArray2[0];
                        String[] stringArray3 = stringArray2[1].trim().split("#");
                        if (stringArray3.length >= 1) {
                            String[] stringArray4;
                            String[] stringArray5 = stringArray3[0].trim().split(",");
                            if (stringArray5.length == 2) {
                                dimension = new Dimension(new Integer(stringArray5[0]), new Integer(stringArray5[1]));
                            }
                            if ((stringArray4 = stringArray3[1].trim().split(",")).length == 2) {
                                point = new Point(new Integer(stringArray4[0]), new Integer(stringArray4[1]));
                            }
                        }
                    }
                    if (string3 == null || dimension == null && point == null) continue;
                    this.mWindowInfoList.add(new WindowInfo(string3, dimension, point));
                }
            }
        }
    }

    public void addRecallItem(String string, String string2) {
        RecallItem recallItem = new RecallItem(string, string2);
        if (this.mTotalRecall.contains(recallItem)) {
            this.mTotalRecall.remove(recallItem);
        } else if (this.mTotalRecall.size() == 12) {
            this.mTotalRecall.removeLast();
        }
        this.mTotalRecall.addFirst(recallItem);
        this.updatePersistenceStore();
    }

    public final LinkedList<RecallItem> getRecallList() {
        return this.mTotalRecall;
    }

    public void removeRecallItem(String string, String string2) {
        if (this.mTotalRecall.remove(new RecallItem(string, string2))) {
            this.updatePersistenceStore();
        }
    }

    public void removeDataset(LocallyUniqueId locallyUniqueId) {
        if (locallyUniqueId != null) {
            this.mDatasetMaps.remove(locallyUniqueId.asInt());
        }
    }

    public void removePersistenceData(LocallyUniqueId locallyUniqueId, String string) {
        DialogDataModel dialogDataModel = this.lookupModel(locallyUniqueId, string);
        if (dialogDataModel != null) {
            dialogDataModel.clear();
        }
    }

    public void savePersistentState(String string, DialogDataModel dialogDataModel) {
        LocallyUniqueId locallyUniqueId = this.getActiveDatasetId();
        if (locallyUniqueId == null || locallyUniqueId.isNull()) {
            return;
        }
        this.putModel(locallyUniqueId, string, dialogDataModel);
    }

    public void loadPersistentState(String string, DialogDataModel dialogDataModel) {
        if (string == null || dialogDataModel == null) {
            return;
        }
        LocallyUniqueId locallyUniqueId = this.getActiveDatasetId();
        if (locallyUniqueId == null || locallyUniqueId.isNull()) {
            return;
        }
        DialogDataModel dialogDataModel2 = this.lookupModel(locallyUniqueId, string);
        if (dialogDataModel2 == null) {
            return;
        }
        dialogDataModel.copyFrom(dialogDataModel2);
    }

    public boolean activateLastProcedureDialog() {
        if (this.mLastDialog != null) {
            if (this.mDialogMap.containsKey(this.mLastDialog.getIActionKey())) {
                this.mLastDialog.toFront();
                return true;
            }
            this.mLastDialog = null;
        } else {
            for (Map.Entry<String, BaseProcedureDialog> entry : this.mDialogMap.entrySet()) {
                if (ProcedureDlgMgr.isExceptionDialog(entry.getKey())) continue;
                this.mLastDialog = entry.getValue();
                this.mLastDialog.toFront();
                return true;
            }
        }
        return false;
    }

    public BaseProcedureDialog getLastDialog() {
        return this.mLastDialog;
    }

    public DialogDataModel getDialogDDM(LocallyUniqueId locallyUniqueId, String string) {
        DialogDataModel dialogDataModel = this.lookupModel(locallyUniqueId, string);
        if (dialogDataModel == null) {
            dialogDataModel = new DialogDataModel();
            this.putModel(locallyUniqueId, string, dialogDataModel);
        }
        return dialogDataModel;
    }

    private void updatePersistenceStore() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("recall");
        try {
            preferences2.removeNode();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        preferences2 = preferences.node("recall");
        int n = 0;
        preferences2.putInt("recallCount", this.mTotalRecall.size());
        for (RecallItem recallItem : this.mTotalRecall) {
            String string = "item" + n + "_name";
            preferences2.put(string, recallItem.getProcedureName());
            string = "item" + n + "_id";
            preferences2.put(string, recallItem.getProcedureId());
            ++n;
        }
    }

    private void loadPersistentStore() {
        this.mTotalRecall.clear();
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("recall");
        int n = preferences2.getInt("recallCount", 0);
        for (int i = 0; i < n; ++i) {
            String string = "item" + i + "_name";
            String string2 = "item" + i + "_id";
            String string3 = preferences2.get(string, "");
            String string4 = preferences2.get(string2, "");
            if (string3.length() <= 0 || string4.length() <= 0) continue;
            RecallItem recallItem = new RecallItem(string3, string4);
            this.mTotalRecall.addLast(recallItem);
        }
    }

    private DialogDataModel lookupModel(LocallyUniqueId locallyUniqueId, String string) {
        int n = locallyUniqueId.asInt();
        if (!this.mDatasetMaps.containsKey(n)) {
            return null;
        }
        HashMap<String, DialogDataModel> hashMap = this.mDatasetMaps.get(n);
        return hashMap.get(string);
    }

    private void putModel(LocallyUniqueId locallyUniqueId, String string, DialogDataModel dialogDataModel) {
        int n = locallyUniqueId.asInt();
        if (!this.mDatasetMaps.containsKey(n)) {
            this.mDatasetMaps.put(n, new HashMap());
        }
        HashMap<String, DialogDataModel> hashMap = this.mDatasetMaps.get(n);
        hashMap.put(string, dialogDataModel);
    }

    private ProcedureDlgMgr() {
        this.loadPersistentStore();
        this.restoreFromPrefs();
    }

    class WindowInfo {
        String mID = null;
        Dimension mSize = null;
        Point mLocation = null;

        WindowInfo(String string, Dimension dimension, Point point) {
            this.mID = string;
            this.mSize = dimension;
            this.mLocation = point;
        }

        public String getID() {
            return this.mID;
        }

        public Dimension getSize() {
            return this.mSize;
        }

        public void setSize(Dimension dimension) {
            this.mSize = dimension;
        }

        public Point getLocation() {
            return this.mLocation;
        }

        public void setLocation(Point point) {
            this.mLocation = point;
        }
    }

    public class RecallItem {
        private String mProcedureName = "";
        private String mProcedureId = "";

        RecallItem(String string, String string2) {
            this.mProcedureName = string;
            this.mProcedureId = string2;
        }

        public String getProcedureName() {
            return this.mProcedureName;
        }

        public String getProcedureId() {
            return this.mProcedureId;
        }

        public String toString() {
            return this.getProcedureName();
        }

        public boolean equals(Object object) {
            if (object instanceof RecallItem) {
                RecallItem recallItem = (RecallItem)object;
                return recallItem.mProcedureId.equals(this.mProcedureId) && recallItem.mProcedureName.equals(this.mProcedureName);
            }
            return super.equals(object);
        }
    }
}

