/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.uitools.util.IOptionConstants;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class PairedVariablesTable
extends PlainTable
implements ListSelectionListener {
    private SrcVariableList mSrcVarList;

    public PairedVariablesTable(SrcVariableList srcVariableList, ArrayList<String> arrayList) {
        this.mSrcVarList = srcVariableList;
        this.init(arrayList);
    }

    public PairedVariablesTable(SrcVariableList srcVariableList, String[] stringArray) {
        this(srcVariableList, new ArrayList<String>(Arrays.asList(stringArray)));
    }

    private void init(ArrayList<String> arrayList) {
        Vector<String> vector = new Vector<String>();
        vector.add(arrayList.get(0));
        vector.add(arrayList.get(1));
        vector.add(arrayList.get(2));
        Vector vector2 = new Vector();
        DefaultTableModel defaultTableModel = new DefaultTableModel(vector2, vector){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.setModel(defaultTableModel);
        Object[] objectArray = new Object[]{"1", "", ""};
        ((DefaultTableModel)this.getModel()).addRow(objectArray);
        DefaultTableColumnModel defaultTableColumnModel = (DefaultTableColumnModel)this.getColumnModel();
        defaultTableColumnModel.getColumn(0).setCellRenderer(new PlaiinTableCellRenderer());
        defaultTableColumnModel.getColumn(1).setCellRenderer(new PlaiinTableCellRenderer());
        defaultTableColumnModel.getColumn(2).setCellRenderer(new PlaiinTableCellRenderer());
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = arrayList.get(i);
            int n = fontMetrics.stringWidth(string);
            defaultTableColumnModel.getColumn(i).setPreferredWidth(n + 30);
        }
        this.setSelectionMode(2);
        this.addMouseListener(new MyMouseAdapater());
    }

    class MyMouseAdapater
    extends MouseAdapter {
        MyMouseAdapater() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (PairedVariablesTable.this.getSelectedColumn() != 0) {
                PairedVariablesTable.this.setRowSelectionAllowed(false);
                PairedVariablesTable.this.setCellSelectionEnabled(true);
                PairedVariablesTable.this.repaint();
            } else {
                PairedVariablesTable.this.setCellSelectionEnabled(false);
                PairedVariablesTable.this.setRowSelectionAllowed(true);
                PairedVariablesTable.this.repaint();
            }
        }
    }

    class PlaiinTableCellRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        int mIndex;

        PlaiinTableCellRenderer() {
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options");
            preferences = preferences.node("general");
            String string = preferences.get("var_list_display", PrefDefaults.DEF_VAR_LIST_DISPLAY_LABELS);
            this.mIndex = DialogUtil.getIndexOfItem(IOptionConstants.VAR_LIST_DISPLAY_VALUES, string);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 1 || n2 == 2) {
                if (object instanceof String) {
                    this.setIcon(null);
                    JLabel jLabel = null;
                    jLabel = ComponentState.isBtdRtlOrLtr() && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (bl) {
                        if (this.hasFocus()) {
                            this.setBackground(jTable.getSelectionBackground());
                            this.setForeground(jTable.getSelectionForeground());
                        } else {
                            this.setBackground(jTable.getSelectionBackground());
                            this.setForeground(jTable.getSelectionForeground());
                        }
                    } else {
                        this.setBackground(jTable.getBackground());
                    }
                    if (!jTable.hasFocus()) {
                        this.setBackground(jTable.getBackground());
                    }
                    return jLabel;
                }
                ISpssVariable iSpssVariable = (ISpssVariable)object;
                this.setIcon(PairedVariablesTable.this.mSrcVarList.getIcon((ISpssVariable)object));
                String string = iSpssVariable.getName();
                String string2 = iSpssVariable.getLabel();
                boolean bl3 = PairedVariablesTable.this.mSrcVarList.getModel().getShowVarLabels();
                if (bl3) {
                    this.setText(string2 + " [" + string + "]");
                } else {
                    this.setText(string);
                }
            } else if (n2 == 0) {
                this.setText((String)object);
                this.setHorizontalAlignment(0);
            }
            this.setOpaque(true);
            if (bl) {
                if (this.hasFocus()) {
                    this.setBackground(jTable.getSelectionBackground());
                    this.setForeground(jTable.getSelectionForeground());
                } else {
                    this.setBackground(jTable.getSelectionBackground());
                    this.setForeground(jTable.getSelectionForeground());
                }
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }

        @Override
        public void setToolTipText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setToolTipText(string);
            }
        }
    }
}

