/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.VarInfoBag;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.util.TraceSettings;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.table.DefaultTableModel;

public class PairedVariableUtility {
    public static final String PAIRED_TARGET_TABLE_KEY = "PAIRED_TTEST_TARGET_LIST";

    public static boolean isBlankCellAvailable(PlainTable plainTable) {
        for (int i = 0; i < plainTable.getModel().getRowCount() - 1; ++i) {
            for (int j = 1; j < 3; ++j) {
                Object object = plainTable.getValueAt(i, j);
                if (!(object instanceof String)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isDuplicatePairAvailable(PlainTable plainTable) {
        int n = plainTable.getModel().getRowCount() - 1;
        for (int i = 0; i < n; ++i) {
            String string = ((ISpssVariable)plainTable.getValueAt(i, 1)).getName();
            String string2 = ((ISpssVariable)plainTable.getValueAt(i, 2)).getName();
            for (int j = i + 1; j < n; ++j) {
                String string3 = ((ISpssVariable)plainTable.getValueAt(j, 1)).getName();
                String string4 = ((ISpssVariable)plainTable.getValueAt(j, 2)).getName();
                if (!string3.equals(string) || !string4.equals(string2)) continue;
                SpssAlertOptionPane.showWarningMessageDialog((JComponent)plainTable.getParent(), ResUtil.getCommonDlgString("ERR_PAIR_VARIABLE_DUPLICATE_PAIR_WARNING"), VersionInfo.getAppVersionString());
                plainTable.requestFocus();
                plainTable.setRowSelectionInterval(j, j);
                return true;
            }
        }
        return false;
    }

    public static void removeElementFromTable(PlainTable plainTable, SrcVariableList srcVariableList) {
        int[] nArray = plainTable.getSelectedColumns();
        int[] nArray2 = plainTable.getSelectedRows();
        boolean bl = true;
        if (nArray.length == 3 || nArray.length == 2 || nArray[0] == 0) {
            int n;
            for (n = nArray2.length - 1; n >= 0; --n) {
                if (plainTable.getValueAt(nArray2[n], 1) instanceof String && plainTable.getValueAt(nArray2[n], 2) instanceof String && bl) {
                    SpssAlertOptionPane.showWarningMessageDialog((JComponent)plainTable.getParent(), ResUtil.getCommonDlgString("ERR_PAIR_VARIABLE_EMPTY_ROW_WARNING"), VersionInfo.getAppVersionString());
                    bl = false;
                }
                ((DefaultTableModel)plainTable.getModel()).removeRow(nArray2[n]);
            }
            if (!bl) {
                Object[] objectArray = new Object[]{Integer.toString(plainTable.getModel().getRowCount() + 1), "", ""};
                ((DefaultTableModel)plainTable.getModel()).addRow(objectArray);
            }
            for (n = 0; n < plainTable.getModel().getRowCount(); ++n) {
                plainTable.getModel().setValueAt(Integer.toString(n + 1), n, 0);
            }
            srcVariableList.requestFocus();
        } else if (nArray.length == 1) {
            int n;
            for (n = nArray2.length - 1; n >= 0; --n) {
                int n2 = nArray[0];
                if (plainTable.getValueAt(nArray2[n], n2 == 1 ? 2 : 1) instanceof String) {
                    if (plainTable.getValueAt(nArray2[n], 1) instanceof String && plainTable.getValueAt(nArray2[n], 2) instanceof String) {
                        SpssAlertOptionPane.showWarningMessageDialog((JComponent)plainTable.getParent(), ResUtil.getCommonDlgString("ERR_PAIR_VARIABLE_EMPTY_ROW_WARNING"), VersionInfo.getAppVersionString());
                        return;
                    }
                    ((DefaultTableModel)plainTable.getModel()).removeRow(nArray2[n]);
                    continue;
                }
                plainTable.getModel().setValueAt("", nArray2[n], nArray[0]);
            }
            for (n = 0; n < plainTable.getModel().getRowCount(); ++n) {
                plainTable.getModel().setValueAt(Integer.toString(n + 1), n, 0);
            }
            plainTable.clearSelection();
            plainTable.repaint();
            srcVariableList.requestFocus();
        }
    }

    public static void addElementToTable(PlainTable plainTable, SrcVariableList srcVariableList) {
        ISpssVariable iSpssVariable;
        for (ISpssVariable iSpssVariable2 : iSpssVariable = srcVariableList.getSelectedValues()) {
            if (iSpssVariable2.getType() <= 0) continue;
            SpssAlertOptionPane.showInformationMessageDialog((JComponent)plainTable.getParent(), ResUtil.getCommonDlgString("ERR_FILTER_STRING_MSG"), VersionInfo.getAppVersionString());
            srcVariableList.requestFocus();
            return;
        }
        if (srcVariableList.getSelectedIndices().length > 2) {
            SpssAlertOptionPane.showWarningMessageDialog((JComponent)plainTable.getParent(), ResUtil.getCommonDlgString("ERR_PAIR_VARIABLE_TOO_SAME_VARS_WARNING"), VersionInfo.getAppVersionString());
            srcVariableList.requestFocus();
        } else if (srcVariableList.getSelectedIndices().length == 1) {
            boolean bl = PairedVariableUtility.addSingleColumn(plainTable, srcVariableList);
            if (!bl && !PairedVariableUtility.needToAddRow(plainTable)) {
                Object[] objectArray = new Object[]{Integer.toString(plainTable.getModel().getRowCount() + 1), "", ""};
                ((DefaultTableModel)plainTable.getModel()).addRow(objectArray);
                plainTable.requestFocus();
            }
            if (bl) {
                srcVariableList.requestFocus();
            } else {
                plainTable.requestFocus();
            }
        } else {
            ISpssVariable iSpssVariable3 = null;
            ISpssVariable iSpssVariable4 = null;
            try {
                iSpssVariable3 = iSpssVariable[0].clone();
                iSpssVariable4 = iSpssVariable[1].clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                TraceSettings.trace((String)cloneNotSupportedException.getMessage());
            }
            Object[] objectArray = new Object[]{iSpssVariable3, iSpssVariable4};
            for (int i = 1; i < 3; ++i) {
                plainTable.getModel().setValueAt(objectArray[i - 1], plainTable.getRowCount() - 1, i);
            }
            Object[] objectArray2 = new Object[]{Integer.toString(plainTable.getModel().getRowCount() + 1), "", ""};
            ((DefaultTableModel)plainTable.getModel()).addRow(objectArray2);
            int n = plainTable.getRowCount() - 2;
            plainTable.setRowSelectionInterval(n, n);
            plainTable.setColumnSelectionInterval(1, 2);
            plainTable.requestFocus();
        }
    }

    public static String getSyntaxString(PlainTable plainTable, boolean bl) {
        String string = "";
        String string2 = "";
        int n = bl ? 1 : 2;
        int n2 = bl ? 2 : 1;
        String string3 = bl ? "(PAIRED)" : "(PAIR)";
        for (int i = 0; i < plainTable.getRowCount() - 1; ++i) {
            string = string + ((ISpssVariable)plainTable.getValueAt(i, n)).getName() + " ";
            string2 = string2 + ((ISpssVariable)plainTable.getValueAt(i, n2)).getName() + " ";
        }
        String string4 = string + "WITH " + string2 + string3;
        return string4;
    }

    private static boolean needToAddRow(PlainTable plainTable) {
        for (int i = 0; i < plainTable.getModel().getRowCount(); ++i) {
            for (int j = 1; j < 3; ++j) {
                Object object = plainTable.getValueAt(i, j);
                if (!(object instanceof String) || j == 2 || !((object = plainTable.getValueAt(i, j + 1)) instanceof String)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean addSingleColumn(PlainTable plainTable, SrcVariableList srcVariableList) {
        ISpssVariable[] iSpssVariableArray = srcVariableList.getSelectedValues();
        for (int i = 0; i < plainTable.getModel().getRowCount(); ++i) {
            boolean bl = false;
            for (int j = 1; j < 3; ++j) {
                Object object = plainTable.getValueAt(i, j);
                if (!(object instanceof String)) continue;
                ISpssVariable iSpssVariable = null;
                Object object2 = j == 1 ? plainTable.getValueAt(i, j + 1) : plainTable.getValueAt(i, j - 1);
                if (object2 instanceof ISpssVariable) {
                    bl = true;
                    iSpssVariable = (ISpssVariable)object2;
                }
                if (bl && iSpssVariable.getId().equals((Object)iSpssVariableArray[0].getId())) {
                    SpssAlertOptionPane.showWarningMessageDialog((JComponent)plainTable.getParent(), ResUtil.getCommonDlgString("ERR_PAIR_VARIABLE_DUPLICATE_CELL_WARNING"), VersionInfo.getAppVersionString());
                    int n = srcVariableList.getModel().findElementIndex(iSpssVariableArray[0]);
                    srcVariableList.requestFocus();
                    srcVariableList.setSelectedIndex(n);
                    return true;
                }
                plainTable.setValueAt(iSpssVariableArray[0], i, j);
                plainTable.setCellSelectionEnabled(true);
                plainTable.setColumnSelectionInterval(j, j);
                plainTable.setRowSelectionInterval(i, i);
                return false;
            }
        }
        return false;
    }

    public static void saveTableData(DialogDataModel dialogDataModel, PlainTable plainTable) {
        SerializableObject[] serializableObjectArray = new SerializableObject[plainTable.getRowCount() - 1];
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < plainTable.getRowCount() - 1; ++i) {
            Object object;
            Object object2 = plainTable.getValueAt(i, 1);
            if (!(object2 instanceof ISpssVariable)) {
                object2 = null;
            }
            if (!((object = plainTable.getValueAt(i, 2)) instanceof ISpssVariable)) {
                object = null;
            }
            VarPair varPair = new VarPair((ISpssVariable)object2, (ISpssVariable)object);
            serializableObjectArray[i] = varPair;
        }
        dialogDataModel.putSerializableArray(PAIRED_TARGET_TABLE_KEY, serializableObjectArray);
    }

    public static void loadTableData(DialogDataModel dialogDataModel, PlainTable plainTable) {
        boolean bl = false;
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray(PAIRED_TARGET_TABLE_KEY);
        if (serializableObjectArray != null && serializableObjectArray.length > 0 && serializableObjectArray[0] instanceof VarPair) {
            int n = 0;
            ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
            for (SerializableObject serializableObject : serializableObjectArray) {
                int n2;
                int n3;
                arrayList.clear();
                if (serializableObject instanceof VarPair) {
                    VarPair varPair = (VarPair)serializableObject;
                    if (varPair.getFirstVar() == null || varPair.getSecondVar() == null) break;
                    arrayList.add(varPair.getFirstVar());
                    arrayList.add(varPair.getSecondVar());
                }
                if (n == 0) {
                    n3 = arrayList.size();
                    if (n3 > 1) {
                        for (n2 = 0; n2 < n3; ++n2) {
                            plainTable.setValueAt(arrayList.get(n2), 0, n2 + 1);
                        }
                        bl = true;
                    }
                } else if (arrayList.size() > 1) {
                    n3 = plainTable.getModel().getRowCount();
                    for (n2 = 0; n2 < n3; ++n2) {
                        if (!plainTable.getValueAt(n2, 1).equals("")) continue;
                        ((DefaultTableModel)plainTable.getModel()).removeRow(n2);
                        break;
                    }
                    Object[] objectArray = new Object[]{Integer.toString(plainTable.getModel().getRowCount() + 1), arrayList.get(0), arrayList.get(1)};
                    ((DefaultTableModel)plainTable.getModel()).addRow(objectArray);
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                Object[] objectArray = new Object[]{Integer.toString(plainTable.getModel().getRowCount() + 1), "", ""};
                ((DefaultTableModel)plainTable.getModel()).addRow(objectArray);
            }
        }
    }

    public static void resetTable(PlainTable plainTable) {
        for (int i = plainTable.getRowCount() - 1; i >= 0; --i) {
            ((DefaultTableModel)plainTable.getModel()).removeRow(i);
        }
        Object[] objectArray = new Object[]{Integer.toString(plainTable.getModel().getRowCount() + 1), "", ""};
        ((DefaultTableModel)plainTable.getModel()).addRow(objectArray);
    }

    public static void validateTableData(DialogDataModel dialogDataModel) {
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray(PAIRED_TARGET_TABLE_KEY);
        ArrayList<SerializableObject> arrayList = null;
        if (serializableObjectArray != null && serializableObjectArray.length > 0 && serializableObjectArray[0] instanceof VarPair) {
            arrayList = new ArrayList<SerializableObject>(Arrays.asList(serializableObjectArray));
            int n = serializableObjectArray.length;
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            for (int i = n - 1; i >= 0; --i) {
                int n2;
                VarPair varPair = (VarPair)serializableObjectArray[i];
                ISpssVariable iSpssVariable = varPair.getFirstVar();
                int n3 = n2 = iSpssVariable != null ? iSpssDataSrc.findVarIndex(iSpssVariable.getId()) : -1;
                if (n2 == -1) {
                    arrayList.remove(i);
                    continue;
                }
                iSpssVariable = varPair.getSecondVar();
                int n4 = n2 = iSpssVariable != null ? iSpssDataSrc.findVarIndex(iSpssVariable.getId()) : -1;
                if (n2 != -1) continue;
                arrayList.remove(i);
            }
        }
        if (arrayList != null) {
            serializableObjectArray = new SerializableObject[arrayList.size()];
            dialogDataModel.putSerializableArray(PAIRED_TARGET_TABLE_KEY, arrayList.toArray(serializableObjectArray));
        } else {
            dialogDataModel.putSerializableArray(PAIRED_TARGET_TABLE_KEY, null);
        }
    }

    public static class VarPair
    implements SerializableObject {
        private ISpssVariable mFirstVar;
        private ISpssVariable mSecondVar;

        public VarPair() {
            this(null, null);
        }

        public VarPair(ISpssVariable iSpssVariable, ISpssVariable iSpssVariable2) {
            this.mFirstVar = iSpssVariable;
            this.mSecondVar = iSpssVariable2;
        }

        public ISpssVariable getFirstVar() {
            return this.mFirstVar;
        }

        public ISpssVariable getSecondVar() {
            return this.mSecondVar;
        }

        public String getClassName() {
            return "com.spss.java_client.ui.dialogs.common.PairedVariableUtility$VarPair";
        }

        public boolean writeVersionedObject(ObjectOutputStream objectOutputStream, int n) throws Exception {
            VarInfoBag varInfoBag = new VarInfoBag(this.mFirstVar);
            boolean bl = varInfoBag.writeVersionedObject(objectOutputStream, n);
            varInfoBag = new VarInfoBag(this.mSecondVar);
            return bl &= varInfoBag.writeVersionedObject(objectOutputStream, n);
        }

        public boolean readVersionedObject(ObjectInputStream objectInputStream, int n) throws Exception {
            this.mFirstVar = null;
            VarInfoBag varInfoBag = new VarInfoBag();
            boolean bl = varInfoBag.readVersionedObject(objectInputStream, n);
            if (bl) {
                this.mFirstVar = DialogDataModel.varBagToVariable(varInfoBag);
            }
            this.mSecondVar = null;
            varInfoBag = new VarInfoBag();
            boolean bl2 = varInfoBag.readVersionedObject(objectInputStream, n);
            if (bl2) {
                this.mSecondVar = DialogDataModel.varBagToVariable(varInfoBag);
            }
            return bl && bl2;
        }
    }
}

