/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.controls.SpssProgressDlg;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertDialog;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.actions.ProcedureAction;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.help.StatsHelp;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.lang.reflect.Constructor;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class MeasureLevelAlertDlg
extends SpssAlertDialog {
    private JButton mScanDataButton;
    private JButton mAssignButton;
    private JButton mCancelButton;
    private JButton mHelpButton;
    private boolean mScanButtonPressed;
    private SpssProgressDlg mProgressDlg;

    public MeasureLevelAlertDlg(JFrame jFrame) {
        super(jFrame, ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), ResUtil.getCommonDlgString("IDS_MEASURELEVEL_ALERT_MSG"), ResUtil.getCommonDlgString("IDS_MEASURELEVEL_TITLE"), SpssAlertOptionPane.IconType.eInformation);
        this.setLocationRelativeTo(jFrame);
        this.mProgressDlg = new SpssProgressDlg(null, ResUtil.getCommonDlgString("IDS_MEASURELEVEL_TITLE"));
    }

    public boolean isScanDataButtonPressed() {
        return this.mScanButtonPressed;
    }

    @Override
    protected void setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mScanDataButton);
        vector.add(this.mAssignButton);
        vector.add(this.mCancelButton);
        vector.add(this.mHelpButton);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    @Override
    protected JPanel setupCmdButtons() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        this.mScanDataButton = new JButton(new ScanDataAction());
        this.mCancelButton = new JButton((Action)this.createCancelAction());
        this.mHelpButton = new JButton((Action)this.createHelpAction());
        this.mAssignButton = new JButton(new AssignAction());
        if (DialogUtil.areCommandButtonsBelow()) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap() * 3, 0, 0, 0));
            int n = 6 * (insets.left + insets.right);
            FlowLayout flowLayout = null;
            flowLayout = OSCheck.getOSType() == OSInfo.OSType.MAC ? new FlowLayout(2, n, 0) : new FlowLayout(1, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(this.mScanDataButton);
            jPanel.add(this.mAssignButton);
            jPanel.add(this.mCancelButton);
            jPanel.add(this.mHelpButton);
            this.getRootPane().setDefaultButton(this.mScanDataButton);
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(this.mScanDataButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mAssignButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mCancelButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mHelpButton);
            this.getRootPane().setDefaultButton(this.mScanDataButton);
        }
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    @Override
    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_measurement_alert");
    }

    public boolean isProgressAbort() {
        return this.mProgressDlg != null && this.mProgressDlg.abort();
    }

    public void dispose() {
        if (this.mProgressDlg != null) {
            this.mProgressDlg.dispose();
        }
        super.dispose();
    }

    private void scanData() {
        Runnable runnable = new Runnable(){
            boolean success = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block9: {
                    try {
                        this.success = SyntaxMgr.getSyntaxMgr().executeSyntax("EXECUTE.\n");
                        if (!this.success) break block9;
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            do {
                                this.wait(500L);
                            } while (ComponentState.getProcessorBusy());
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    finally {
                        MeasureLevelAlertDlg.this.dispose();
                    }
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        this.setVisible(false);
        this.mProgressDlg.setInterruptThread(thread);
        this.mProgressDlg.setVisible(true);
    }

    class AssignAction
    extends AbstractAction {
        public AssignAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_MEASURELEVEL_ASSIGN"));
            if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", MeasureLevelAlertDlg.this.getDlgAccessKey("IDK_MEASURELEVEL_ASSIGN_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MeasureLevelAlertDlg.this.dispose();
            SpssAction spssAction = ActionCatalog.getActionCatalog().getSpssAction("data_assign_measurelevel");
            try {
                ProcedureAction procedureAction = (ProcedureAction)spssAction;
                Class<?> clazz = Class.forName(procedureAction.getDlgLaunchPath());
                Constructor<?> constructor = clazz.getConstructor(JFrame.class);
                constructor.newInstance(MeasureLevelAlertDlg.this.getParent().getParent());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class ScanDataAction
    extends AbstractAction {
        public ScanDataAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_MEASURELEVEL_SCANDATA"));
            if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", MeasureLevelAlertDlg.this.getDlgAccessKey("IDK_MEASURELEVEL_SCANDATA_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MeasureLevelAlertDlg.this.scanData();
            MeasureLevelAlertDlg.this.mScanButtonPressed = true;
        }
    }
}

