/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.cop.client.COPClientFactoryJAX;
import com.spss.cop.client.ICOPClientForRequesterJAX;
import com.spss.java_client.core.common.ClusterMgr;
import com.spss.java_client.core.common.LogonMgr;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.server.ClusterObject;
import com.spss.java_client.core.server.ServerObject;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.EditCluster;
import com.spss.java_client.ui.dialogs.common.EditServer;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.fopen.ChooserUIFactory;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.PerConnectAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.pes.jaxws.PESBrowser;
import com.spss.pes.jaxws.ResultObjectInfo;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.dialogs.DlgKeyAdapter;
import com.spss.uitools.dialogs.DlgKeyPressListener;
import com.spss.uitools.dialogs.IDlgKeyPressListener;
import com.spss.uitools.dialogs.ResizeConstrainer;
import com.spss.uitools.help.StatsHelp;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public class LogonDlg
extends JDialog {
    protected final int NUM_COLS = 4;
    protected MyTableModel mTableModel;
    protected PlainTable mTable;
    protected JButton mAddButton;
    protected JButton mEditButton;
    protected JButton mDeleteButton;
    protected JButton mSearchButton;
    protected JButton mOkButton;
    protected JButton mCancelButton;
    protected JButton mHelpButton;
    protected JCheckBox mSetCredentials;
    protected JLabel mUserIDPrompt;
    protected JLabel mPasswordPrompt;
    protected JLabel mDomainPrompt;
    protected ContextEnabledTextField mUserIDEdit;
    protected JPasswordField mPasswordEdit;
    protected JCheckBox mSavePassCheck;
    protected ContextEnabledTextField mDomainEdit;
    protected int mCurrentServerRow;
    protected int mCurrentRowSeln;
    protected boolean mInInit;
    protected boolean mModalResult;
    protected DlgKeyAdapter mKeyAdapter;
    protected boolean mUseSelectServer;
    protected ServerObject mSelectedServer;
    protected final String[] columnNames;
    protected final String tableMsg;
    protected final String addButtonTxt;
    protected final String editButtonTxt;
    protected final String delButtonTxt;
    protected final String searchButtonTxt;
    protected final String setCredentialsTxt;
    protected final String userIdPrompt;
    protected final String passwordPrompt;
    protected final String domainPrompt;
    protected final String rememberCheckTxt;
    protected final String okButtonTxt;
    protected final String cancelButtonTxt;
    protected final String helpButtonTxt;
    protected final String kNone;
    protected final String kCopNotfoundErrorTxt;
    protected final String kCopErrorDialogTxt;

    public LogonDlg(SpssFrame spssFrame, boolean bl) throws HeadlessException {
        block3: {
            super(spssFrame, ResUtil.getCommonDlgString("IDS_SERVER_LOGIN"), true);
            this.NUM_COLS = 4;
            this.mTableModel = null;
            this.mTable = null;
            this.mAddButton = null;
            this.mEditButton = null;
            this.mDeleteButton = null;
            this.mSearchButton = null;
            this.mOkButton = null;
            this.mCancelButton = null;
            this.mHelpButton = null;
            this.mSetCredentials = null;
            this.mUserIDPrompt = null;
            this.mPasswordPrompt = null;
            this.mDomainPrompt = null;
            this.mUserIDEdit = null;
            this.mPasswordEdit = null;
            this.mSavePassCheck = null;
            this.mDomainEdit = null;
            this.mCurrentServerRow = -1;
            this.mCurrentRowSeln = -1;
            this.mInInit = false;
            this.mModalResult = false;
            this.mKeyAdapter = null;
            this.mUseSelectServer = false;
            this.mSelectedServer = null;
            this.columnNames = new String[]{ResUtil.getCommonDlgString("IDS_DEFAULT"), ResUtil.getCommonDlgString("IDS_SERVER_NAME"), ResUtil.getCommonDlgString("IDS_DESCRIPTION"), ResUtil.getCommonDlgString("IDS_PORT")};
            this.tableMsg = ResUtil.getCommonDlgString("IDS_STARTUP_DEFAULT");
            this.addButtonTxt = ResUtil.getCommonDlgString("IDS_ADD_ELLIPSIS");
            this.editButtonTxt = ResUtil.getCommonDlgString("IDS_EDIT_ELLIPSIS");
            this.delButtonTxt = ResUtil.getCommonDlgString("IDS_DELETE");
            this.searchButtonTxt = ResUtil.getCommonDlgString("IDS_SEARCH");
            this.setCredentialsTxt = ResUtil.getCommonDlgString("IDS_SET_CREDENTIALS");
            this.userIdPrompt = ResUtil.getCommonDlgString("IDS_USER_ID_COLON");
            this.passwordPrompt = ResUtil.getCommonDlgString("IDS_PASSWORD_COLON");
            this.domainPrompt = ResUtil.getCommonDlgString("IDS_DOMAIN_COLON");
            this.rememberCheckTxt = ResUtil.getCommonDlgString("IDS_RETAIN_PSWD");
            this.okButtonTxt = ResUtil.getCommonDlgString("IDS_OK");
            this.cancelButtonTxt = ResUtil.getCommonDlgString("IDS_CANCEL");
            this.helpButtonTxt = ResUtil.getCommonDlgString("IDS_HELP");
            this.kNone = ResUtil.getCommonDlgString("IDS_NONE_PARENS");
            this.kCopNotfoundErrorTxt = ResUtil.getCommonDlgString("IDS_COP_WS_NOTFOUND");
            this.kCopErrorDialogTxt = ResUtil.getCommonDlgString("IDS_COP_ERROR_DIALOG");
            try {
                this.mUseSelectServer = bl;
                this.mInInit = true;
                this.jbInit();
                this.mInInit = false;
                Dimension dimension = ProcedureDlgMgr.getMgr().getDialogSize("file_switch_server");
                if (dimension != null) {
                    this.setSize(dimension);
                }
                this.mKeyAdapter = new DlgKeyAdapter((JDialog)this);
                this.mKeyAdapter.addDlgKeyPressListener((IDlgKeyPressListener)new DlgKeyPressListener());
                this.setLocationRelativeTo(null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!(exception instanceof HeadlessException)) break block3;
                throw (HeadlessException)exception;
            }
        }
    }

    public boolean getModalResult() {
        return this.mModalResult;
    }

    public ServerObject getSelectedServer() {
        return this.mSelectedServer;
    }

    public boolean logon(ServerObject serverObject) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        boolean bl = serverObject instanceof ClusterObject ? ClusterMgr.getClusterMgr().logon(serverObject, (JDialog)this) : LogonMgr.getLogonMgr().logon(serverObject, (JDialog)this);
        this.setCursor(null);
        if (bl) {
            this.mCurrentServerRow = this.mTableModel.getServerRow(serverObject);
            this.saveToPreferences();
            if (!serverObject.isSetCredentials()) {
                PerConnectAction.doBackendPESConnect();
            }
        }
        return bl;
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new GridBagLayout());
        this.loadServerData();
        this.setupTable();
        this.setupRightPane();
        this.setupCenterPane();
        this.setupBottomPane();
        this.setDefaultCloseOperation(2);
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                LogonDlg.this.mModalResult = false;
            }
        };
        this.addWindowListener(windowAdapter);
        this.getRootPane().setDefaultButton(this.mOkButton);
        this.pack();
        ResizeConstrainer resizeConstrainer = new ResizeConstrainer((Container)this, this.getSize());
        this.addComponentListener((ComponentListener)resizeConstrainer);
        if (this.mCurrentRowSeln > -1 && this.mCurrentRowSeln < this.mTable.getRowCount()) {
            this.mTable.setRowSelectionInterval(this.mCurrentRowSeln, this.mCurrentRowSeln);
            if (this.mCurrentRowSeln == 0) {
                this.mTable.requestFocusInWindow();
            } else {
                this.mPasswordEdit.requestFocusInWindow();
            }
        }
    }

    private void loadServerData() {
        this.mCurrentServerRow = LogonMgr.getLogonMgr().getCurrentServerIndex();
        if (this.mUseSelectServer) {
            this.mCurrentServerRow = LogonMgr.getLogonMgr().getCurrentServerIndex() - 1;
        }
        this.mCurrentRowSeln = this.mCurrentServerRow;
    }

    private void setupTable() throws Exception {
        Serializable serializable;
        TableColumnModel tableColumnModel;
        this.mTableModel = new MyTableModel();
        this.mTable = new PlainTable(this.mTableModel);
        int[] nArray = new int[]{50, 110, 180, 50};
        int n = 4;
        if (this.mUseSelectServer) {
            nArray = new int[]{110, 180, 50};
            n = 3;
        }
        if ((tableColumnModel = this.mTable.getColumnModel()).getColumnCount() == n) {
            for (int i = 0; i < n; ++i) {
                serializable = tableColumnModel.getColumn(i);
                serializable.setHeaderValue(this.mUseSelectServer ? this.columnNames[i + 1] : this.columnNames[i]);
                serializable.setWidth(nArray[i]);
                serializable.setPreferredWidth(nArray[i]);
            }
        }
        this.mTable.setSelectionMode(0);
        this.mTable.setRowSelectionAllowed(true);
        this.mTable.setColumnSelectionAllowed(false);
        this.mTable.getTableHeader().setResizingAllowed(true);
        this.mTable.setShowGrid(false);
        this.mTable.setPreferredScrollableViewportSize(new Dimension(390, 70));
        this.mTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    LogonDlg.this.mOkButton.doClick();
                    mouseEvent.consume();
                }
            }
        });
        this.mTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    LogonDlg.this.mOkButton.doClick();
                    keyEvent.consume();
                }
            }
        });
        ListSelectionModel listSelectionModel = this.mTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int n = LogonDlg.this.mInInit ? -1 : LogonDlg.this.mCurrentRowSeln;
                LogonDlg.this.mCurrentRowSeln = -1;
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    LogonDlg.this.updateEditingControls(n, false);
                } else {
                    LogonDlg.this.mCurrentRowSeln = listSelectionModel.getMinSelectionIndex();
                    LogonDlg.this.updateEditingControls(n, LogonDlg.this.mCurrentRowSeln > (LogonDlg.this.mUseSelectServer ? -1 : 0));
                }
            }
        });
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).anchor = 23;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        JScrollPane jScrollPane = new JScrollPane(this.mTable);
        JPanel jPanel = new JPanel(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, (GridBagConstraints)serializable, 0, 0, 1, 1, 17, new Insets(5, 5, 5, 5));
        JLabel jLabel = new JLabel(this.tableMsg);
        ((GridBagConstraints)serializable).weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, (GridBagConstraints)serializable, 0, 1, 1, 1, 17, new Insets(0, 5, 0, 5));
        ((GridBagConstraints)serializable).weighty = 0.0;
        DialogUtil.addUsingGBL(this.getContentPane(), jPanel, (GridBagConstraints)serializable, 0, 0, 1, 1, 17, new Insets(5, 5, 5, 2));
    }

    protected void setupRightPane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(3, 3, 3, 3);
        int n = OSInfo.getOSType() == OSInfo.OSType.MAC ? 100 : 90;
        Dimension dimension = new Dimension(n, 26);
        this.mAddButton = new JButton(new LogonButtonAction(this.addButtonTxt));
        this.mAddButton.setPreferredSize(dimension);
        DialogUtil.addUsingGBL(jPanel, this.mAddButton, gridBagConstraints, 0, 0, 1, 1, 11, insets);
        this.mEditButton = new JButton(new LogonButtonAction(this.editButtonTxt));
        this.mEditButton.setPreferredSize(dimension);
        DialogUtil.addUsingGBL(jPanel, this.mEditButton, gridBagConstraints, 0, 1, 1, 1, 11, insets);
        this.mDeleteButton = new JButton(new LogonButtonAction(this.delButtonTxt));
        this.mDeleteButton.setPreferredSize(dimension);
        DialogUtil.addUsingGBL(jPanel, this.mDeleteButton, gridBagConstraints, 0, 2, 1, 1, 11, insets);
        this.mSearchButton = new JButton(new LogonButtonAction(this.searchButtonTxt));
        this.mSearchButton.setPreferredSize(dimension);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mSearchButton, gridBagConstraints, 0, 3, 1, 1, 11, insets);
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.getContentPane(), jPanel, gridBagConstraints, 1, 0, 1, 1, 11, new Insets(15, 1, 5, 5));
        DialogUtil.createCmdButtonGroup(jPanel);
    }

    protected void setupCenterPane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.mSetCredentials = new JCheckBox(new LogonButtonAction(this.setCredentialsTxt));
        DialogUtil.addUsingGBL(jPanel, this.mSetCredentials, gridBagConstraints, 0, 0, 2, 1, 17, new Insets(5, 5, 5, 5));
        this.mUserIDPrompt = new JLabel(this.userIdPrompt);
        DialogUtil.addUsingGBL(jPanel, this.mUserIDPrompt, gridBagConstraints, 0, 1, 1, 1, 17, new Insets(5, 5, 5, 5));
        this.mPasswordPrompt = new JLabel(this.passwordPrompt);
        DialogUtil.addUsingGBL(jPanel, this.mPasswordPrompt, gridBagConstraints, 0, 2, 1, 1, 17, new Insets(5, 5, 5, 5));
        this.mDomainPrompt = new JLabel(this.domainPrompt);
        DialogUtil.addUsingGBL(jPanel, this.mDomainPrompt, gridBagConstraints, 0, 4, 1, 1, 17, new Insets(5, 5, 5, 5));
        this.mUserIDEdit = new ContextEnabledTextField();
        Dimension dimension = new Dimension(280, 22);
        this.mUserIDEdit.setPreferredSize(dimension);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mUserIDEdit, gridBagConstraints, 1, 1, 1, 1, 17, new Insets(5, 5, 5, 5));
        this.mPasswordEdit = new JPasswordField();
        this.mPasswordEdit.setPreferredSize(dimension);
        DialogUtil.addUsingGBL(jPanel, this.mPasswordEdit, gridBagConstraints, 1, 2, 1, 1, 17, new Insets(5, 5, 3, 5));
        this.mSavePassCheck = new JCheckBox(new LogonButtonAction(this.rememberCheckTxt));
        DialogUtil.addUsingGBL(jPanel, this.mSavePassCheck, gridBagConstraints, 1, 3, 1, 1, 17, new Insets(0, 5, 3, 5));
        this.mDomainEdit = new ContextEnabledTextField();
        this.mDomainEdit.setPreferredSize(dimension);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDomainEdit, gridBagConstraints, 1, 4, 1, 1, 17, new Insets(5, 5, 5, 5));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.getContentPane(), jPanel, gridBagConstraints, 0, 1, 1, 1, 17, new Insets(5, 5, 5, 5));
    }

    protected void setupBottomPane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.mOkButton = new JButton(new LogonButtonAction(this.okButtonTxt));
        this.mCancelButton = new JButton(new LogonButtonAction(this.cancelButtonTxt));
        this.mHelpButton = new JButton(new LogonButtonAction(this.helpButtonTxt));
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            Insets insets = new Insets(0, 5, 0, 0);
            int n = 23;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            DialogUtil.setupMacHelpButton(this.mHelpButton);
            DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, 0, 0, 1, 1, n, null);
            n = 24;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        } else {
            Insets insets = new Insets(5, 15, 5, 15);
            DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 0, 0, 1, 1, 10, insets);
            DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 1, 0, 1, 1, 10, insets);
            DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, 2, 0, 1, 1, 10, insets);
        }
        DialogUtil.normalizeButtonWidths((JPanel)jPanel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.getContentPane(), jPanel, gridBagConstraints, 0, 2, 2, 1, 11, new Insets(5, 5, 5, 5));
        DialogUtil.createCmdButtonGroup(jPanel);
    }

    protected void saveToPreferences() {
        int n = this.mUseSelectServer ? this.mCurrentServerRow + 1 : this.mCurrentServerRow;
        LogonMgr.getLogonMgr().setCurrentServerIndex(n);
        LogonMgr.getLogonMgr().saveToPreferences();
    }

    protected void updateEditingControls(int n, boolean bl) {
        Color color;
        ServerObject serverObject;
        ServerObject serverObject2;
        if (this.mUseSelectServer) {
            serverObject2 = n >= 0 && n < LogonMgr.getLogonMgr().getServerCount() - 1 ? LogonMgr.getLogonMgr().getServer(n + 1) : null;
            serverObject = this.mCurrentRowSeln >= 0 && this.mCurrentRowSeln < LogonMgr.getLogonMgr().getServerCount() - 1 ? LogonMgr.getLogonMgr().getServer(this.mCurrentRowSeln + 1) : null;
        } else {
            serverObject2 = n > 0 && n < LogonMgr.getLogonMgr().getServerCount() ? LogonMgr.getLogonMgr().getServer(n) : null;
            serverObject = this.mCurrentRowSeln > 0 && this.mCurrentRowSeln < LogonMgr.getLogonMgr().getServerCount() ? LogonMgr.getLogonMgr().getServer(this.mCurrentRowSeln) : null;
        }
        SystemColor systemColor = color = bl ? SystemColor.text : SystemColor.control;
        if (bl && OSCheck.getOSType() == OSInfo.OSType.LINUX) {
            color = Color.white;
        }
        if (serverObject2 != null && this.mUserIDEdit != null) {
            serverObject2.setUseCredentials(this.mSetCredentials.isSelected());
            serverObject2.setUserID(this.mUserIDEdit.getText());
            serverObject2.setDomain(this.mDomainEdit.getText());
            serverObject2.setSavePassword(this.mSavePassCheck.isSelected());
            char[] cArray = this.mPasswordEdit.getPassword();
            if (cArray != null) {
                String string = new String(cArray);
                serverObject2.setPassword(string);
            }
        }
        if (this.mEditButton != null && this.mEditButton.getAction() != null) {
            this.mEditButton.getAction().setEnabled(bl);
        }
        if (this.mDeleteButton != null) {
            this.mDeleteButton.getAction().setEnabled(bl);
        }
        if (this.mSetCredentials != null) {
            this.mSetCredentials.setEnabled(bl);
        }
        if (this.mUserIDPrompt != null) {
            this.mUserIDPrompt.setEnabled(bl);
        }
        if (this.mPasswordPrompt != null) {
            this.mPasswordPrompt.setEnabled(bl);
        }
        if (this.mDomainPrompt != null) {
            this.mDomainPrompt.setEnabled(bl);
        }
        if (this.mUserIDEdit != null) {
            this.mUserIDEdit.setEnabled(bl);
            this.mUserIDEdit.setBackground(color);
            this.mUserIDEdit.setText(serverObject != null ? serverObject.getUserID() : "");
        }
        if (this.mPasswordEdit != null) {
            this.mPasswordEdit.setEnabled(bl);
            this.mPasswordEdit.setBackground(color);
            this.mPasswordEdit.setText(serverObject != null ? serverObject.getPassword() : "");
        }
        if (this.mSavePassCheck != null) {
            this.mSavePassCheck.setEnabled(bl);
            this.mSavePassCheck.setSelected(serverObject != null && serverObject.getSavePassword());
        }
        if (this.mDomainEdit != null) {
            this.mDomainEdit.setEnabled(bl);
            this.mDomainEdit.setBackground(color);
            this.mDomainEdit.setText(serverObject != null ? serverObject.getDomain() : "");
        }
        if (this.mSetCredentials != null) {
            this.mSetCredentials.setEnabled(bl);
            this.mSetCredentials.setSelected(serverObject != null && serverObject.isSetCredentials());
            this.mUserIDEdit.setEnabled(this.mSetCredentials.isSelected());
            this.mPasswordEdit.setEnabled(this.mSetCredentials.isSelected());
            this.mSavePassCheck.setEnabled(this.mSetCredentials.isSelected());
            this.mDomainEdit.setEnabled(this.mSetCredentials.isSelected());
        }
        serverObject = this.mUseSelectServer ? (this.mCurrentRowSeln >= 0 && this.mCurrentRowSeln < LogonMgr.getLogonMgr().getServerCount() - 1 ? LogonMgr.getLogonMgr().getServer(this.mCurrentRowSeln + 1) : null) : (this.mCurrentRowSeln >= 0 && this.mCurrentRowSeln < LogonMgr.getLogonMgr().getServerCount() ? LogonMgr.getLogonMgr().getServer(this.mCurrentRowSeln) : null);
        this.updateTitleBar(serverObject);
    }

    protected void updateTitleBar(ServerObject serverObject) {
        String string = ResUtil.getCommonDlgString("IDS_SERVER_LOGIN") + ": ";
        string = serverObject != null ? string + serverObject.getName() : string + this.kNone;
        this.setTitle(string);
    }

    public void doHelp() {
        if (this.mUseSelectServer) {
            StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "IDH_PROD_SERVER_LOGIN");
        } else {
            StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "IDH_IDD_SERVER_LOGIN_DLG");
        }
    }

    protected JPanel setupCmdButtonPanel() {
        return null;
    }

    public class LogonButtonAction
    extends AbstractAction {
        public LogonButtonAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == LogonDlg.this.mSetCredentials) {
                LogonDlg.this.mUserIDEdit.setEnabled(LogonDlg.this.mSetCredentials.isSelected());
                LogonDlg.this.mPasswordEdit.setEnabled(LogonDlg.this.mSetCredentials.isSelected());
                LogonDlg.this.mSavePassCheck.setEnabled(LogonDlg.this.mSetCredentials.isSelected());
                LogonDlg.this.mDomainEdit.setEnabled(LogonDlg.this.mSetCredentials.isSelected());
            } else if (object == LogonDlg.this.mAddButton) {
                ServerObject serverObject = new ServerObject("", "", VersionInfo.getDefaultServerPort());
                int n = LogonDlg.this.mTableModel.AddServer(serverObject) - 1;
                LogonDlg.this.mTable.setRowSelectionInterval(n, n);
                EditServer editServer = new EditServer(LogonDlg.this, serverObject, true);
                editServer.setLocationRelativeTo(null);
                editServer.setVisible(true);
                if (serverObject.getPort() < 0) {
                    LogonDlg.this.mTableModel.RemoveServer(n);
                }
                LogonDlg.this.mTable.repaint();
            } else if (object == LogonDlg.this.mEditButton) {
                EditServer editServer = new EditServer(LogonDlg.this, LogonDlg.this.mTableModel.getServer(-1), false);
                editServer.setLocationRelativeTo(null);
                editServer.setVisible(true);
                LogonDlg.this.mTable.repaint();
            } else if (object == LogonDlg.this.mDeleteButton) {
                if (LogonDlg.this.mCurrentRowSeln > (LogonDlg.this.mUseSelectServer ? -1 : 0)) {
                    LogonDlg.this.mTableModel.RemoveServer(LogonDlg.this.mCurrentRowSeln);
                }
                LogonDlg.this.mTable.repaint();
            } else if (object == LogonDlg.this.mSearchButton) {
                this.searchClusterServers();
                LogonDlg.this.mTable.repaint();
            } else if (object == LogonDlg.this.mSavePassCheck) {
                if (LogonDlg.this.mCurrentRowSeln > (LogonDlg.this.mUseSelectServer ? -1 : 0)) {
                    int n = LogonDlg.this.mUseSelectServer ? LogonDlg.this.mCurrentRowSeln + 1 : LogonDlg.this.mCurrentRowSeln;
                    ServerObject serverObject = LogonMgr.getLogonMgr().getServer(n);
                    serverObject.setSavePassword(LogonDlg.this.mSavePassCheck.getModel().isSelected());
                }
            } else if (object == LogonDlg.this.mOkButton) {
                LogonDlg.this.updateEditingControls(LogonDlg.this.mCurrentRowSeln, LogonDlg.this.mCurrentRowSeln > (LogonDlg.this.mUseSelectServer ? -1 : 0));
                LogonDlg.this.saveToPreferences();
                try {
                    ServerObject serverObject = (ServerObject)LogonDlg.this.mTableModel.getServer(LogonDlg.this.mCurrentRowSeln).clone();
                    if (LogonDlg.this.mUseSelectServer) {
                        LogonDlg.this.mSelectedServer = serverObject;
                        LogonDlg.this.dispose();
                        LogonDlg.this.mModalResult = true;
                        return;
                    }
                    if (serverObject.isLocalServer()) {
                        serverObject = LogonMgr.getLogonMgr().getLocalServer();
                    }
                    if (serverObject != null && LogonDlg.this.logon(serverObject)) {
                        ProcedureDlgMgr.getMgr().saveDialogSize("file_switch_server", LogonDlg.this.getSize());
                        LogonDlg.this.dispose();
                        LogonDlg.this.mModalResult = true;
                        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                            ChooserUIFactory.setUseQuaqua(false);
                        }
                    }
                    LogonMgr.getLogonMgr().loadFromPreferences();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
            } else if (object == LogonDlg.this.mCancelButton) {
                LogonDlg.this.mModalResult = false;
                LogonDlg.this.dispose();
            } else if (object == LogonDlg.this.mHelpButton) {
                LogonDlg.this.doHelp();
            }
        }

        private boolean searchClusterServers() {
            ResultObjectInfo resultObjectInfo;
            ICOPClientForRequesterJAX iCOPClientForRequesterJAX = COPClientFactoryJAX.getCOPClientForRequester();
            boolean bl = PESBrowser.getLoginCount() == 0 ? (resultObjectInfo = PESBrowser.connectSPSSToRepository((boolean)false)).getWhichOK() != -1 : true;
            if (bl) {
                resultObjectInfo = PESBrowser.getDefaultRepositoryConnectionDescriptor();
                String string = resultObjectInfo.getHostName();
                int n = resultObjectInfo.getPortNumber();
                boolean bl2 = resultObjectInfo.getUseSSL();
                String string2 = resultObjectInfo.getUserName();
                String string3 = resultObjectInfo.getProviderInfo(resultObjectInfo.getProviderKey()).getProviderDomain();
                if (string3 != null && !string3.equals("")) {
                    string2 = resultObjectInfo.getProviderInfo(resultObjectInfo.getProviderKey()).getProviderDomain() + "/" + resultObjectInfo.getUserName();
                }
                String string4 = resultObjectInfo.getPassword();
                String string5 = resultObjectInfo.getProviderInfo() != null ? resultObjectInfo.getProviderInfo().getProviderID() : resultObjectInfo.getProviderInfo(resultObjectInfo.getProviderKey()).getProviderID();
                Object object = resultObjectInfo.getSsoToken();
                iCOPClientForRequesterJAX.setCOPHostAndPort(string, n, bl2);
                if (object != null) {
                    iCOPClientForRequesterJAX.setSsoToken(object);
                } else {
                    iCOPClientForRequesterJAX.setSecurityTokens(string2, string4, string5);
                }
                ClusterMgr.getClusterMgr().setCOPParameters(string, n, bl2, string2, string4, string5, object);
                if (iCOPClientForRequesterJAX.sendCOPSanityRequest()) {
                    ClusterMgr.getClusterMgr().loadClusterServers();
                    EditCluster editCluster = new EditCluster(LogonDlg.this, false);
                    editCluster.setLocationRelativeTo(null);
                    editCluster.setVisible(true);
                    Vector<ServerObject> vector = editCluster.getSelectedServers();
                    for (ServerObject serverObject : vector) {
                        int n2 = LogonDlg.this.mTableModel.AddServer(serverObject) - 1;
                        LogonDlg.this.mTable.setRowSelectionInterval(n2, n2);
                        if (serverObject instanceof ClusterObject || serverObject.getPort() >= 0) continue;
                        LogonDlg.this.mTableModel.RemoveServer(n2);
                    }
                    LogonDlg.this.mTable.repaint();
                } else {
                    JOptionPane.showMessageDialog(null, LogonDlg.this.kCopNotfoundErrorTxt, LogonDlg.this.kCopErrorDialogTxt, -1);
                }
            }
            return true;
        }
    }

    class MyTableModel
    extends AbstractTableModel
    implements TableModelListener {
        final int DEF_COL = 0;
        final int NAME_COL = 1;
        final int DESC_COL = 2;
        final int PORT_COL = 3;

        MyTableModel() {
            this.addTableModelListener(this);
        }

        @Override
        public int getColumnCount() {
            int n = LogonDlg.this.mUseSelectServer ? 3 : 4;
            return LogonMgr.getLogonMgr().getServerCount() == 0 ? 0 : n;
        }

        @Override
        public int getRowCount() {
            return LogonDlg.this.mUseSelectServer ? LogonMgr.getLogonMgr().getServerCount() - 1 : LogonMgr.getLogonMgr().getServerCount();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n >= 0 && n2 <= 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string;
            block14: {
                ServerObject serverObject;
                block13: {
                    if (n >= LogonMgr.getLogonMgr().getServerCount() || n2 > 3) {
                        return null;
                    }
                    n = LogonDlg.this.mUseSelectServer ? n + 1 : n;
                    serverObject = LogonMgr.getLogonMgr().getServer(n);
                    string = "";
                    if (!LogonDlg.this.mUseSelectServer) break block13;
                    switch (n2) {
                        case 0: {
                            string = serverObject.getName();
                            break;
                        }
                        case 1: {
                            string = serverObject.getDesc();
                            break;
                        }
                        case 2: {
                            int n3 = serverObject.getPort();
                            if (n3 > 0) {
                                string = Integer.toString(n3);
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break block14;
                }
                switch (n2) {
                    case 0: {
                        return serverObject.isDefaultServer();
                    }
                    case 1: {
                        string = serverObject.getName();
                        break;
                    }
                    case 2: {
                        string = serverObject.getDesc();
                        break;
                    }
                    case 3: {
                        int n4 = serverObject.getPort();
                        if (n4 <= 0) break;
                        string = Integer.toString(n4);
                        break;
                    }
                }
            }
            return string;
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            int n = tableModelEvent.getFirstRow();
            int n2 = tableModelEvent.getColumn();
            if (n2 == 0 && !LogonDlg.this.mUseSelectServer && n > -1 && n < LogonMgr.getLogonMgr().getServerCount()) {
                ServerObject serverObject = LogonMgr.getLogonMgr().getServer(n);
                boolean bl = !serverObject.isDefaultServer();
                this.setDefaultServer(n, bl);
            }
        }

        ServerObject getServer(int n) {
            ServerObject serverObject = null;
            if (n == -1) {
                n = LogonDlg.this.mTable.getSelectionModel().getAnchorSelectionIndex();
            }
            int n2 = n = LogonDlg.this.mUseSelectServer ? n + 1 : n;
            if (n >= 0 && n < LogonMgr.getLogonMgr().getServerCount()) {
                serverObject = LogonMgr.getLogonMgr().getServer(n);
            }
            return serverObject;
        }

        int getServerRow(ServerObject serverObject) {
            int n = LogonMgr.getLogonMgr().getServerIndex(serverObject);
            if (LogonDlg.this.mUseSelectServer) {
                n = LogonMgr.getLogonMgr().getServerIndex(serverObject) + 1;
            }
            return n;
        }

        int AddServer(ServerObject serverObject) {
            int n = LogonMgr.getLogonMgr().AddServer(serverObject);
            n = LogonDlg.this.mUseSelectServer ? n - 1 : n;
            int n2 = n - 1;
            this.fireTableRowsInserted(n2, n2);
            LogonDlg.this.mTable.repaint();
            return n;
        }

        void RemoveServer(int n) {
            int n2;
            int n3 = LogonMgr.getLogonMgr().RemoveServer(LogonDlg.this.mUseSelectServer ? n + 1 : n);
            n3 = LogonDlg.this.mUseSelectServer ? n3 - 1 : n3;
            this.fireTableRowsDeleted(n3, n3);
            if (LogonDlg.this.mTable.getSelectedRow() < 0 && (n2 = LogonDlg.this.mTable.getRowCount() - 1) >= 0) {
                LogonDlg.this.mTable.setRowSelectionInterval(n2, n2);
            }
            LogonDlg.this.mTable.repaint();
        }

        void setDefaultServer(int n, boolean bl) {
            LogonMgr.getLogonMgr().setDefaultServer(n, bl);
            LogonDlg.this.mTable.repaint();
        }
    }
}

