/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.ui.dialogs.common.SwingWorker;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;

public abstract class GlassPaneSwingWorker
extends SwingWorker<Object> {
    private GlassPane mGlassPane;

    public GlassPaneSwingWorker(Component component) {
        this.mGlassPane = new GlassPane(component);
    }

    @Override
    protected Object construct() {
        this.mGlassPane.applyGlassPane();
        Object object = this.doConstruct();
        return object;
    }

    @Override
    protected void finished() {
        this.mGlassPane.removeGlassPane();
        this.doFinished();
    }

    public abstract Object doConstruct();

    public void doFinished() {
    }

    private class GlassPane
    extends JComponent
    implements AWTEventListener {
        private Component mComponent;
        private RootPaneContainer mRootPane;
        private Window mParentWindow;
        private Component mOrignalGlassPane;
        private Component mFocussedComponent;
        private int mDefaultCloseOperation;

        public GlassPane(Component component) {
            this.mComponent = component;
            this.initGlassPane();
        }

        private void initGlassPane() {
            this.getRootContainer();
            this.getParentWindow();
            this.getOrignalGlassPane();
            this.addListeners();
        }

        private void getRootContainer() {
            Component component;
            for (component = this.mComponent; component != null && !(component instanceof RootPaneContainer); component = component.getParent()) {
            }
            this.mRootPane = (RootPaneContainer)((Object)component);
        }

        private void getParentWindow() {
            Component component;
            for (component = this.mComponent; component != null && !(component instanceof Window); component = component.getParent()) {
            }
            this.mParentWindow = (Window)component;
        }

        private void getOrignalGlassPane() {
            this.mOrignalGlassPane = this.mRootPane.getGlassPane();
        }

        private void addListeners() {
            this.addKeyListener(new KeyAdapter(){});
            this.addMouseListener(new MouseAdapter(){});
        }

        private void getDefaultCloseOperation() {
            if (this.mParentWindow instanceof JDialog) {
                this.mDefaultCloseOperation = ((JDialog)this.mParentWindow).getDefaultCloseOperation();
                ((JDialog)this.mParentWindow).setDefaultCloseOperation(0);
            } else if (this.mParentWindow instanceof JFrame) {
                this.mDefaultCloseOperation = ((JFrame)this.mParentWindow).getDefaultCloseOperation();
                ((JFrame)this.mParentWindow).setDefaultCloseOperation(0);
            }
        }

        private void setDefaultCloseOperation() {
            if (this.mParentWindow instanceof JDialog) {
                ((JDialog)this.mParentWindow).setDefaultCloseOperation(this.mDefaultCloseOperation);
            } else if (this.mParentWindow instanceof JFrame) {
                ((JFrame)this.mParentWindow).setDefaultCloseOperation(this.mDefaultCloseOperation);
            }
        }

        public void applyGlassPane() {
            this.mFocussedComponent = this.mParentWindow.getFocusOwner();
            this.mRootPane.setGlassPane(this);
            this.getDefaultCloseOperation();
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
            this.mParentWindow.setCursor(Cursor.getPredefinedCursor(3));
            this.setVisible(true);
        }

        public void removeGlassPane() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            this.mParentWindow.setCursor(Cursor.getPredefinedCursor(0));
            this.mRootPane.setGlassPane(this.mOrignalGlassPane);
            this.mOrignalGlassPane.setVisible(false);
            this.setDefaultCloseOperation();
            if (null != this.mFocussedComponent) {
                this.mFocussedComponent.requestFocus();
            }
            this.setVisible(false);
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            Object object = aWTEvent.getSource();
            if (object instanceof Component && aWTEvent instanceof KeyEvent) {
                ((KeyEvent)aWTEvent).consume();
            }
        }
    }
}

