/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.comp_util.CoreFrequencies;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IFrequencyScannerListener;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class FrequenciesScanner {
    private JTextField mCasesTextField;
    private Timer mTimer;
    private CoreFrequencies mCoreFreq;
    private ScanningCasesDlg mCasesScanningDlg;
    private ArrayList<IFrequencyScannerListener> mFreqScannerListener = new ArrayList();

    public FrequenciesScanner(CoreFrequencies coreFrequencies) {
        this.mCoreFreq = coreFrequencies;
    }

    public FrequenciesScanner(CoreFrequencies coreFrequencies, SpssFrame spssFrame, String string) {
        this.mCoreFreq = coreFrequencies;
    }

    public FrequenciesScanner(CoreFrequencies coreFrequencies, BaseDialog baseDialog, String string) {
        this(coreFrequencies, baseDialog, string, true);
    }

    public FrequenciesScanner(CoreFrequencies coreFrequencies, BaseDialog baseDialog, String string, boolean bl) {
        this.mCoreFreq = coreFrequencies;
        this.mCasesScanningDlg = bl ? new ScanningCasesDlg(baseDialog, string) : null;
    }

    public void registerScannerListener(IFrequencyScannerListener iFrequencyScannerListener) {
        this.mFreqScannerListener.add(iFrequencyScannerListener);
    }

    public void startScanning() {
        this.mTimer = new Timer("Scanning Cases Timer");
        long l = this.mCoreFreq.getUpdateInterval();
        if (l < 1L) {
            l = 1000L;
        }
        this.mTimer.schedule((TimerTask)new ProgressMeter(), 0L, l);
        if (this.mCasesScanningDlg != null) {
            this.mCasesScanningDlg.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishedScanning(boolean bl) {
        this.mTimer.cancel();
        if (bl) {
            this.mCoreFreq.stop();
        }
        FrequenciesScanner frequenciesScanner = this;
        synchronized (frequenciesScanner) {
            int n = 0;
            while (!this.mCoreFreq.isFinished() && n++ < 100) {
                try {
                    this.wait(200L);
                }
                catch (InterruptedException interruptedException) {
                    ++n;
                }
            }
        }
        if (this.mCasesScanningDlg != null) {
            this.mCasesScanningDlg.setVisible(false);
            this.mCasesScanningDlg.dispose();
        }
        for (IFrequencyScannerListener iFrequencyScannerListener : this.mFreqScannerListener) {
            iFrequencyScannerListener.finishedScanning(this.mCoreFreq);
        }
    }

    class ProgressMeter
    extends TimerTask {
        ProgressMeter() {
        }

        @Override
        public void run() {
            if (!FrequenciesScanner.this.mCoreFreq.isFinished()) {
                if (FrequenciesScanner.this.mCasesTextField != null) {
                    FrequenciesScanner.this.mCasesTextField.setText(FrequenciesScanner.this.mCoreFreq.casesPassed() + "");
                }
            } else {
                FrequenciesScanner.this.finishedScanning(false);
            }
        }
    }

    class StopAction
    extends AbstractAction {
        StopAction() {
            Integer n;
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_STOP"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC && (n = ResUtil.getCommonDlgAccessKey("IDK_STOP")) != null) {
                this.putValue("MnemonicKey", n);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FrequenciesScanner.this.finishedScanning(true);
        }
    }

    class ScanningCasesDlg
    extends BaseDialog {
        ScanningCasesDlg(SpssFrame spssFrame, String string) throws HeadlessException {
            super((JFrame)spssFrame, string, OSInfo.getOSType() != OSInfo.OSType.MAC, ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
            this.setLocationRelativeTo(this.getParent());
            if (this.mDialogConfig != null) {
                WindowAdapter windowAdapter = this.mDialogConfig.getThreadAgent();
                this.removeWindowListener(windowAdapter);
            }
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    FrequenciesScanner.this.mTimer.cancel();
                    ScanningCasesDlg.this.dispose();
                }
            });
        }

        ScanningCasesDlg(BaseDialog baseDialog, String string) throws HeadlessException {
            super(baseDialog, string, OSInfo.getOSType() != OSInfo.OSType.MAC, ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
            this.setLocationRelativeTo(this.getParent());
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    FrequenciesScanner.this.mTimer.cancel();
                    ScanningCasesDlg.this.dispose();
                }
            });
        }

        protected void init() {
            super.init();
            this.setupProgressPanel();
            this.pack();
        }

        protected void prepareAutomationState() {
        }

        protected JPanel setupCmdButtonPanel() {
            Serializable serializable;
            JPanel jPanel = new JPanel(true);
            Insets insets = DialogUtil.getStandardButtonInsets();
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                serializable = new FlowLayout(2, n, 0);
                jPanel.setLayout((LayoutManager)((Object)serializable));
            } else {
                serializable = new FlowLayout(1, n, 0);
                jPanel.setLayout((LayoutManager)((Object)serializable));
            }
            serializable = new JButton(new StopAction());
            jPanel.add((Component)serializable);
            return jPanel;
        }

        private void setupProgressPanel() {
            JPanel jPanel = this.getViewPanel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            int n = 10;
            Insets insets = DialogUtil.getStandardControlInsets();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            JLabel jLabel = new JLabel(ResUtil.getCommonDlgString("IDS_SCANNING_CASES_LABEL"));
            FrequenciesScanner.this.mCasesTextField = new JTextField();
            FrequenciesScanner.this.mCasesTextField.setEnabled(false);
            FrequenciesScanner.this.mCasesTextField.setBackground(this.getBackground());
            DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
            DialogUtil.addUsingGBL(jPanel, FrequenciesScanner.this.mCasesTextField, gridBagConstraints, 0, 1, 1, 1, n, insets);
        }

        public void doHelp() {
        }
    }
}

