/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.server.ServerObject;
import com.spss.java_client.core.server.ssl.SSLChannelFactory;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.dialogs.DlgKeyAdapter;
import com.spss.uitools.dialogs.DlgKeyPressListener;
import com.spss.uitools.dialogs.IDlgKeyPressListener;
import com.spss.uitools.dialogs.ResizeConstrainer;
import com.spss.uitools.help.StatsHelp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class EditServer
extends JDialog {
    protected JButton mOkButton = null;
    protected JButton mCancelButton = null;
    protected JButton mHelpButton = null;
    protected ContextEnabledTextField mServerNameEdit = null;
    protected ContextEnabledTextField mPortNoEdit = null;
    protected ContextEnabledTextField mDescriptionEdit = null;
    protected JCheckBox mUseSSLCheck = null;
    protected ServerObject mServer = null;
    protected static final String dialogTitle = ResUtil.getCommonDlgString("IDS_SRVR_LOGON_SETTINGS");
    protected final String okButtonTxt = ResUtil.getCommonDlgString("IDS_OK");
    protected final String cancelButtonTxt = ResUtil.getCommonDlgString("IDS_CANCEL");
    protected final String helpButtonTxt = ResUtil.getCommonDlgString("IDS_HELP");
    protected final String serverNamePrompt = ResUtil.getCommonDlgString("IDS_SERVER_NAME_COLON");
    protected final String portNoPrompt = ResUtil.getCommonDlgString("IDS_PORT_NUMBER_COLON");
    protected final String descriptionPrompt = ResUtil.getCommonDlgString("IDS_DESCRIPTION_COLON");
    protected final String advSettings = ResUtil.getCommonDlgString("IDS_ADV_CONNECTION_SETTINGS");
    protected final String sslPrompt = ResUtil.getCommonDlgString("IDS_SSL_CONNECT");

    public EditServer(JDialog jDialog, ServerObject serverObject, boolean bl) {
        super(jDialog, dialogTitle, true);
        try {
            Point point;
            Dimension dimension;
            this.jbInit();
            this.mServer = serverObject;
            this.loadServerSettings();
            if (bl) {
                this.mServer.setPort(-1);
            }
            if ((dimension = ProcedureDlgMgr.getMgr().getDialogSize("file_switch_server_settings")) != null) {
                this.setSize(dimension);
            }
            if ((point = ProcedureDlgMgr.getMgr().getDialogLocation("file_switch_server_settings")) != null) {
                this.setLocation(point);
            } else {
                this.setLocationRelativeTo(jDialog);
            }
            DlgKeyAdapter dlgKeyAdapter = new DlgKeyAdapter((JDialog)this);
            dlgKeyAdapter.addDlgKeyPressListener((IDlgKeyPressListener)new DlgKeyPressListener());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean hasSSLCertInstalled() {
        boolean bl = false;
        String string = SSLChannelFactory.getSSLCertDir();
        if (string != null) {
            try {
                File file = new File(string);
                if (file.exists() && file.isDirectory()) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new GridBagLayout());
        this.addTopPanel();
        this.addMiddlePanel();
        this.addLowerPanel();
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(this.mOkButton);
        this.pack();
        this.addComponentListener((ComponentListener)new ResizeConstrainer((Container)this, this.getSize()));
    }

    private void addTopPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(this.serverNamePrompt);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 17, new Insets(5, 5, 5, 5));
        jLabel = new JLabel(this.portNoPrompt);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, 17, new Insets(5, 5, 5, 5));
        jLabel = new JLabel(this.descriptionPrompt);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 2, 1, 1, 17, new Insets(5, 5, 5, 5));
        this.mServerNameEdit = new ContextEnabledTextField();
        Dimension dimension = new Dimension(280, 22);
        this.mServerNameEdit.setPreferredSize(dimension);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mServerNameEdit, gridBagConstraints, 1, 0, 1, 1, 17, new Insets(5, 5, 5, 5));
        this.mPortNoEdit = new ContextEnabledTextField();
        this.mPortNoEdit.setPreferredSize(dimension);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mPortNoEdit, gridBagConstraints, 1, 1, 1, 1, 17, new Insets(5, 5, 5, 5));
        this.mDescriptionEdit = new ContextEnabledTextField();
        this.mDescriptionEdit.setPreferredSize(dimension);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDescriptionEdit, gridBagConstraints, 1, 2, 1, 1, 17, new Insets(5, 5, 5, 5));
        if (OSCheck.getOSType() == OSInfo.OSType.LINUX) {
            this.mServerNameEdit.setBackground(Color.white);
            this.mPortNoEdit.setBackground(Color.white);
            this.mDescriptionEdit.setBackground(Color.white);
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.getContentPane(), jPanel, gridBagConstraints, 0, 0, 1, 1, 17, new Insets(5, 5, 5, 5));
    }

    private void addMiddlePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 1, 5, 2));
        TitledBorder titledBorder = new TitledBorder(this.advSettings){

            @Override
            public Insets getBorderInsets(Component component, Insets insets) {
                Serializable serializable;
                int n = 0;
                int n2 = 16;
                int n3 = 16;
                Border border = this.getBorder();
                if (border != null) {
                    if (border instanceof AbstractBorder) {
                        ((AbstractBorder)border).getBorderInsets(component, insets);
                    } else {
                        serializable = border.getBorderInsets(component);
                        insets.top = serializable.top;
                        insets.right = serializable.right;
                        insets.bottom = serializable.bottom;
                        insets.left = serializable.left;
                    }
                } else {
                    insets.bottom = 0;
                    insets.right = 0;
                    insets.top = 0;
                    insets.left = 0;
                }
                insets.left += 4;
                insets.right += 4;
                insets.top += 4;
                insets.bottom += 4;
                if (component == null || this.getTitle() == null || this.getTitle().equals("")) {
                    return insets;
                }
                serializable = this.getFont(component);
                FontMetrics fontMetrics = component.getFontMetrics((Font)serializable);
                if (fontMetrics != null) {
                    n = fontMetrics.getDescent();
                    n2 = fontMetrics.getAscent();
                    n3 = fontMetrics.getHeight();
                }
                switch (this.getTitlePosition()) {
                    case 1: {
                        insets.top += n2 + n + (Math.max(2, 4) - 2);
                        break;
                    }
                    case 0: 
                    case 2: {
                        insets.top += n2 + n;
                        break;
                    }
                    case 3: {
                        insets.top += n2 + n + 2;
                        break;
                    }
                    case 4: {
                        insets.bottom += n2 + n + 2;
                        break;
                    }
                    case 5: {
                        insets.bottom += n2 + n;
                        break;
                    }
                    case 6: {
                        insets.bottom += n3;
                    }
                }
                insets.left += 5;
                insets.top -= 3;
                insets.bottom += 3;
                return insets;
            }
        };
        jPanel.setBorder(titledBorder);
        this.mUseSSLCheck = new JCheckBox(this.sslPrompt);
        jPanel.add(this.mUseSSLCheck);
        if (!this.hasSSLCertInstalled()) {
            this.mUseSSLCheck.setEnabled(false);
        }
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(this.getContentPane(), jPanel, gridBagConstraints, 0, 1, 1, 1, 17, new Insets(5, 5, 5, 5));
    }

    private void addLowerPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.mOkButton = new JButton(new OKAction(this.okButtonTxt));
        this.mCancelButton = new JButton(new CancelAction(this.cancelButtonTxt));
        this.mHelpButton = new JButton(new HelpAction(this.helpButtonTxt));
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            Insets insets = new Insets(0, 5, 0, 0);
            int n = 23;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, 0, 0, 1, 1, n, null);
            n = 24;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        } else {
            Insets insets = new Insets(5, 15, 5, 15);
            DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 0, 0, 1, 1, 10, insets);
            DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 1, 0, 1, 1, 10, insets);
            DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, 2, 0, 1, 1, 10, insets);
        }
        DialogUtil.normalizeButtonWidths((JPanel)jPanel);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.getContentPane(), jPanel, gridBagConstraints, 0, 2, 1, 1, 15, new Insets(5, 5, 5, 5));
        DialogUtil.createCmdButtonGroup(jPanel);
    }

    protected void loadServerSettings() {
        this.mServerNameEdit.setText(this.mServer.getName());
        this.mPortNoEdit.setText(Integer.toString(this.mServer.getPort()));
        this.mDescriptionEdit.setText(this.mServer.getDesc());
        this.mUseSSLCheck.getModel().setSelected(this.mServer.getSslProtocolType() != ServerObject.SslProtocolType.SslNotUsed);
    }

    protected boolean saveServerSettings() {
        try {
            String string = this.mPortNoEdit.getText();
            int n = Integer.parseInt(string);
            if (n < 0 || n > 65535) {
                this.mPortNoEdit.setText("");
                this.mPortNoEdit.requestFocus();
                return false;
            }
            this.mServer.setPort(n);
        }
        catch (NumberFormatException numberFormatException) {
            this.mPortNoEdit.setText("");
            this.mPortNoEdit.requestFocus();
            return false;
        }
        this.mServer.setName(this.mServerNameEdit.getText());
        this.mServer.setDesc(this.mDescriptionEdit.getText());
        this.mServer.setSslProtocolType(this.mUseSSLCheck.getModel().isSelected() ? ServerObject.SslProtocolType.TLSv1 : ServerObject.SslProtocolType.SslNotUsed);
        return true;
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "IDH_IDD_ADD_SERVER_DIALOG");
    }

    protected JPanel setupCmdButtonPanel() {
        return null;
    }

    public class HelpAction
    extends AbstractAction {
        public HelpAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EditServer.this.doHelp();
        }
    }

    public class CancelAction
    extends AbstractAction {
        public CancelAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EditServer.this.dispose();
        }
    }

    private class OKAction
    extends AbstractAction {
        public OKAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            String string = EditServer.this.mServerNameEdit.getText();
            String string2 = EditServer.this.mPortNoEdit.getText();
            if (string.length() == 0) {
                SpssAlertOptionPane.showErrorMessageDialog(EditServer.this, ResUtil.getCommonDlgString("IDS_SERVER_NAME_REQUIRED_MSG"), VersionInfo.getAppVersionString());
                return;
            }
            if (string2.length() == 0) {
                SpssAlertOptionPane.showErrorMessageDialog(EditServer.this, ResUtil.getCommonDlgString("IDS_PORT_REQUIRED_MSG"), VersionInfo.getAppVersionString());
                return;
            }
            if (!string.equals(string.trim()) && (n = SpssAlertOptionPane.showConfirmDialog(EditServer.this, ResUtil.getCommonDlgString("IDS_SERVER_NAME_WHITESPACE_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION)) == 2) {
                return;
            }
            try {
                n = Integer.parseInt(string2);
                if (n < 0 || n > 65535) {
                    SpssAlertOptionPane.showErrorMessageDialog(EditServer.this, ResUtil.getCommonDlgString("IDS_PORT_OUT_OF_RANGE_MSG"), VersionInfo.getAppVersionString());
                } else if (EditServer.this.saveServerSettings()) {
                    ProcedureDlgMgr.getMgr().saveDialogSize("file_switch_server_settings", EditServer.this.getSize());
                    ProcedureDlgMgr.getMgr().saveDialogLocation("file_switch_server_settings", EditServer.this.getLocation());
                    EditServer.this.dispose();
                }
            }
            catch (NumberFormatException numberFormatException) {
                SpssAlertOptionPane.showErrorMessageDialog(EditServer.this, ResUtil.getCommonDlgString("IDS_PORT_OUT_OF_RANGE_MSG"), VersionInfo.getAppVersionString());
            }
        }
    }
}

