/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.common.ClusterMgr;
import com.spss.java_client.core.server.ServerObject;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.DlgKeyAdapter;
import com.spss.uitools.dialogs.DlgKeyPressListener;
import com.spss.uitools.dialogs.IDlgKeyPressListener;
import com.spss.uitools.dialogs.ResizeConstrainer;
import com.spss.uitools.help.StatsHelp;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public class EditCluster
extends BaseDialog {
    protected final int NUM_COLS = 3;
    protected MyTableModel mTableModel = new MyTableModel();
    protected JTable mTable = new JTable(this.mTableModel);
    protected JButton mOkButton = null;
    protected JButton mCancelButton = null;
    protected JButton mHelpButton = null;
    protected Vector<ServerObject> mServerClusters = new Vector();
    protected boolean mIsAddition = false;
    protected int mCurrentRowSeln = -1;
    protected static final String dialogTitle = ResUtil.getCommonDlgString("IDS_SRVR_SEARCH_DIALOG");
    protected final String okButtonTxt = ResUtil.getCommonDlgString("IDS_OK");
    protected final String cancelButtonTxt = ResUtil.getCommonDlgString("IDS_CANCEL");
    protected final String helpButtonTxt = ResUtil.getCommonDlgString("IDS_HELP");
    protected final String[] columnNames = new String[]{ResUtil.getCommonDlgString("IDS_SERVER_NAME"), ResUtil.getCommonDlgString("IDS_DESCRIPTION"), ResUtil.getCommonDlgString("IDS_PORT")};

    public EditCluster(JDialog jDialog, boolean bl) {
        super(jDialog, dialogTitle, true, ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
        try {
            this.jbInit();
            this.mIsAddition = bl;
            if (ClusterMgr.getClusterMgr().hasNoServersFound()) {
                this.mTable.setRowSelectionAllowed(false);
            }
            this.mTable.repaint();
            DlgKeyAdapter dlgKeyAdapter = new DlgKeyAdapter((BaseDialog)this);
            dlgKeyAdapter.addDlgKeyPressListener((IDlgKeyPressListener)new DlgKeyPressListener());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Vector<ServerObject> getSelectedServers() {
        return this.mServerClusters;
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setupTable();
        this.addLowerPanel();
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(this.mOkButton);
        this.pack();
        this.addComponentListener((ComponentListener)new ResizeConstrainer((Container)((Object)this), this.getSize()));
    }

    private void setupTable() throws Exception {
        Serializable serializable;
        int[] nArray = new int[]{110, 180, 50};
        TableColumnModel tableColumnModel = this.mTable.getColumnModel();
        if (tableColumnModel.getColumnCount() == 3) {
            for (int i = 0; i < 3; ++i) {
                serializable = tableColumnModel.getColumn(i);
                serializable.setHeaderValue(this.columnNames[i]);
                serializable.setWidth(nArray[i]);
                serializable.setPreferredWidth(nArray[i]);
            }
        }
        this.mTable.setRowSelectionAllowed(true);
        this.mTable.setColumnSelectionAllowed(false);
        this.mTable.getTableHeader().setResizingAllowed(true);
        this.mTable.setShowGrid(false);
        this.mTable.setPreferredScrollableViewportSize(new Dimension(390, 70));
        this.mTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    EditCluster.this.mOkButton.doClick();
                    mouseEvent.consume();
                }
            }
        });
        this.mTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    EditCluster.this.mOkButton.doClick();
                    keyEvent.consume();
                }
            }
        });
        ListSelectionModel listSelectionModel = this.mTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EditCluster.this.mCurrentRowSeln = -1;
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty()) {
                    EditCluster.this.mCurrentRowSeln = listSelectionModel.getMinSelectionIndex();
                    EditCluster.this.mOkButton.setEnabled(true);
                }
            }
        });
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).anchor = 23;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        JScrollPane jScrollPane = new JScrollPane(this.mTable);
        JPanel jPanel = new JPanel(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, (GridBagConstraints)serializable, 0, 0, 1, 1, 17, new Insets(5, 5, 5, 5));
        ((GridBagConstraints)serializable).weighty = 0.0;
        DialogUtil.addUsingGBL(this.getContentPane(), jPanel, (GridBagConstraints)serializable, 0, 0, 1, 1, 17, new Insets(5, 5, 5, 2));
    }

    private void addLowerPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Dimension dimension = new Dimension(80, 26);
        this.mOkButton = new JButton(new ServerButtonAction(this.okButtonTxt));
        this.mOkButton.setPreferredSize(dimension);
        this.mOkButton.setEnabled(false);
        this.mCancelButton = new JButton(new ServerButtonAction(this.cancelButtonTxt));
        this.mCancelButton.setPreferredSize(dimension);
        this.mHelpButton = new JButton(new ServerButtonAction(this.helpButtonTxt));
        this.mHelpButton.setPreferredSize(dimension);
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            Insets insets = new Insets(0, 5, 0, 0);
            int n = 23;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, 0, 0, 1, 1, n, null);
            n = 24;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        } else {
            Insets insets = new Insets(5, 15, 5, 15);
            DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 0, 0, 1, 1, 10, insets);
            DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 1, 0, 1, 1, 10, insets);
            DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, 2, 0, 1, 1, 10, insets);
        }
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.getContentPane(), jPanel, gridBagConstraints, 0, 2, 1, 1, 15, new Insets(5, 5, 5, 5));
        DialogUtil.createCmdButtonGroup(jPanel);
    }

    protected boolean saveServerSettings() {
        int[] nArray;
        for (int n : nArray = this.mTable.getSelectedRows()) {
            ServerObject serverObject = this.mTableModel.getServer(n);
            if (serverObject == null) continue;
            this.mServerClusters.add(serverObject);
        }
        return true;
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_server_search");
    }

    protected JPanel setupCmdButtonPanel() {
        return null;
    }

    class MyTableModel
    extends AbstractTableModel
    implements TableModelListener {
        final int NAME_COL = 0;
        final int DESC_COL = 1;
        final int PORT_COL = 2;

        MyTableModel() {
            this.addTableModelListener(this);
        }

        @Override
        public int getColumnCount() {
            return ClusterMgr.getClusterMgr().getServerCount() == 0 ? 0 : 3;
        }

        @Override
        public int getRowCount() {
            return ClusterMgr.getClusterMgr().getServerCount();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n >= 0 && n2 <= 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n >= ClusterMgr.getClusterMgr().getServerCount() || n2 > 2) {
                return null;
            }
            ServerObject serverObject = ClusterMgr.getClusterMgr().getServer(n);
            String string = "";
            switch (n2) {
                case 0: {
                    string = serverObject.getName();
                    break;
                }
                case 1: {
                    string = serverObject.getDesc();
                    break;
                }
                case 2: {
                    int n3 = serverObject.getPort();
                    if (n3 <= 0) break;
                    string = Integer.toString(n3);
                    break;
                }
            }
            return string;
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
        }

        ServerObject getServer(int n) {
            ServerObject serverObject = null;
            if (n == -1) {
                n = EditCluster.this.mTable.getSelectionModel().getAnchorSelectionIndex();
            }
            if (n >= 0 && n < ClusterMgr.getClusterMgr().getServerCount()) {
                serverObject = ClusterMgr.getClusterMgr().getServer(n);
            }
            return serverObject;
        }
    }

    public class ServerButtonAction
    extends AbstractAction {
        public ServerButtonAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ClusterMgr.getClusterMgr().hasNoServersFound()) {
                EditCluster.this.dispose();
                return;
            }
            Object object = actionEvent.getSource();
            if (object == EditCluster.this.mOkButton) {
                if (EditCluster.this.saveServerSettings()) {
                    EditCluster.this.dispose();
                }
            } else if (object == EditCluster.this.mCancelButton) {
                EditCluster.this.dispose();
            } else if (object == EditCluster.this.mHelpButton) {
                EditCluster.this.doHelp();
            }
        }
    }
}

