/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.ExpressionValidator;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.ui.controls.BasicACRWidget;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineLabel;
import com.spss.java_client.ui.controls.TableSorter;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.ListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.ListMouseHandler;
import com.spss.java_client.ui.controls.drag_drop.TableMouseHandler;
import com.spss.java_client.ui.controls.drag_drop.TreeMouseHandler;
import com.spss.java_client.ui.controls.drag_drop.VarListDropListener;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.output.drag_drop.ViewerOutputPaneDragAdapter;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.TextCompUndoManager;
import com.spss.uitools.controls.TextCompUndoManagerHolder;
import com.spss.uitools.controls.drag_drop.ComponentDragAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.File;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class DialogUtil
extends UIToolDialogUtil {
    private static final Insets BUTTON_INSETS = new Insets(1, 2, 1, 2);
    private static final Insets CONTROL_INSETS = new Insets(1, 2, 1, 2);
    private static final Insets ARROW_BUTTON_INSETS = new Insets(10, 10, 10, 10);
    private static final int GROUP_BOX_INNER_MARGIN = 6;
    private static final int VAR_LIST_MIN_WIDTH = 150;
    private static final int VAR_SRC_LIST_PREF_HEIGHT = 160;
    private static final int MAIN_BUTTON_GAP = 8;
    private static final int COMPONENT_GROUP_GAP = 8;
    private static final Dimension ARROW_BUTTON_SIZE = new Dimension(32, 30);
    private static final int FUNCTION_GROUP_LIST_HEIGHT = 90;
    private static final int FUNCTION_GROUP_LIST_WIDTH = 150;
    private static final Color FOCUS_BORDER_COLOR = new Color(153, 205, 230);
    private static final int LINE_BREAK = 50;
    private static final int SUB_CHECKBOX_GROUP_INDENT = 20;

    public static void addUsingGBL(Container container, JComponent jComponent, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, Insets insets) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.insets = insets == null ? new Insets(0, 0, 0, 0) : insets;
        container.add((Component)jComponent, gridBagConstraints);
    }

    public static void addUsingGBLOnSpssTab(Container container, JComponent jComponent, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, Insets insets) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.insets = insets == null ? new Insets(0, 0, 0, 0) : insets;
        jComponent.setOpaque(false);
        container.add((Component)jComponent, gridBagConstraints);
    }

    public static void normalizeLabelWidths(JPanel jPanel) {
        int n = 0;
        ArrayList<JLabel> arrayList = new ArrayList<JLabel>();
        for (Component component : jPanel.getComponents()) {
            if (!(component instanceof JLabel)) continue;
            JLabel jLabel = (JLabel)component;
            FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
            if (jLabel.getText() == null) continue;
            int n2 = fontMetrics.stringWidth(jLabel.getText());
            n = n > n2 ? n : n2;
            arrayList.add(jLabel);
        }
        for (JLabel jLabel : arrayList) {
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width = n;
            jLabel.setMaximumSize(dimension);
            jLabel.setMinimumSize(dimension);
        }
    }

    public static Image makeColorTransparent(Image image, final Color color) {
        RGBImageFilter rGBImageFilter = new RGBImageFilter(){
            public int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
            }

            @Override
            public final int filterRGB(int n, int n2, int n3) {
                if ((n3 | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & n3;
                }
                return n3;
            }
        };
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), rGBImageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public static Insets getStandardButtonInsets() {
        return BUTTON_INSETS;
    }

    public static Insets getStandardControlInsets() {
        return CONTROL_INSETS;
    }

    public static Insets getStandardControlInsets2() {
        return new Insets(1, 2, 1, 2);
    }

    public static Insets getArrowButtonInsets() {
        return ARROW_BUTTON_INSETS;
    }

    public static int getVarListWidth() {
        return 150;
    }

    public static int getVarListHeight() {
        return 160;
    }

    public static int getMainButtonGap() {
        return 8;
    }

    public static Dimension getArrowButtonSize() {
        return ARROW_BUTTON_SIZE;
    }

    public static int getComponentGroupGap() {
        return 8;
    }

    public static int getSubCheckboxGroupIndent() {
        return 20;
    }

    public static int getGroupBoxInnerMargin() {
        return 6;
    }

    public static void applyTopBorder(JPanel jPanel) {
        jPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray));
    }

    public static void setupVerticalFill(GridBagConstraints gridBagConstraints, double d, double d2) {
        DialogUtil.setupFill(gridBagConstraints, 3, d, d2);
    }

    public static void setupHorizontalFill(GridBagConstraints gridBagConstraints, double d, double d2) {
        DialogUtil.setupFill(gridBagConstraints, 2, d, d2);
    }

    public static void setupBothFill(GridBagConstraints gridBagConstraints, double d, double d2) {
        DialogUtil.setupFill(gridBagConstraints, 1, d, d2);
    }

    private static void setupFill(GridBagConstraints gridBagConstraints, int n, double d, double d2) {
        gridBagConstraints.fill = n;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    public static void setupNoSize(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
    }

    public static JRadioButton createRadioButton(BaseDialog baseDialog, String string, ActionListener actionListener) {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(baseDialog, string);
        JRadioButton jRadioButton = new JRadioButton(toggleButtonAction);
        jRadioButton.addActionListener(actionListener);
        return jRadioButton;
    }

    public static JRadioButton createRadioButton(ResourceBundle resourceBundle, String string, ActionListener actionListener) {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(resourceBundle, string);
        JRadioButton jRadioButton = new JRadioButton(toggleButtonAction);
        jRadioButton.addActionListener(actionListener);
        return jRadioButton;
    }

    public static JCheckBox createCheckBox(BaseDialog baseDialog, String string) {
        return DialogUtil.createCheckBox(baseDialog, string, null);
    }

    public static JCheckBox createCheckBox(BaseDialog baseDialog, String string, ActionListener actionListener) {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(baseDialog, string);
        JCheckBox jCheckBox = new JCheckBox(toggleButtonAction);
        if (actionListener != null) {
            jCheckBox.addActionListener(actionListener);
        }
        return jCheckBox;
    }

    public static JCheckBox createCheckBox(ResourceBundle resourceBundle, String string, ActionListener actionListener) {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(resourceBundle, string);
        JCheckBox jCheckBox = new JCheckBox(toggleButtonAction);
        if (actionListener != null) {
            jCheckBox.addActionListener(actionListener);
        }
        return jCheckBox;
    }

    public static JLabel createLabel(BaseDialog baseDialog, String string) {
        JLabel jLabel = new JLabel(baseDialog.getResString(string));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            String string2 = string + "_KEY";
            Integer n = baseDialog.getDlgAccessKey(string2 = string2.replace("IDS_", "IDK_"));
            if (n != null) {
                jLabel.setDisplayedMnemonic(n);
            }
            if (jLabel != null && jLabel.getText() != null && jLabel.getText().length() == 0 && n != null && n == 35) {
                jLabel.getAccessibleContext().setAccessibleName(ResUtil.getCommonDlgString("IDS_SOURCE_VARIABLE_LIST_LABEL"));
            }
        }
        return jLabel;
    }

    public static JLabel createLabel(BaseDialog baseDialog, String string, int n) {
        JLabel jLabel = new JLabel(baseDialog.getResString(string));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            String string2 = string + n + "_KEY";
            Integer n2 = baseDialog.getDlgAccessKey(string2 = string2.replace("IDS_", "IDK_"));
            if (n2 != null) {
                jLabel.setDisplayedMnemonic(n2);
            }
        }
        return jLabel;
    }

    public static JLabel createLabel(String string) {
        Integer n;
        JLabel jLabel = new JLabel(ResUtil.getCommonDlgString(string));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC && (n = ResUtil.getCommonDlgAccessKey(string = string.replace("IDS_", "IDK_"))) != null) {
            jLabel.setDisplayedMnemonic(n);
        }
        return jLabel;
    }

    public static JLabel createMultiLineLabel(BaseDialog baseDialog, String string, int n) {
        Integer n2 = null;
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            String string2 = string + "_KEY";
            string2 = string2.replace("IDS_", "IDK_");
            n2 = baseDialog.getDlgAccessKey(string2);
        }
        return new SpssMultiLineLabel(baseDialog.getResString(string), n2, n);
    }

    public static JTextArea createCommonInfoArea(BaseDialog baseDialog, String string, int n, int n2) {
        JTextArea jTextArea = new JTextArea(baseDialog.getResString(string));
        jTextArea.setPreferredSize(new Dimension(n, n2));
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        return jTextArea;
    }

    public static JButton createButton(BaseDialog baseDialog, String string) {
        return DialogUtil.createButton(baseDialog, string, null);
    }

    public static JButton createButton(BaseDialog baseDialog, String string, ActionListener actionListener) {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(baseDialog, string);
        JButton jButton = new JButton(toggleButtonAction);
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        return jButton;
    }

    public static JButton createButton(BaseDialog baseDialog, String string, int n, ActionListener actionListener) {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(baseDialog, string, n);
        JButton jButton = new JButton(toggleButtonAction);
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        return jButton;
    }

    public static JToggleButton createToggledButton(BaseDialog baseDialog, String string, ActionListener actionListener) {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(baseDialog, string);
        JToggleButton jToggleButton = new JToggleButton(toggleButtonAction);
        if (actionListener != null) {
            jToggleButton.addActionListener(actionListener);
        }
        return jToggleButton;
    }

    public static JFormattedTextField getTextField(JSpinner jSpinner) {
        JComponent jComponent = jSpinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)jComponent).getTextField();
        }
        return null;
    }

    public static void leftAlignSpinnerText(JSpinner jSpinner) {
        JFormattedTextField jFormattedTextField = DialogUtil.getTextField(jSpinner);
        if (jFormattedTextField != null) {
            jFormattedTextField.setHorizontalAlignment(2);
        }
    }

    public static Vector<String> getFilesWithExtension(File file, String string) {
        Vector<String> vector = new Vector<String>();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return null;
        }
        for (File file2 : fileArray) {
            String string2;
            String string3;
            int n;
            if (!file2.isFile() || (n = (string3 = file2.getName()).lastIndexOf(".")) <= 0 || n >= string3.length() - 1 || !(string2 = string3.substring(n + 1).toLowerCase()).equals(string)) continue;
            vector.add(string3.substring(0, n));
        }
        return vector;
    }

    public static int getIndexOfItem(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static int getIndexOfItemIgnoreCase(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public static void setSelectedButton(ButtonGroup buttonGroup, int n) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            if (n2 == n) {
                ((JRadioButton)abstractButton).setSelected(true);
                break;
            }
            ++n2;
        }
    }

    public static void addDragAdapters(DragPane dragPane, Component component) {
        DialogUtil.addDragAdapters(dragPane, component, null);
    }

    public static void addDragAdapters(DragPane dragPane, Component component, IVarMoveHandler iVarMoveHandler) {
        if (component instanceof VariableList) {
            VariableList variableList = (VariableList)component;
            ListDragAdapter listDragAdapter = new ListDragAdapter(variableList, dragPane, "VariableList");
            DialogUtil.modifyMouseInputListeners(variableList, listDragAdapter);
            dragPane.addDropListener((IDropListener)new VarListDropListener(variableList, iVarMoveHandler));
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (Component component2 : container.getComponents()) {
                DialogUtil.addDragAdapters(dragPane, component2, iVarMoveHandler);
            }
        }
    }

    public static void removeDragAdapters(DragPane dragPane, Component component) {
        IDropListener iDropListener;
        Object object;
        Serializable serializable;
        if (component instanceof VariableList) {
            int n;
            serializable = (VariableList)component;
            object = ((Component)serializable).getMouseListeners();
            iDropListener = ((Component)serializable).getMouseMotionListeners();
            for (n = ((Object[])object).length - 1; n >= 0; --n) {
                if (!(object[n] instanceof ListDragAdapter) && !(object[n] instanceof ListMouseHandler)) continue;
                ((Component)serializable).removeMouseListener((MouseListener)object[n]);
            }
            for (n = ((MouseMotionListener[])iDropListener).length - 1; n >= 0; --n) {
                if (!(iDropListener[n] instanceof ListDragAdapter) && !(iDropListener[n] instanceof ListMouseHandler)) continue;
                ((Component)serializable).removeMouseMotionListener((MouseMotionListener)iDropListener[n]);
            }
        } else if (component instanceof Container) {
            serializable = (Container)component;
            for (Component component2 : ((Container)serializable).getComponents()) {
                DialogUtil.removeDragAdapters(dragPane, component2);
            }
        }
        serializable = new Vector();
        ((Vector)serializable).addAll(dragPane.getDropListeners());
        object = ((Vector)serializable).iterator();
        while (object.hasNext()) {
            iDropListener = (IDropListener)object.next();
            if (!(iDropListener instanceof VarListDropListener)) continue;
            dragPane.removeDropListener(iDropListener);
        }
    }

    public static void modifyMouseInputListeners(JComponent jComponent, ComponentDragAdapter componentDragAdapter) {
        int n;
        String string = System.getProperty("java.specification.version");
        if (string != null && string.compareTo("1.6") < 0) {
            DialogUtil.oldModifyMouseInputListeners(jComponent, componentDragAdapter);
            return;
        }
        ListMouseHandler listMouseHandler = null;
        TableMouseHandler tableMouseHandler = null;
        TreeMouseHandler treeMouseHandler = null;
        if (jComponent instanceof JList) {
            listMouseHandler = new ListMouseHandler((JList)jComponent);
        } else if (jComponent instanceof JTree) {
            treeMouseHandler = new TreeMouseHandler((JTree)jComponent);
        } else if (jComponent instanceof JTable) {
            tableMouseHandler = new TableMouseHandler((JTable)jComponent);
        }
        MouseListener[] mouseListenerArray = jComponent.getMouseListeners();
        MouseMotionListener[] mouseMotionListenerArray = jComponent.getMouseMotionListeners();
        int n2 = -1;
        for (n = 0; n < mouseListenerArray.length; ++n) {
            jComponent.removeMouseListener(mouseListenerArray[n]);
            if (mouseListenerArray[n].getClass().getName().equals("javax.swing.plaf.basic.BasicListUI$Handler")) {
                n2 = n;
                continue;
            }
            if (mouseListenerArray[n].getClass().getName().equals("javax.swing.plaf.basic.BasicTableUI$Handler")) {
                n2 = n;
                continue;
            }
            if (mouseListenerArray[n].getClass().getName().equals("javax.swing.plaf.basic.BasicTreeUI$Handler")) {
                n2 = n;
                continue;
            }
            if (!(mouseListenerArray[n] instanceof ViewerOutputPaneDragAdapter)) continue;
            n2 = n;
        }
        jComponent.addMouseListener((MouseListener)componentDragAdapter);
        if (n2 == -1) {
            if (listMouseHandler != null) {
                jComponent.addMouseListener(listMouseHandler);
            } else if (tableMouseHandler != null) {
                jComponent.addMouseListener(tableMouseHandler);
            } else if (treeMouseHandler != null) {
                jComponent.addMouseListener(treeMouseHandler);
            }
        }
        for (n = 0; n < mouseListenerArray.length; ++n) {
            if (n == n2) {
                if (listMouseHandler != null) {
                    jComponent.addMouseListener(listMouseHandler);
                    continue;
                }
                if (tableMouseHandler != null) {
                    jComponent.addMouseListener(tableMouseHandler);
                    continue;
                }
                if (treeMouseHandler == null) continue;
                jComponent.addMouseListener(treeMouseHandler);
                continue;
            }
            if (mouseListenerArray[n] instanceof ComponentDragAdapter) continue;
            jComponent.addMouseListener(mouseListenerArray[n]);
        }
        n2 = -1;
        for (n = 0; n < mouseMotionListenerArray.length; ++n) {
            jComponent.removeMouseMotionListener(mouseMotionListenerArray[n]);
            if (mouseMotionListenerArray[n].getClass().getName().equals("javax.swing.plaf.basic.BasicListUI$Handler")) {
                n2 = n;
                continue;
            }
            if (mouseListenerArray[n].getClass().getName().equals("javax.swing.plaf.basic.BasicTableUI$Handler")) {
                n2 = n;
                continue;
            }
            if (mouseListenerArray[n].getClass().getName().equals("javax.swing.plaf.basic.BasicTreeUI$Handler")) {
                n2 = n;
                continue;
            }
            if (!(mouseListenerArray[n] instanceof ViewerOutputPaneDragAdapter)) continue;
            n2 = n;
        }
        jComponent.addMouseMotionListener((MouseMotionListener)componentDragAdapter);
        if (n2 == -1) {
            if (listMouseHandler != null) {
                jComponent.addMouseMotionListener(listMouseHandler);
            } else if (tableMouseHandler != null) {
                jComponent.addMouseMotionListener(tableMouseHandler);
            } else if (treeMouseHandler != null) {
                jComponent.addMouseListener(treeMouseHandler);
            }
        }
        for (n = 0; n < mouseMotionListenerArray.length; ++n) {
            if (n == n2) {
                if (listMouseHandler != null) {
                    jComponent.addMouseMotionListener(listMouseHandler);
                    continue;
                }
                if (tableMouseHandler == null) continue;
                jComponent.addMouseMotionListener(tableMouseHandler);
                continue;
            }
            if (mouseMotionListenerArray[n] instanceof ComponentDragAdapter) continue;
            jComponent.addMouseMotionListener(mouseMotionListenerArray[n]);
        }
    }

    private static void oldModifyMouseInputListeners(JComponent jComponent, ComponentDragAdapter componentDragAdapter) {
        int n;
        MouseListener[] mouseListenerArray = jComponent.getMouseListeners();
        MouseMotionListener[] mouseMotionListenerArray = jComponent.getMouseMotionListeners();
        int n2 = -1;
        for (n = 0; n < mouseListenerArray.length; ++n) {
            jComponent.removeMouseListener(mouseListenerArray[n]);
            if (mouseListenerArray[n].getClass().getSimpleName().equals("ListDragGestureRecognizer")) {
                n2 = n;
                continue;
            }
            if (mouseListenerArray[n].getClass().getSimpleName().equals("TableDragGestureRecognizer")) {
                n2 = n;
                continue;
            }
            if (mouseListenerArray[n].getClass().getSimpleName().equals("TreeDragGestureRecognizer")) {
                n2 = n;
                continue;
            }
            if (!(mouseListenerArray[n] instanceof ViewerOutputPaneDragAdapter)) continue;
            n2 = n;
        }
        if (n2 == -1) {
            jComponent.addMouseListener((MouseListener)componentDragAdapter);
        }
        for (n = 0; n < mouseListenerArray.length; ++n) {
            if (n == n2) {
                jComponent.addMouseListener((MouseListener)componentDragAdapter);
                continue;
            }
            if (mouseListenerArray[n] instanceof ComponentDragAdapter) continue;
            jComponent.addMouseListener(mouseListenerArray[n]);
        }
        n2 = -1;
        for (n = 0; n < mouseMotionListenerArray.length; ++n) {
            jComponent.removeMouseMotionListener(mouseMotionListenerArray[n]);
            if (mouseMotionListenerArray[n].getClass().getSimpleName().equals("ListDragGestureRecognizer")) {
                n2 = n;
                continue;
            }
            if (mouseMotionListenerArray[n].getClass().getSimpleName().equals("TableDragGestureRecognizer")) {
                n2 = n;
                continue;
            }
            if (mouseListenerArray[n].getClass().getSimpleName().equals("TreeDragGestureRecognizer")) {
                n2 = n;
                continue;
            }
            if (!(mouseListenerArray[n] instanceof ViewerOutputPaneDragAdapter)) continue;
            n2 = n;
        }
        if (n2 == -1) {
            jComponent.addMouseMotionListener((MouseMotionListener)componentDragAdapter);
        }
        for (n = 0; n < mouseMotionListenerArray.length; ++n) {
            if (n == n2) {
                jComponent.addMouseMotionListener((MouseMotionListener)componentDragAdapter);
                continue;
            }
            if (mouseMotionListenerArray[n] instanceof ComponentDragAdapter) continue;
            jComponent.addMouseMotionListener(mouseMotionListenerArray[n]);
        }
    }

    public static void removeMouseInputListeners(JComponent jComponent) {
        MouseListener[] mouseListenerArray = jComponent.getMouseListeners();
        MouseMotionListener[] mouseMotionListenerArray = jComponent.getMouseMotionListeners();
        for (MouseListener eventListener : mouseListenerArray) {
            jComponent.removeMouseListener(eventListener);
        }
        for (EventListener eventListener : mouseMotionListenerArray) {
            jComponent.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
    }

    public static SpssButtonGroup createButtonGroup(JPanel jPanel) {
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        for (Component component : jPanel.getComponents()) {
            if (!(component instanceof JRadioButton) && !(component instanceof JCheckBox)) continue;
            spssButtonGroup.add((AbstractButton)component);
        }
        return spssButtonGroup;
    }

    public static SpssButtonGroup createCmdButtonGroup(JPanel jPanel) {
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        for (Component component : jPanel.getComponents()) {
            if (!(component instanceof JButton)) continue;
            spssButtonGroup.add((AbstractButton)component);
        }
        return spssButtonGroup;
    }

    public static String formatDouble(double d) {
        return DialogUtil.formatDouble(d, ComponentState.getSPSSLocale());
    }

    public static String formatDouble(double d, Locale locale) {
        int n;
        String string = d > 100000.0 ? String.format(locale, "%.6f", d) : String.format(locale, "%.12f", d);
        for (n = string.length(); n > 0 && string.charAt(n - 1) == '0'; --n) {
        }
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
        if (n > 0 && string.charAt(n - 1) == decimalFormatSymbols.getDecimalSeparator()) {
            --n;
        }
        string = string.substring(0, n);
        return string;
    }

    public static boolean checkNewVarName(Window window, ISpssDataSrc iSpssDataSrc, String string) {
        boolean bl = false;
        String string2 = null;
        VarNameValidator.ValidNameCode validNameCode = VarNameValidator.validateSPSSName((String)(string = string == null ? "" : string), (boolean)true);
        if (validNameCode == VarNameValidator.ValidNameCode.SPSSNAME_STANDARD || validNameCode == VarNameValidator.ValidNameCode.SPSSNAME_WARN_UNDERSCORE) {
            bl = true;
            if (validNameCode == VarNameValidator.ValidNameCode.SPSSNAME_WARN_UNDERSCORE) {
                string2 = ResUtil.getCommonDlgString("ERR_TRAILING_UNDERSCORE_MESSAGE");
            }
        } else {
            string2 = validNameCode.equals((Object)VarNameValidator.ValidNameCode.SPSSNAME_BADLTH) ? ResUtil.getCommonDlgString("ERR_BADVAR_LENGTH_ERROR_MESSAGE") : (validNameCode.equals((Object)VarNameValidator.ValidNameCode.SPSSNAME_RESERVED) ? ResUtil.getCommonDlgString("ERR_BADVAR_RESERVED_ERROR_MESSAGE") : (validNameCode.equals((Object)VarNameValidator.ValidNameCode.SPSSNAME_BADFIRST) ? ResUtil.getCommonDlgString("ERR_BADVAR_FIRST_ERROR_MESSAGE") : (validNameCode.equals((Object)VarNameValidator.ValidNameCode.SPSSNAME_BADLAST) ? ResUtil.getCommonDlgString("ERR_BADVAR_LAST_ERROR_MESSAGE") : (validNameCode == VarNameValidator.ValidNameCode.SPSSNAME_BADCHAR ? ResUtil.getCommonDlgString("ERR_BADVAR_MIDDLE_ERROR_MESSAGE") : ResUtil.getCommonDlgString("ERR_BAD_VAR_NAME")))));
        }
        if (iSpssDataSrc != null && iSpssDataSrc.findVarIndex(string) != -1) {
            string2 = ResUtil.getCommonDlgString("ERR_BADVAR_DUPLICATE_ERROR_MESSAGE");
            bl = false;
        }
        if (string2 != null) {
            final String string3 = string2;
            final Window window2 = window;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                Toolkit.getDefaultToolkit().beep();
                SpssAlertOptionPane.showWarningMessageDialog(window2, string3, VersionInfo.getAppVersionString());
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Toolkit.getDefaultToolkit().beep();
                        SpssAlertOptionPane.showWarningMessageDialog(window2, string3, VersionInfo.getAppVersionString());
                    }
                });
            }
        }
        return bl;
    }

    public static boolean showBadSpssVarNameWarning(int n, BaseDialog baseDialog) {
        String string = "";
        boolean bl = true;
        switch (n) {
            case 1: {
                string = ResUtil.getCommonDlgString("ERR_BADVAR_SCRATCH_ERROR_MESSAGE");
                bl = false;
                break;
            }
            case 2: {
                string = ResUtil.getCommonDlgString("ERR_BADVAR_SYSTEM_ERROR_MESSAGE");
                bl = false;
                break;
            }
            case 3: {
                string = ResUtil.getCommonDlgString("ERR_BADVAR_BAD_LENGTH_ERROR_MESSAGE");
                bl = false;
                break;
            }
            case 4: {
                string = ResUtil.getCommonDlgString("ERR_BADVAR_MIDDLE_ERROR_MESSAGE");
                bl = false;
                break;
            }
            case 5: {
                string = ResUtil.getCommonDlgString("ERR_BADVAR_RESERVED_ERROR_MESSAGE");
                bl = false;
                break;
            }
            case 6: {
                string = ResUtil.getCommonDlgString("ERR_BADVAR_FIRST_ERROR_MESSAGE");
                bl = false;
                break;
            }
            case 7: {
                string = ResUtil.getCommonDlgString("ERR_BADVAR_LAST_ERROR_MESSAGE");
                bl = false;
                break;
            }
            case 100: {
                string = ResUtil.getCommonDlgString("ERR_TRAILING_UNDERSCORE_MESSAGE");
                bl = false;
                break;
            }
        }
        if (n > 0) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)baseDialog, string, VersionInfo.getAppVersionString());
        }
        return bl;
    }

    public static boolean showBadDatasetNameWarning(int n, BaseDialog baseDialog) {
        String string = "";
        boolean bl = true;
        switch (n) {
            case 1: {
                string = ResUtil.getCommonDlgString("ERR_BAD_DATASET_SCRATCH_ERROR_MESSAGE");
                bl = false;
                break;
            }
            case 2: {
                string = ResUtil.getCommonDlgString("ERR_BAD_DATASET_SYSTEM_ERROR_MESSAGE");
                bl = false;
                break;
            }
            case 3: {
                string = ResUtil.getCommonDlgString("ERR_BAD_DATASET_BAD_LENGTH_ERROR_MESSAGE");
                bl = false;
                break;
            }
            case 4: {
                string = ResUtil.getCommonDlgString("ERR_BAD_DATASET_MIDDLE_ERROR_MESSAGE");
                bl = false;
                break;
            }
            case 5: {
                string = ResUtil.getCommonDlgString("ERR_BAD_DATASET_RESERVED_ERROR_MESSAGE");
                bl = false;
                break;
            }
            case 6: {
                string = ResUtil.getCommonDlgString("ERR_BAD_DATASET_FIRST_ERROR_MESSAGE");
                bl = false;
                break;
            }
            case 7: {
                string = ResUtil.getCommonDlgString("ERR_BAD_DATASET_LAST_ERROR_MESSAGE");
                bl = false;
                break;
            }
        }
        if (n > 0) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)baseDialog, string, VersionInfo.getAppVersionString());
        }
        return bl;
    }

    public static void enableTitledBorder(JPanel jPanel, boolean bl) {
        Border border = jPanel.getBorder();
        DialogUtil.enableTitledBorder(border, bl);
    }

    public static void enableTitledBorder(Border border, boolean bl) {
        UIManager.getColor("Button.disabled");
        if (border instanceof TitledBorder) {
            TitledBorder titledBorder = (TitledBorder)border;
            if (bl) {
                titledBorder.setTitleColor(UIManager.getColor("TitledBorder.titleColor"));
            } else {
                titledBorder.setTitleColor(UIManager.getColor("Button.disabledText"));
            }
        }
    }

    public static void enableHTMLComponent(JComponent jComponent, boolean bl) {
        Color color = UIManager.getColor("textInactiveText");
        if (bl) {
            color = UIManager.getColor("textText");
        }
        jComponent.setForeground(color);
        jComponent.setEnabled(bl);
    }

    public static void enableAllComponents(JPanel jPanel, boolean bl) {
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            if (jPanel.getComponent(i) instanceof JPanel) {
                DialogUtil.enableTitledBorder((JPanel)jPanel.getComponent(i), bl);
                DialogUtil.enableAllComponents((JPanel)jPanel.getComponent(i), bl);
            } else if (jPanel.getComponent(i) instanceof JTextField) {
                ((JTextField)jPanel.getComponent(i)).setOpaque(bl);
            }
            jPanel.getComponent(i).setEnabled(bl);
        }
    }

    public static String readTempDirLocationPrefs() {
        return PrefsMgr.getPrefsMgr().getTempPath();
    }

    public static String wrapDisplayMessage(String string) {
        return DialogUtil.wrapDisplayMessage(string, 80);
    }

    public static String wrapDisplayMessage(String string, int n) {
        if (string.length() > n) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.insert(n, '\n');
            return stringBuffer.toString();
        }
        return string;
    }

    public static int readCurrentPrinterSettings() {
        return 8;
    }

    public static boolean isValidIfExpression(String string, BaseDialog baseDialog) {
        ExpressionValidator expressionValidator = new ExpressionValidator();
        boolean bl = expressionValidator.validateIfExpression(string);
        if (!bl) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)baseDialog, expressionValidator.checkError(), VersionInfo.getAppVersionString());
        }
        return bl;
    }

    public static void moveSelectedRow(final PlainTable plainTable, boolean bl) {
        final int[] nArray = plainTable.getSelectedRows();
        TableModel tableModel = plainTable.getModel();
        DefaultTableModel defaultTableModel = null;
        if (tableModel instanceof DefaultTableModel) {
            defaultTableModel = (DefaultTableModel)tableModel;
        } else if (tableModel instanceof TableSorter) {
            if (((TableSorter)tableModel).isSorting()) {
                plainTable.pushOrderFromViewToModel();
                ((TableSorter)tableModel).cancelSorting();
            }
            defaultTableModel = (DefaultTableModel)((TableSorter)tableModel).getTableModel();
        }
        Rectangle rectangle = null;
        if (defaultTableModel != null) {
            for (int n : nArray) {
                if (bl) {
                    if (n - 1 > -1) {
                        defaultTableModel.moveRow(n, n, n - 1);
                        rectangle = plainTable.getCellRect(n - 1, 0, false);
                    }
                } else if (n + 1 < defaultTableModel.getRowCount()) {
                    defaultTableModel.moveRow(n, n, n + 1);
                    rectangle = plainTable.getCellRect(n + 1, 0, false);
                }
                if (plainTable.getVisibleRect().intersects(rectangle)) continue;
                plainTable.scrollRectToVisible(rectangle);
            }
        }
        final boolean bl2 = bl;
        final DefaultTableModel defaultTableModel2 = defaultTableModel;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n = defaultTableModel2.getRowCount();
                plainTable.clearSelection();
                plainTable.requestFocus();
                for (int n2 : nArray) {
                    int n3 = bl2 ? n2 - 1 : n2 + 1;
                    if (n3 <= -1 || n3 >= n) continue;
                    plainTable.addRowSelectionInterval(n3, n3);
                }
            }
        });
    }

    public static boolean isNumber(String string) {
        ParsePosition parsePosition;
        string = string.trim();
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(UIToolResUtil.getSPSSLocale());
        Number number = decimalFormat.parse(string, parsePosition = new ParsePosition(0));
        return number != null && parsePosition.getIndex() == string.length();
    }

    public static Double parseDouble(String string) {
        ParsePosition parsePosition;
        string = string.trim();
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(UIToolResUtil.getSPSSLocale());
        Number number = decimalFormat.parse(string, parsePosition = new ParsePosition(0));
        if (number != null && parsePosition.getIndex() == string.length()) {
            return number.doubleValue();
        }
        return null;
    }

    public static int getFunctionGroupListWidth() {
        return 150;
    }

    public static int getFunctionGroupListHeight() {
        return 90;
    }

    public static int getGroupingIndent() {
        return (int)((double)UIManager.getIcon("CheckBox.icon").getIconWidth() * 1.2);
    }

    public static void resetTextCompUndoManager(Container container) {
        for (Component component : container.getComponents()) {
            if (component instanceof TextCompUndoManagerHolder) {
                TextCompUndoManager textCompUndoManager = ((TextCompUndoManagerHolder)component).getUndoManger();
                if (textCompUndoManager == null) continue;
                textCompUndoManager.discardAllEdits();
                continue;
            }
            if (!(component instanceof Container)) continue;
            DialogUtil.resetTextCompUndoManager((Container)component);
        }
    }

    public static Color getFocusBorderColor() {
        return UIManager.getColor("border.color.focus") == null ? FOCUS_BORDER_COLOR : UIManager.getColor("border.color.focus");
    }

    public static String applyMultiLines(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string.length();
        int n2 = 0;
        int n3 = 50;
        while (n3 < n) {
            char c = stringBuffer.charAt(n3);
            while (c != ' ' && n3 < stringBuffer.length()) {
                c = stringBuffer.charAt(n3);
                ++n3;
            }
            stringBuffer.insert(n3, "<br>");
            n3 = n3 + 50 + ++n2;
        }
        return "<html>" + stringBuffer.toString() + "</html>";
    }

    public static void setupMacHelpButton(JButton jButton) {
        jButton.putClientProperty("JButton.buttonType", "help");
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        boolean bl = lookAndFeel.getClass().getName().contains("Aqua");
        if (OSInfo.getOSType() == OSInfo.OSType.MAC && OSInfo.isMacOSXLeopardOrLater() && bl) {
            jButton.setText("");
            jButton.getAccessibleContext().setAccessibleName(ResUtil.getCommonDlgString("IDS_HELP"));
        }
    }

    public static void addARCWidgetsToTabTraversalVector(BasicACRWidget basicACRWidget, Vector<Object> vector) {
        for (int i = 0; i < basicACRWidget.getComponentCount(); ++i) {
            if (!(basicACRWidget.getComponent(i) instanceof JPanel)) continue;
            JPanel jPanel = (JPanel)basicACRWidget.getComponent(i);
            for (int j = 0; j < jPanel.getComponentCount(); ++j) {
                if (!(jPanel.getComponent(j) instanceof JButton)) continue;
                vector.add(jPanel.getComponent(j));
            }
        }
        vector.add(basicACRWidget.getList());
    }

    public static boolean needMeasureLevelAlertDlg() {
        boolean bl = false;
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        if (locallyUniqueId == null || locallyUniqueId.isNull()) {
            locallyUniqueId = DataMgr.getDataMgr().getActiveBackendDocumentId();
        }
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = iSpssDataSrc.columnCount();
        for (int i = 0; i < n; ++i) {
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
            MeasurementLevel measurementLevel = iSpssVariable.getMeasurementLevel();
            if (measurementLevel != MeasurementLevel.unknown) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

