/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.DateAndTimeVariable;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.LegacyStatVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssCalculatedScaleVar;
import com.spss.java_client.core.documents.data.dictionary.SpssCovariateVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssFactorVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssMRVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssModelVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssPseudoVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssRandomVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.core.documents.data.dictionary.TimeDependentPredictors;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.cf_integration.dialog.CFProcedureDialog;
import com.spss.java_client.ui.dialogs.adv_stats.cox_regression.CoxRegressionPlots;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.GLMComboBoxModel;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.SaveTab;
import com.spss.java_client.ui.dialogs.base.analyze.multiple_res.MRVariableSet;
import com.spss.java_client.ui.dialogs.base.analyze.regression.partial_least_squares.PLSComboBoxModel;
import com.spss.java_client.ui.dialogs.base.analyze.reports.olap_cubes.OlapCubesDifferences;
import com.spss.java_client.ui.dialogs.base.analyze.reports.report_summaries_in_column.ReportSummariesInColumnsDlg;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.TimeSeriesSaveTab;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.CriteriaARIMATransferTab;
import com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.CriteriaExpertModelTabWrapper;
import com.spss.java_client.ui.dialogs.base.custom_gui.ListBoxItem;
import com.spss.java_client.ui.dialogs.base.data.MultRespParam;
import com.spss.java_client.ui.dialogs.base.data.aggregate.AggregateDlg;
import com.spss.java_client.ui.dialogs.base.file.SaveDataVariablesWrapper;
import com.spss.java_client.ui.dialogs.base.graphs.interactive.SpssIGraphVariable;
import com.spss.java_client.ui.dialogs.base.transform.ShiftValuesDlg;
import com.spss.java_client.ui.dialogs.base.transform.TimeSeriesDlg;
import com.spss.java_client.ui.dialogs.base.transform.recode_into_diff_variable.OutputDetails;
import com.spss.java_client.ui.dialogs.base.transform.replace_missing_val.ReplaceMissingValuesDlg;
import com.spss.java_client.ui.dialogs.common.DialogData;
import com.spss.java_client.ui.dialogs.common.PairedVariableUtility;
import com.spss.java_client.ui.dialogs.common.VarInfoBag;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegSaveVariable;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.catpca.VariableScaleDecoration;
import com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.overals.VariableDecoration;
import com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg.RegressionConstraint;
import com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg.RegressionParam;
import com.spss.java_client.ui.dialogs.rfm_analysis.SaveTableItem;
import com.spss.java_client.ui.dialogs.trees.TableVariable;
import com.spss.java_client.ui.dialogs.trees.TreeCriteriaIntervalsTab;
import com.spss.java_client.ui.dialogs.trees.TreeDlg;
import com.spss.java_client.ui.dialogs.trees.TreeOptionsMisclassificationCostsTab;
import com.spss.java_client.ui.dialogs.trees.TreeOptionsProfitsTab;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.CrossVariableRule;
import com.spss.java_client.ui.dialogs.validatedata.define_rules.SingleVariableRule;
import com.spss.java_client.ui.dialogs.validatedata.validate_data.SummaryVariable;
import com.spss.shared.core_tools.utils.SerializableObject;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class DialogDataModel
implements DialogData {
    public static final String EXPORT_XML_ID = "EXPORT_XML_FILE_PATH";
    public static final String IMPORT_XML_ID = "IMPORT_XML_FILE_PATH";
    public static final String EXPORT_PMML_ID = "EXPORT_PMMML_FILE_PATH";
    public static final String IMPORT_PMML_ID = "IMPORT_PMML_FILE_PATH";
    public static final String PMML_COUNT_KEY = "PMML_COUNT_KEY";
    protected static final int FIRST_VERSION = 0;
    protected static final int BASE_VERSION = 1;
    protected static final int CURRENT_VERSION = 1;
    protected static final int VERSION_MASK = Integer.MIN_VALUE;
    protected static final HashMap<String, Class<? extends SerializableObject>> SERIALIZABLE_CLASSES = new HashMap();
    protected HashMap<String, Boolean> mBooleanValues = new HashMap();
    protected HashMap<String, String> mStringValues = new HashMap();
    protected HashMap<String, Integer> mIntegerValues = new HashMap();
    protected HashMap<String, Long> mLongValues = new HashMap();
    protected HashMap<String, Object[]> mListValues = new HashMap();
    protected HashMap<String, HashMap<Integer, Object>> mMapValues = new HashMap();
    protected HashMap<String, Object> mObjectValues = new HashMap();
    protected HashMap<String, VarInfoBag[]> mVarArrays = new HashMap();
    protected HashMap<String, SerializableObject> mSerializableObjects = new HashMap();
    protected HashMap<String, SerializableObject[]> mSerializableArrays = new HashMap();
    protected HashMap<String, HashMap<String, SerializableObject>> mSerializableMaps = new HashMap();
    protected Object mUserObject = null;
    protected boolean mInTestMode = false;
    protected HashMap<String, Object> mOverrideValues = new HashMap();

    public void copyFrom(DialogDataModel dialogDataModel) {
        if (dialogDataModel == this) {
            return;
        }
        this.mBooleanValues.clear();
        this.mStringValues.clear();
        this.mIntegerValues.clear();
        this.mLongValues.clear();
        this.mListValues.clear();
        this.mMapValues.clear();
        this.mObjectValues.clear();
        this.mVarArrays.clear();
        this.mSerializableObjects.clear();
        this.mSerializableArrays.clear();
        this.mSerializableMaps.clear();
        this.mOverrideValues.clear();
        this.mBooleanValues.putAll(dialogDataModel.mBooleanValues);
        this.mStringValues.putAll(dialogDataModel.mStringValues);
        this.mIntegerValues.putAll(dialogDataModel.mIntegerValues);
        this.mLongValues.putAll(dialogDataModel.mLongValues);
        this.mListValues.putAll(dialogDataModel.mListValues);
        this.mMapValues.putAll(dialogDataModel.mMapValues);
        this.mObjectValues.putAll(dialogDataModel.mObjectValues);
        this.mVarArrays.putAll(dialogDataModel.mVarArrays);
        this.mSerializableObjects.putAll(dialogDataModel.mSerializableObjects);
        this.mSerializableArrays.putAll(dialogDataModel.mSerializableArrays);
        this.mSerializableMaps.putAll(dialogDataModel.mSerializableMaps);
        this.mOverrideValues.putAll(dialogDataModel.mOverrideValues);
        this.mUserObject = dialogDataModel.mUserObject;
    }

    @Override
    public void putBoolean(String string, Boolean bl) {
        if (bl != null) {
            this.mBooleanValues.put(string, bl);
        } else {
            this.mBooleanValues.remove(string);
        }
    }

    @Override
    public Boolean getBoolean(String string) {
        return this.mBooleanValues.get(string);
    }

    public boolean containsBooleanKey(String string) {
        return this.mBooleanValues.containsKey(string);
    }

    public boolean getSafeBoolean(String string) {
        Boolean bl = this.mBooleanValues.get(string);
        return bl != null && bl != false;
    }

    @Override
    public void putString(String string, String string2) {
        if (string2 != null) {
            this.mStringValues.put(string, string2);
        } else {
            this.mStringValues.remove(string);
        }
    }

    @Override
    public String getString(String string) {
        return this.mStringValues.get(string);
    }

    public String getSafeString(String string) {
        String string2 = this.mStringValues.get(string);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public Map<String, String> getStringsByKeyPrefix(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : this.mStringValues.keySet()) {
            if (!string2.startsWith(string)) continue;
            hashMap.put(string2, this.mStringValues.get(string2));
        }
        return hashMap;
    }

    @Override
    public void putInteger(String string, Integer n) {
        if (n != null) {
            this.mIntegerValues.put(string, n);
        } else {
            this.mIntegerValues.remove(string);
        }
    }

    @Override
    public Integer getInteger(String string) {
        return this.mIntegerValues.get(string);
    }

    @Override
    public void putLong(String string, Long l) {
        if (l != null) {
            this.mLongValues.put(string, l);
        } else {
            this.mLongValues.remove(string);
        }
    }

    @Override
    public Long getLong(String string) {
        return this.mLongValues.get(string);
    }

    @Override
    public void putArray(String string, Object[] objectArray) {
        if (objectArray != null) {
            if (objectArray.length > 0 && objectArray[0] instanceof SerializableObject) assert (false);
            this.mListValues.put(string, objectArray);
        } else {
            this.mListValues.remove(string);
        }
    }

    @Override
    public Object[] getArray(String string) {
        return this.mListValues.get(string);
    }

    @Override
    public void putMap(String string, HashMap<Integer, Object> hashMap) {
        if (hashMap != null) {
            this.mMapValues.put(string, hashMap);
        } else {
            this.mMapValues.remove(string);
        }
    }

    @Override
    public HashMap<Integer, Object> getMap(String string) {
        return this.mMapValues.get(string);
    }

    @Override
    public void putObject(String string, Object object) {
        if (object != null) {
            if (object instanceof SerializableObject) assert (false);
            this.mObjectValues.put(string, object);
        } else {
            this.mObjectValues.remove(string);
        }
    }

    @Override
    public Object getObject(String string) {
        return this.mObjectValues.get(string);
    }

    @Override
    public String[] getVarNameArray(String string) {
        ISpssVariable[] iSpssVariableArray = this.getVarArray(string);
        String[] stringArray = new String[iSpssVariableArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = iSpssVariableArray[i].getName();
        }
        return stringArray;
    }

    @Override
    public void putSerializableObject(String string, SerializableObject serializableObject) {
        try {
            this.checkSerializableObject(serializableObject);
            if (serializableObject != null) {
                this.mSerializableObjects.put(string, serializableObject);
            } else {
                this.mSerializableObjects.remove(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public SerializableObject getSerializableObject(String string) {
        return this.mSerializableObjects.get(string);
    }

    @Override
    public void putSerializableArray(String string, SerializableObject[] serializableObjectArray) {
        try {
            if (serializableObjectArray != null) {
                for (SerializableObject serializableObject : serializableObjectArray) {
                    this.checkSerializableObject(serializableObject);
                }
                this.mSerializableArrays.put(string, serializableObjectArray);
            } else {
                this.mSerializableArrays.remove(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public SerializableObject[] getSerializableArray(String string) {
        return this.mSerializableArrays.get(string);
    }

    @Override
    public Object getValueForValueLabel(String string, String string2) {
        ISpssVariable[] iSpssVariableArray;
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc == null) {
            return null;
        }
        for (ISpssVariable iSpssVariable : iSpssVariableArray = this.getVarArray(string2)) {
            IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
            Set set = iValueLabelMap.getValueLabelEntries();
            for (Map.Entry entry : set) {
                if (!string.equals(entry.getValue())) continue;
                return iSpssVariable.getType() == 0 ? Double.valueOf(((OBS)entry.getKey()).getNum()) : ((OBS)entry.getKey()).getString();
            }
        }
        return null;
    }

    public void putSerializableMap(String string, HashMap<String, SerializableObject> hashMap) {
        try {
            if (hashMap != null) {
                for (SerializableObject serializableObject : hashMap.values()) {
                    this.checkSerializableObject(serializableObject);
                }
                this.mSerializableMaps.put(string, hashMap);
            } else {
                this.mSerializableMaps.remove(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public HashMap<String, SerializableObject> getSerializableMap(String string) {
        return this.mSerializableMaps.get(string);
    }

    public void putVarArray(String string, ISpssVariable[] iSpssVariableArray) {
        if (iSpssVariableArray != null) {
            LinkedList<VarInfoBag> linkedList = new LinkedList<VarInfoBag>();
            try {
                for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                    linkedList.add(new VarInfoBag(iSpssVariable));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            VarInfoBag[] varInfoBagArray = new VarInfoBag[iSpssVariableArray.length];
            this.mVarArrays.put(string, linkedList.toArray(varInfoBagArray));
        } else {
            this.mVarArrays.remove(string);
        }
    }

    public ISpssVariable[] getVarArray(String string) {
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        VarInfoBag[] varInfoBagArray = this.mVarArrays.get(string);
        if (varInfoBagArray == null) {
            return new ISpssVariable[0];
        }
        boolean bl = CommandLine.isClementineCaller();
        LinkedList<ISpssVariable> linkedList = new LinkedList<ISpssVariable>();
        for (VarInfoBag varInfoBag : varInfoBagArray) {
            ISpssVariable iSpssVariable = null;
            if (varInfoBag.getVarFlavor() != VarInfoBag.VariableFlavor.Standard) {
                iSpssVariable = DialogDataModel.createSpecialVariable(varInfoBag);
            } else {
                int n = bl ? iSpssDataSrc.findVarIndex(varInfoBag.getVarName()) : iSpssDataSrc.findVarIndex(varInfoBag.getVarId());
                if (n > -1) {
                    iSpssVariable = iSpssDataSrc.getVariable(n);
                }
            }
            if (iSpssVariable != null) {
                if (varInfoBag.getMeasurementLevel() != MeasurementLevel.unknown && varInfoBag.getMeasurementLevel() != iSpssVariable.getMeasurementLevel()) {
                    try {
                        iSpssVariable = iSpssVariable.clone();
                        iSpssVariable.setDisplayMeasurementLevel(varInfoBag.getMeasurementLevel());
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        cloneNotSupportedException.printStackTrace();
                    }
                }
            } else if (bl || this.isInTestMode()) {
                iSpssVariable = DialogDataModel.createSimulatedVariable(varInfoBag);
            }
            if (iSpssVariable == null) continue;
            linkedList.add(iSpssVariable);
        }
        VarInfoBag[] varInfoBagArray2 = new ISpssVariable[linkedList.size()];
        return (ISpssVariable[])linkedList.toArray(varInfoBagArray2);
    }

    public int varArrayCount() {
        return this.mVarArrays.size();
    }

    public boolean hasVarArray(String string) {
        for (Map.Entry<String, VarInfoBag[]> entry : this.mVarArrays.entrySet()) {
            if (!entry.getKey().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.mBooleanValues.clear();
        this.mStringValues.clear();
        this.mIntegerValues.clear();
        this.mLongValues.clear();
        this.mListValues.clear();
        this.mMapValues.clear();
        this.mObjectValues.clear();
        this.mVarArrays.clear();
        this.mSerializableObjects.clear();
        this.mSerializableArrays.clear();
        this.mSerializableMaps.clear();
    }

    public static int getSerializeVersion() {
        return 1;
    }

    public static ISpssVariable varBagToVariable(VarInfoBag varInfoBag) {
        Object object = null;
        try {
            LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            if (varInfoBag.getVarFlavor() != VarInfoBag.VariableFlavor.Standard) {
                object = DialogDataModel.createSpecialVariable(varInfoBag);
            } else if (!CommandLine.isClementineCaller()) {
                int n = iSpssDataSrc.findVarIndex(varInfoBag.getVarId());
                if (n > -1) {
                    object = iSpssDataSrc.getVariable(n);
                }
            } else {
                int n = iSpssDataSrc.findVarIndex(varInfoBag.getVarName());
                object = n > -1 ? iSpssDataSrc.getVariable(n) : DialogDataModel.createSimulatedVariable(varInfoBag);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }

    public boolean serializeIn(ObjectInputStream objectInputStream) {
        this.clear();
        try {
            String string;
            int n;
            int[] nArray = new int[]{0};
            boolean bl = this.readVersion(objectInputStream, nArray);
            int n2 = bl ? nArray[0] : 0;
            int n3 = bl ? objectInputStream.readInt() : nArray[0];
            for (n = 0; n < n3; ++n) {
                string = objectInputStream.readUTF();
                this.mBooleanValues.put(string, objectInputStream.readBoolean());
            }
            n3 = objectInputStream.readInt();
            for (n = 0; n < n3; ++n) {
                string = objectInputStream.readUTF();
                this.mStringValues.put(string, objectInputStream.readUTF());
            }
            n3 = objectInputStream.readInt();
            for (n = 0; n < n3; ++n) {
                string = objectInputStream.readUTF();
                this.mIntegerValues.put(string, objectInputStream.readInt());
            }
            n3 = objectInputStream.readInt();
            for (n = 0; n < n3; ++n) {
                string = objectInputStream.readUTF();
                this.mLongValues.put(string, objectInputStream.readLong());
            }
            n3 = objectInputStream.readInt();
            for (n = 0; n < n3; ++n) {
                string = objectInputStream.readUTF();
                this.mListValues.put(string, (Object[])objectInputStream.readObject());
            }
            n3 = objectInputStream.readInt();
            for (n = 0; n < n3; ++n) {
                string = objectInputStream.readUTF();
                this.mMapValues.put(string, (HashMap)objectInputStream.readObject());
            }
            n3 = objectInputStream.readInt();
            for (n = 0; n < n3; ++n) {
                string = objectInputStream.readUTF();
                this.mObjectValues.put(string, objectInputStream.readObject());
            }
            if (bl) {
                int n4;
                Object object;
                int n5;
                n3 = objectInputStream.readInt();
                for (n = 0; n < n3; ++n) {
                    string = objectInputStream.readUTF();
                    n5 = objectInputStream.readInt();
                    object = new VarInfoBag[n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        object[n4] = (VarInfoBag)DialogDataModel.readObject(objectInputStream, n2);
                    }
                    this.mVarArrays.put(string, (VarInfoBag[])object);
                }
                n3 = objectInputStream.readInt();
                for (n = 0; n < n3; ++n) {
                    string = objectInputStream.readUTF();
                    this.mSerializableObjects.put(string, DialogDataModel.readObject(objectInputStream, n2));
                }
                n3 = objectInputStream.readInt();
                for (n = 0; n < n3; ++n) {
                    string = objectInputStream.readUTF();
                    n5 = objectInputStream.readInt();
                    object = new SerializableObject[n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        object[n4] = DialogDataModel.readObject(objectInputStream, n2);
                    }
                    this.mSerializableArrays.put(string, (SerializableObject[])object);
                }
                n3 = objectInputStream.readInt();
                for (n = 0; n < n3; ++n) {
                    string = objectInputStream.readUTF();
                    object = new HashMap();
                    n4 = objectInputStream.readInt();
                    for (int i = 0; i < n4; ++i) {
                        String string2 = objectInputStream.readUTF();
                        ((HashMap)object).put(string2, DialogDataModel.readObject(objectInputStream, n2));
                    }
                    this.mSerializableMaps.put(string, (HashMap<String, SerializableObject>)object);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean serializeOut(ObjectOutputStream objectOutputStream) {
        try {
            objectOutputStream.writeInt(-2147483647);
            objectOutputStream.writeInt(this.mBooleanValues.size());
            for (Map.Entry<String, Boolean> entry : this.mBooleanValues.entrySet()) {
                objectOutputStream.writeUTF(entry.getKey());
                objectOutputStream.writeBoolean(entry.getValue());
            }
            objectOutputStream.writeInt(this.mStringValues.size());
            for (Map.Entry<String, Object> entry : this.mStringValues.entrySet()) {
                objectOutputStream.writeUTF(entry.getKey());
                objectOutputStream.writeUTF((String)entry.getValue());
            }
            objectOutputStream.writeInt(this.mIntegerValues.size());
            for (Map.Entry<String, Object> entry : this.mIntegerValues.entrySet()) {
                objectOutputStream.writeUTF(entry.getKey());
                objectOutputStream.writeInt((Integer)entry.getValue());
            }
            objectOutputStream.writeInt(this.mLongValues.size());
            for (Map.Entry<String, Object> entry : this.mLongValues.entrySet()) {
                objectOutputStream.writeUTF(entry.getKey());
                objectOutputStream.writeLong((Long)entry.getValue());
            }
            objectOutputStream.writeInt(this.mListValues.size());
            for (Map.Entry<String, Object> entry : this.mListValues.entrySet()) {
                objectOutputStream.writeUTF(entry.getKey());
                objectOutputStream.writeObject(entry.getValue());
            }
            objectOutputStream.writeInt(this.mMapValues.size());
            for (Map.Entry<String, Object> entry : this.mMapValues.entrySet()) {
                objectOutputStream.writeUTF(entry.getKey());
                objectOutputStream.writeObject(entry.getValue());
            }
            objectOutputStream.writeInt(this.mObjectValues.size());
            for (Map.Entry<String, Object> entry : this.mObjectValues.entrySet()) {
                objectOutputStream.writeUTF(entry.getKey());
                objectOutputStream.writeObject(entry.getValue());
            }
            objectOutputStream.writeInt(this.mVarArrays.size());
            for (Map.Entry<String, VarInfoBag[]> entry : this.mVarArrays.entrySet()) {
                objectOutputStream.writeUTF(entry.getKey());
                Iterator<Map.Entry<String, Object>> iterator = entry.getValue();
                objectOutputStream.writeInt(((Iterator<Map.Entry<String, Object>>)iterator).length);
                for (SerializableObject serializableObject : iterator) {
                    DialogDataModel.writeObject(objectOutputStream, serializableObject);
                }
            }
            objectOutputStream.writeInt(this.mSerializableObjects.size());
            for (Map.Entry<String, SerializableObject> entry : this.mSerializableObjects.entrySet()) {
                objectOutputStream.writeUTF(entry.getKey());
                DialogDataModel.writeObject(objectOutputStream, entry.getValue());
            }
            objectOutputStream.writeInt(this.mSerializableArrays.size());
            for (Map.Entry<String, SerializableObject[]> entry : this.mSerializableArrays.entrySet()) {
                objectOutputStream.writeUTF(entry.getKey());
                objectOutputStream.writeInt(entry.getValue().length);
                for (SerializableObject serializableObject : entry.getValue()) {
                    DialogDataModel.writeObject(objectOutputStream, serializableObject);
                }
            }
            objectOutputStream.writeInt(this.mSerializableMaps.size());
            for (Map.Entry<String, HashMap<String, SerializableObject>> entry : this.mSerializableMaps.entrySet()) {
                objectOutputStream.writeUTF(entry.getKey());
                objectOutputStream.writeInt(entry.getValue().size());
                for (Map.Entry entry2 : entry.getValue().entrySet()) {
                    objectOutputStream.writeUTF((String)entry2.getKey());
                    DialogDataModel.writeObject(objectOutputStream, (SerializableObject)entry2.getValue());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public String dumpToString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nBoolean count = ").append(this.mBooleanValues.size()).append("\n");
        for (Map.Entry<String, Boolean> entry : this.mBooleanValues.entrySet()) {
            stringBuffer.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        stringBuffer.append("\nString count = ").append(this.mStringValues.size()).append("\n");
        for (Map.Entry<String, Object> entry : this.mStringValues.entrySet()) {
            stringBuffer.append(entry.getKey()).append("=").append((String)entry.getValue()).append("\n");
        }
        stringBuffer.append("\nInteger count = ").append(this.mIntegerValues.size()).append("\n");
        for (Map.Entry<String, Object> entry : this.mIntegerValues.entrySet()) {
            stringBuffer.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        stringBuffer.append("\nLong count = ").append(this.mLongValues.size()).append("\n");
        for (Map.Entry<String, Object> entry : this.mLongValues.entrySet()) {
            stringBuffer.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        stringBuffer.append("\nList count = ").append(this.mListValues.size()).append("\n");
        for (Map.Entry<String, Object> entry : this.mListValues.entrySet()) {
            stringBuffer.append(entry.getKey()).append("=");
            for (Object object2 : (Object[])entry.getValue()) {
                stringBuffer.append(object2).append(",");
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("\nMap count = ").append(this.mMapValues.size()).append("\n");
        for (Map.Entry<String, Object> entry : this.mMapValues.entrySet()) {
            stringBuffer.append(entry.getKey()).append("=");
            object = (HashMap)entry.getValue();
            for (Integer n : ((HashMap)object).keySet()) {
                Object v = ((HashMap)object).get(n);
                stringBuffer.append(n).append("=").append(v);
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("\nObject count = ").append(this.mObjectValues.size()).append("\n");
        for (Map.Entry<String, Object> entry : this.mObjectValues.entrySet()) {
            stringBuffer.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        stringBuffer.append("\nVariable array count = ").append(this.mVarArrays.size()).append("\n");
        for (Map.Entry<String, Object> entry : this.mVarArrays.entrySet()) {
            stringBuffer.append(entry.getKey()).append("=");
            for (VarInfoBag varInfoBag : (VarInfoBag[])entry.getValue()) {
                stringBuffer.append(varInfoBag).append(",");
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("\nVarInfoBag arrays count = ").append(this.mVarArrays.size()).append("\n");
        for (Map.Entry<String, Object> entry : this.mVarArrays.entrySet()) {
            stringBuffer.append(entry.getKey()).append("=\n");
            for (VarInfoBag varInfoBag : (VarInfoBag[])entry.getValue()) {
                stringBuffer.append(varInfoBag).append("\n");
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("\nSerializableObject count = ").append(this.mSerializableObjects.size()).append("\n");
        for (Map.Entry<String, Object> entry : this.mSerializableObjects.entrySet()) {
            stringBuffer.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        stringBuffer.append("\nSerializableObject array count = ").append(this.mSerializableArrays.size()).append("\n");
        for (Map.Entry<String, Object> entry : this.mSerializableArrays.entrySet()) {
            stringBuffer.append(entry.getKey()).append("=");
            for (SerializableObject serializableObject : (SerializableObject[])entry.getValue()) {
                stringBuffer.append(serializableObject).append(",");
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("\nSerializableMap count = ").append(this.mSerializableMaps.size()).append("\n");
        for (Map.Entry<String, Object> entry : this.mSerializableMaps.entrySet()) {
            stringBuffer.append(entry.getKey()).append("=");
            object = (HashMap)entry.getValue();
            for (String string : ((HashMap)object).keySet()) {
                Object v = ((HashMap)object).get(string);
                stringBuffer.append(string).append("=").append(v);
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public Object getUserObject() {
        return this.mUserObject;
    }

    public void setUserObject(Object object) {
        this.mUserObject = object;
    }

    public boolean isInTestMode() {
        return this.mInTestMode;
    }

    public void setInTestMode(boolean bl) {
        this.mInTestMode = bl;
    }

    public void setOverrideValue(String string, Object object) {
        if (object != null) {
            this.mOverrideValues.put(string, object);
        } else {
            this.mOverrideValues.remove(string);
        }
    }

    public HashMap<String, Object> getOverrideMap() {
        return this.mOverrideValues;
    }

    public static SerializableObject readObject(ObjectInputStream objectInputStream, int n) throws Exception {
        String string = objectInputStream.readUTF();
        SerializableObject serializableObject = DialogDataModel.createSerializableObject(string = DialogDataModel.lookupReplacementClassName(string, n));
        if (serializableObject != null && serializableObject.readVersionedObject(objectInputStream, n)) {
            return serializableObject;
        }
        return null;
    }

    public static boolean writeObject(ObjectOutputStream objectOutputStream, SerializableObject serializableObject) throws Exception {
        objectOutputStream.writeUTF(serializableObject.getClassName());
        return serializableObject.writeVersionedObject(objectOutputStream, 1);
    }

    private boolean readVersion(ObjectInputStream objectInputStream, int[] nArray) throws Exception {
        int n = objectInputStream.readInt();
        nArray[0] = n & Integer.MAX_VALUE;
        return (n & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    private static String lookupReplacementClassName(String string, int n) {
        HashMap hashMap = new HashMap();
        if (!hashMap.containsKey(string)) {
            return string;
        }
        return (String)hashMap.get(string);
    }

    protected void checkSerializableObject(SerializableObject serializableObject) throws Exception {
        if (serializableObject == null) {
            return;
        }
        if (!SERIALIZABLE_CLASSES.containsKey(serializableObject.getClassName())) {
            throw new Exception(String.format("DDM Error: class %s must be registered in DialogDataModel.SERIALIZABLE_CLASSES", serializableObject.getClassName()));
        }
    }

    private static SerializableObject createSerializableObject(String string) {
        SerializableObject serializableObject = null;
        try {
            Class<? extends SerializableObject> clazz = SERIALIZABLE_CLASSES.get(string);
            if (clazz != null) {
                Constructor<? extends SerializableObject> constructor = clazz.getConstructor(new Class[0]);
                serializableObject = constructor.newInstance(new Object[0]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return serializableObject;
    }

    private static ISpssVariable createSpecialVariable(VarInfoBag varInfoBag) {
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        Object object = null;
        boolean bl = CommandLine.isClementineCaller();
        if (varInfoBag.getVarFlavor() == VarInfoBag.VariableFlavor.MRCategories || varInfoBag.getVarFlavor() == VarInfoBag.VariableFlavor.MRDichotomies) {
            Vector vector = iSpssDataSrc.getMRVariables();
            for (ISpssVariable iSpssVariable : vector) {
                if (!iSpssVariable.getName().equals(varInfoBag.getVarName())) continue;
                object = iSpssVariable;
                break;
            }
        } else if (varInfoBag.getVarFlavor() == VarInfoBag.VariableFlavor.CalculatedScaleVar) {
            object = new SpssCalculatedScaleVar(varInfoBag.getVarName(), varInfoBag.getVarLabel());
        } else if (varInfoBag.getVarFlavor() == VarInfoBag.VariableFlavor.CovariateVariable) {
            int n = bl ? iSpssDataSrc.findVarIndex(varInfoBag.getVarName()) : iSpssDataSrc.findVarIndex(varInfoBag.getVarId());
            if (n > -1) {
                object = new SpssCovariateVariable((SpssVariable)iSpssDataSrc.getVariable(n));
            }
        } else if (varInfoBag.getVarFlavor() == VarInfoBag.VariableFlavor.FactorVariable) {
            int n = bl ? iSpssDataSrc.findVarIndex(varInfoBag.getVarName()) : iSpssDataSrc.findVarIndex(varInfoBag.getVarId());
            if (n > -1) {
                object = new SpssFactorVariable((SpssVariable)iSpssDataSrc.getVariable(n));
            }
        } else if (varInfoBag.getVarFlavor() == VarInfoBag.VariableFlavor.DateAndTimeVariable) {
            object = new DateAndTimeVariable(varInfoBag.getVarName(), varInfoBag.getVarLabel());
        } else if (varInfoBag.getVarFlavor() == VarInfoBag.VariableFlavor.IGraphVariable) {
            object = new SpssIGraphVariable(varInfoBag.getSetType(), varInfoBag.getVarMeasureType(), new SPSS_Format(varInfoBag.getIGraphVarId()));
            object.setName(varInfoBag.getVarName());
            object.setLabel(varInfoBag.getVarLabel());
        } else if (varInfoBag.getVarFlavor() == VarInfoBag.VariableFlavor.RandomVariable) {
            int n = bl ? iSpssDataSrc.findVarIndex(varInfoBag.getVarName()) : iSpssDataSrc.findVarIndex(varInfoBag.getVarId());
            if (n > -1) {
                object = new SpssRandomVariable((SpssVariable)iSpssDataSrc.getVariable(n));
            }
        } else if (varInfoBag.getVarFlavor() == VarInfoBag.VariableFlavor.TimeDependentPredictors) {
            object = new TimeDependentPredictors(varInfoBag.getVarName(), varInfoBag.getExpression());
        } else if (varInfoBag.getVarFlavor() == VarInfoBag.VariableFlavor.PseudoVariable) {
            object = new SpssPseudoVariable();
            object.setType(varInfoBag.getVarType());
            object.setName(varInfoBag.getVarName());
            object.setLabel(varInfoBag.getVarLabel());
            object.setMeasurementLevel(varInfoBag.getMeasurementLevel());
            object.setFormat(varInfoBag.getVarFormat());
            object.setId(varInfoBag.getVarId());
        } else if (varInfoBag.getVarFlavor() == VarInfoBag.VariableFlavor.LegacyStatVar) {
            int n = iSpssDataSrc.findVarIndex(varInfoBag.getVarName());
            object = new LegacyStatVariable(iSpssDataSrc.getVariable(n));
            object.setId(varInfoBag.getVarId());
        }
        return object;
    }

    public static boolean isSpecialVariable(ISpssVariable iSpssVariable) {
        return iSpssVariable instanceof SpssModelVariable || iSpssVariable instanceof TimeDependentPredictors || iSpssVariable instanceof DateAndTimeVariable || iSpssVariable instanceof SpssCalculatedScaleVar || iSpssVariable instanceof SpssIGraphVariable || iSpssVariable instanceof SpssPseudoVariable || iSpssVariable instanceof LegacyStatVariable;
    }

    private static SpssVariable createSimulatedVariable(VarInfoBag varInfoBag) {
        Object object = varInfoBag.getVarFlavor() == VarInfoBag.VariableFlavor.Standard ? new SpssVariable() : new SpssMRVariable(null);
        object.setName(varInfoBag.getVarName());
        object.setLabel(varInfoBag.getVarLabel());
        object.setFormat(varInfoBag.getVarFormat());
        object.setType(varInfoBag.getVarType());
        object.setMeasurementLevel(varInfoBag.getMeasurementLevel());
        return object;
    }

    static {
        SERIALIZABLE_CLASSES.put("com.spss.java_client.core.common.LocallyUniqueId", LocallyUniqueId.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.adv_stats.cox_regression.CoxRegressionPlots$CoVariateAttributes", CoxRegressionPlots.CoVariateAttributes.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.GLMComboBoxModel", GLMComboBoxModel.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.base.analyze.multiple_res.MRVariableSet", MRVariableSet.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.base.analyze.regression.partial_least_squares.PLSComboBoxModel", PLSComboBoxModel.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.SaveTab$SaveTableItem", SaveTab.SaveTableItem.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.common.VarInfoBag", VarInfoBag.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.base.analyze.reports.olap_cubes.OlapCubesDifferences$MyLabelData", OlapCubesDifferences.MyLabelData.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.CriteriaARIMATransferTab$TransferDataModel", CriteriaARIMATransferTab.TransferDataModel.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.base.analyze.time_series.create_models.CriteriaExpertModelTabWrapper", CriteriaExpertModelTabWrapper.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.common.PairedVariableUtility$VarPair", PairedVariableUtility.VarPair.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.core.documents.data.dictionary.SPSS_Format", SPSS_Format.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.trees.TableVariable", TableVariable.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.trees.TreeOptionsMisclassificationCostsTab.CostsData", TreeOptionsMisclassificationCostsTab.CostsData.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.trees.TableVariable.TreeCriteriaIntervalsTab$IntervalTableVar", TreeCriteriaIntervalsTab.IntervalTableVar.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.trees.TreeOptionsProfitsTab$RevExpVal", TreeOptionsProfitsTab.RevExpVal.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.trees.TreeDlg$Categories", TreeDlg.Categories.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.overals.VariableDecoration", VariableDecoration.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg.RegressionParam", RegressionParam.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.base.transform.TimeSeriesDlg$TimeSeriesVariable", TimeSeriesDlg.TimeSeriesVariable.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.base.file.SaveDataVariablesWrapper", SaveDataVariablesWrapper.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegSaveVariable", CSCoxRegSaveVariable.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.rfm_analysis.SaveTableItem", SaveTableItem.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.base.analyze.time_series.TimeSeriesSaveTab$SaveTableItem", TimeSeriesSaveTab.SaveTableItem.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.validatedata.define_rules.CrossVariableRule", CrossVariableRule.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.validatedata.validate_data.SummaryVariable", SummaryVariable.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg.RegressionConstraint", RegressionConstraint.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.validatedata.define_rules.SingleVariableRule", SingleVariableRule.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling.catpca.VariableScaleDecoration", VariableScaleDecoration.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.base.data.MultRespParam", MultRespParam.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.base.transform.recode_info_diff_variable.OutputDetails", OutputDetails.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.base.transform.replace_missing_val.ReplaceMissingValuesDlg$RMVCustomData", ReplaceMissingValuesDlg.RMVCustomData.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.base.analyze.reports.report_summaries_in_column.ReportSummariesInColumnsDlg$ColumnListModel", ReportSummariesInColumnsDlg.ColumnListModel.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.base.custom_gui.DialogBuilder$ListBoxItem", ListBoxItem.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.cf_integration.dialog.CFProcedureDialog$CFSerializable", CFProcedureDialog.CFSerializable.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.base.transform.ShiftValuesDlg$ShiftSeriesVariable", ShiftValuesDlg.ShiftSeriesVariable.class);
        SERIALIZABLE_CLASSES.put("com.spss.java_client.ui.dialogs.base.data.aggregate.AggregateDlg$ListData", AggregateDlg.ListData.class);
    }
}

