/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertDialog;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.actions.ProcedureAction;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class DefineVariablesAlertDlg
extends SpssAlertDialog {
    static final String DONT_SHOW_DIALOG_CHECK = "IDS_DONT_SHOW_DIALOG";
    static final String DEFINE_VARIABLE_KEY = "DEFINE_BUTTON_PRESSED";
    public static final String DEFINE_OK_KEY = "OK_BUTTON_PRESSED_KEY";
    protected OkAction mOkAction;
    private DefineAction mDefineAction;
    protected JCheckBox mDontShowCheck;
    private BaseDialog mParent;
    private String mDontShowPrefKey;
    private String mPrefArea;
    protected JButton okButton;
    private JButton defineButton;
    private SpssAlertOptionPane.IconType mIconType;
    private boolean mIsOKPressed;
    protected ExitCode mExitCode = ExitCode.OK_ACTION;

    public DefineVariablesAlertDlg(BaseProcedureDialog baseProcedureDialog, String string, String string2, SpssAlertOptionPane.IconType iconType, String string3, String string4) {
        super(baseProcedureDialog, baseProcedureDialog.getResourceBundle(), string2, string, iconType);
        this.mIconType = iconType;
        this.mParent = baseProcedureDialog;
        this.mDontShowPrefKey = string4;
        this.mPrefArea = string3;
        this.setLocationRelativeTo(this.getParent());
        this.mParent.requestFocusInWindow();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefineVariablesAlertDlg.this.setVisible(true);
            }
        });
    }

    public DefineVariablesAlertDlg(JFrame jFrame, ResourceBundle resourceBundle, String string, String string2, SpssAlertOptionPane.IconType iconType, String string3, String string4) {
        super(jFrame, resourceBundle, string2, string, iconType);
        this.mIconType = iconType;
        this.mDontShowPrefKey = string4;
        this.mPrefArea = string3;
        this.setLocationRelativeTo(this.getParent());
    }

    public DefineVariablesAlertDlg(BaseDialog baseDialog, ResourceBundle resourceBundle, String string, String string2, SpssAlertOptionPane.IconType iconType, String string3, String string4) {
        super(baseDialog, resourceBundle, string2, string, iconType);
        this.mIconType = iconType;
        this.mParent = baseDialog;
        this.mDontShowPrefKey = string4;
        this.mPrefArea = string3;
        this.setLocationRelativeTo(this.getParent());
        this.saveOKStatus(false);
        this.doPreShowHandling();
        this.setVisible(true);
    }

    protected void doPreShowHandling() {
    }

    public boolean isOKPressed() {
        return this.mIsOKPressed;
    }

    @Override
    protected void initVars() {
        super.initVars();
        this.mOkAction = new OkAction();
        this.mDefineAction = new DefineAction();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, DONT_SHOW_DIALOG_CHECK);
        this.mDontShowCheck = new JCheckBox(toggleButtonAction);
        this.mDontShowCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = DefineVariablesAlertDlg.this.mDontShowCheck.isSelected();
                Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
                Preferences preferences2 = preferences.node("dialog_settings/" + DefineVariablesAlertDlg.this.mPrefArea);
                preferences2.putBoolean(DefineVariablesAlertDlg.this.mDontShowPrefKey, bl);
            }
        });
        this.addWindowListener(new WindowAdapter(){
            boolean closed = false;

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                if (!(windowEvent.getWindow() != DefineVariablesAlertDlg.this || this.closed || DefineVariablesAlertDlg.this.getButtonPressedValue() != 3 && DefineVariablesAlertDlg.this.getButtonPressedValue() != -1)) {
                    this.closed = true;
                    if (DefineVariablesAlertDlg.this.mParent != null) {
                        DefineVariablesAlertDlg.this.mParent.dispose();
                    }
                }
            }
        });
    }

    @Override
    protected JPanel setupCmdButtons() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        this.okButton = new JButton(this.mOkAction);
        this.defineButton = new JButton(this.mDefineAction);
        if (DialogUtil.areCommandButtonsBelow()) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
                FlowLayout flowLayout = new FlowLayout(2, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.okButton);
                jPanel.add(this.defineButton);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.okButton);
                jPanel.add(this.defineButton);
            }
            this.getRootPane().setDefaultButton(this.defineButton);
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(this.okButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.defineButton);
            this.getRootPane().setDefaultButton(this.defineButton);
        }
        return jPanel;
    }

    @Override
    protected void addComponents(boolean bl) {
        super.addComponents(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getGroupBoxInnerMargin() * 3, DialogUtil.getComponentGroupGap(), 0);
        int n2 = 2;
        if (this.mIconType == SpssAlertOptionPane.IconType.eNone) {
            n2 = 1;
        }
        DialogUtil.addUsingGBL(this.mViewPanel, this.mDontShowCheck, gridBagConstraints, 0, 1, n2, 1, n, insets);
        this.pack();
    }

    @Override
    protected void setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.defineButton);
        vector.add(this.mDontShowCheck);
        vector.add(this.okButton);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    private void saveOKStatus(boolean bl) {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("dialog_settings/" + this.mPrefArea);
        preferences2.putBoolean(DEFINE_OK_KEY, bl);
    }

    public static enum ExitCode {
        OK_ACTION,
        CANCEL_ACTION,
        SUB_CLASS_ACTION_1,
        SUB_CLASS_ACTION_2,
        SUB_CLASS_ACTION_3;

    }

    class DefineAction
    extends AbstractAction {
        public DefineAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_DEFINE_VAR_PROPERTIES"));
            if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", DefineVariablesAlertDlg.this.getDlgAccessKey("IDK_DEFINE_VAR_PROPERTIES_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefineVariablesAlertDlg.this.dispose();
            if (DefineVariablesAlertDlg.this.mParent != null) {
                DefineVariablesAlertDlg.this.mParent.dispose();
            }
            SpssAction spssAction = ActionCatalog.getActionCatalog().getSpssAction("data_define_var_property");
            try {
                ProcedureAction procedureAction = (ProcedureAction)spssAction;
                Class<?> clazz = Class.forName(procedureAction.getDlgLaunchPath());
                Constructor<?> constructor = clazz.getConstructor(JFrame.class);
                constructor.newInstance(DefineVariablesAlertDlg.this.getParent() instanceof JFrame ? DefineVariablesAlertDlg.this.getParent() : DefineVariablesAlertDlg.this.getParent().getParent());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class OkAction
    extends AbstractAction {
        public OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefineVariablesAlertDlg.this.saveOKStatus(true);
            DefineVariablesAlertDlg.this.mIsOKPressed = true;
            DefineVariablesAlertDlg.this.dispose();
        }
    }
}

