/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.CustomVarListModel;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFormatter;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.controls.FloatDocument;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class DefineGroupsSubDlg
extends BaseSubDialog
implements DocumentListener {
    private TargetVariableList mGroupVarList;
    private SpssButtonGroup mButtonGroup;
    private JRadioButton mSpecifiedValuesRadio;
    private JRadioButton mUseMidValueRadio;
    private JRadioButton mCutPointRadio;
    private JLabel mGroup1Label;
    private JLabel mGroup2Label;
    private ContextEnabledTextField mGroup1Text;
    private ContextEnabledTextField mGroup2Text;
    private JLabel mCutpointLabel;
    private FloatTextField mCutPointText;
    private boolean mIsForStringVar;
    private String mHelpId;

    public DefineGroupsSubDlg(BaseProcedureDialog baseProcedureDialog, boolean bl, TargetVariableList targetVariableList, String string) {
        super(baseProcedureDialog, ResUtil.getCommonDlgString("IDS_DEFINE_GROUPS_TITLE"), true);
        this.mIsForStringVar = bl;
        this.mGroupVarList = targetVariableList;
        this.mHelpId = string;
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.setDefaults();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public boolean continuePressed() {
        String[] stringArray = new String[2];
        if (this.mSpecifiedValuesRadio.isSelected()) {
            stringArray[0] = this.mGroup1Text.getText();
            stringArray[1] = this.mGroup2Text.getText();
        } else if (this.mUseMidValueRadio.isSelected()) {
            stringArray[0] = "";
            stringArray[1] = "";
        } else {
            stringArray[0] = this.mCutPointText.getText();
            stringArray[1] = "";
        }
        int n = this.mGroupVarList.getSelectedIndex() > -1 ? this.mGroupVarList.getSelectedIndex() : 0;
        ((GroupVarModel)this.mGroupVarList.getModel()).setElementPropertyAt(n, stringArray);
        if (this.mSpecifiedValuesRadio.isSelected() && this.mGroup1Text.getText().equals(this.mGroup2Text.getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), ResUtil.getCommonDlgString("ERR_EQUAL_VALUES_WARNING"), VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    @Override
    public String getDialogHelpID() {
        return this.mHelpId;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.onUserSpecified(this.mSpecifiedValuesRadio.isSelected());
        this.onCutPoint(this.mCutPointRadio.isSelected());
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
    }

    private void initVars() {
        this.mButtonGroup = new SpssButtonGroup();
        ControlAction controlAction = new ToggleButtonAction("IDS_SPECIFIED_VALUES_RADIO"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefineGroupsSubDlg.this.onUserSpecified(DefineGroupsSubDlg.this.mSpecifiedValuesRadio.isSelected());
                DefineGroupsSubDlg.this.onCutPoint(DefineGroupsSubDlg.this.mCutPointRadio.isSelected());
                DefineGroupsSubDlg.this.enableContinue(DefineGroupsSubDlg.this.canEnableContinue());
            }
        };
        this.mSpecifiedValuesRadio = new JRadioButton(controlAction);
        this.mButtonGroup.add(this.mSpecifiedValuesRadio);
        controlAction = new ToggleButtonAction("IDS_MID_VALUES_RADIO"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefineGroupsSubDlg.this.onUserSpecified(DefineGroupsSubDlg.this.mSpecifiedValuesRadio.isSelected());
                DefineGroupsSubDlg.this.onCutPoint(DefineGroupsSubDlg.this.mCutPointRadio.isSelected());
                DefineGroupsSubDlg.this.enableContinue(DefineGroupsSubDlg.this.canEnableContinue());
            }
        };
        this.mUseMidValueRadio = new JRadioButton(controlAction);
        this.mButtonGroup.add(this.mUseMidValueRadio);
        controlAction = new ToggleButtonAction("IDS_USE_CUT_POINT_RADIO"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefineGroupsSubDlg.this.onUserSpecified(DefineGroupsSubDlg.this.mSpecifiedValuesRadio.isSelected());
                DefineGroupsSubDlg.this.onCutPoint(DefineGroupsSubDlg.this.mCutPointRadio.isSelected());
                DefineGroupsSubDlg.this.enableContinue(DefineGroupsSubDlg.this.canEnableContinue());
            }
        };
        this.mCutPointRadio = new JRadioButton(controlAction);
        this.mButtonGroup.add(this.mCutPointRadio);
        this.mCutpointLabel = DialogUtil.createLabel("IDS_CUT_POINT");
        controlAction = new TextFieldAction(this.mParentDlg, "IDS_CUTPOINT_TEXT");
        this.mCutPointText = new FloatTextField(-9999999.0, 9.9999999E7, 15, false);
        this.mCutpointLabel.setLabelFor((Component)this.mCutPointText);
        this.mCutPointText.setAction((Action)controlAction);
        this.mCutPointText.setDocument((Document)new FloatDocument());
        this.mCutPointText.setColumns(8);
        this.mCutPointText.getDocument().addDocumentListener(this);
    }

    private void createGroupValueFields() {
        this.mGroup1Label = DialogUtil.createLabel("IDS_GROUP_1_LABEL");
        TextFieldAction textFieldAction = new TextFieldAction(this.mParentDlg, "IDS_GROUP1_TEXT");
        this.mGroup1Text = this.mIsForStringVar ? new ContextEnabledTextField() : new FloatTextField(Double.NaN, Double.NaN, 5, false);
        this.mGroup1Text.setAction((Action)textFieldAction);
        this.mGroup1Text.setColumns(8);
        this.mGroup1Text.getDocument().addDocumentListener(this);
        this.mGroup1Label.setLabelFor((Component)this.mGroup1Text);
        this.mGroup2Label = DialogUtil.createLabel("IDS_GROUP_2_LABEL");
        textFieldAction = new TextFieldAction(this.mParentDlg, "IDS_GROUP2_TEXT");
        this.mGroup2Text = this.mIsForStringVar ? new ContextEnabledTextField() : new FloatTextField(Double.NaN, Double.NaN, 5, false);
        this.mGroup2Text.setAction((Action)textFieldAction);
        this.mGroup2Text.setColumns(8);
        this.mGroup2Text.getDocument().addDocumentListener(this);
        this.mGroup2Label.setLabelFor((Component)this.mGroup2Text);
    }

    private boolean canEnableContinue() {
        boolean bl = true;
        if (this.mGroup1Text.isEnabled() && this.mGroup1Text.getText().length() == 0) {
            bl = false;
        }
        if (bl && this.mGroup2Text.isEnabled() && this.mGroup2Text.getText().length() == 0) {
            bl = false;
        }
        if (bl && this.mCutPointText.isEnabled() && this.mCutPointText.getText().length() == 0) {
            bl = false;
        }
        return bl;
    }

    private void setDefaults() {
        this.mSpecifiedValuesRadio.setSelected(true);
        this.mGroup1Text.setText("");
        this.mGroup2Text.setText("");
        this.mCutPointText.setText("");
        this.onUserSpecified(true);
        this.onCutPoint(false);
        this.enableContinue(false);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        if (!this.mIsForStringVar) {
            vector.add(this.mButtonGroup);
            vector.add(this.mGroup1Text);
            vector.add(this.mGroup2Text);
            vector.add(this.mCutPointText);
        } else {
            vector.add(this.mGroup1Text);
            vector.add(this.mGroup2Text);
        }
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void setupPanel(JPanel jPanel) {
        this.createGroupValueFields();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        if (!this.mIsForStringVar) {
            DialogUtil.addUsingGBL(jPanel, this.mSpecifiedValuesRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
            DialogUtil.addUsingGBL(jPanel, this.mUseMidValueRadio, gridBagConstraints, 0, 3, 2, 1, n, insets);
            DialogUtil.addUsingGBL(jPanel, this.mCutPointRadio, gridBagConstraints, 0, 4, 2, 1, n, insets);
            Insets insets2 = new Insets(2, 20 + DialogUtil.getComponentGroupGap(), DialogUtil.getGroupBoxInnerMargin(), 2);
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, this.mGroup1Label, gridBagConstraints, 0, 1, 1, 1, n, insets2);
            DialogUtil.addUsingGBL(jPanel, this.mGroup2Label, gridBagConstraints, 0, 2, 1, 1, n, insets2);
            DialogUtil.addUsingGBL(jPanel, this.mCutpointLabel, gridBagConstraints, 0, 5, 1, 1, n, insets2);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, (JComponent)this.mGroup1Text, gridBagConstraints, 1, 1, 1, 1, n, null);
            DialogUtil.addUsingGBL(jPanel, (JComponent)this.mGroup2Text, gridBagConstraints, 1, 2, 1, 1, n, null);
            gridBagConstraints.weighty = 1.0;
            DialogUtil.addUsingGBL(jPanel, (JComponent)this.mCutPointText, gridBagConstraints, 1, 5, 1, 1, n, null);
        } else {
            gridBagConstraints.fill = 0;
            JLabel jLabel = DialogUtil.createLabel("IDS_DEFINE_GROUPS_STRINGVAR_INFO");
            Insets insets3 = (Insets)insets.clone();
            insets3.bottom += 5;
            DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 2, 1, n, insets3);
            DialogUtil.addUsingGBL(jPanel, this.mGroup1Label, gridBagConstraints, 0, 2, 1, 1, n, insets);
            DialogUtil.addUsingGBL(jPanel, (JComponent)this.mGroup1Text, gridBagConstraints, 1, 2, 1, 1, n, insets);
            DialogUtil.addUsingGBL(jPanel, this.mGroup2Label, gridBagConstraints, 0, 3, 1, 1, n, insets);
            gridBagConstraints.weightx = 1.0;
            DialogUtil.addUsingGBL(jPanel, (JComponent)this.mGroup2Text, gridBagConstraints, 1, 3, 1, 1, n, insets);
        }
    }

    private void onUserSpecified(boolean bl) {
        this.mGroup1Label.setEnabled(bl);
        this.mGroup1Text.setEnabled(bl);
        this.mGroup2Label.setEnabled(bl);
        this.mGroup2Text.setEnabled(bl);
    }

    private void onCutPoint(boolean bl) {
        this.mCutpointLabel.setEnabled(bl);
        this.mCutPointText.setEnabled(bl);
    }

    public static class GroupVarFormatter
    extends SpssVarFormatter {
        public GroupVarFormatter(TargetVariableList targetVariableList) {
            super(targetVariableList);
        }

        @Override
        public String getDisplayText(ISpssVariable iSpssVariable) {
            String[] stringArray = (String[])this.getVarMap().get(iSpssVariable.getId().asInt());
            if (iSpssVariable.getType() == 0 || stringArray[0].equals("?")) {
                if (!stringArray[1].equals("")) {
                    return iSpssVariable.getName() + "(" + stringArray[0] + " " + stringArray[1] + ")";
                }
                if (stringArray[0].length() == 0) {
                    return iSpssVariable.getName() + "(MIDPOINT)";
                }
                return iSpssVariable.getName() + "(" + stringArray[0] + ")";
            }
            return iSpssVariable.getName() + "(" + stringArray[0] + " " + stringArray[1] + ")";
        }

        public String getDisplaySyntax(ISpssVariable iSpssVariable) {
            String[] stringArray = (String[])this.getVarMap().get(iSpssVariable.getId().asInt());
            if (iSpssVariable.getType() == 0 || stringArray[0].equals("?")) {
                if (!stringArray[1].equals("")) {
                    return "LEVEL(" + stringArray[0] + " " + stringArray[1] + ")";
                }
                if (stringArray[0].length() == 0) {
                    return "MIDPOINT";
                }
                return "CUTPOINT(" + stringArray[0] + ")";
            }
            return "LEVEL(" + stringArray[0] + " " + stringArray[1] + ")";
        }
    }

    public static class GroupVarModel
    extends CustomVarListModel {
        public GroupVarModel(SpssVarFormatter spssVarFormatter) {
            super(spssVarFormatter);
        }

        @Override
        public boolean insertElementAt(ISpssVariable iSpssVariable, int n) {
            String[] stringArray = new String[]{"?", "?"};
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), stringArray);
            return super.insertElementAt(iSpssVariable, n);
        }

        @Override
        public boolean addElement(ISpssVariable iSpssVariable) {
            String[] stringArray = new String[]{"?", "?"};
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), stringArray);
            return super.addElement(iSpssVariable);
        }

        public void setElementPropertyAt(int n, String[] stringArray) {
            if (n < 0 || n >= this.mVariables.size()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            ISpssVariable iSpssVariable = this.getElementAt(n);
            String[] stringArray2 = new String[]{stringArray[0], stringArray[1]};
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), stringArray2);
            this.fireContentsChanged(iSpssVariable, n, n);
        }

        @Override
        public void fireContentsChanged(Object object, int n, int n2) {
            super.fireContentsChanged(object, n, n2);
        }
    }
}

